/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.providers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.IProjectLabelProvider;
import org.eclipse.lsp4mp.jdt.core.utils.JDTMicroProfileUtils;

public class MavenProjectLabelProvider
implements IProjectLabelProvider {
    public static final String MAVEN_LABEL = "maven";
    private static final String MAVEN_NATURE_ID = "org.eclipse.m2e.core.maven2Nature";

    @Override
    public List<String> getProjectLabels(IJavaProject project) throws JavaModelException {
        if (MavenProjectLabelProvider.isMavenProject(project.getProject())) {
            return Collections.singletonList(MAVEN_LABEL);
        }
        return Collections.emptyList();
    }

    private static boolean isMavenProject(IProject project) {
        return JDTMicroProfileUtils.hasNature(project, MAVEN_NATURE_ID);
    }
}

