/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.JavaCursorContextKind;
import org.eclipse.lsp4mp.commons.JavaCursorContextResult;
import org.eclipse.lsp4mp.commons.JavaFileInfo;
import org.eclipse.lsp4mp.commons.MicroProfileDefinition;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCompletionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDefinitionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsSettings;
import org.eclipse.lsp4mp.commons.MicroProfileJavaFileInfoParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaHoverParams;
import org.eclipse.lsp4mp.jdt.core.java.codelens.JavaCodeLensContext;
import org.eclipse.lsp4mp.jdt.core.java.completion.JavaCompletionContext;
import org.eclipse.lsp4mp.jdt.core.java.definition.JavaDefinitionContext;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.java.hover.JavaHoverContext;
import org.eclipse.lsp4mp.jdt.core.utils.ASTNodeUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTMicroProfileUtils;
import org.eclipse.lsp4mp.jdt.internal.core.java.JavaFeaturesRegistry;
import org.eclipse.lsp4mp.jdt.internal.core.java.codeaction.CodeActionHandler;
import org.eclipse.lsp4mp.jdt.internal.core.java.codelens.JavaCodeLensDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.completion.JavaCompletionDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.definition.JavaDefinitionDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.diagnostics.JavaDiagnosticsDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.hover.JavaHoverDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.symbols.JavaWorkspaceSymbolsDefinition;

public class PropertiesManagerForJava {
    private static final PropertiesManagerForJava INSTANCE = new PropertiesManagerForJava();
    private final CodeActionHandler codeActionHandler = new CodeActionHandler();

    public static PropertiesManagerForJava getInstance() {
        return INSTANCE;
    }

    private PropertiesManagerForJava() {
    }

    public JavaFileInfo fileInfo(MicroProfileJavaFileInfoParams params, IJDTUtils utils, IProgressMonitor monitor) {
        String uri = params.getUri();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        if (unit != null && unit.exists()) {
            JavaFileInfo fileInfo = new JavaFileInfo();
            String packageName = unit.getParent() != null ? unit.getParent().getElementName() : "";
            fileInfo.setPackageName(packageName);
            return fileInfo;
        }
        return null;
    }

    public List<? extends CodeAction> codeAction(MicroProfileJavaCodeActionParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        return this.codeActionHandler.codeAction(params, utils, monitor);
    }

    public CodeAction resolveCodeAction(CodeAction unresolved, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        return this.codeActionHandler.resolveCodeAction(unresolved, utils, monitor);
    }

    public List<? extends CodeLens> codeLens(MicroProfileJavaCodeLensParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return Collections.emptyList();
        }
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        this.collectCodeLens(uri, typeRoot, utils, params, lenses, monitor);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return lenses;
    }

    private void collectCodeLens(String uri, ITypeRoot typeRoot, IJDTUtils utils, MicroProfileJavaCodeLensParams params, List<CodeLens> lenses, IProgressMonitor monitor) {
        JavaCodeLensContext context = new JavaCodeLensContext(uri, typeRoot, utils, params);
        List<JavaCodeLensDefinition> definitions = JavaFeaturesRegistry.getInstance().getJavaCodeLensDefinitions().stream().filter(definition -> definition.isAdaptedForCodeLens(context, monitor)).collect(Collectors.toList());
        if (definitions.isEmpty()) {
            return;
        }
        definitions.forEach(definition -> definition.beginCodeLens(context, monitor));
        definitions.forEach(definition -> {
            List<CodeLens> collectedLenses = definition.collectCodeLens(context, monitor);
            if (collectedLenses != null && !collectedLenses.isEmpty()) {
                lenses.addAll(collectedLenses);
            }
        });
        definitions.forEach(definition -> definition.endCodeLens(context, monitor));
    }

    public CompletionList completion(MicroProfileJavaCompletionParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return null;
        }
        Position completionPosition = params.getPosition();
        int completionOffset = utils.toOffset(typeRoot.getBuffer(), completionPosition.getLine(), completionPosition.getCharacter());
        ArrayList completionItems = new ArrayList();
        JavaCompletionContext completionContext = new JavaCompletionContext(uri, typeRoot, utils, completionOffset);
        List<JavaCompletionDefinition> completions = JavaFeaturesRegistry.getInstance().getJavaCompletionDefinitions().stream().filter(completion -> completion.isAdaptedForCompletion(completionContext, monitor)).collect(Collectors.toList());
        if (completions.isEmpty()) {
            return null;
        }
        completions.forEach(completion -> {
            List<? extends CompletionItem> collectedCompletionItems = completion.collectCompletionItems(completionContext, monitor);
            if (collectedCompletionItems != null) {
                completionItems.addAll(collectedCompletionItems);
            }
        });
        if (monitor.isCanceled()) {
            return null;
        }
        CompletionList completionList = new CompletionList();
        completionList.setItems(completionItems);
        return completionList;
    }

    public List<MicroProfileDefinition> definition(MicroProfileJavaDefinitionParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return Collections.emptyList();
        }
        Position hyperlinkedPosition = params.getPosition();
        int definitionOffset = utils.toOffset(typeRoot.getBuffer(), hyperlinkedPosition.getLine(), hyperlinkedPosition.getCharacter());
        IJavaElement hyperlinkedElement = this.getHoveredElement(typeRoot, definitionOffset);
        ArrayList<MicroProfileDefinition> locations = new ArrayList<MicroProfileDefinition>();
        this.collectDefinition(uri, typeRoot, hyperlinkedElement, utils, hyperlinkedPosition, locations, monitor);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return locations;
    }

    private void collectDefinition(String uri, ITypeRoot typeRoot, IJavaElement hyperlinkedElement, IJDTUtils utils, Position hyperlinkedPosition, List<MicroProfileDefinition> locations, IProgressMonitor monitor) {
        JavaDefinitionContext context = new JavaDefinitionContext(uri, typeRoot, utils, hyperlinkedElement, hyperlinkedPosition);
        List<JavaDefinitionDefinition> definitions = JavaFeaturesRegistry.getInstance().getJavaDefinitionDefinitions().stream().filter(definition -> definition.isAdaptedForDefinition(context, monitor)).collect(Collectors.toList());
        if (definitions.isEmpty()) {
            return;
        }
        definitions.forEach(definition -> definition.beginDefinition(context, monitor));
        definitions.forEach(definition -> {
            List<MicroProfileDefinition> collectedDefinitions = definition.collectDefinitions(context, monitor);
            if (collectedDefinitions != null && !collectedDefinitions.isEmpty()) {
                locations.addAll(collectedDefinitions);
            }
        });
        definitions.forEach(definition -> definition.endDefinition(context, monitor));
    }

    public List<PublishDiagnosticsParams> diagnostics(MicroProfileJavaDiagnosticsParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        List<String> uris = params.getUris();
        if (uris == null) {
            return Collections.emptyList();
        }
        DocumentFormat documentFormat = params.getDocumentFormat();
        ArrayList<PublishDiagnosticsParams> publishDiagnostics = new ArrayList<PublishDiagnosticsParams>();
        for (String uri : uris) {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            PublishDiagnosticsParams publishDiagnostic = new PublishDiagnosticsParams(uri, diagnostics);
            publishDiagnostics.add(publishDiagnostic);
            this.collectDiagnostics(uri, utils, documentFormat, params.getSettings(), diagnostics, monitor);
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return publishDiagnostics;
    }

    private void collectDiagnostics(String uri, IJDTUtils utils, DocumentFormat documentFormat, MicroProfileJavaDiagnosticsSettings settings, List<Diagnostic> diagnostics, IProgressMonitor monitor) {
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return;
        }
        JavaDiagnosticsContext context = new JavaDiagnosticsContext(uri, typeRoot, utils, documentFormat, settings);
        List<JavaDiagnosticsDefinition> definitions = JavaFeaturesRegistry.getInstance().getJavaDiagnosticsDefinitions().stream().filter(definition -> definition.isAdaptedForDiagnostics(context, monitor)).collect(Collectors.toList());
        if (definitions.isEmpty()) {
            return;
        }
        definitions.forEach(definition -> definition.beginDiagnostics(context, monitor));
        definitions.forEach(definition -> {
            List<Diagnostic> collectedDiagnostics = definition.collectDiagnostics(context, monitor);
            if (collectedDiagnostics != null && !collectedDiagnostics.isEmpty()) {
                diagnostics.addAll(collectedDiagnostics);
            }
        });
        definitions.forEach(definition -> definition.endDiagnostics(context, monitor));
    }

    public Hover hover(MicroProfileJavaHoverParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return null;
        }
        Position hoverPosition = params.getPosition();
        int hoveredOffset = utils.toOffset(typeRoot.getBuffer(), hoverPosition.getLine(), hoverPosition.getCharacter());
        IJavaElement hoverElement = this.getHoveredElement(typeRoot, hoveredOffset);
        DocumentFormat documentFormat = params.getDocumentFormat();
        boolean surroundEqualsWithSpaces = params.isSurroundEqualsWithSpaces();
        ArrayList<Hover> hovers = new ArrayList<Hover>();
        this.collectHover(uri, typeRoot, hoverElement, utils, hoverPosition, documentFormat, surroundEqualsWithSpaces, hovers, monitor);
        if (hovers.isEmpty()) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return (Hover)hovers.get(0);
    }

    public JavaCursorContextResult javaCursorContext(MicroProfileJavaCompletionParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return new JavaCursorContextResult(JavaCursorContextKind.IN_EMPTY_FILE, "");
        }
        CompilationUnit ast = ASTResolving.createQuickFixAST((ICompilationUnit)((ICompilationUnit)typeRoot), (IProgressMonitor)monitor);
        JavaCursorContextKind kind = PropertiesManagerForJava.getJavaCursorContextKind(params, typeRoot, ast, utils, monitor);
        String prefix = PropertiesManagerForJava.getJavaCursorPrefix(params, typeRoot, ast, utils, monitor);
        return new JavaCursorContextResult(kind, prefix);
    }

    private static JavaCursorContextKind getJavaCursorContextKind(MicroProfileJavaCompletionParams params, ITypeRoot typeRoot, CompilationUnit ast, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        ASTNode node;
        if (typeRoot.findPrimaryType() == null) {
            return JavaCursorContextKind.IN_EMPTY_FILE;
        }
        Position completionPosition = params.getPosition();
        int completionOffset = utils.toOffset(typeRoot.getBuffer(), completionPosition.getLine(), completionPosition.getCharacter());
        NodeFinder nodeFinder = new NodeFinder((ASTNode)ast, completionOffset, 0);
        ASTNode oldNode = node = nodeFinder.getCoveringNode();
        while (!(node == null || node instanceof AbstractTypeDeclaration && PropertiesManagerForJava.offsetOfFirstNonAnnotationModifier((BodyDeclaration)node) < completionOffset)) {
            if (node.getParent() != null) {
                switch (node.getParent().getNodeType()) {
                    case 23: 
                    case 31: 
                    case 72: 
                    case 82: {
                        if (ASTNodeUtils.isAnnotation(node) || node.getStartPosition() >= completionOffset) break;
                        return JavaCursorContextKind.NONE;
                    }
                }
            }
            oldNode = node;
            node = node.getParent();
        }
        if (node == null) {
            FindWhatsBeingAnnotatedASTVisitor visitor = new FindWhatsBeingAnnotatedASTVisitor(completionOffset, false);
            oldNode.accept((ASTVisitor)visitor);
            switch (visitor.getAnnotatedNodeType()) {
                case 55: 
                case 71: 
                case 81: 
                case 103: {
                    if (visitor.isInAnnotations()) {
                        return JavaCursorContextKind.IN_CLASS_ANNOTATIONS;
                    }
                    return JavaCursorContextKind.BEFORE_CLASS;
                }
            }
            return JavaCursorContextKind.NONE;
        }
        AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)node;
        FindWhatsBeingAnnotatedASTVisitor visitor = new FindWhatsBeingAnnotatedASTVisitor(completionOffset);
        typeDeclaration.accept((ASTVisitor)visitor);
        switch (visitor.getAnnotatedNodeType()) {
            case 55: 
            case 71: 
            case 81: 
            case 103: {
                return visitor.isInAnnotations() ? JavaCursorContextKind.IN_CLASS_ANNOTATIONS : JavaCursorContextKind.BEFORE_CLASS;
            }
            case 31: 
            case 82: {
                return visitor.isInAnnotations() ? JavaCursorContextKind.IN_METHOD_ANNOTATIONS : JavaCursorContextKind.BEFORE_METHOD;
            }
            case 23: 
            case 72: {
                return visitor.isInAnnotations() ? JavaCursorContextKind.IN_FIELD_ANNOTATIONS : JavaCursorContextKind.BEFORE_FIELD;
            }
        }
        return JavaCursorContextKind.IN_CLASS;
    }

    @NonNull
    private static String getJavaCursorPrefix(MicroProfileJavaCompletionParams params, ITypeRoot typeRoot, CompilationUnit ast, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        IBuffer buffer;
        String fileContents;
        int completionOffset;
        block5: {
            Position completionPosition = params.getPosition();
            completionOffset = utils.toOffset(typeRoot.getBuffer(), completionPosition.getLine(), completionPosition.getCharacter());
            fileContents = null;
            try {
                buffer = typeRoot.getBuffer();
                if (buffer != null) break block5;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return "";
            }
        }
        fileContents = buffer.getContents();
        if (fileContents == null) {
            return "";
        }
        int i = completionOffset;
        while (i > 0 && !Character.isWhitespace(fileContents.charAt(i - 1))) {
            --i;
        }
        return fileContents.substring(i, completionOffset);
    }

    private IJavaElement getHoveredElement(ITypeRoot typeRoot, int offset) throws JavaModelException {
        IJavaElement hoverElement = typeRoot.getElementAt(offset);
        if (hoverElement == null) {
            return null;
        }
        if (hoverElement.getElementType() == 9) {
            hoverElement = this.getHoveredMethodParameter((IMethod)hoverElement, offset);
        }
        return hoverElement;
    }

    private IJavaElement getHoveredMethodParameter(IMethod method, int offset) throws JavaModelException {
        ILocalVariable[] parameters = method.getParameters();
        int i = 0;
        while (i < parameters.length) {
            ISourceRange range = parameters[i].getSourceRange();
            int start = range.getOffset();
            int end = start + range.getLength();
            if (start <= offset && offset <= end) {
                return parameters[i];
            }
            ++i;
        }
        return method;
    }

    private void collectHover(String uri, ITypeRoot typeRoot, IJavaElement hoverElement, IJDTUtils utils, Position hoverPosition, DocumentFormat documentFormat, boolean surroundEqualsWithSpaces, List<Hover> hovers, IProgressMonitor monitor) {
        JavaHoverContext context = new JavaHoverContext(uri, typeRoot, utils, hoverElement, hoverPosition, documentFormat, surroundEqualsWithSpaces);
        List<JavaHoverDefinition> definitions = JavaFeaturesRegistry.getInstance().getJavaHoverDefinitions().stream().filter(definition -> definition.isAdaptedForHover(context, monitor)).collect(Collectors.toList());
        if (definitions.isEmpty()) {
            return;
        }
        definitions.forEach(definition -> definition.beginHover(context, monitor));
        definitions.forEach(definition -> {
            Hover hover = definition.collectHover(context, monitor);
            if (hover != null) {
                hovers.add(hover);
            }
        });
        definitions.forEach(definition -> definition.endHover(context, monitor));
    }

    public List<SymbolInformation> workspaceSymbols(String projectUri, IJDTUtils utils, IProgressMonitor monitor) {
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        Optional<IJavaProject> projectOpt = Stream.of(JDTMicroProfileUtils.getJavaProjects()).filter(project -> projectUri.equals(JDTMicroProfileUtils.getProjectURI(project))).findFirst();
        if (projectOpt.isEmpty()) {
            return symbols;
        }
        this.collectWorkspaceSymbols(projectOpt.get(), utils, symbols, monitor);
        return symbols;
    }

    private void collectWorkspaceSymbols(IJavaProject project, IJDTUtils utils, List<SymbolInformation> symbols, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        List<JavaWorkspaceSymbolsDefinition> definitions = JavaFeaturesRegistry.getInstance().getJavaWorkspaceSymbolsDefinitions();
        if (definitions.isEmpty()) {
            return;
        }
        definitions.forEach(definition -> definition.collectSymbols(project, utils, symbols, monitor));
    }

    private static ITypeRoot resolveTypeRoot(String uri, IJDTUtils utils, IProgressMonitor monitor) {
        utils.waitForLifecycleJobs(monitor);
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        IClassFile classFile = null;
        if (unit == null ? (classFile = utils.resolveClassFile(uri)) == null : !unit.getResource().exists() || monitor.isCanceled()) {
            return null;
        }
        return unit != null ? unit : classFile;
    }

    /*
     * WARNING - void declaration
     */
    private static int offsetOfFirstNonAnnotationModifier(BodyDeclaration node) {
        List modifiers = node.modifiers();
        int i2 = 0;
        while (i2 < modifiers.size()) {
            ASTNode modifier = (ASTNode)modifiers.get(i2);
            if (!ASTNodeUtils.isAnnotation(modifier)) {
                return modifier.getStartPosition();
            }
            ++i2;
        }
        BodyDeclaration bodyDeclaration = node;
        if (bodyDeclaration instanceof MethodDeclaration) {
            void method;
            MethodDeclaration i2 = (MethodDeclaration)bodyDeclaration;
            MethodDeclaration cfr_ignored_0 = (MethodDeclaration)bodyDeclaration;
            if (method.getReturnType2() != null) {
                return method.getReturnType2().getStartPosition();
            }
            return method.getName().getStartPosition();
        }
        BodyDeclaration bodyDeclaration2 = node;
        if (bodyDeclaration2 instanceof FieldDeclaration) {
            void field;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration2;
            FieldDeclaration cfr_ignored_1 = (FieldDeclaration)bodyDeclaration2;
            return field.getType().getStartPosition();
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)node;
        int nameOffset = type.getName().getStartPosition();
        int keywordLength = (switch (type.getNodeType()) {
            case 55 -> {
                if (((TypeDeclaration)type).isInterface()) {
                    yield "interface";
                }
                yield "class";
            }
            case 71 -> "enum";
            case 81 -> "@interface";
            case 103 -> "record";
            default -> "";
        }).length();
        return nameOffset - (keywordLength + 1);
    }

    private static boolean isGenerated(ASTNode node) {
        try {
            return (Boolean)node.getClass().getField("$isGenerated").get(node);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return false;
        }
    }

    private static class FindWhatsBeingAnnotatedASTVisitor
    extends ASTVisitor {
        private int completionOffset;
        private int closest = Integer.MAX_VALUE;
        private int annotatedNode = 0;
        private boolean visitedParentType;
        private boolean inAnnotations = false;

        public FindWhatsBeingAnnotatedASTVisitor(int completionOffset, boolean startingInParent) {
            this.completionOffset = completionOffset;
            this.visitedParentType = !startingInParent;
        }

        public FindWhatsBeingAnnotatedASTVisitor(int completionOffset) {
            this(completionOffset, true);
        }

        public boolean visit(MethodDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(FieldDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(EnumConstantDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(AnnotationTypeMemberDeclaration node) {
            return this.visitNode((BodyDeclaration)node);
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        public boolean visit(EnumDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        public boolean visit(RecordDeclaration node) {
            return this.visitAbstractType((AbstractTypeDeclaration)node);
        }

        private boolean visitAbstractType(AbstractTypeDeclaration node) {
            if (!this.visitedParentType) {
                this.visitedParentType = true;
                return true;
            }
            return this.visitNode((BodyDeclaration)node);
        }

        private boolean visitNode(BodyDeclaration node) {
            int start;
            if (PropertiesManagerForJava.isGenerated((ASTNode)node)) {
                return false;
            }
            int n = start = node.modifiers().isEmpty() ? node.getStartPosition() : PropertiesManagerForJava.offsetOfFirstNonAnnotationModifier(node);
            if (start < this.closest && this.completionOffset <= start) {
                this.closest = node.getStartPosition();
                this.annotatedNode = node.getNodeType();
                this.inAnnotations = node.getStartPosition() < this.completionOffset && this.completionOffset <= start;
            }
            return false;
        }

        public int getAnnotatedNodeType() {
            return this.annotatedNode;
        }

        public boolean isInAnnotations() {
            return this.inAnnotations;
        }
    }
}

