/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java.codeaction;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CodeAction;

public class ExtendedCodeAction
extends CodeAction {
    private static final CodeActionComparator CODE_ACTION_COMPARATOR = new CodeActionComparator();
    private transient int relevance;

    public ExtendedCodeAction(String name) {
        super(name);
    }

    public int getRelevance() {
        return this.relevance;
    }

    public void setRelevance(int relevance) {
        this.relevance = relevance;
    }

    public static void sort(List<CodeAction> codeActions) {
        Collections.sort(codeActions, CODE_ACTION_COMPARATOR);
    }

    private static class CodeActionComparator
    implements Comparator<CodeAction> {
        private CodeActionComparator() {
        }

        @Override
        public int compare(CodeAction ca1, CodeAction ca2) {
            String k1 = ca1.getKind();
            String k2 = ca2.getKind();
            if (!(StringUtils.isBlank((CharSequence)k1) || StringUtils.isBlank((CharSequence)k2) || k1.equals(k2))) {
                return k1.compareTo(k2);
            }
            if (ca1 instanceof ExtendedCodeAction && ca2 instanceof ExtendedCodeAction) {
                int r1 = ((ExtendedCodeAction)ca1).getRelevance();
                int r2 = ((ExtendedCodeAction)ca2).getRelevance();
                int relevanceDif = r2 - r1;
                if (relevanceDif != 0) {
                    return relevanceDif;
                }
            }
            return ca1.getTitle().compareToIgnoreCase(ca2.getTitle());
        }
    }
}

