/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.outline.CNFOutlinePage;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class EditorToOutlineAdapterFactory
implements IAdapterFactory {
    private static final String OUTLINE_VIEW_ID = "org.eclipse.ui.views.ContentOutline";
    private static final Map<IEditorPart, LanguageServerWrapper> LANG_SERVER_CACHE = Collections.synchronizedMap(new HashMap());

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        IEditorPart editorPart;
        IEditorInput editorInput;
        if (adapterType == IContentOutlinePage.class && adaptableObject instanceof IEditorPart && (editorInput = (editorPart = (IEditorPart)adaptableObject).getEditorInput()) != null && LanguageServersRegistry.getInstance().canUseLanguageServer(editorInput)) {
            LanguageServerWrapper server = LANG_SERVER_CACHE.remove(adaptableObject);
            if (server != null && server.isActive()) {
                return adapterType.cast(EditorToOutlineAdapterFactory.createOutlinePage(editorPart, server));
            }
            IDocument document = LSPEclipseUtils.getDocument(editorInput);
            if (document != null) {
                CompletableFuture<Optional<LanguageServerWrapper>> languageServer = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(capabilities -> LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getDocumentSymbolProvider()))).computeFirst((w, ls) -> CompletableFuture.completedFuture(w));
                try {
                    return languageServer.get(50L, TimeUnit.MILLISECONDS).filter(Objects::nonNull).filter(LanguageServerWrapper::isActive).map(s -> adapterType.cast(EditorToOutlineAdapterFactory.createOutlinePage(editorPart, s))).orElse(null);
                }
                catch (TimeoutException e) {
                    EditorToOutlineAdapterFactory.refreshContentOutlineAsync(languageServer, editorPart);
                }
                catch (ExecutionException e) {
                    LanguageServerPlugin.logError(e);
                }
                catch (InterruptedException e) {
                    LanguageServerPlugin.logError(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IContentOutlinePage.class};
    }

    private static CNFOutlinePage createOutlinePage(IEditorPart editorPart, @NonNull LanguageServerWrapper wrapper) {
        return new CNFOutlinePage(wrapper, UI.asTextEditor(editorPart));
    }

    private static void refreshContentOutlineAsync(CompletableFuture<Optional<LanguageServerWrapper>> wrapper, IEditorPart editorPart) {
        wrapper.thenAcceptAsync(servers -> {
            if (!servers.isEmpty()) {
                Display.getDefault().asyncExec(() -> {
                    IViewPart viewPart;
                    IWorkbenchPage page = UI.getActivePage();
                    if (page != null && (viewPart = page.findView(OUTLINE_VIEW_ID)) instanceof ContentOutline) {
                        ContentOutline contentOutline = (ContentOutline)viewPart;
                        LANG_SERVER_CACHE.put(editorPart, (LanguageServerWrapper)servers.get());
                        contentOutline.partActivated((IWorkbenchPart)editorPart);
                    }
                });
            }
        });
    }
}

