/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.machine.teditor.ide.contentassist.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.lsat.machine.teditor.ide.contentassist.antlr.internal.InternalMachineParser;
import org.eclipse.lsat.machine.teditor.services.MachineGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.AbstractContentAssistParser;

public class MachineParser extends AbstractContentAssistParser {

	@Singleton
	public static final class NameMappings {
		
		private final Map<AbstractElement, String> mappings;
		
		@Inject
		public NameMappings(MachineGrammarAccess grammarAccess) {
			ImmutableMap.Builder<AbstractElement, String> builder = ImmutableMap.builder();
			init(builder, grammarAccess);
			this.mappings = builder.build();
		}
		
		public String getRuleName(AbstractElement element) {
			return mappings.get(element);
		}
		
		private static void init(ImmutableMap.Builder<AbstractElement, String> builder, MachineGrammarAccess grammarAccess) {
			builder.put(grammarAccess.getMachineAccess().getAlternatives_4(), "rule__Machine__Alternatives_4");
			builder.put(grammarAccess.getPathAccess().getAlternatives(), "rule__Path__Alternatives");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getAlternatives_4(), "rule__UnidirectionalPath__Alternatives_4");
			builder.put(grammarAccess.getBidirectionalPathAccess().getAlternatives_4(), "rule__BidirectionalPath__Alternatives_4");
			builder.put(grammarAccess.getFullMeshPathAccess().getAlternatives_3(), "rule__FullMeshPath__Alternatives_3");
			builder.put(grammarAccess.getIIDAccess().getAlternatives(), "rule__IID__Alternatives");
			builder.put(grammarAccess.getResourceTypeAccess().getAlternatives(), "rule__ResourceType__Alternatives");
			builder.put(grammarAccess.getMachineAccess().getGroup(), "rule__Machine__Group__0");
			builder.put(grammarAccess.getMachineAccess().getGroup_2(), "rule__Machine__Group_2__0");
			builder.put(grammarAccess.getMachineAccess().getGroup_3(), "rule__Machine__Group_3__0");
			builder.put(grammarAccess.getImportAccess().getGroup(), "rule__Import__Group__0");
			builder.put(grammarAccess.getPathAnnotationAccess().getGroup(), "rule__PathAnnotation__Group__0");
			builder.put(grammarAccess.getPeripheralTypeAccess().getGroup(), "rule__PeripheralType__Group__0");
			builder.put(grammarAccess.getPeripheralTypeAccess().getGroup_4(), "rule__PeripheralType__Group_4__0");
			builder.put(grammarAccess.getPeripheralTypeAccess().getGroup_5(), "rule__PeripheralType__Group_5__0");
			builder.put(grammarAccess.getPeripheralTypeAccess().getGroup_5_8(), "rule__PeripheralType__Group_5_8__0");
			builder.put(grammarAccess.getActionTypeAccess().getGroup(), "rule__ActionType__Group__0");
			builder.put(grammarAccess.getSetPointAccess().getGroup(), "rule__SetPoint__Group__0");
			builder.put(grammarAccess.getSetPointAccess().getGroup_2(), "rule__SetPoint__Group_2__0");
			builder.put(grammarAccess.getAxisAccess().getGroup(), "rule__Axis__Group__0");
			builder.put(grammarAccess.getAxisAccess().getGroup_2(), "rule__Axis__Group_2__0");
			builder.put(grammarAccess.getAxisAccess().getGroup_3(), "rule__Axis__Group_3__0");
			builder.put(grammarAccess.getAxisAccess().getGroup_3_2(), "rule__Axis__Group_3_2__0");
			builder.put(grammarAccess.getResourceItemAccess().getGroup(), "rule__ResourceItem__Group__0");
			builder.put(grammarAccess.getResourceAccess().getGroup(), "rule__Resource__Group__0");
			builder.put(grammarAccess.getResourceAccess().getGroup_2(), "rule__Resource__Group_2__0");
			builder.put(grammarAccess.getResourceAccess().getGroup_2_2(), "rule__Resource__Group_2_2__0");
			builder.put(grammarAccess.getPeripheralAccess().getGroup(), "rule__Peripheral__Group__0");
			builder.put(grammarAccess.getPeripheralAccess().getGroup_3(), "rule__Peripheral__Group_3__0");
			builder.put(grammarAccess.getPeripheralAccess().getGroup_3_1(), "rule__Peripheral__Group_3_1__0");
			builder.put(grammarAccess.getPeripheralAccess().getGroup_3_1_0(), "rule__Peripheral__Group_3_1_0__0");
			builder.put(grammarAccess.getPeripheralAccess().getGroup_3_1_1(), "rule__Peripheral__Group_3_1_1__0");
			builder.put(grammarAccess.getPeripheralAccess().getGroup_3_1_5(), "rule__Peripheral__Group_3_1_5__0");
			builder.put(grammarAccess.getPeripheralAccess().getGroup_3_1_7(), "rule__Peripheral__Group_3_1_7__0");
			builder.put(grammarAccess.getPeripheralAccess().getGroup_3_1_8(), "rule__Peripheral__Group_3_1_8__0");
			builder.put(grammarAccess.getDistanceAccess().getGroup(), "rule__Distance__Group__0");
			builder.put(grammarAccess.getDistanceAccess().getGroup_2(), "rule__Distance__Group_2__0");
			builder.put(grammarAccess.getDistanceAccess().getGroup_2_2(), "rule__Distance__Group_2_2__0");
			builder.put(grammarAccess.getAxisPositionsMapEntryAccess().getGroup(), "rule__AxisPositionsMapEntry__Group__0");
			builder.put(grammarAccess.getAxisPositionsMapEntryAccess().getGroup_2(), "rule__AxisPositionsMapEntry__Group_2__0");
			builder.put(grammarAccess.getAxisPositionsMapEntryAccess().getGroup_2_2(), "rule__AxisPositionsMapEntry__Group_2_2__0");
			builder.put(grammarAccess.getPositionAccess().getGroup(), "rule__Position__Group__0");
			builder.put(grammarAccess.getSymbolicPositionAccess().getGroup(), "rule__SymbolicPosition__Group__0");
			builder.put(grammarAccess.getSymbolicPositionAccess().getGroup_2(), "rule__SymbolicPosition__Group_2__0");
			builder.put(grammarAccess.getSymbolicPositionAccess().getGroup_2_2(), "rule__SymbolicPosition__Group_2_2__0");
			builder.put(grammarAccess.getAxisPositionMapEntryAccess().getGroup(), "rule__AxisPositionMapEntry__Group__0");
			builder.put(grammarAccess.getProfileAccess().getGroup(), "rule__Profile__Group__0");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getGroup(), "rule__UnidirectionalPath__Group__0");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getGroup_4_0(), "rule__UnidirectionalPath__Group_4_0__0");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getGroup_4_0_2(), "rule__UnidirectionalPath__Group_4_0_2__0");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getGroup_4_1(), "rule__UnidirectionalPath__Group_4_1__0");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getGroup_5(), "rule__UnidirectionalPath__Group_5__0");
			builder.put(grammarAccess.getBidirectionalPathAccess().getGroup(), "rule__BidirectionalPath__Group__0");
			builder.put(grammarAccess.getBidirectionalPathAccess().getGroup_4_0(), "rule__BidirectionalPath__Group_4_0__0");
			builder.put(grammarAccess.getBidirectionalPathAccess().getGroup_4_0_2(), "rule__BidirectionalPath__Group_4_0_2__0");
			builder.put(grammarAccess.getBidirectionalPathAccess().getGroup_4_1(), "rule__BidirectionalPath__Group_4_1__0");
			builder.put(grammarAccess.getBidirectionalPathAccess().getGroup_5(), "rule__BidirectionalPath__Group_5__0");
			builder.put(grammarAccess.getFullMeshPathAccess().getGroup(), "rule__FullMeshPath__Group__0");
			builder.put(grammarAccess.getFullMeshPathAccess().getGroup_3_0(), "rule__FullMeshPath__Group_3_0__0");
			builder.put(grammarAccess.getFullMeshPathAccess().getGroup_3_0_2(), "rule__FullMeshPath__Group_3_0_2__0");
			builder.put(grammarAccess.getFullMeshPathAccess().getGroup_3_1(), "rule__FullMeshPath__Group_3_1__0");
			builder.put(grammarAccess.getFullMeshPathAccess().getGroup_4(), "rule__FullMeshPath__Group_4__0");
			builder.put(grammarAccess.getPathTargetReferenceAccess().getGroup(), "rule__PathTargetReference__Group__0");
			builder.put(grammarAccess.getPathTargetReferenceAccess().getGroup_2(), "rule__PathTargetReference__Group_2__0");
			builder.put(grammarAccess.getPathTargetReferenceAccess().getGroup_2_2(), "rule__PathTargetReference__Group_2_2__0");
			builder.put(grammarAccess.getMachineAccess().getImportsAssignment_1(), "rule__Machine__ImportsAssignment_1");
			builder.put(grammarAccess.getMachineAccess().getTypeAssignment_2_1(), "rule__Machine__TypeAssignment_2_1");
			builder.put(grammarAccess.getMachineAccess().getPathAnnotationsAssignment_3_2(), "rule__Machine__PathAnnotationsAssignment_3_2");
			builder.put(grammarAccess.getMachineAccess().getPeripheralTypesAssignment_4_0(), "rule__Machine__PeripheralTypesAssignment_4_0");
			builder.put(grammarAccess.getMachineAccess().getResourcesAssignment_4_1(), "rule__Machine__ResourcesAssignment_4_1");
			builder.put(grammarAccess.getImportAccess().getImportURIAssignment_1(), "rule__Import__ImportURIAssignment_1");
			builder.put(grammarAccess.getPathAnnotationAccess().getNameAssignment_1(), "rule__PathAnnotation__NameAssignment_1");
			builder.put(grammarAccess.getPeripheralTypeAccess().getNameAssignment_2(), "rule__PeripheralType__NameAssignment_2");
			builder.put(grammarAccess.getPeripheralTypeAccess().getActionsAssignment_4_2(), "rule__PeripheralType__ActionsAssignment_4_2");
			builder.put(grammarAccess.getPeripheralTypeAccess().getSetPointsAssignment_5_2(), "rule__PeripheralType__SetPointsAssignment_5_2");
			builder.put(grammarAccess.getPeripheralTypeAccess().getAxesAssignment_5_6(), "rule__PeripheralType__AxesAssignment_5_6");
			builder.put(grammarAccess.getPeripheralTypeAccess().getConversionAssignment_5_8_1(), "rule__PeripheralType__ConversionAssignment_5_8_1");
			builder.put(grammarAccess.getActionTypeAccess().getNameAssignment_1(), "rule__ActionType__NameAssignment_1");
			builder.put(grammarAccess.getSetPointAccess().getNameAssignment_1(), "rule__SetPoint__NameAssignment_1");
			builder.put(grammarAccess.getSetPointAccess().getUnitAssignment_2_1(), "rule__SetPoint__UnitAssignment_2_1");
			builder.put(grammarAccess.getAxisAccess().getNameAssignment_1(), "rule__Axis__NameAssignment_1");
			builder.put(grammarAccess.getAxisAccess().getUnitAssignment_2_1(), "rule__Axis__UnitAssignment_2_1");
			builder.put(grammarAccess.getAxisAccess().getSetPointsAssignment_3_1(), "rule__Axis__SetPointsAssignment_3_1");
			builder.put(grammarAccess.getAxisAccess().getSetPointsAssignment_3_2_1(), "rule__Axis__SetPointsAssignment_3_2_1");
			builder.put(grammarAccess.getResourceItemAccess().getNameAssignment_1(), "rule__ResourceItem__NameAssignment_1");
			builder.put(grammarAccess.getResourceAccess().getResourceTypeAssignment_0(), "rule__Resource__ResourceTypeAssignment_0");
			builder.put(grammarAccess.getResourceAccess().getNameAssignment_1(), "rule__Resource__NameAssignment_1");
			builder.put(grammarAccess.getResourceAccess().getItemsAssignment_2_1(), "rule__Resource__ItemsAssignment_2_1");
			builder.put(grammarAccess.getResourceAccess().getItemsAssignment_2_2_1(), "rule__Resource__ItemsAssignment_2_2_1");
			builder.put(grammarAccess.getResourceAccess().getPeripheralsAssignment_4(), "rule__Resource__PeripheralsAssignment_4");
			builder.put(grammarAccess.getPeripheralAccess().getNameAssignment_0(), "rule__Peripheral__NameAssignment_0");
			builder.put(grammarAccess.getPeripheralAccess().getTypeAssignment_2(), "rule__Peripheral__TypeAssignment_2");
			builder.put(grammarAccess.getPeripheralAccess().getAxisPositionsAssignment_3_1_0_2(), "rule__Peripheral__AxisPositionsAssignment_3_1_0_2");
			builder.put(grammarAccess.getPeripheralAccess().getPositionsAssignment_3_1_1_2(), "rule__Peripheral__PositionsAssignment_3_1_1_2");
			builder.put(grammarAccess.getPeripheralAccess().getProfilesAssignment_3_1_4(), "rule__Peripheral__ProfilesAssignment_3_1_4");
			builder.put(grammarAccess.getPeripheralAccess().getProfilesAssignment_3_1_5_1(), "rule__Peripheral__ProfilesAssignment_3_1_5_1");
			builder.put(grammarAccess.getPeripheralAccess().getDistancesAssignment_3_1_7_2(), "rule__Peripheral__DistancesAssignment_3_1_7_2");
			builder.put(grammarAccess.getPeripheralAccess().getPathsAssignment_3_1_8_2(), "rule__Peripheral__PathsAssignment_3_1_8_2");
			builder.put(grammarAccess.getDistanceAccess().getNameAssignment_1(), "rule__Distance__NameAssignment_1");
			builder.put(grammarAccess.getDistanceAccess().getSettlingAssignment_2_1(), "rule__Distance__SettlingAssignment_2_1");
			builder.put(grammarAccess.getDistanceAccess().getSettlingAssignment_2_2_1(), "rule__Distance__SettlingAssignment_2_2_1");
			builder.put(grammarAccess.getAxisPositionsMapEntryAccess().getKeyAssignment_1(), "rule__AxisPositionsMapEntry__KeyAssignment_1");
			builder.put(grammarAccess.getAxisPositionsMapEntryAccess().getValueAssignment_2_1(), "rule__AxisPositionsMapEntry__ValueAssignment_2_1");
			builder.put(grammarAccess.getAxisPositionsMapEntryAccess().getValueAssignment_2_2_1(), "rule__AxisPositionsMapEntry__ValueAssignment_2_2_1");
			builder.put(grammarAccess.getPositionAccess().getNameAssignment_1(), "rule__Position__NameAssignment_1");
			builder.put(grammarAccess.getSymbolicPositionAccess().getNameAssignment_1(), "rule__SymbolicPosition__NameAssignment_1");
			builder.put(grammarAccess.getSymbolicPositionAccess().getAxisPositionAssignment_2_1(), "rule__SymbolicPosition__AxisPositionAssignment_2_1");
			builder.put(grammarAccess.getSymbolicPositionAccess().getAxisPositionAssignment_2_2_1(), "rule__SymbolicPosition__AxisPositionAssignment_2_2_1");
			builder.put(grammarAccess.getAxisPositionMapEntryAccess().getKeyAssignment_1(), "rule__AxisPositionMapEntry__KeyAssignment_1");
			builder.put(grammarAccess.getAxisPositionMapEntryAccess().getValueAssignment_3(), "rule__AxisPositionMapEntry__ValueAssignment_3");
			builder.put(grammarAccess.getProfileAccess().getNameAssignment_1(), "rule__Profile__NameAssignment_1");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getSourceAssignment_1(), "rule__UnidirectionalPath__SourceAssignment_1");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getTargetAssignment_3(), "rule__UnidirectionalPath__TargetAssignment_3");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getProfilesAssignment_4_0_1(), "rule__UnidirectionalPath__ProfilesAssignment_4_0_1");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getProfilesAssignment_4_0_2_1(), "rule__UnidirectionalPath__ProfilesAssignment_4_0_2_1");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getProfilesAssignment_4_1_1(), "rule__UnidirectionalPath__ProfilesAssignment_4_1_1");
			builder.put(grammarAccess.getUnidirectionalPathAccess().getAnnotationsAssignment_5_1(), "rule__UnidirectionalPath__AnnotationsAssignment_5_1");
			builder.put(grammarAccess.getBidirectionalPathAccess().getEndPointsAssignment_1(), "rule__BidirectionalPath__EndPointsAssignment_1");
			builder.put(grammarAccess.getBidirectionalPathAccess().getEndPointsAssignment_3(), "rule__BidirectionalPath__EndPointsAssignment_3");
			builder.put(grammarAccess.getBidirectionalPathAccess().getProfilesAssignment_4_0_1(), "rule__BidirectionalPath__ProfilesAssignment_4_0_1");
			builder.put(grammarAccess.getBidirectionalPathAccess().getProfilesAssignment_4_0_2_1(), "rule__BidirectionalPath__ProfilesAssignment_4_0_2_1");
			builder.put(grammarAccess.getBidirectionalPathAccess().getProfilesAssignment_4_1_1(), "rule__BidirectionalPath__ProfilesAssignment_4_1_1");
			builder.put(grammarAccess.getBidirectionalPathAccess().getAnnotationsAssignment_5_1(), "rule__BidirectionalPath__AnnotationsAssignment_5_1");
			builder.put(grammarAccess.getFullMeshPathAccess().getProfilesAssignment_3_0_1(), "rule__FullMeshPath__ProfilesAssignment_3_0_1");
			builder.put(grammarAccess.getFullMeshPathAccess().getProfilesAssignment_3_0_2_1(), "rule__FullMeshPath__ProfilesAssignment_3_0_2_1");
			builder.put(grammarAccess.getFullMeshPathAccess().getProfilesAssignment_3_1_1(), "rule__FullMeshPath__ProfilesAssignment_3_1_1");
			builder.put(grammarAccess.getFullMeshPathAccess().getAnnotationsAssignment_4_1(), "rule__FullMeshPath__AnnotationsAssignment_4_1");
			builder.put(grammarAccess.getFullMeshPathAccess().getEndPointsAssignment_5(), "rule__FullMeshPath__EndPointsAssignment_5");
			builder.put(grammarAccess.getPathTargetReferenceAccess().getPositionAssignment_1(), "rule__PathTargetReference__PositionAssignment_1");
			builder.put(grammarAccess.getPathTargetReferenceAccess().getSettlingAssignment_2_1(), "rule__PathTargetReference__SettlingAssignment_2_1");
			builder.put(grammarAccess.getPathTargetReferenceAccess().getSettlingAssignment_2_2_1(), "rule__PathTargetReference__SettlingAssignment_2_2_1");
		}
	}
	
	@Inject
	private NameMappings nameMappings;

	@Inject
	private MachineGrammarAccess grammarAccess;

	@Override
	protected InternalMachineParser createParser() {
		InternalMachineParser result = new InternalMachineParser(null);
		result.setGrammarAccess(grammarAccess);
		return result;
	}

	@Override
	protected String getRuleName(AbstractElement element) {
		return nameMappings.getRuleName(element);
	}

	@Override
	protected String[] getInitialHiddenTokens() {
		return new String[] { "RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT" };
	}

	public MachineGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(MachineGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
	
	public NameMappings getNameMappings() {
		return nameMappings;
	}
	
	public void setNameMappings(NameMappings nameMappings) {
		this.nameMappings = nameMappings;
	}
}
