/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.mpt.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.mpt.Matrix;
import org.eclipse.lsat.common.mpt.RowVector;

public final class SpecificationValidator {
    private SpecificationValidator() {
    }

    public static boolean allMatricesSameSize(Collection<Matrix> matrixCollection) {
        Matrix first = matrixCollection.iterator().next();
        int rows = first.getRows().size();
        int columns = ((RowVector)first.getRows().get(0)).getValues().size();
        for (Matrix m : matrixCollection) {
            if (m.getRows().size() != rows) {
                return false;
            }
            if (((RowVector)m.getRows().get(0)).getValues().size() == columns) continue;
            return false;
        }
        return true;
    }

    public static Set<Integer> findUnusedResources(Collection<Matrix> matrices) {
        int resourceCount = matrices.iterator().next().getRows().size();
        List usedResourcesPerMatrix = matrices.stream().map(m -> SpecificationValidator.findUnusedResourcesInMatrix(m)).collect(Collectors.toList());
        HashSet<Integer> unusedResources = new HashSet<Integer>();
        int resId = 0;
        while (resId < resourceCount) {
            int res = resId;
            boolean unusedInAllMatrices = usedResourcesPerMatrix.stream().allMatch(s -> s.contains(res));
            if (unusedInAllMatrices) {
                unusedResources.add(resId);
            }
            ++resId;
        }
        return unusedResources;
    }

    public static Set<Integer> findUnusedResourcesInMatrix(Matrix matrix) {
        int matrixSize = matrix.getRows().size();
        HashSet<Integer> unusedResources = new HashSet<Integer>();
        int resId = 0;
        while (resId < matrixSize) {
            boolean identityRow = true;
            int column = 0;
            while (column < matrixSize) {
                if (resId == column) {
                    if (matrix.getValue(resId, column) != 0.0) {
                        identityRow = false;
                        break;
                    }
                } else if (resId != column && matrix.getValue(resId, column) != Double.NEGATIVE_INFINITY) {
                    identityRow = false;
                    break;
                }
                ++column;
            }
            boolean identityColumn = true;
            int row = 0;
            while (row < matrixSize) {
                if (resId == row) {
                    if (matrix.getValue(row, resId) != 0.0) {
                        identityColumn = false;
                        break;
                    }
                } else if (resId != row && matrix.getValue(row, resId) != Double.NEGATIVE_INFINITY) {
                    identityColumn = false;
                    break;
                }
                ++row;
            }
            if (identityRow && identityColumn) {
                unusedResources.add(resId);
            }
            ++resId;
        }
        return unusedResources;
    }

    public static Set<Integer> findUnconnectedResources(Collection<Matrix> matrices) {
        int resourceCount = matrices.iterator().next().getRows().size();
        List unconnectedResourcesPerMatrix = matrices.stream().map(m -> SpecificationValidator.findUnconnectedResourcesInMatrix(m)).collect(Collectors.toList());
        HashSet<Integer> unconnectedResources = new HashSet<Integer>();
        int resId = 0;
        while (resId < resourceCount) {
            int res = resId;
            boolean unconnectedInAllMatrices = unconnectedResourcesPerMatrix.stream().allMatch(s -> s.contains(res));
            if (unconnectedInAllMatrices) {
                unconnectedResources.add(resId);
            }
            ++resId;
        }
        return unconnectedResources;
    }

    public static Set<Integer> findUnconnectedResourcesInMatrix(Matrix matrix) {
        int matrixSize = matrix.getRows().size();
        HashSet<Integer> unconnectedResources = new HashSet<Integer>();
        int resId = 0;
        while (resId < matrixSize) {
            boolean identityColumn = true;
            int column = 0;
            while (column < matrixSize) {
                if (resId == column) {
                    if (matrix.getValue(resId, column) != 0.0) {
                        identityColumn = false;
                        break;
                    }
                } else if (resId != column && matrix.getValue(resId, column) != Double.NEGATIVE_INFINITY) {
                    identityColumn = false;
                    break;
                }
                ++column;
            }
            if (identityColumn) {
                unconnectedResources.add(resId);
            }
            ++resId;
        }
        return unconnectedResources;
    }
}

