/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.benchmarking;

import java.io.PrintWriter;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionDouble;
import org.eclipse.lsat.common.ludus.backend.datastructures.weights.DoubleWeightFunctionInt;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.Benchmark;
import org.eclipse.lsat.common.ludus.backend.games.benchmarking.generator.Sprand;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.JGraphTEdge;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGDoubleImplJGraphT;
import org.eclipse.lsat.common.ludus.backend.graph.jgrapht.ratio.RGIntImplJGraphT;

public class EpsilonVaryingBenchmark
extends Benchmark {
    private final String name;
    private final Integer numberOfVerticesMin;
    private final Integer numberOfVerticesMax;
    private final Integer stepSize;
    private final Integer edgeRatio;
    private final Integer maxWeight1;
    private final Integer maxWeight2;
    private PrintWriter file;

    public EpsilonVaryingBenchmark(String name, Integer numberOfVerticesMin, Integer numberOfVerticesMax, Integer stepSize, Integer edgeRatio, Integer maxWeight1, Integer maxWeight2) {
        this.name = name;
        this.numberOfVerticesMin = numberOfVerticesMin;
        this.numberOfVerticesMax = numberOfVerticesMax;
        this.stepSize = stepSize;
        this.edgeRatio = edgeRatio;
        this.maxWeight1 = maxWeight1;
        this.maxWeight2 = maxWeight2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void run(Integer numberOfIterations, boolean runPI, boolean runEG, boolean runZP) {
        this.file = this.getFile(this.name);
        this.file.printf("%s,%s,%s,%s,%s,%s,%s,%s\n", "N", "edgeRatio", "maxWeight1", "maxWeight2", "PolicyIterationN", "PolicyIterationR10E-13", "PolicyIterationR10E-10", "PolicyIterationR10E-5");
        System.out.printf("%s,%s,%s,%s,%s,%s,%s,%s\n", "N", "edgeRatio", "maxWeight1", "maxWeight2", "PolicyIterationN", "PolicyIterationR10E-13", "PolicyIterationR10E-10", "PolicyIterationR10E-5");
        int runId = 0;
        while (runId < numberOfIterations) {
            int v = this.numberOfVerticesMin;
            while (v <= this.numberOfVerticesMax) {
                this.runAlgorithmsSprand(v, this.edgeRatio, this.maxWeight1, this.maxWeight2);
                v += this.stepSize.intValue();
            }
            ++runId;
        }
        this.file.close();
    }

    private void runAlgorithmsSprand(Integer numberOfVertices, Integer edgeRatio, Integer maxWeight1, Integer maxWeight2) {
        RGIntImplJGraphT sprandGraph = Sprand.generateRatioGame(numberOfVertices, edgeRatio, maxWeight1, maxWeight2);
        float piSec = 0.0f;
        if (this.runPI) {
            long piResult = this.runPI(sprandGraph);
            piSec = (float)piResult / 1.0E9f;
        }
        RGDoubleImplJGraphT sprandDoubleGraph = this.toDoubleGameGraph(sprandGraph);
        Double epsilon = 1.0E-12;
        float piSecD1 = 0.0f;
        if (this.runPI) {
            long piResult = this.runPI(sprandDoubleGraph, epsilon);
            piSecD1 = (float)piResult / 1.0E9f;
        }
        epsilon = 1.0E-9;
        float piSecD2 = 0.0f;
        if (this.runPI) {
            long piResult = this.runPI(sprandDoubleGraph, epsilon);
            piSecD2 = (float)piResult / 1.0E9f;
        }
        epsilon = 1.0E-4;
        float piSecD3 = 0.0f;
        if (this.runPI) {
            long piResult = this.runPI(sprandDoubleGraph, epsilon);
            piSecD3 = (float)piResult / 1.0E9f;
        }
        this.file.printf("%d,%d,%d,%d,%f,%f,%f,%f\n", numberOfVertices, edgeRatio, maxWeight1, maxWeight2, Float.valueOf(piSec), Float.valueOf(piSecD1), Float.valueOf(piSecD2), Float.valueOf(piSecD3));
        System.out.printf("%d,%d,%d,%d,%f,%f,%f,%f\n", numberOfVertices, edgeRatio, maxWeight1, maxWeight2, Float.valueOf(piSec), Float.valueOf(piSecD1), Float.valueOf(piSecD2), Float.valueOf(piSecD3));
    }

    private RGDoubleImplJGraphT toDoubleGameGraph(RGIntImplJGraphT ratioGame) {
        DoubleWeightFunctionInt<JGraphTEdge> f = ratioGame.getEdgeWeights();
        DoubleWeightFunctionDouble<JGraphTEdge> weights = new DoubleWeightFunctionDouble<JGraphTEdge>();
        for (JGraphTEdge e : ratioGame.getEdges()) {
            weights.addWeight(e, (double)((Integer)f.getWeight1((Object)e)).intValue() * 1.0, (double)((Integer)f.getWeight2((Object)e)).intValue() * 1.0);
        }
        return new RGDoubleImplJGraphT(ratioGame.getGraph(), weights);
    }
}

