/*
 * Copyright (C) 2018 Ossdev07
 *
 * This file is part of the JNR project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package jnr.a64asm;

public enum ERROR_CODE {

    /** No error (success). */
    ERROR_NONE,

    /** Memory allocation error (@c ASMJIT_MALLOC returned @c NULL). */
    ERROR_NO_HEAP_MEMORY,

    /** Virtual memory allocation error (@c VirtualMemory returned @c NULL). */
    ERROR_NO_VIRTUAL_MEMORY,

    /** Unknown instruction. This happens only if instruction code is
    *out of bounds. Shouldn't happen. */
    ERROR_UNKNOWN_INSTRUCTION,

    /**
    * Illegal instruction.
    *
    * Usually generated by AsmJit::AssemblerCore class when emitting instruction
    * opcode. If this error is generated the target buffer is not affected by
    * this invalid instruction. In debug mode you get assertion failure instead.
    */
    ERROR_ILLEGAL_INSTRUCTION,

    /** Illegal addressing used (unencodable). */
    ERROR_ILLEGAL_ADDRESING,

    /** Short jump instruction used, but displacement is out of bounds. */
    ERROR_ILLEGAL_SHORT_JUMP,

    /** Count of error codes by AsmJit. Can grow in future. */
    _ERROR_COUNT;

    public final int intValue() {
        return ordinal();
    }
}
