/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.MappedSeriesSettings;
import org.eclipse.swtchart.extensions.core.MappingsKey;
import org.eclipse.swtchart.extensions.core.MappingsSupport;
import org.eclipse.swtchart.extensions.core.MappingsType;

public class SeriesMapper {
    private static final Map<MappingsKey, ISeriesSettings> MAPPINGS = new HashMap<MappingsKey, ISeriesSettings>();

    private SeriesMapper() {
    }

    public static void clear() {
        MAPPINGS.clear();
    }

    public static void remove(MappingsKey mappingsKey) {
        MAPPINGS.remove(mappingsKey);
    }

    public static void put(MappingsKey mappingsKey, ISeriesSettings seriesSettings) {
        if (seriesSettings != null) {
            MAPPINGS.put(mappingsKey, seriesSettings);
        }
    }

    public static ISeriesSettings get(ISeries<?> series, BaseChart baseChart) {
        MappingsKey mappingsKeyX;
        MappingsKey mappingsKey;
        String id;
        ISeriesSettings seriesSettings;
        MappingsType mappingsType;
        ISeriesSettings seriesSettingsMapped = null;
        if (baseChart != null && SeriesMapper.isValidMappingsType(mappingsType = MappingsSupport.getMappingsType(seriesSettings = baseChart.getSeriesSettings(id = series.getId()))) && (seriesSettingsMapped = MAPPINGS.get(mappingsKey = new MappingsKey(mappingsType, id))) == null && (mappingsKeyX = SeriesMapper.getKeyViaRegex(mappingsKey)) != null) {
            seriesSettingsMapped = MAPPINGS.get(mappingsKeyX);
        }
        return seriesSettingsMapped;
    }

    public static void map(ISeries<?> series, BaseChart baseChart) {
        MappingsType mappingsType;
        String id = series.getId();
        ISeriesSettings seriesSettings = baseChart.getSeriesSettings(id);
        ISeriesSettings seriesSettingsCopy = MappingsSupport.copySettings(seriesSettings);
        if (seriesSettingsCopy != null && SeriesMapper.isValidMappingsType(mappingsType = MappingsSupport.getMappingsType(seriesSettings))) {
            SeriesMapper.put(new MappingsKey(mappingsType, id), seriesSettingsCopy);
        }
    }

    public static void unmap(ISeries<?> series, BaseChart baseChart) {
        String seriesId = series.getId();
        ISeriesSettings seriesSettings = baseChart.getSeriesSettings(seriesId);
        MappingsType mappingsType = MappingsSupport.getMappingsType(seriesSettings);
        SeriesMapper.remove(new MappingsKey(mappingsType, seriesId));
        baseChart.resetSeriesSettings(series);
    }

    public static List<MappedSeriesSettings> getMappings() {
        ArrayList<MappedSeriesSettings> mappings = new ArrayList<MappedSeriesSettings>();
        for (Map.Entry<MappingsKey, ISeriesSettings> entry : MAPPINGS.entrySet()) {
            MappingsKey mappingsKey = entry.getKey();
            MappingsType mappingsType = mappingsKey.getMappingsType();
            if (MappingsType.NONE.equals((Object)mappingsType)) continue;
            String id = mappingsKey.getId();
            ISeriesSettings seriesSettings = entry.getValue();
            mappings.add(new MappedSeriesSettings(mappingsType, id, seriesSettings));
        }
        return mappings;
    }

    public static void update(BaseChart baseChart) {
        ISeriesSet seriesSet = baseChart.getSeriesSet();
        ISeries[] iSeriesArray = seriesSet.getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            String id = series.getId();
            ISeriesSettings seriesSettings = baseChart.getSeriesSettings(id);
            MappingsType mappingsType = MappingsSupport.getMappingsType(seriesSettings);
            MappingsKey mappingsKey = new MappingsKey(mappingsType, id);
            if (MAPPINGS.containsKey(mappingsKey)) {
                baseChart.applySeriesSettings(series, seriesSettings);
            } else {
                MappingsKey mappingsKeyX = SeriesMapper.getKeyViaRegex(mappingsKey);
                if (mappingsKeyX != null) {
                    baseChart.applySeriesSettings(series, seriesSettings);
                }
            }
            ++n2;
        }
    }

    private static boolean isValidMappingsType(MappingsType mappingsType) {
        return !MappingsType.NONE.equals((Object)mappingsType);
    }

    private static MappingsKey getKeyViaRegex(MappingsKey mappingsKey) {
        for (MappingsKey mappingsKeyStored : MAPPINGS.keySet()) {
            try {
                String regularExpression;
                if (MappingsType.NONE.equals((Object)mappingsKeyStored.getMappingsType()) || !mappingsKeyStored.getMappingsType().equals((Object)mappingsKey.getMappingsType()) || (regularExpression = mappingsKeyStored.getId()).isEmpty()) continue;
                String id = mappingsKey.getId();
                Pattern.compile(regularExpression);
                if (!id.matches(regularExpression)) continue;
                return mappingsKeyStored;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

