/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.properties;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swtchart.ILegend;
import org.eclipse.swtchart.Resources;
import org.eclipse.swtchart.extensions.charts.InteractiveChart;
import org.eclipse.swtchart.extensions.properties.AbstractPage;
import org.eclipse.swtchart.extensions.properties.Messages;

public class LegendPage
extends AbstractPage {
    protected Button showLegendButton;
    private Label backgroundLabel;
    private ColorSelector backgroundButton;
    private Label foregroundLabel;
    private ColorSelector foregroundButton;
    private Label fontSizeLabel;
    private Spinner fontSizeSpinner;
    private ILegend legend;

    public LegendPage(InteractiveChart chart, String title) {
        super(chart, title);
        this.legend = chart.getLegend();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.addLegendPanel(composite);
        this.selectValues();
        return composite;
    }

    private void addLegendPanel(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)new GridLayout(2, false));
        this.showLegendButton = this.createCheckBoxControl(group, Messages.getString("SHOW_LEGEND"));
        this.showLegendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = LegendPage.this.showLegendButton.getSelection();
                LegendPage.this.setControlsEnable(visible);
            }
        });
        this.backgroundLabel = this.createLabelControl(group, Messages.getString("BACKGROUND"));
        this.backgroundButton = this.createColorButtonControl(group);
        this.foregroundLabel = this.createLabelControl(group, Messages.getString("FOREGROUND"));
        this.foregroundButton = this.createColorButtonControl(group);
        this.fontSizeLabel = this.createLabelControl(group, Messages.getString("FONT_SIZE"));
        this.fontSizeSpinner = this.createSpinnerControl(group, 8, 30);
    }

    private void selectValues() {
        this.showLegendButton.setSelection(this.legend.isVisible());
        this.setControlsEnable(this.legend.isVisible());
        this.backgroundButton.setColorValue(this.legend.getBackground().getRGB());
        this.foregroundButton.setColorValue(this.legend.getForeground().getRGB());
        this.fontSizeSpinner.setSelection(this.legend.getFont().getFontData()[0].getHeight());
    }

    protected void setControlsEnable(boolean enabled) {
        this.backgroundLabel.setEnabled(enabled);
        this.backgroundButton.setEnabled(enabled);
        this.foregroundLabel.setEnabled(enabled);
        this.foregroundButton.setEnabled(enabled);
        this.fontSizeLabel.setEnabled(enabled);
        this.fontSizeSpinner.setEnabled(enabled);
    }

    @Override
    public void apply() {
        this.legend.setVisible(this.showLegendButton.getSelection());
        Color color = Resources.getColor((RGB)this.backgroundButton.getColorValue());
        this.legend.setBackground(color);
        color = Resources.getColor((RGB)this.foregroundButton.getColorValue());
        this.legend.setForeground(color);
        FontData fontData = this.legend.getFont().getFontData()[0];
        Font font = Resources.getFont((String)fontData.getName(), (int)this.fontSizeSpinner.getSelection(), (int)fontData.getStyle());
        this.legend.setFont(font);
    }

    protected void performDefaults() {
        this.showLegendButton.setSelection(true);
        this.setControlsEnable(true);
        this.backgroundButton.setColorValue(new RGB(255, 255, 255));
        this.foregroundButton.setColorValue(new RGB(0, 0, 0));
        this.fontSizeSpinner.setSelection(9);
        super.performDefaults();
    }
}

