/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.ARpmlintResolution;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.HardcodedPackagerTag;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.HardcodedPrefixTag;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.MacroInChangelog;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.NoBuildSection;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.NoInstallSection;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.NoPrepSection;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.PatchNotApplied;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.RpmBuildrootUsage;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.SetupNotQuiet;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class RpmlintMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public static final String RPMLINT_ERROR_ID = "rpmlintErrorId";
    public static final String RPMLINT_REFFERED_CONTENT = "rpmlintrefferedContent";

    public boolean hasResolutions(IMarker marker) {
        String rpmlintErrorId;
        return switch (rpmlintErrorId = RpmlintMarkerResolutionGenerator.getRpmlintErrorId(marker)) {
            case "setup-not-quiet", "patch-not-applied", "no-%build-section", "macro-in-%changelog", "rpm-buildroot-usage", "hardcoded-prefix-tag", "hardcoded-packager-tag", "no-%prep-section", "no-%install-section" -> true;
            default -> false;
        };
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<ARpmlintResolution> resolutions = new ArrayList<ARpmlintResolution>();
        String rpmlintErrorId = RpmlintMarkerResolutionGenerator.getRpmlintErrorId(marker);
        if ("setup-not-quiet".equals(rpmlintErrorId)) {
            resolutions.add(new SetupNotQuiet());
        } else if ("patch-not-applied".equals(rpmlintErrorId)) {
            resolutions.add(new PatchNotApplied());
        } else if ("no-%build-section".equals(rpmlintErrorId)) {
            resolutions.add(new NoBuildSection());
        } else if ("macro-in-%changelog".equals(rpmlintErrorId)) {
            resolutions.add(new MacroInChangelog());
        } else if ("rpm-buildroot-usage".equals(rpmlintErrorId)) {
            resolutions.add(new RpmBuildrootUsage());
        } else if ("hardcoded-prefix-tag".equals(rpmlintErrorId)) {
            resolutions.add(new HardcodedPrefixTag());
        } else if ("hardcoded-packager-tag".equals(rpmlintErrorId)) {
            resolutions.add(new HardcodedPackagerTag());
        } else if ("no-%prep-section".equals(rpmlintErrorId)) {
            resolutions.add(new NoPrepSection());
        } else if ("no-%install-section".equals(rpmlintErrorId)) {
            resolutions.add(new NoInstallSection());
        }
        return (IMarkerResolution[])resolutions.toArray(IMarkerResolution[]::new);
    }

    private static String getRpmlintErrorId(IMarker marker) {
        return marker.getAttribute(RPMLINT_ERROR_ID, "");
    }
}

