/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.catalog;

import java.nio.file.Paths;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.catalog.CatalogEntry;
import org.eclipse.lemminx.extensions.catalog.CatalogUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class CatalogCatalogEntry
extends CatalogEntry {
    public CatalogCatalogEntry(@NonNull String baseURI, DOMElement entryElement) {
        super(baseURI, entryElement);
    }

    @Override
    public DOMRange getLinkRange() {
        DOMAttr catalogAttr = CatalogUtils.getCatalogEntryCatalog(this.getEntryElement());
        if (catalogAttr == null) {
            return null;
        }
        return catalogAttr.getNodeAttrValue();
    }

    @Override
    public String getResolvedURI() {
        DOMAttr catalogAttr = CatalogUtils.getCatalogEntryCatalog(this.getEntryElement());
        if (catalogAttr == null) {
            return null;
        }
        String lastSegment = catalogAttr.getValue();
        if (StringUtils.isBlank(lastSegment)) {
            return null;
        }
        return Paths.get(this.getBaseURI(), lastSegment).toString();
    }
}

