/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.Arrays;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.SchemaEnabled;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLSchemaSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationFilter;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.extensions.xsd.participants.XSDErrorCode;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.junit.jupiter.api.Test;

public class XMLValidationFilterTest
extends AbstractCacheBasedTest {
    @Test
    public void disableValidationFilter() throws Exception {
        String xml = "<foo";
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        XMLValidationFilter filter = new XMLValidationFilter();
        filter.setEnabled(false);
        filter.setPattern("**.myxml");
        validation.setFilters(Arrays.asList(filter).toArray(new XMLValidationFilter[0]));
        XMLLanguageService ls = new XMLLanguageService();
        String fileURI = "file:///home/test.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(0, 1, 0, 4), "No grammar constraints (DTD or XML Schema).", DiagnosticSeverity.Hint, "xml", XMLSyntaxErrorCode.NoGrammarConstraints.getCode()), new Diagnostic(XMLAssert.r(0, 1, 0, 4), "XML document structures must start and end within the same entity.", DiagnosticSeverity.Error, "xml", XMLSyntaxErrorCode.MarkupEntityMismatch.getCode())));
        fileURI = "file:///home/test.myxml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
    }

    @Test
    public void noGrammarFilter() throws Exception {
        String xml = "<foo />";
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        XMLValidationFilter filter = new XMLValidationFilter();
        filter.setEnabled(true);
        filter.setNoGrammar("ignore");
        filter.setPattern("foo.xml");
        validation.setFilters(Arrays.asList(filter).toArray(new XMLValidationFilter[0]));
        XMLLanguageService ls = new XMLLanguageService();
        String fileURI = "file:///home/test.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(0, 1, 0, 4), "No grammar constraints (DTD or XML Schema).", DiagnosticSeverity.Hint, "xml", XMLSyntaxErrorCode.NoGrammarConstraints.getCode())));
        fileURI = "file:///home/foo.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
    }

    @Test
    public void defaultDisableNoGrammarFilter() throws Exception {
        String xml = "<foo />";
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        XMLLanguageService ls = new XMLLanguageService();
        String fileURI = "file:///home/test.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(0, 1, 0, 4), "No grammar constraints (DTD or XML Schema).", DiagnosticSeverity.Hint, "xml", XMLSyntaxErrorCode.NoGrammarConstraints.getCode())));
        fileURI = "file:///home/.project";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
        fileURI = "file:///home/.classpath";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
        fileURI = "file:///home/plugin.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
        fileURI = "file:///home/feature.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
        fileURI = "file:///home/category.xml";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
        fileURI = "file:///home/foo.target";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
        fileURI = "file:///home/foo.product";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
    }

    @Test
    public void disableXMLSchemaValidationFilter() throws Exception {
        String xml = "<schema xmlns=\"http://www.w3.org/2001/XMLSchema\">\r\n    <annotation>\r\n      <appInfo>\r\n      </appInfo>\r\n   </annotation>\r\n</schema>";
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        XMLValidationFilter filter = new XMLValidationFilter();
        filter.setEnabled(true);
        filter.setNoGrammar("ignore");
        XMLSchemaSettings schemaSettings = new XMLSchemaSettings();
        schemaSettings.setEnabled(SchemaEnabled.never);
        filter.setSchema(schemaSettings);
        filter.setPattern("**.myxsd");
        validation.setFilters(Arrays.asList(filter).toArray(new XMLValidationFilter[0]));
        XMLLanguageService ls = new XMLLanguageService();
        String fileURI = "file:///home/test.xsd";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(2, 15, 2, 15), "src-annotation: <annotation> elements can only contain <appinfo> and <documentation> elements, but 'appInfo' was found.", DiagnosticSeverity.Error, "xsd", XSDErrorCode.src_annotation.getCode())));
        fileURI = "file:///home/test.myxsd";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
        xml = "<schema xmlns=\"http://www.w3.org/2001/XMLSchema\">\r\n    <annotation>\r\n</schema>";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(1, 5, 1, 15), "The element type \"annotation\" must be terminated by the matching end-tag \"</annotation>\".", DiagnosticSeverity.Error, "xml", XMLSyntaxErrorCode.ETagRequired.getCode())));
    }

    @Test
    public void defaultDisableXMLSchemaValidationFilter() throws Exception {
        String xml = "<schema xmlns=\"http://www.w3.org/2001/XMLSchema\">\r\n    <annotation>\r\n      <appInfo>\r\n      </appInfo>\r\n   </annotation>\r\n</schema>";
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        XMLLanguageService ls = new XMLLanguageService();
        String fileURI = "file:///home/test.xsd";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(2, 15, 2, 15), "src-annotation: <annotation> elements can only contain <appinfo> and <documentation> elements, but 'appInfo' was found.", DiagnosticSeverity.Error, "xsd", XSDErrorCode.src_annotation.getCode())));
        fileURI = "file:///home/test.exsd";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic[0]));
        xml = "<schema xmlns=\"http://www.w3.org/2001/XMLSchema\">\r\n    <annotation>\r\n</schema>";
        XMLAssert.testPublishDiagnosticsFor(xml, fileURI, validation, ls, XMLAssert.pd(fileURI, new Diagnostic(XMLAssert.r(1, 5, 1, 15), "The element type \"annotation\" must be terminated by the matching end-tag \"</annotation>\".", DiagnosticSeverity.Error, "xml", XMLSyntaxErrorCode.ETagRequired.getCode())));
    }
}

