/*******************************************************************************
* Copyright (c) 2020 Red Hat Inc. and others.
* All rights reserved. This program and the accompanying materials
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* SPDX-License-Identifier: EPL-2.0
*
* Contributors:
*     Red Hat Inc. - initial API and implementation
*******************************************************************************/
package org.eclipse.lemminx.settings;

import org.eclipse.lsp4j.FormattingOptions;

/**
 * Composite settings class
 * 
 * Provides a new SharedSettings instance with a second
 * setting merged
 */
public class CompositeSettings extends SharedSettings {
	public CompositeSettings(SharedSettings settings, FormattingOptions formatting) {
		super(settings);
		this.getFormattingSettings().merge(formatting);
	}
}