/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.services.IXMLDocumentProvider;
import org.eclipse.lemminx.services.IXMLNotificationService;
import org.eclipse.lemminx.services.IXMLValidationService;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.services.extensions.IDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IDocumentLifecycleParticipant;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.services.extensions.IHighlightingParticipant;
import org.eclipse.lemminx.services.extensions.IHoverParticipant;
import org.eclipse.lemminx.services.extensions.IReferenceParticipant;
import org.eclipse.lemminx.services.extensions.IRenameParticipant;
import org.eclipse.lemminx.services.extensions.ISymbolsProviderParticipant;
import org.eclipse.lemminx.services.extensions.ITypeDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IWorkspaceServiceParticipant;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.commands.IXMLCommandService;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.services.extensions.format.IFormatterParticipant;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.telemetry.TelemetryManager;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lsp4j.InitializeParams;

public class XMLExtensionsRegistry
implements IComponentProvider {
    private static final Logger LOGGER = Logger.getLogger(XMLExtensionsRegistry.class.getName());
    private final URIResolverExtensionManager resolverExtensionManager;
    private final Collection<IXMLExtension> extensions = new ArrayList<IXMLExtension>();
    private final List<ICompletionParticipant> completionParticipants = new ArrayList<ICompletionParticipant>();
    private final List<IHoverParticipant> hoverParticipants = new ArrayList<IHoverParticipant>();
    private final List<IDiagnosticsParticipant> diagnosticsParticipants = new ArrayList<IDiagnosticsParticipant>();
    private final List<ICodeActionParticipant> codeActionsParticipants = new ArrayList<ICodeActionParticipant>();
    private final List<IDocumentLinkParticipant> documentLinkParticipants = new ArrayList<IDocumentLinkParticipant>();
    private final List<IDefinitionParticipant> definitionParticipants = new ArrayList<IDefinitionParticipant>();
    private final List<ITypeDefinitionParticipant> typeDefinitionParticipants = new ArrayList<ITypeDefinitionParticipant>();
    private final List<IReferenceParticipant> referenceParticipants = new ArrayList<IReferenceParticipant>();
    private final List<ICodeLensParticipant> codeLensParticipants = new ArrayList<ICodeLensParticipant>();
    private final List<IHighlightingParticipant> highlightingParticipants = new ArrayList<IHighlightingParticipant>();
    private final List<IRenameParticipant> renameParticipants = new ArrayList<IRenameParticipant>();
    private final List<IFormatterParticipant> formatterParticipants = new ArrayList<IFormatterParticipant>();
    private final List<ISymbolsProviderParticipant> symbolsProviderParticipants = new ArrayList<ISymbolsProviderParticipant>();
    private final List<IWorkspaceServiceParticipant> workspaceServiceParticipants = new ArrayList<IWorkspaceServiceParticipant>();
    private final List<IDocumentLifecycleParticipant> documentLifecycleParticipants = new ArrayList<IDocumentLifecycleParticipant>();
    private IXMLDocumentProvider documentProvider;
    private IXMLValidationService validationService;
    private IXMLCommandService commandService;
    private InitializeParams params;
    private ISaveContext initialSaveContext;
    private boolean initialized;
    private IXMLNotificationService notificationService;
    private final Map<Class<?>, Object> components;
    private TelemetryManager telemetryManager;

    public XMLExtensionsRegistry() {
        this.resolverExtensionManager = new URIResolverExtensionManager();
        this.components = new HashMap();
        this.telemetryManager = new TelemetryManager(null);
        this.registerComponent(this.resolverExtensionManager);
    }

    public void registerComponent(Object component) {
        this.components.put(component.getClass(), component);
    }

    @Override
    public <T> T getComponent(Class clazz) {
        return (T)this.components.get(clazz);
    }

    public void initializeParams(InitializeParams params) {
        if (this.initialized) {
            this.extensions.stream().forEach(extension -> {
                try {
                    extension.start(params, this);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error while starting extension <" + extension.getClass().getName() + ">", e);
                }
            });
        } else {
            this.params = params;
        }
    }

    public void doSave(ISaveContext saveContext) {
        if (this.initialized) {
            this.extensions.stream().forEach(extension -> extension.doSave(saveContext));
        } else if (this.initialSaveContext == null || saveContext != null && saveContext.getType() == ISaveContext.SaveContextType.SETTINGS) {
            this.initialSaveContext = saveContext;
        }
    }

    public Collection<IXMLExtension> getExtensions() {
        this.initializeIfNeeded();
        return this.extensions;
    }

    public Collection<ICompletionParticipant> getCompletionParticipants() {
        this.initializeIfNeeded();
        return this.completionParticipants;
    }

    public Collection<IHoverParticipant> getHoverParticipants() {
        this.initializeIfNeeded();
        return this.hoverParticipants;
    }

    public Collection<IDiagnosticsParticipant> getDiagnosticsParticipants() {
        this.initializeIfNeeded();
        return this.diagnosticsParticipants;
    }

    public List<ICodeActionParticipant> getCodeActionsParticipants() {
        this.initializeIfNeeded();
        return this.codeActionsParticipants;
    }

    public Collection<IDocumentLinkParticipant> getDocumentLinkParticipants() {
        this.initializeIfNeeded();
        return this.documentLinkParticipants;
    }

    public Collection<IDefinitionParticipant> getDefinitionParticipants() {
        this.initializeIfNeeded();
        return this.definitionParticipants;
    }

    public Collection<ITypeDefinitionParticipant> getTypeDefinitionParticipants() {
        this.initializeIfNeeded();
        return this.typeDefinitionParticipants;
    }

    public Collection<IReferenceParticipant> getReferenceParticipants() {
        this.initializeIfNeeded();
        return this.referenceParticipants;
    }

    public Collection<ICodeLensParticipant> getCodeLensParticipants() {
        this.initializeIfNeeded();
        return this.codeLensParticipants;
    }

    public Collection<IHighlightingParticipant> getHighlightingParticipants() {
        this.initializeIfNeeded();
        return this.highlightingParticipants;
    }

    public Collection<IRenameParticipant> getRenameParticipants() {
        this.initializeIfNeeded();
        return this.renameParticipants;
    }

    public Collection<IFormatterParticipant> getFormatterParticipants() {
        this.initializeIfNeeded();
        return this.formatterParticipants;
    }

    public Collection<ISymbolsProviderParticipant> getSymbolsProviderParticipants() {
        this.initializeIfNeeded();
        return this.symbolsProviderParticipants;
    }

    public Collection<IWorkspaceServiceParticipant> getWorkspaceServiceParticipants() {
        this.initializeIfNeeded();
        return this.workspaceServiceParticipants;
    }

    public List<IDocumentLifecycleParticipant> getDocumentLifecycleParticipants() {
        this.initializeIfNeeded();
        return this.documentLifecycleParticipants;
    }

    public void initializeIfNeeded() {
        if (this.initialized) {
            return;
        }
        this.initialize();
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        if (this.commandService != null) {
            this.commandService.beginCommandsRegistration();
        }
        Iterator<IXMLExtension> extensions = ServiceLoader.load(IXMLExtension.class).iterator();
        while (extensions.hasNext()) {
            try {
                this.registerExtension(extensions.next());
            }
            catch (ServiceConfigurationError e) {
                LOGGER.log(Level.SEVERE, "Error while instantiating extension", e);
            }
        }
        this.initialized = true;
        if (this.commandService != null) {
            this.commandService.endCommandsRegistration();
        }
    }

    void registerExtension(IXMLExtension extension) {
        try {
            this.extensions.add(extension);
            extension.start(this.params, this);
            if (this.initialSaveContext != null) {
                extension.doSave(this.initialSaveContext);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while initializing extension <" + extension.getClass().getName() + ">", e);
        }
    }

    void unregisterExtension(IXMLExtension extension) {
        try {
            this.extensions.remove(extension);
            extension.stop(this);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while stopping extension <" + extension.getClass().getName() + ">", e);
        }
    }

    public void dispose() {
        ArrayList extensionReferences = new ArrayList();
        this.extensions.forEach(extensionReferences::add);
        extensionReferences.forEach(this::unregisterExtension);
    }

    public void registerCompletionParticipant(ICompletionParticipant completionParticipant) {
        this.completionParticipants.add(completionParticipant);
    }

    public void unregisterCompletionParticipant(ICompletionParticipant completionParticipant) {
        this.completionParticipants.remove(completionParticipant);
    }

    public void registerHoverParticipant(IHoverParticipant hoverParticipant) {
        this.hoverParticipants.add(hoverParticipant);
    }

    public void unregisterHoverParticipant(IHoverParticipant hoverParticipant) {
        this.hoverParticipants.remove(hoverParticipant);
    }

    public void registerDiagnosticsParticipant(IDiagnosticsParticipant diagnosticsParticipant) {
        this.diagnosticsParticipants.add(diagnosticsParticipant);
    }

    public void unregisterDiagnosticsParticipant(IDiagnosticsParticipant diagnosticsParticipant) {
        this.diagnosticsParticipants.remove(diagnosticsParticipant);
    }

    public void registerCodeActionParticipant(ICodeActionParticipant codeActionsParticipant) {
        this.codeActionsParticipants.add(codeActionsParticipant);
    }

    public void unregisterCodeActionParticipant(ICodeActionParticipant codeActionsParticipant) {
        this.codeActionsParticipants.remove(codeActionsParticipant);
    }

    public void registerDocumentLinkParticipant(IDocumentLinkParticipant documentLinkParticipant) {
        this.documentLinkParticipants.add(documentLinkParticipant);
    }

    public void unregisterDocumentLinkParticipant(IDocumentLinkParticipant documentLinkParticipant) {
        this.documentLinkParticipants.remove(documentLinkParticipant);
    }

    public void registerDefinitionParticipant(IDefinitionParticipant definitionParticipant) {
        this.definitionParticipants.add(definitionParticipant);
    }

    public void unregisterDefinitionParticipant(IDefinitionParticipant definitionParticipant) {
        this.definitionParticipants.remove(definitionParticipant);
    }

    public void registerTypeDefinitionParticipant(ITypeDefinitionParticipant typeDefinitionParticipant) {
        this.typeDefinitionParticipants.add(typeDefinitionParticipant);
    }

    public void unregisterTypeDefinitionParticipant(ITypeDefinitionParticipant typeDefinitionParticipant) {
        this.typeDefinitionParticipants.remove(typeDefinitionParticipant);
    }

    public void registerReferenceParticipant(IReferenceParticipant referenceParticipant) {
        this.referenceParticipants.add(referenceParticipant);
    }

    public void unregisterReferenceParticipant(IReferenceParticipant referenceParticipant) {
        this.referenceParticipants.remove(referenceParticipant);
    }

    public void registerCodeLensParticipant(ICodeLensParticipant codeLensParticipant) {
        this.codeLensParticipants.add(codeLensParticipant);
    }

    public void unregisterCodeLensParticipant(ICodeLensParticipant codeLensParticipant) {
        this.codeLensParticipants.remove(codeLensParticipant);
    }

    public void registerHighlightingParticipant(IHighlightingParticipant highlightingParticipant) {
        this.highlightingParticipants.add(highlightingParticipant);
    }

    public void unregisterHighlightingParticipant(IHighlightingParticipant highlightingParticipant) {
        this.highlightingParticipants.remove(highlightingParticipant);
    }

    public void registerRenameParticipant(IRenameParticipant renameParticipant) {
        this.renameParticipants.add(renameParticipant);
    }

    public void unregisterRenameParticipant(IRenameParticipant renameParticipant) {
        this.renameParticipants.remove(renameParticipant);
    }

    public void registerFormatterParticipant(IFormatterParticipant formatterParticipant) {
        this.formatterParticipants.add(formatterParticipant);
    }

    public void unregisterFormatterParticipant(IFormatterParticipant formatterParticipant) {
        this.formatterParticipants.remove(formatterParticipant);
    }

    public void registerSymbolsProviderParticipant(ISymbolsProviderParticipant symbolsProviderParticipant) {
        this.symbolsProviderParticipants.add(symbolsProviderParticipant);
    }

    public void unregisterSymbolsProviderParticipant(ISymbolsProviderParticipant symbolsProviderParticipant) {
        this.symbolsProviderParticipants.remove(symbolsProviderParticipant);
    }

    public void registerWorkspaceServiceParticipant(IWorkspaceServiceParticipant workspaceServiceParticipant) {
        this.workspaceServiceParticipants.add(workspaceServiceParticipant);
    }

    public void unregisterWorkspaceServiceParticipant(IWorkspaceServiceParticipant workspaceServiceParticipant) {
        this.workspaceServiceParticipants.remove(workspaceServiceParticipant);
    }

    public void registerDocumentLifecycleParticipant(IDocumentLifecycleParticipant documentLifecycleParticipant) {
        this.documentLifecycleParticipants.add(documentLifecycleParticipant);
    }

    public void unregisterDocumentLifecycleParticipant(IDocumentLifecycleParticipant documentLifecycleParticipant) {
        this.documentLifecycleParticipants.remove(documentLifecycleParticipant);
    }

    public IXMLDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public void setDocumentProvider(IXMLDocumentProvider documentProvider) {
        this.documentProvider = documentProvider;
    }

    public URIResolverExtensionManager getResolverExtensionManager() {
        return this.resolverExtensionManager;
    }

    public IXMLNotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(IXMLNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public IXMLValidationService getValidationService() {
        return this.validationService;
    }

    public void setValidationService(IXMLValidationService validationService) {
        this.validationService = validationService;
    }

    public IXMLCommandService getCommandService() {
        return this.commandService;
    }

    public void setCommandService(IXMLCommandService commandService) {
        this.commandService = commandService;
    }

    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    public void setTelemetryManager(TelemetryManager telemetryManager) {
        this.telemetryManager = telemetryManager;
    }
}

