/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.services.RenameRequest;
import org.eclipse.lemminx.services.extensions.IRenameParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;

public class XMLRename {
    private static final Logger LOGGER = Logger.getLogger(XMLRename.class.getName());
    private final XMLExtensionsRegistry extensionsRegistry;

    public XMLRename(XMLExtensionsRegistry extensionsRegistry) {
        this.extensionsRegistry = extensionsRegistry;
    }

    public WorkspaceEdit doRename(DOMDocument xmlDocument, Position position, String newText) {
        RenameRequest renameRequest = null;
        try {
            renameRequest = new RenameRequest(xmlDocument, position, newText, this.extensionsRegistry);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "Failed creating RenameRequest", e);
            return null;
        }
        DOMNode node = renameRequest.getNode();
        if (node == null || !node.isAttribute() && !node.isElement() || node.isElement() && !((DOMElement)node).hasTagName()) {
            return this.createWorkspaceEdit(xmlDocument.getDocumentURI(), Collections.emptyList());
        }
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        for (IRenameParticipant participant : this.extensionsRegistry.getRenameParticipants()) {
            try {
                participant.doRename(renameRequest, textEdits);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error while processing rename for the participant '" + participant.getClass().getName() + "'.", e);
            }
        }
        textEdits.addAll(this.getRenameTextEdits(xmlDocument, node, position, newText));
        return this.createWorkspaceEdit(xmlDocument.getDocumentURI(), textEdits);
    }

    private List<TextEdit> getRenameTextEdits(DOMDocument xmlDocument, DOMNode node, Position position, String newText) {
        DOMElement element = this.getAssociatedElement(node);
        if (node == null) {
            return Collections.emptyList();
        }
        if (node.isCDATA()) {
            return this.getCDATARenameTextEdits(xmlDocument, element, position, newText);
        }
        if (this.isRenameTagName(xmlDocument, element, position)) {
            return this.getTagNameRenameTextEdits(xmlDocument, element, position, newText);
        }
        if (element.isDocumentElement()) {
            return this.getXmlnsAttrRenameTextEdits(xmlDocument, element, position, newText);
        }
        return Collections.emptyList();
    }

    private DOMElement getAssociatedElement(DOMNode node) {
        if (node == null || !node.isElement() && !node.isAttribute()) {
            return null;
        }
        if (node.isAttribute()) {
            return ((DOMAttr)node).getOwnerElement();
        }
        return (DOMElement)node;
    }

    private List<TextEdit> getCDATARenameTextEdits(DOMDocument xmlDocument, DOMElement element, Position position, String newText) {
        Position startPos = null;
        Position endPos = null;
        Range tempRange = null;
        try {
            startPos = xmlDocument.positionAt(element.getStart());
            endPos = xmlDocument.positionAt(element.getEnd());
            tempRange = new Range(startPos, endPos);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In XMLRename the Node at provided Offset is a BadLocation", e);
            return Collections.emptyList();
        }
        if (XMLPositionUtility.covers(tempRange, position)) {
            startPos.setCharacter(startPos.getCharacter() + 1);
            endPos.setCharacter(endPos.getCharacter() - 1);
            Position startPosEnd = new Position(startPos.getLine(), startPos.getCharacter() + 8);
            Position endPosStart = new Position(endPos.getLine(), endPos.getCharacter() - 2);
            Range startTagRange = new Range(startPos, startPosEnd);
            Range endTagRange = new Range(endPosStart, endPos);
            return XMLRename.getRenameList(startTagRange, endTagRange, newText);
        }
        return Collections.emptyList();
    }

    private boolean isRenameTagName(DOMDocument document, DOMElement element, Position position) {
        Range startTagRange = XMLPositionUtility.getTagNameRange(TokenType.StartTag, element.getStart(), document);
        Range endTagRange = element.hasEndTag() ? XMLPositionUtility.getTagNameRange(TokenType.EndTag, element.getEndTagOpenOffset(), document) : null;
        return XMLPositionUtility.doesTagCoverPosition(startTagRange, endTagRange, position);
    }

    private List<TextEdit> getTagNameRenameTextEdits(DOMDocument xmlDocument, DOMElement element, Position position, String newText) {
        Range startTagRange = XMLPositionUtility.getTagNameRange(TokenType.StartTag, element.getStart(), xmlDocument);
        Range endTagRange = element.hasEndTag() ? XMLPositionUtility.getTagNameRange(TokenType.EndTag, element.getEndTagOpenOffset(), xmlDocument) : null;
        String fullNodeName = element.getNodeName();
        int indexOfColon = fullNodeName.indexOf(":");
        if (indexOfColon > 0) {
            Position endTagPrefixPosition;
            Position endTagStartPosition;
            Range endTagPrefixRange;
            Position startTagPrefixPosition;
            Position startTagStartPosition = startTagRange.getStart();
            Range startTagPrefixRange = new Range(startTagStartPosition, startTagPrefixPosition = new Position(startTagStartPosition.getLine(), startTagStartPosition.getCharacter() + indexOfColon));
            if (XMLPositionUtility.doesTagCoverPosition(startTagPrefixRange, endTagPrefixRange = new Range(endTagStartPosition = endTagRange.getStart(), endTagPrefixPosition = new Position(endTagStartPosition.getLine(), endTagStartPosition.getCharacter() + indexOfColon)), position)) {
                String prefix = element.getPrefix();
                return XMLRename.renameElementNamespace(xmlDocument, element, prefix.length(), newText);
            }
            String suffixName = element.getLocalName();
            int suffixLength = suffixName.length();
            Position startTagEndPosition = startTagRange.getEnd();
            Position suffixStartPositionStart = new Position(startTagEndPosition.getLine(), startTagEndPosition.getCharacter() - suffixLength);
            Position endTagEndPosition = endTagRange.getEnd();
            Position suffixEndPositionStart = new Position(endTagEndPosition.getLine(), endTagEndPosition.getCharacter() - suffixLength);
            Range suffixRangeStart = new Range(suffixStartPositionStart, startTagEndPosition);
            Range suffixRangeEnd = new Range(suffixEndPositionStart, endTagEndPosition);
            return XMLRename.getRenameList(suffixRangeStart, suffixRangeEnd, newText);
        }
        return XMLRename.getRenameList(startTagRange, endTagRange, newText);
    }

    private List<TextEdit> getXmlnsAttrRenameTextEdits(DOMDocument xmlDocument, DOMElement element, Position position, String newText) {
        List<DOMAttr> attributes = element.getAttributeNodes();
        if (attributes == null) {
            return Collections.emptyList();
        }
        for (DOMAttr attr : attributes) {
            Position end;
            Position start;
            DOMNode nameNode = attr.getNodeAttrName();
            if (!attr.isXmlns()) continue;
            try {
                start = xmlDocument.positionAt(nameNode.getStart() + "xmlns:".length());
                end = xmlDocument.positionAt(nameNode.getEnd());
            }
            catch (BadLocationException e) {
                continue;
            }
            if (!XMLPositionUtility.covers(new Range(start, end), position)) continue;
            String namespaceName = attr.getLocalName();
            return XMLRename.renameAllNamespaceOccurrences(xmlDocument, namespaceName, newText, attr);
        }
        return Collections.emptyList();
    }

    private WorkspaceEdit createWorkspaceEdit(String documentURI, List<TextEdit> textEdits) {
        HashMap<String, List<TextEdit>> changes = new HashMap<String, List<TextEdit>>();
        changes.put(documentURI, textEdits);
        return new WorkspaceEdit(changes);
    }

    private static List<TextEdit> getRenameList(Range startTagRange, Range endTagRange, String newText) {
        ArrayList<TextEdit> result = new ArrayList<TextEdit>(2);
        if (startTagRange != null) {
            result.add(new TextEdit(startTagRange, newText));
        }
        if (endTagRange != null) {
            result.add(new TextEdit(endTagRange, newText));
        }
        return result;
    }

    private static List<TextEdit> renameAllNamespaceOccurrences(DOMDocument document, String oldNamespace, String newNamespace, @Nullable DOMAttr rootAttr) {
        DOMElement rootElement = document.getDocumentElement();
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        if (rootAttr != null) {
            Position start;
            try {
                start = document.positionAt(rootAttr.getStart() + "xmlns:".length());
            }
            catch (BadLocationException e) {
                start = null;
            }
            if (start != null) {
                Position end = new Position(start.getLine(), start.getCharacter() + oldNamespace.length());
                edits.add(new TextEdit(new Range(start, end), newNamespace));
            }
        }
        List<DOMNode> children = Arrays.asList(rootElement);
        return XMLRename.renameElementsNamespace(document, edits, children, oldNamespace, newNamespace);
    }

    private static List<TextEdit> renameElementsNamespace(DOMDocument document, List<TextEdit> edits, List<DOMNode> elements, String oldNamespace, String newNamespace) {
        int oldNamespaceLength = oldNamespace.length();
        for (DOMNode node : elements) {
            if (!node.isElement()) continue;
            DOMElement element = (DOMElement)node;
            if (oldNamespace.equals(element.getPrefix())) {
                edits.addAll(XMLRename.renameElementNamespace(document, element, oldNamespaceLength, newNamespace));
            }
            if (element.hasAttributes()) {
                edits.addAll(XMLRename.renameElementAttributeValueNamespace(document, element, oldNamespace, newNamespace));
            }
            if (!element.hasChildNodes()) continue;
            XMLRename.renameElementsNamespace(document, edits, element.getChildren(), oldNamespace, newNamespace);
        }
        return edits;
    }

    private static List<TextEdit> renameElementNamespace(DOMDocument document, DOMElement element, int oldNamespaceLength, String newNamespace) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        Range[] ranges = XMLRename.createNamespaceRange(document, element, oldNamespaceLength);
        if (ranges == null) {
            return edits;
        }
        for (Range r : ranges) {
            if (r == null) continue;
            edits.add(new TextEdit(r, newNamespace));
        }
        return edits;
    }

    private static List<TextEdit> renameElementAttributeValueNamespace(DOMDocument document, DOMElement element, String oldNamespace, String newNamespace) {
        List<DOMAttr> attributes = element.getAttributeNodes();
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        if (attributes != null) {
            for (DOMAttr attr : attributes) {
                Position end;
                Position start;
                String attrValueText;
                DOMNode attrValue = attr.getNodeAttrValue();
                if (attrValue == null || (attrValueText = attr.getValue()) == null || !attrValueText.startsWith(oldNamespace + ":")) continue;
                int startOffset = attrValue.getStart() + 1;
                try {
                    start = document.positionAt(startOffset);
                    end = new Position(start.getLine(), start.getCharacter() + oldNamespace.length());
                }
                catch (BadLocationException e) {
                    return edits;
                }
                edits.add(new TextEdit(new Range(start, end), newNamespace));
            }
        }
        return edits;
    }

    private static Range[] createNamespaceRange(DOMDocument document, DOMElement element, int namespaceLength) {
        Range[] ranges = new Range[2];
        try {
            Position end;
            Position start;
            int startName;
            if (element.hasStartTag()) {
                startName = element.getStart() + 1;
                start = document.positionAt(startName);
                end = new Position(start.getLine(), start.getCharacter() + namespaceLength);
                ranges[0] = new Range(start, end);
            }
            if (element.hasEndTag()) {
                startName = element.getEndTagOpenOffset() + 2;
                start = document.positionAt(startName);
                end = new Position(start.getLine(), start.getCharacter() + namespaceLength);
                ranges[1] = new Range(start, end);
            }
            return ranges;
        }
        catch (BadLocationException e) {
            return null;
        }
    }
}

