/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPSAXParser;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLParserConfiguration;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.ReferencedGrammarDiagnosticsInfo;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.extensions.diagnostics.LSPContentHandler;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XMLValidator {
    private static final Logger LOGGER = Logger.getLogger(XMLValidator.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDiagnostics(DOMDocument document, XMLEntityResolver entityResolver, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, ContentModelManager contentModelManager, CancelChecker monitor) {
        XMLGrammarPool grammarPool = contentModelManager.getGrammarPool();
        HashMap<String, ReferencedGrammarDiagnosticsInfo> referencedGrammarDiagnosticsInfoCache = new HashMap<String, ReferencedGrammarDiagnosticsInfo>();
        LSPErrorReporterForXML reporterForXML = new LSPErrorReporterForXML(document, diagnostics, contentModelManager, validationSettings != null ? validationSettings.isRelatedInformation() : false, referencedGrammarDiagnosticsInfoCache);
        LSPErrorReporterForXML reporterForGrammar = new LSPErrorReporterForXML(document, diagnostics, contentModelManager, validationSettings != null ? validationSettings.isRelatedInformation() : false, referencedGrammarDiagnosticsInfoCache);
        try {
            boolean hasGrammar;
            LSPXMLParserConfiguration configuration = new LSPXMLParserConfiguration(grammarPool, XMLValidator.isDisableOnlyDTDValidation(document), reporterForXML, reporterForGrammar, validationSettings);
            if (entityResolver != null) {
                configuration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", entityResolver);
            }
            LSPSAXParser parser = new LSPSAXParser(document, reporterForXML, (XMLParserConfiguration)configuration, grammarPool);
            parser.setContentHandler(new LSPContentHandler(monitor));
            boolean hasSchemaGrammar = document.hasSchemaLocation() || document.hasNoNamespaceSchemaLocation() || XMLValidator.hasExternalSchemaGrammar(document);
            boolean bl = hasGrammar = document.hasDTD() || hasSchemaGrammar || document.hasExternalGrammar();
            if (validationSettings == null || validationSettings.isSchema()) {
                XMLValidator.updateExternalGrammarLocation(document, parser);
                parser.setFeature("http://apache.org/xml/features/validation/schema", hasSchemaGrammar);
                XMLValidator.warnNoGrammar(document, diagnostics, validationSettings);
            } else {
                hasGrammar = false;
            }
            parser.setFeature("http://xml.org/sax/features/validation", hasGrammar);
            String content = document.getText();
            String uri = document.getDocumentURI();
            XMLValidator.parseXML(content, uri, parser);
        }
        catch (IOException | CancellationException | SAXException configuration) {
        }
        catch (CacheResourceDownloadingException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected XMLValidator error", e);
        }
        finally {
            reporterForXML.endReport();
            reporterForGrammar.endReport();
        }
    }

    private static boolean hasExternalSchemaGrammar(DOMDocument document) {
        if (document.getExternalGrammarFromNamespaceURI() != null) {
            return true;
        }
        Map<String, String> externalGrammarLocation = document.getExternalGrammarLocation();
        if (externalGrammarLocation == null) {
            return false;
        }
        return externalGrammarLocation.containsKey("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation") || externalGrammarLocation.containsKey("http://apache.org/xml/properties/schema/external-schemaLocation");
    }

    private static void parseXML(String content, String uri, SAXParser parser) throws SAXException, IOException {
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(content));
        inputSource.setSystemId(uri);
        parser.parse(inputSource);
    }

    private static boolean isDisableOnlyDTDValidation(DOMDocument document) {
        Map<String, String> externalGrammarLocation = document.getExternalGrammarLocation();
        if (externalGrammarLocation != null && externalGrammarLocation.containsKey("http://apache.org/xml/properties/dtd/external-doctype")) {
            return true;
        }
        if (!document.hasDTD()) {
            return false;
        }
        DOMDocumentType docType = document.getDoctype();
        if (docType.getKindNode() != null) {
            return false;
        }
        return !docType.getChildren().stream().anyMatch(node -> node.isDTDElementDecl() || node.isDTDAttListDecl());
    }

    private static void warnNoGrammar(DOMDocument document, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings) {
        boolean hasGrammar = document.hasGrammar();
        if (hasGrammar) {
            return;
        }
        DiagnosticSeverity severity = XMLValidationSettings.getNoGrammarSeverity(validationSettings);
        if (severity == null) {
            return;
        }
        if (!hasGrammar) {
            Range range = null;
            DOMElement documentElement = document.getDocumentElement();
            if (documentElement != null) {
                range = XMLPositionUtility.selectStartTagName(documentElement);
            }
            if (range == null) {
                range = new Range(new Position(0, 0), new Position(0, 0));
            }
            diagnostics.add(new Diagnostic(range, "No grammar constraints (DTD or XML Schema).", severity, document.getDocumentURI(), XMLSyntaxErrorCode.NoGrammarConstraints.name()));
        }
    }

    private static void updateExternalGrammarLocation(DOMDocument document, SAXParser reader) throws SAXNotRecognizedException, SAXNotSupportedException {
        Map<String, String> externalGrammarLocation = document.getExternalGrammarLocation();
        if (externalGrammarLocation != null) {
            String xsd = externalGrammarLocation.get("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation");
            if (xsd != null) {
                String defaultNamespace = null;
                DOMElement documentElement = document.getDocumentElement();
                if (documentElement != null) {
                    defaultNamespace = documentElement.getAttribute("xmlns");
                }
                if (StringUtils.isEmpty(defaultNamespace)) {
                    String noNamespaceSchemaLocation = xsd;
                    reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)noNamespaceSchemaLocation);
                } else {
                    String schemaLocation = defaultNamespace + " " + xsd;
                    reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)schemaLocation);
                }
            } else {
                String doctype = externalGrammarLocation.get("http://apache.org/xml/properties/dtd/external-doctype");
                if (doctype != null) {
                    reader.setProperty("http://apache.org/xml/properties/dtd/external-doctype", (Object)doctype);
                }
            }
        }
    }
}

