/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.gpsd4java.types;

import de.taimos.gpsd4java.types.IGPSObject;

public class SATObject
implements IGPSObject {
    public static final String NAME = "SAT";
    private int PRN = -1;
    private int azimuth = -1;
    private int elevation = -1;
    private int signalStrength = -1;
    private boolean used = false;

    public int getPRN() {
        return this.PRN;
    }

    public void setPRN(int PRN) {
        this.PRN = PRN;
    }

    public int getAzimuth() {
        return this.azimuth;
    }

    public void setAzimuth(int azimuth) {
        this.azimuth = azimuth;
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setElevation(int elevation) {
        this.elevation = elevation;
    }

    public int getSignalStrength() {
        return this.signalStrength;
    }

    public void setSignalStrength(int signalStrength) {
        this.signalStrength = signalStrength;
    }

    public boolean getUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.PRN);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.azimuth);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.elevation);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.signalStrength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.used ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SATObject other = (SATObject)obj;
        if (Double.doubleToLongBits(this.PRN) != Double.doubleToLongBits(other.PRN)) {
            return false;
        }
        if (Double.doubleToLongBits(this.azimuth) != Double.doubleToLongBits(other.azimuth)) {
            return false;
        }
        if (Double.doubleToLongBits(this.elevation) != Double.doubleToLongBits(other.elevation)) {
            return false;
        }
        if (Double.doubleToLongBits(this.signalStrength) != Double.doubleToLongBits(other.signalStrength)) {
            return false;
        }
        return this.used == other.used;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SATObject{PRN=");
        sb.append(this.PRN);
        sb.append(", az=");
        sb.append(this.azimuth);
        sb.append(", el=");
        sb.append(this.elevation);
        sb.append(", ss=");
        sb.append(this.signalStrength);
        sb.append(", used=");
        sb.append(this.used ? "Y" : "N");
        sb.append("}");
        return sb.toString();
    }
}

