/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.configuration.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.rest.configuration.api.ComponentConfigurationDTO;
import org.eclipse.kura.rest.configuration.api.ComponentConfigurationList;
import org.eclipse.kura.rest.configuration.api.OcdDTO;
import org.eclipse.kura.rest.configuration.api.PropertyDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTOUtil {
    private static final Logger logger = LoggerFactory.getLogger(DTOUtil.class);

    private DTOUtil() {
    }

    public static ComponentConfigurationDTO toComponentConfigurationDTO(ComponentConfiguration config, CryptoService cryptoService, boolean decryptPasswords) {
        return new ComponentConfigurationDTO(config.getPid(), DTOUtil.ocdToDto(config.getDefinition()), DTOUtil.configurationPropertiesToDtos(config.getConfigurationProperties(), cryptoService, decryptPasswords));
    }

    public static ComponentConfigurationList toComponentConfigurationList(List<ComponentConfiguration> configs, CryptoService cryptoService, boolean decryptPasswords) {
        List<ComponentConfigurationDTO> result = configs.stream().map(c -> DTOUtil.toComponentConfigurationDTO(c, cryptoService, decryptPasswords)).collect(Collectors.toList());
        return new ComponentConfigurationList(result);
    }

    public static Map<String, Object> dtosToConfigurationProperties(Map<String, PropertyDTO> properties) {
        if (properties == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(properties.size());
        for (Map.Entry<String, PropertyDTO> e : properties.entrySet()) {
            if (e.getValue().getValue() == null) {
                result.put(e.getKey(), null);
                continue;
            }
            Object propertyValue = e.getValue().toConfigurationProperty().orElseThrow(() -> new IllegalArgumentException("Invalid property value for " + (String)e.getKey() + " " + e.getValue()));
            result.put(e.getKey(), propertyValue);
        }
        return result;
    }

    public static OcdDTO ocdToDto(OCD ocd) {
        if (ocd == null) {
            return null;
        }
        return new OcdDTO(ocd);
    }

    public static Map<String, PropertyDTO> configurationPropertiesToDtos(Map<String, Object> properties, CryptoService cryptoService, boolean decryptPasswords) {
        if (properties == null) {
            return null;
        }
        HashMap<String, PropertyDTO> result = new HashMap<String, PropertyDTO>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getValue() == null) continue;
            Optional<Object> value = decryptPasswords ? DTOUtil.decryptPassword(entry.getValue(), cryptoService) : Optional.ofNullable(entry.getValue());
            Optional propertyDTO = value.flatMap(PropertyDTO::fromConfigurationProperty);
            if (!propertyDTO.isPresent()) {
                logger.warn("ignoring invalid configiration property for {}: {}", (Object)entry.getKey(), entry.getValue());
                continue;
            }
            result.put(entry.getKey(), (PropertyDTO)propertyDTO.get());
        }
        return result;
    }

    public static Optional<Object> decryptPassword(Object property, CryptoService cryptoService) {
        try {
            Password[] result;
            if (property instanceof Password) {
                result = new Password(cryptoService.decryptAes(((Password)property).getPassword()));
            } else if (property instanceof Password[]) {
                Password[] asPasswords = property;
                Password[] resultPasswords = new Password[asPasswords.length];
                int i = 0;
                while (i < asPasswords.length) {
                    resultPasswords[i] = new Password(cryptoService.decryptAes(asPasswords[i].getPassword()));
                    ++i;
                }
                result = resultPasswords;
            } else {
                result = property;
            }
            return Optional.ofNullable(result);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

