/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.camelcloud;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.camel.camelcloud.CamelCloudService;
import org.eclipse.kura.camel.internal.camelcloud.CamelCloudClient;
import org.eclipse.kura.cloud.CloudClient;

public class DefaultCamelCloudService
implements CamelCloudService {
    private final CamelContext camelContext;
    private final Map<String, CloudClient> clients = new ConcurrentHashMap<String, CloudClient>();
    private final Map<String, String> baseEndpoints = new ConcurrentHashMap<String, String>();

    public DefaultCamelCloudService(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CloudClient newCloudClient(String applicationId) throws KuraException {
        String baseEndpoint = this.baseEndpoints.get(applicationId);
        if (baseEndpoint == null) {
            baseEndpoint = "vm:%s";
        }
        CamelCloudClient cloudClient = new CamelCloudClient(this, this.camelContext, applicationId, baseEndpoint);
        this.clients.put(applicationId, cloudClient);
        return cloudClient;
    }

    public String[] getCloudApplicationIdentifiers() {
        return this.clients.keySet().toArray(new String[0]);
    }

    public boolean isConnected() {
        return this.camelContext.getStatus() == ServiceStatus.Started;
    }

    @Override
    public void registerBaseEndpoint(String applicationId, String baseEndpoint) {
        this.baseEndpoints.put(applicationId, baseEndpoint);
    }

    @Override
    public void release(String applicationId) {
        CloudClient client = this.clients.remove(applicationId);
        if (client != null) {
            client.release();
        }
    }

    public void dispose() {
        LinkedList<Exception> errors = new LinkedList<Exception>();
        for (CloudClient client : this.clients.values()) {
            try {
                client.release();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        this.clients.clear();
        if (!errors.isEmpty()) {
            Exception first = (Exception)errors.pollFirst();
            errors.forEach(first::addSuppressed);
            throw new RuntimeException(first);
        }
    }
}

