/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;

public class UnZip {
    private static final int BUFFER = 1024;
    private static int tooBig = 0x6400000;
    private static int tooMany = 1024;

    private UnZip() {
    }

    public static void unZipBytes(byte[] bytes, String outputFolder) throws IOException {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(bytes));
        UnZip.unZipZipInputStream(zis, outputFolder);
    }

    public static void unZipFile(String filename, String outputFolder) throws IOException {
        File file = new File(filename);
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        UnZip.unZipZipInputStream(zis, outputFolder);
    }

    private static void unZipZipInputStream(ZipInputStream zis, String outFolder) throws IOException {
        File folder;
        String outputFolder = outFolder;
        if (outputFolder == null) {
            outputFolder = System.getProperty("user.dir");
        }
        if (!(folder = new File(outputFolder)).exists()) {
            folder.mkdirs();
        }
        int entries = 0;
        long total = 0L;
        try {
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                byte[] buffer = new byte[1024];
                String expectedFilePath = folder.getPath() + File.separator + ze.getName();
                File newFile = UnZip.getFile(expectedFilePath, folder);
                if (ze.isDirectory()) {
                    newFile.mkdirs();
                    ze = zis.getNextEntry();
                    continue;
                }
                if (newFile.getParent() != null) {
                    File parent = new File(newFile.getParent());
                    parent.mkdirs();
                }
                Throwable throwable = null;
                Object var12_12 = null;
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len = zis.read(buffer);
                    while (total + 1024L <= (long)tooBig && len > 0) {
                        fos.write(buffer, 0, len);
                        total += (long)len;
                        len = zis.read(buffer);
                    }
                    fos.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (++entries > tooMany) {
                    throw new IllegalStateException("Too many files to unzip.");
                }
                if (total + 1024L > (long)tooBig) {
                    throw new IllegalStateException("File being unzipped is too big.");
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        finally {
            if (zis != null) {
                zis.close();
            }
        }
    }

    private static File getFile(String expectedFilePath, File folder) throws IOException {
        String fileName;
        try {
            fileName = UnZip.validateFileName(expectedFilePath, folder.getPath());
        }
        catch (KuraException kuraException) {
            throw new IOException("File is outside extraction target directory.");
        }
        return new File(fileName);
    }

    private static String validateFileName(String zipFileName, String intendedDir) throws IOException, KuraException {
        File iD;
        String canonicalID;
        File zipFile = new File(zipFileName);
        String filePath = zipFile.getCanonicalPath();
        if (filePath.startsWith(canonicalID = (iD = new File(intendedDir)).getCanonicalPath())) {
            return filePath;
        }
        throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
    }

    public static boolean isZipCompressed(String filePath) throws IOException {
        byte b1 = 0;
        byte b2 = 0;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream is = new FileInputStream(filePath);){
                b1 = (byte)((InputStream)is).read();
                b2 = (byte)((InputStream)is).read();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        return b1 == 80 && b2 == 75;
    }

    public static boolean isZipCompressed(byte[] bytes) {
        if (bytes.length > 2) {
            return bytes[0] == 80 && bytes[1] == 75;
        }
        return false;
    }
}

