/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.pmp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.tigris.mtoolkit.iagent.internal.pmp.ObjectInfo;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPPeerImpl;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPServiceImpl;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPSessionThread;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.pmp.PMPServer;
import org.tigris.mtoolkit.iagent.rpc.Remote;

public class Server
extends PMPPeerImpl
implements Runnable,
PMPServer,
AllServiceListener {
    public static final String URI = "uri";
    public static final String PORT = "port";
    private static final int DEFAULT_PORT = 1450;
    private static final int FAILURE_RANDOM = 0;
    private static final int FAILURE_RETRY = 1;
    private static final int FAILURE_FAIL = 2;
    private static final int FAILURE_REUSE = 3;
    protected int maxStringLength;
    protected int maxArrayLength;
    private ServerSocket socket;
    protected volatile boolean run;
    protected String uri;
    protected int port = 1450;
    private BundleContext context;
    protected Hashtable eventTypes = new Hashtable(10);
    static /* synthetic */ Class class$0;

    public Server(BundleContext context, Dictionary config) throws IOException {
        this.context = context;
        this.uri = (String)config.get(URI);
        this.maxArrayLength = (Integer)config.get("maxarraylength");
        this.maxStringLength = (Integer)config.get("maxstringlength");
        Integer port = (Integer)config.get(PORT);
        if (port != null) {
            this.port = port;
        }
        this.init();
        context.addServiceListener((ServiceListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProps(Dictionary config) {
        int tempMaxA = (Integer)config.get("maxarraylength");
        int tempMaxS = (Integer)config.get("maxstringlength");
        if (this.maxArrayLength == tempMaxA && this.maxStringLength == tempMaxS) {
            return;
        }
        List list = this.connections;
        synchronized (list) {
            Iterator it = this.connections.iterator();
            while (it.hasNext()) {
                PMPSessionThread session = (PMPSessionThread)it.next();
                session.maxA = this.maxArrayLength;
                session.maxS = this.maxStringLength;
            }
        }
    }

    private int determineFailureAction() {
        String failureActionProp = System.getProperty("iagent.pmp.bindFailureAction");
        if ("random".equals(failureActionProp)) {
            return 0;
        }
        if ("retry".equals(failureActionProp)) {
            return 1;
        }
        if ("fail".equals(failureActionProp)) {
            return 2;
        }
        if ("reuse".equals(failureActionProp)) {
            return 3;
        }
        return 0;
    }

    protected void init() throws IOException {
        this.run = true;
        try {
            this.socket = new ServerSocket(this.port);
        }
        catch (IOException e) {
            DebugUtils.log(this, 1, "Failed to open PMP server on " + this.port + ".", e);
            int failureAction = this.determineFailureAction();
            switch (failureAction) {
                case 0: {
                    DebugUtils.log(this, 0, "Failure action set to 'random'. Retrying...");
                    this.socket = new ServerSocket(0);
                    this.port = this.socket.getLocalPort();
                    DebugUtils.log(this, 0, "PMP server listening on " + this.port);
                    break;
                }
                case 1: {
                    Integer timeoutProp = Integer.getInteger("iagent.pmp.bindFailureAction.retryTimeout");
                    int timeout = timeoutProp != null ? timeoutProp : 10000;
                    DebugUtils.log(this, 0, "Failure action set to 'retry'. Retrying with timeout " + timeout);
                    try {
                        Thread.sleep(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        throw e;
                    }
                    this.socket = new ServerSocket(this.port);
                    break;
                }
                case 2: {
                    throw e;
                }
                case 3: {
                    DebugUtils.log(this, 0, "Failure action set to 'reuse'. Retrying...");
                    ServerSocket serverSock = new ServerSocket();
                    serverSock.setReuseAddress(true);
                    serverSock.bind(new InetSocketAddress(this.port));
                    this.socket = serverSock;
                }
            }
        }
        this.socket.setSoTimeout(1000);
        new Thread((Runnable)this, "IAgent Server Thread").start();
    }

    public void run() {
        while (this.run) {
            Socket client;
            try {
                client = this.socket.accept();
            }
            catch (IOException iOException) {
                continue;
            }
            try {
                if (!this.run) continue;
                if (System.getProperty("pmp.server.timeout") != null) {
                    Integer timeout = Integer.getInteger("pmp.server.timeout", 0);
                    client.setSoTimeout(timeout);
                }
                PMPSessionThread newSession = new PMPSessionThread(this, client, this.createSessionId(), client.getInetAddress().toString());
                this.addElement(newSession);
            }
            catch (Exception exc) {
                this.error("Error Accepting Client", exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Server server = this;
        synchronized (server) {
            if (!this.run) {
                return;
            }
            this.run = false;
        }
        this.closeConnections("PMP Server has been stopped.");
        try {
            this.info("Closing PMP Socket for " + this.uri);
        }
        catch (Throwable throwable) {}
        if (this.socket != null) {
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception exc) {
                this.error("Error Closing PMP Socket", exc);
                this.socket = null;
            }
        }
        super.close();
    }

    public boolean isActive() {
        return this.run;
    }

    public void event(Object ev, String t) {
        Vector ls = (Vector)this.eventTypes.get(t);
        if (ls != null) {
            int i = 0;
            while (i < ls.size()) {
                ((PMPSessionThread)ls.elementAt(i)).event(ev, t);
                ++i;
            }
        }
    }

    protected synchronized byte addListener(String evType, PMPSessionThread listener) {
        Vector<PMPSessionThread> ls = (Vector<PMPSessionThread>)this.eventTypes.get(evType);
        if (ls == null) {
            ls = new Vector<PMPSessionThread>();
            this.eventTypes.put(evType, ls);
        }
        if (ls.contains(listener)) {
            return 1;
        }
        ls.addElement(listener);
        return 2;
    }

    protected synchronized byte removeListener(String evType, PMPSessionThread listener) {
        Vector ls = (Vector)this.eventTypes.get(evType);
        return (byte)(ls == null ? 1 : (ls.removeElement(listener) ? 2 : 1));
    }

    protected synchronized void removeListeners(Vector evTypes, PMPSessionThread listener) {
        int i = 0;
        while (i < evTypes.size()) {
            this.removeListener((String)evTypes.elementAt(i), listener);
            ++i;
        }
    }

    protected void debug(String msg) {
        DebugUtils.debug(this, msg);
    }

    protected void error(String msg, Throwable exc) {
        DebugUtils.error(this, msg, exc);
    }

    protected void info(String msg) {
        DebugUtils.info(this, msg);
    }

    protected ObjectInfo getService(String clazz, String filter) {
        Object service = null;
        ServiceReference sRef = null;
        ServiceReference[] refs = null;
        Class[] interfaces = null;
        try {
            refs = this.context.getAllServiceReferences(clazz, filter);
        }
        catch (Exception exception) {
            return null;
        }
        if (refs == null) {
            return null;
        }
        int i = 0;
        while (i < refs.length) {
            service = this.context.getService(refs[i]);
            if (service instanceof Remote && PMPServiceImpl.checkInstance(interfaces = ((Remote)service).remoteInterfaces(), service.getClass())) {
                sRef = refs[i];
                break;
            }
            this.context.ungetService(refs[i]);
            StringBuffer stringBuffer = new StringBuffer().append(service).append(" is not instance of ");
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.tigris.mtoolkit.iagent.rpc.Remote");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.debug(stringBuffer.append(clazz2.getName()).append(" or one of its remote interfaces").toString());
            service = null;
            interfaces = null;
            ++i;
        }
        if (service != null) {
            return new ObjectInfo(service, interfaces, sRef);
        }
        return null;
    }

    protected void ungetService(ObjectInfo info) {
        this.context.ungetService((ServiceReference)info.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanRemoteObjects(ServiceReference sRef) {
        List list = this.connections;
        synchronized (list) {
            Iterator it = this.connections.iterator();
            while (it.hasNext()) {
                PMPSessionThread session = (PMPSessionThread)it.next();
                if (!session.connected) continue;
                session.unregisterService(sRef);
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 4) {
            this.cleanRemoteObjects(event.getServiceReference());
        }
    }

    public String getRole() {
        return "Server";
    }

    public Map getProperties() {
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put(PORT, new Integer(this.port));
        return properties;
    }
}

