/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.xml;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.eclipse.kura.camel.bean.PayloadFactory;
import org.eclipse.kura.camel.component.AbstractXmlCamelComponent;
import org.eclipse.kura.camel.component.Configuration;
import org.eclipse.kura.camel.runner.CamelRunner;
import org.eclipse.kura.camel.utils.CamelContexts;
import org.eclipse.kura.cloud.CloudService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRouterComponent
extends AbstractXmlCamelComponent {
    private static final String TOKEN_PATTERN = "\\s*,\\s*";
    private static final Logger logger = LoggerFactory.getLogger(XmlRouterComponent.class);
    private static final String CLOUD_SERVICE_PREREQS = "cloudService.prereqs";
    private static final String COMPONENT_PREREQS = "component.prereqs";
    private static final String LANGUAGE_PREREQS = "language.prereqs";
    private static final String DISABLE_JMX = "disableJmx";
    private static final String INIT_CODE = "initCode";
    private final BundleContext bundleContext;
    private Set<String> requiredComponents = new HashSet<String>();
    private Set<String> requiredLanguages = new HashSet<String>();
    private Map<String, String> cloudServiceRequirements = new HashMap<String, String>();
    private String initCode = "";
    private boolean disableJmx;

    public XmlRouterComponent() {
        super("xml.data");
        this.bundleContext = FrameworkUtil.getBundle(XmlRouterComponent.class).getBundleContext();
    }

    protected void customizeBuilder(CamelRunner.Builder builder, Map<String, Object> properties) {
        boolean disableJmxTemp = Configuration.asBoolean(properties, (String)DISABLE_JMX, (boolean)false);
        builder.disableJmx(disableJmxTemp);
        Set<String> newRequiredComponents = XmlRouterComponent.parseRequirements(Configuration.asString(properties, (String)COMPONENT_PREREQS));
        Set<String> newRequiredLanguages = XmlRouterComponent.parseRequirements(Configuration.asString(properties, (String)LANGUAGE_PREREQS));
        Map<String, String> cloudServiceRequirementsTemp = XmlRouterComponent.parseCloudServiceRequirements(Configuration.asString(properties, (String)CLOUD_SERVICE_PREREQS));
        String initCodeTemp = XmlRouterComponent.parseInitCode(properties);
        logger.debug("Setting new component requirements");
        for (String string : newRequiredComponents) {
            logger.debug("Require component: {}", (Object)string);
            builder.requireComponent(string);
        }
        logger.debug("Setting new language requirements");
        for (String string : newRequiredLanguages) {
            logger.debug("Require language: {}", (Object)string);
            builder.requireLanguage(string);
        }
        logger.debug("Setting new cloud service requirements");
        for (Map.Entry entry : cloudServiceRequirementsTemp.entrySet()) {
            String filter = ((String)entry.getValue()).startsWith("(") ? (String)entry.getValue() : String.format("(&(%s=%s)(kura.service.pid=%s))", "objectClass", CloudService.class.getName(), entry.getValue());
            builder.cloudService(null, filter, CamelRunner.Builder.addAsCloudComponent((String)((String)entry.getKey())));
        }
        if (!initCodeTemp.isEmpty()) {
            builder.addBeforeStart(camelContext -> CamelContexts.scriptInitCamelContext((CamelContext)camelContext, (String)initCodeTemp, (ClassLoader)XmlRouterComponent.class.getClassLoader()));
        }
        BundleContext bundleContext = FrameworkUtil.getBundle(XmlRouterComponent.class).getBundleContext();
        HashMap<String, PayloadFactory> services = new HashMap<String, PayloadFactory>();
        services.put("payloadFactory", new PayloadFactory());
        builder.registryFactory(CamelRunner.createOsgiRegistry((BundleContext)bundleContext, services));
        this.requiredComponents = newRequiredComponents;
        this.requiredLanguages = newRequiredLanguages;
        this.cloudServiceRequirements = cloudServiceRequirementsTemp;
        this.initCode = initCodeTemp;
        this.disableJmx = disableJmxTemp;
    }

    protected boolean isRestartNeeded(Map<String, Object> properties) {
        boolean disableJmxTemp = Configuration.asBoolean(properties, (String)DISABLE_JMX, (boolean)false);
        Set<String> newRequiredComponents = XmlRouterComponent.parseRequirements(Configuration.asString(properties, (String)COMPONENT_PREREQS));
        Map<String, String> cloudServiceRequirementsTemp = XmlRouterComponent.parseCloudServiceRequirements(Configuration.asString(properties, (String)CLOUD_SERVICE_PREREQS));
        String initCodeTemp = XmlRouterComponent.parseInitCode(properties);
        if (this.disableJmx != disableJmxTemp) {
            logger.debug("Require restart due to '{}' change", (Object)DISABLE_JMX);
            return true;
        }
        if (!this.requiredComponents.equals(newRequiredComponents)) {
            logger.debug("Require restart due to '{}' change", (Object)COMPONENT_PREREQS);
            return true;
        }
        if (!this.requiredLanguages.equals(newRequiredComponents)) {
            logger.debug("Require restart due to '{}' change", (Object)LANGUAGE_PREREQS);
            return true;
        }
        if (!this.cloudServiceRequirements.equals(cloudServiceRequirementsTemp)) {
            logger.debug("Require restart due to '{}' change", (Object)CLOUD_SERVICE_PREREQS);
            return true;
        }
        if (!this.initCode.equals(initCodeTemp)) {
            logger.debug("Require restart due to '{}' change", (Object)INIT_CODE);
            return true;
        }
        return false;
    }

    private static Map<String, String> parseCloudServiceRequirements(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String[] stringArray = value.split(TOKEN_PATTERN);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            logger.debug("Testing - '{}'", (Object)tok);
            String[] s = tok.split("=", 2);
            if (s.length == 2) {
                logger.debug("CloudService - '{}' -> '{}'", (Object)s[0], (Object)s[1]);
                result.put(s[0], s[1]);
            }
            ++n2;
        }
        return result;
    }

    private static Set<String> parseRequirements(String value) {
        if (value == null || value.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(value.split(TOKEN_PATTERN)));
    }

    private static String parseInitCode(Map<String, Object> properties) {
        return Configuration.asString(properties, (String)INIT_CODE, (String)"");
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }
}

