/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.cloudconnection.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.cloud.factory.CloudServiceFactory;
import org.eclipse.kura.cloudconnection.CloudConnectionConstants;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.cloudconnection.CloudEndpoint;
import org.eclipse.kura.cloudconnection.factory.CloudConnectionFactory;
import org.eclipse.kura.cloudconnection.publisher.CloudPublisher;
import org.eclipse.kura.cloudconnection.subscriber.CloudSubscriber;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.CloudComponentFactories;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.CloudConnectionFactoryInfo;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.CloudConnectionState;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.CloudEndpointInstance;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.CloudEndpointType;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.CloudPubSubType;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.PubSubFactoryInfo;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.PubSubInstance;
import org.eclipse.kura.rest.configuration.api.ComponentConfigurationDTO;
import org.eclipse.kura.rest.configuration.api.DTOUtil;
import org.eclipse.kura.util.service.ServiceUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConnectionService {
    private static final Logger logger = LoggerFactory.getLogger(CloudConnectionService.class);
    private static final String CLOUD_CONNECTION_FACTORY_FILTER = "(|(objectClass=org.eclipse.kura.cloudconnection.factory.CloudConnectionFactory)(objectClass=org.eclipse.kura.cloud.factory.CloudServiceFactory))";
    private static final String KURA_UI_CSF_PID_DEFAULT = "kura.ui.csf.pid.default";
    private static final String KURA_UI_CSF_PID_REGEX = "kura.ui.csf.pid.regex";
    private static final String CLOUD_PUBLISHER = CloudPublisher.class.getName();
    private static final String CLOUD_SUBSCRIBER = CloudSubscriber.class.getName();
    private final BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    private final ConfigurationService configurationService;

    public CloudConnectionService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public List<CloudEndpointInstance> findCloudEndpointInstances() throws KuraException {
        ArrayList<CloudEndpointInstance> result = new ArrayList<CloudEndpointInstance>();
        this.withAllCloudConnectionFactories((ServiceUtil.ServiceConsumer<CloudConnectionFactory>)((ServiceUtil.ServiceConsumer)service -> {
            String factoryPid = service.getFactoryPid();
            if (factoryPid == null) {
                return;
            }
            for (String pid : service.getManagedCloudConnectionPids()) {
                if (pid == null) continue;
                CloudEndpointInstance cloudConnectionEntry = new CloudEndpointInstance(factoryPid, pid);
                this.fillState(cloudConnectionEntry);
                result.add(cloudConnectionEntry);
            }
        }));
        return result;
    }

    public List<PubSubInstance> findPubsubInstances() throws KuraException {
        ArrayList<PubSubInstance> result = new ArrayList<PubSubInstance>();
        result.addAll(this.getPubSubInstances(CloudPubSubType.PUBLISHER));
        result.addAll(this.getPubSubInstances(CloudPubSubType.SUBSCRIBER));
        return result;
    }

    public Set<String> getStackComponentsPids(String factoryPid, String cloudEndpointPid) throws KuraException {
        HashSet<String> result = new HashSet<String>();
        this.withAllCloudConnectionFactories((ServiceUtil.ServiceConsumer<CloudConnectionFactory>)((ServiceUtil.ServiceConsumer)factory -> {
            if (factoryPid.equals(factory.getFactoryPid())) {
                if (!factory.getManagedCloudConnectionPids().contains(cloudEndpointPid)) {
                    throw new KuraException(KuraErrorCode.NOT_FOUND);
                }
                result.addAll(this.getStackComponentPids((CloudConnectionFactory)factory, cloudEndpointPid));
            }
        }));
        return result;
    }

    private List<String> getStackComponentPids(CloudConnectionFactory factory, String pid) {
        List<String> result = new ArrayList<String>();
        try {
            result = factory.getStackComponentsPids(pid);
        }
        catch (Exception exception) {}
        return result;
    }

    public Set<ComponentConfiguration> getStackConfigurationsByPid(Set<String> pids) throws KuraException {
        ArrayList result = new ArrayList();
        HashSet<ComponentConfiguration> resultSet = new HashSet<ComponentConfiguration>();
        this.withAllCloudConnectionFactories((ServiceUtil.ServiceConsumer<CloudConnectionFactory>)((ServiceUtil.ServiceConsumer)factory -> {
            Set managedCloudConnectionPids = factory.getManagedCloudConnectionPids();
            for (String cloudConnectionPid : managedCloudConnectionPids) {
                List<String> stackComponentsPids = this.getStackComponentPids((CloudConnectionFactory)factory, cloudConnectionPid);
                pids.stream().filter(stackComponentsPids::contains).forEach(result::add);
            }
        }));
        for (String stackConfigurationPid : result) {
            ComponentConfiguration componetConfiguration = this.configurationService.getComponentConfiguration(stackConfigurationPid);
            if (componetConfiguration == null) continue;
            resultSet.add(componetConfiguration);
        }
        return resultSet;
    }

    public void createCloudEndpointFromFactory(String factoryPid, String cloudServicePid) throws KuraException {
        if (factoryPid == null || factoryPid.trim().isEmpty() || cloudServicePid == null || cloudServicePid.trim().isEmpty()) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        AtomicReference<Boolean> found = new AtomicReference<Boolean>(false);
        this.withAllCloudConnectionFactories((ServiceUtil.ServiceConsumer<CloudConnectionFactory>)((ServiceUtil.ServiceConsumer)service -> {
            if (service.getFactoryPid().equals(factoryPid)) {
                found.set(true);
                service.createConfiguration(cloudServicePid);
            }
        }));
        if (Boolean.FALSE.equals(found.get())) {
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
    }

    public void deleteCloudEndpointFromFactory(String factoryPid, String cloudEndpointPid) throws KuraException {
        if (factoryPid == null || factoryPid.trim().isEmpty() || cloudEndpointPid == null || cloudEndpointPid.trim().isEmpty()) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        AtomicReference<Boolean> found = new AtomicReference<Boolean>(false);
        this.withAllCloudConnectionFactories((ServiceUtil.ServiceConsumer<CloudConnectionFactory>)((ServiceUtil.ServiceConsumer)factory -> {
            if (factory.getFactoryPid().equals(factoryPid) && factory.getManagedCloudConnectionPids().contains(cloudEndpointPid)) {
                factory.deleteConfiguration(cloudEndpointPid);
                found.set(true);
            }
        }));
        if (Boolean.FALSE.equals(found.get())) {
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
    }

    public CloudComponentFactories getCloudComponentFactories() throws KuraException {
        ArrayList<CloudConnectionFactoryInfo> cloudConnectionFactoryPids = new ArrayList<CloudConnectionFactoryInfo>();
        this.withAllCloudConnectionFactoryRefs((ServiceUtil.ServiceReferenceConsumer<Object>)((ServiceUtil.ServiceReferenceConsumer)(ref, ctx) -> {
            try {
                CloudConnectionFactory service = this.wrap(ctx.getService(ref));
                String defaultPid = (String)ref.getProperty(KURA_UI_CSF_PID_DEFAULT);
                String pidRegex = (String)ref.getProperty(KURA_UI_CSF_PID_REGEX);
                CloudConnectionFactoryInfo cloudConnectionFactoryInfoDTO = new CloudConnectionFactoryInfo(service.getFactoryPid(), defaultPid, pidRegex);
                cloudConnectionFactoryPids.add(cloudConnectionFactoryInfoDTO);
            }
            finally {
                ctx.ungetService(ref);
            }
        }));
        List<PubSubFactoryInfo> pubSubFactories = this.getPubSubFactories();
        return new CloudComponentFactories(cloudConnectionFactoryPids, pubSubFactories);
    }

    public void createPubSubInstance(String pid, String factoryPid, String cloudEndpointPid) throws KuraException {
        if (pid == null || pid.trim().isEmpty() || factoryPid == null || factoryPid.trim().isEmpty() || cloudEndpointPid == null || cloudEndpointPid.trim().isEmpty()) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        this.requireIsPubSubFactory(factoryPid);
        ServiceUtil.applyToServiceOptionally((BundleContext)this.bundleContext, ConfigurationService.class, cs -> {
            cs.createFactoryConfiguration(factoryPid, pid, Collections.singletonMap(CloudConnectionConstants.CLOUD_ENDPOINT_SERVICE_PID_PROP_NAME.value(), cloudEndpointPid), true);
            return null;
        });
    }

    public void deletePubSubInstance(String pid) throws KuraException {
        this.requireIsPubSub(pid);
        ServiceUtil.applyToServiceOptionally((BundleContext)this.bundleContext, ConfigurationService.class, cs -> {
            cs.deleteFactoryConfiguration(pid, true);
            return null;
        });
    }

    public List<ComponentConfiguration> getPubSubConfiguration(Set<String> pids) throws KuraException {
        ArrayList<ComponentConfiguration> result = new ArrayList<ComponentConfiguration>();
        for (String pid : pids) {
            ComponentConfiguration configuration;
            if (!this.isPubSub(pid) || (configuration = this.configurationService.getComponentConfiguration(pid)) == null) continue;
            result.add(configuration);
        }
        return result;
    }

    public void updateStackComponentConfiguration(List<ComponentConfigurationDTO> componentConfigurations, boolean takeSnapshot) throws KuraException {
        for (ComponentConfigurationDTO componentConfig : componentConfigurations) {
            if (this.isPubSub(componentConfig.getPid()) || this.isComponentManagedByFactory(componentConfig.getPid())) continue;
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        this.updateComponentConfigurations(componentConfigurations, takeSnapshot);
    }

    private void updateComponentConfigurations(List<ComponentConfigurationDTO> componentConfigurations, boolean takeSnapshot) throws KuraException {
        List configs = componentConfigurations.stream().map(cc -> new ComponentConfigurationImpl(cc.getPid(), null, DTOUtil.dtosToConfigurationProperties((Map)cc.getProperties()))).collect(Collectors.toList());
        this.configurationService.updateConfigurations(configs, takeSnapshot);
    }

    private boolean isComponentManagedByFactory(String pid) {
        AtomicBoolean result = new AtomicBoolean(false);
        try {
            this.withAllCloudConnectionFactories((ServiceUtil.ServiceConsumer<CloudConnectionFactory>)((ServiceUtil.ServiceConsumer)f -> {
                for (String stackPid : f.getManagedCloudConnectionPids()) {
                    if (!f.getStackComponentsPids(stackPid).contains(pid)) continue;
                    result.set(true);
                    return;
                }
            }));
        }
        catch (Exception exception) {
            return false;
        }
        return result.get();
    }

    private void requireIsPubSub(String pid) throws KuraException {
        if (!this.isPubSub(pid)) {
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
    }

    private boolean isPubSub(String pid) {
        return ServiceUtil.providesService((BundleContext)this.bundleContext, (String)pid, CloudPublisher.class) || ServiceUtil.providesService((BundleContext)this.bundleContext, (String)pid, CloudSubscriber.class);
    }

    private List<PubSubFactoryInfo> getPubSubFactories() throws KuraException {
        return (List)ServiceUtil.applyToServiceOptionally((BundleContext)this.bundleContext, ServiceComponentRuntime.class, scr -> scr.getComponentDescriptionDTOs(new Bundle[0]).stream().map(this::pubSubFactoryToInfo).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void requireIsPubSubFactory(String factoryPid) throws KuraException {
        boolean isPubSub = (Boolean)ServiceUtil.applyToServiceOptionally((BundleContext)this.bundleContext, ServiceComponentRuntime.class, scr -> scr.getComponentDescriptionDTOs(new Bundle[0]).stream().anyMatch(c -> {
            Map properties = c.properties;
            if (properties == null) {
                return false;
            }
            return Objects.equals(factoryPid, properties.get("service.pid")) && this.pubSubFactoryToInfo((ComponentDescriptionDTO)c) != null;
        }));
        if (!isPubSub) {
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
    }

    private PubSubFactoryInfo pubSubFactoryToInfo(ComponentDescriptionDTO component) {
        if (Arrays.stream(component.serviceInterfaces).noneMatch(intf -> CLOUD_PUBLISHER.equals(intf) || CLOUD_SUBSCRIBER.equals(intf))) {
            return null;
        }
        String ccsfFactoryPidPropName = CloudConnectionConstants.CLOUD_CONNECTION_FACTORY_PID_PROP_NAME.value();
        Object ccsfFactoryPid = component.properties.get(ccsfFactoryPidPropName);
        Object factoryPid = component.properties.get("service.pid");
        Object defaultFactoryPid = component.properties.get(KURA_UI_CSF_PID_DEFAULT);
        Object defaultFactoryPidRegex = component.properties.get(KURA_UI_CSF_PID_REGEX);
        if (!(factoryPid instanceof String)) {
            logger.warn("component {} defines a CloudPublisher or CloudSubscriber but does not specify the service.pid property, ignoring it", (Object)component.name);
            return null;
        }
        if (!(ccsfFactoryPid instanceof String)) {
            logger.warn("component {} defines a CloudPublisher or CloudSubscriber but does not specify the {} property, ignoring it", (Object)component.name, (Object)ccsfFactoryPidPropName);
            return null;
        }
        return new PubSubFactoryInfo((String)factoryPid, (String)ccsfFactoryPid, (String)defaultFactoryPid, (String)defaultFactoryPidRegex);
    }

    private void fillState(CloudEndpointInstance cloudEndpointInstance) throws KuraException {
        cloudEndpointInstance.setState(CloudConnectionState.UNREGISTERED);
        String filter = String.format("(%s=%s)", "kura.service.pid", cloudEndpointInstance.getCloudEndpointPid());
        ServiceUtil.withAllServices((BundleContext)this.bundleContext, null, (String)filter, service -> {
            if (service instanceof CloudConnectionManager) {
                cloudEndpointInstance.setState(((CloudConnectionManager)service).isConnected() ? CloudConnectionState.CONNECTED : CloudConnectionState.DISCONNECTED);
                cloudEndpointInstance.setConnectionType(CloudEndpointType.CLOUD_CONNECTION_MANAGER);
            } else if (service instanceof CloudEndpoint) {
                cloudEndpointInstance.setConnectionType(CloudEndpointType.CLOUD_ENDPOINT);
            } else if (service instanceof CloudService) {
                cloudEndpointInstance.setState(((CloudService)service).isConnected() ? CloudConnectionState.CONNECTED : CloudConnectionState.DISCONNECTED);
                cloudEndpointInstance.setConnectionType(CloudEndpointType.CLOUD_CONNECTION_MANAGER);
            }
        });
    }

    private void withAllCloudConnectionFactoryRefs(ServiceUtil.ServiceReferenceConsumer<Object> consumer) throws KuraException {
        ServiceUtil.withAllServiceReferences((BundleContext)this.bundleContext, (String)CLOUD_CONNECTION_FACTORY_FILTER, consumer, (Class[])new Class[0]);
    }

    private void withAllCloudConnectionFactories(ServiceUtil.ServiceConsumer<CloudConnectionFactory> consumer) throws KuraException {
        ServiceUtil.withAllServices((BundleContext)this.bundleContext, (String)CLOUD_CONNECTION_FACTORY_FILTER, o -> consumer.consume((Object)this.wrap(o)), (Class[])new Class[0]);
    }

    private CloudConnectionFactory wrap(Object o) {
        if (o instanceof CloudConnectionFactory) {
            return (CloudConnectionFactory)o;
        }
        if (o instanceof CloudServiceFactory) {
            final CloudServiceFactory f = (CloudServiceFactory)o;
            return new CloudConnectionFactory(){

                public List<String> getStackComponentsPids(String pid) throws KuraException {
                    return f.getStackComponentsPids(pid);
                }

                public Set<String> getManagedCloudConnectionPids() throws KuraException {
                    return f.getManagedCloudServicePids();
                }

                public String getFactoryPid() {
                    return f.getFactoryPid();
                }

                public void deleteConfiguration(String pid) throws KuraException {
                    f.deleteConfiguration(pid);
                }

                public void createConfiguration(String pid) throws KuraException {
                    f.createConfiguration(pid);
                }
            };
        }
        return null;
    }

    private Set<PubSubInstance> getPubSubInstances(CloudPubSubType type) throws KuraException {
        HashSet<PubSubInstance> result = new HashSet<PubSubInstance>();
        Class clazz = type == CloudPubSubType.PUBLISHER ? CloudPublisher.class : CloudSubscriber.class;
        try {
            this.bundleContext.getServiceReferences(clazz, null).stream().map(ref -> CloudConnectionService.pubSubRefToDTO(ref, type)).filter(Objects::nonNull).forEach(result::add);
            return result;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"Unexpected error"});
        }
    }

    private static PubSubInstance pubSubRefToDTO(ServiceReference<?> ref, CloudPubSubType type) {
        Object ccsPid = ref.getProperty(CloudConnectionConstants.CLOUD_ENDPOINT_SERVICE_PID_PROP_NAME.value());
        Object factoryPid = ref.getProperty("service.factoryPid");
        if (!(ccsPid instanceof String) || !(factoryPid instanceof String)) {
            return null;
        }
        String kuraServicePid = (String)ref.getProperty("kura.service.pid");
        return new PubSubInstance((String)ccsPid, kuraServicePid, (String)factoryPid, type);
    }
}

