/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.graph.PortAggregator;
import org.eclipse.kura.wire.graph.ReceiverPort;

public class BarrierAggregator
implements PortAggregator {
    private int fullSlots = 0;
    private final List<WireEnvelope> envelopes;
    private Consumer<List<WireEnvelope>> consumer = envelopes -> {};

    public BarrierAggregator(List<ReceiverPort> ports) {
        Objects.requireNonNull(ports);
        this.envelopes = new ArrayList<WireEnvelope>(ports.size());
        int i = 0;
        while (i < ports.size()) {
            this.envelopes.add(null);
            Integer port = i;
            ports.get(i).onWireReceive(envelope -> {
                List<WireEnvelope> list = this.envelopes;
                synchronized (list) {
                    if (this.envelopes.get(port) == null) {
                        ++this.fullSlots;
                    }
                    this.envelopes.set(port, (WireEnvelope)envelope);
                    if (this.fullSlots == this.envelopes.size()) {
                        this.consumer.accept(this.envelopes);
                        this.clearSlots();
                    }
                }
            });
            ++i;
        }
    }

    private void clearSlots() {
        this.fullSlots = 0;
        int i = 0;
        while (i < this.envelopes.size()) {
            this.envelopes.set(i, null);
            ++i;
        }
    }

    public void onWireReceive(Consumer<List<WireEnvelope>> consumer) {
        Objects.requireNonNull(consumer);
        this.consumer = consumer;
    }
}

