/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoadingAwareObjectInputStream
extends ObjectInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoadingAwareObjectInputStream.class);
    private static final ClassLoader FALLBACK_CLASS_LOADER = ClassLoadingAwareObjectInputStream.class.getClassLoader();
    private final ClassLoader inLoader;
    private final TrustedClassFilter securityFilter;

    public ClassLoadingAwareObjectInputStream(InputStream in, TrustedClassFilter filter) throws IOException {
        super(in);
        this.inLoader = in.getClass().getClassLoader();
        this.securityFilter = filter;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = this.load(classDesc.getName(), cl, this.inLoader);
        return this.checkSecurity(clazz);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class[] cinterfaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            cinterfaces[i] = this.load(interfaces[i], cl);
        }
        Class<?> clazz = null;
        IllegalArgumentException failureCause = null;
        try {
            clazz = Proxy.getProxyClass(cl, cinterfaces);
        }
        catch (IllegalArgumentException e) {
            failureCause = e;
            try {
                clazz = Proxy.getProxyClass(this.inLoader, cinterfaces);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                clazz = Proxy.getProxyClass(FALLBACK_CLASS_LOADER, cinterfaces);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (clazz != null) {
            return this.checkSecurity(clazz);
        }
        throw new ClassNotFoundException("Failed find class.", failureCause);
    }

    private Class<?> checkSecurity(Class<?> clazz) throws ClassNotFoundException {
        Class<?> target = clazz;
        while (target.isArray()) {
            target = target.getComponentType();
        }
        while (target.isAnonymousClass() || target.isLocalClass()) {
            target = target.getEnclosingClass();
        }
        if (!target.isPrimitive() && this.securityFilter != null && !this.securityFilter.isTrusted(target)) {
            throw new ClassNotFoundException("Forbidden " + clazz + "! This class is not trusted to be deserialized under the current configuration. Please refer to the documentation for more information on how to configure trusted classes.");
        }
        return clazz;
    }

    private Class<?> load(String className, ClassLoader ... cl) throws ClassNotFoundException {
        Class<?> clazz = ClassLoadingAwareObjectInputStream.loadSimpleType(className);
        if (clazz != null) {
            LOG.trace("Loaded class: {} as simple type -> ", (Object)className, clazz);
            return clazz;
        }
        for (ClassLoader loader : cl) {
            LOG.trace("Attempting to load class: {} using classloader: {}", (Object)className, (Object)cl);
            try {
                Class<?> answer = Class.forName(className, false, loader);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Loaded class: {} using classloader: {} -> ", new Object[]{className, cl, answer});
                }
                return answer;
            }
            catch (ClassNotFoundException e) {
                LOG.trace("Class not found: {} using classloader: {}", (Object)className, (Object)cl);
            }
        }
        return Class.forName(className, false, FALLBACK_CLASS_LOADER);
    }

    public static Class<?> loadSimpleType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return byte[].class;
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return Byte[].class;
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return Object[].class;
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return String[].class;
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return String.class;
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name)) {
            return Boolean.class;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name)) {
            return Integer.class;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name)) {
            return Long.class;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name)) {
            return Short.class;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name)) {
            return Byte.class;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name)) {
            return Float.class;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name)) {
            return Double.class;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        return null;
    }

    public static interface TrustedClassFilter {
        public boolean isTrusted(Class<?> var1);
    }
}

