/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.meta.JmsAbstractResourceId;
import org.apache.qpid.jms.meta.JmsConnectionId;

public final class JmsTransactionId
extends JmsAbstractResourceId
implements Comparable<JmsTransactionId> {
    private final JmsConnectionId connectionId;
    private final long value;

    public JmsTransactionId(JmsConnectionId connectionId, long transactionId) {
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection ID cannot be null");
        }
        this.connectionId = connectionId;
        this.value = transactionId;
    }

    public String toString() {
        return "TX:" + this.connectionId + ":" + this.value;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 1;
            this.hashCode = 31 * this.hashCode + this.connectionId.hashCode();
            this.hashCode = 31 * this.hashCode + (int)(this.value ^ this.value >>> 32);
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != JmsTransactionId.class) {
            return false;
        }
        JmsTransactionId tx = (JmsTransactionId)other;
        return this.value == tx.value && this.connectionId.equals(tx.connectionId);
    }

    @Override
    public int compareTo(JmsTransactionId o) {
        int result = this.connectionId.compareTo(o.connectionId);
        if (result == 0) {
            result = (int)(this.value - o.value);
        }
        return result;
    }

    public Object getProviderTxId() {
        return this.getProviderHint();
    }

    public long getValue() {
        return this.value;
    }

    public JmsConnectionId getConnectionId() {
        return this.connectionId;
    }
}

