/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.meta.JmsAbstractResource;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.policy.JmsDefaultDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsDefaultMessageIDPolicy;
import org.apache.qpid.jms.policy.JmsDefaultPrefetchPolicy;
import org.apache.qpid.jms.policy.JmsDefaultPresettlePolicy;
import org.apache.qpid.jms.policy.JmsDefaultRedeliveryPolicy;
import org.apache.qpid.jms.policy.JmsDeserializationPolicy;
import org.apache.qpid.jms.policy.JmsMessageIDPolicy;
import org.apache.qpid.jms.policy.JmsPrefetchPolicy;
import org.apache.qpid.jms.policy.JmsPresettlePolicy;
import org.apache.qpid.jms.policy.JmsRedeliveryPolicy;

public final class JmsSessionInfo
extends JmsAbstractResource
implements Comparable<JmsSessionInfo> {
    private final JmsSessionId sessionId;
    private int acknowledgementMode;
    private boolean sendAcksAsync;
    private JmsMessageIDPolicy messageIDPolicy;
    private JmsPrefetchPolicy prefetchPolicy;
    private JmsPresettlePolicy presettlePolicy;
    private JmsRedeliveryPolicy redeliveryPolicy;
    private JmsDeserializationPolicy deserializationPolicy;

    public JmsSessionInfo(JmsConnectionInfo connectionInfo, long sessionId) {
        if (connectionInfo == null) {
            throw new IllegalArgumentException("Connection info object cannot be null");
        }
        this.sessionId = new JmsSessionId(connectionInfo.getId(), sessionId);
    }

    public JmsSessionInfo(JmsSessionId sessionId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("session Id object cannot be null");
        }
        this.sessionId = sessionId;
    }

    public JmsSessionInfo copy() {
        JmsSessionInfo copy = new JmsSessionInfo(this.sessionId);
        this.copy(copy);
        return copy;
    }

    private void copy(JmsSessionInfo copy) {
        copy.acknowledgementMode = this.acknowledgementMode;
        copy.sendAcksAsync = this.sendAcksAsync;
        copy.redeliveryPolicy = this.getRedeliveryPolicy().copy();
        copy.presettlePolicy = this.getPresettlePolicy().copy();
        copy.prefetchPolicy = this.getPrefetchPolicy().copy();
        copy.messageIDPolicy = this.getMessageIDPolicy().copy();
        copy.deserializationPolicy = this.getDeserializationPolicy().copy();
    }

    @Override
    public JmsSessionId getId() {
        return this.sessionId;
    }

    @Override
    public void visit(JmsResourceVistor vistor) throws Exception {
        vistor.processSessionInfo(this);
    }

    public int getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(int acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isTransacted() {
        return this.acknowledgementMode == 0;
    }

    public boolean isSendAcksAsync() {
        return this.sendAcksAsync;
    }

    public void setSendAcksAsync(boolean sendAcksAsync) {
        this.sendAcksAsync = sendAcksAsync;
    }

    public String toString() {
        return "JmsSessionInfo { " + this.getId() + " }";
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JmsSessionInfo other = (JmsSessionInfo)obj;
        return this.sessionId.equals(other.sessionId);
    }

    @Override
    public int compareTo(JmsSessionInfo other) {
        return this.sessionId.compareTo(other.sessionId);
    }

    public JmsMessageIDPolicy getMessageIDPolicy() {
        if (this.messageIDPolicy == null) {
            this.messageIDPolicy = new JmsDefaultMessageIDPolicy();
        }
        return this.messageIDPolicy;
    }

    public void setMessageIDPolicy(JmsMessageIDPolicy messageIDPolicy) {
        this.messageIDPolicy = messageIDPolicy;
    }

    public JmsPrefetchPolicy getPrefetchPolicy() {
        if (this.prefetchPolicy == null) {
            this.prefetchPolicy = new JmsDefaultPrefetchPolicy();
        }
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(JmsPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy;
    }

    public JmsPresettlePolicy getPresettlePolicy() {
        if (this.presettlePolicy == null) {
            this.presettlePolicy = new JmsDefaultPresettlePolicy();
        }
        return this.presettlePolicy;
    }

    public void setPresettlePolicy(JmsPresettlePolicy presettlePolicy) {
        this.presettlePolicy = presettlePolicy;
    }

    public JmsRedeliveryPolicy getRedeliveryPolicy() {
        if (this.redeliveryPolicy == null) {
            this.redeliveryPolicy = new JmsDefaultRedeliveryPolicy();
        }
        return this.redeliveryPolicy;
    }

    public void setRedeliveryPolicy(JmsRedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
    }

    public JmsDeserializationPolicy getDeserializationPolicy() {
        if (this.deserializationPolicy == null) {
            this.deserializationPolicy = new JmsDefaultDeserializationPolicy();
        }
        return this.deserializationPolicy;
    }

    public void setDeserializationPolicy(JmsDeserializationPolicy deserializationPolicy) {
        this.deserializationPolicy = deserializationPolicy;
    }
}

