/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.message;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.exceptions.JmsExceptionSupport;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.JmsMessagePropertySupport;
import org.apache.qpid.jms.util.TypeConversionSupport;

public class JmsMessagePropertyIntercepter {
    private static final Map<String, PropertyIntercepter> PROPERTY_INTERCEPTERS = new HashMap<String, PropertyIntercepter>();
    private static final Set<String> STANDARD_HEADERS = new HashSet<String>();
    private static final Set<String> VENDOR_PROPERTIES = new HashSet<String>();

    public static Object getProperty(JmsMessage message, String name) throws JMSException {
        Object value = null;
        JmsMessagePropertySupport.checkPropertyNameIsValid(name, message.isValidatePropertyNames());
        PropertyIntercepter jmsPropertyExpression = PROPERTY_INTERCEPTERS.get(name);
        value = jmsPropertyExpression != null ? jmsPropertyExpression.getProperty(message) : message.getFacade().getProperty(name);
        return value;
    }

    public static void setProperty(JmsMessage message, String name, Object value) throws JMSException {
        PropertyIntercepter jmsPropertyExpression = PROPERTY_INTERCEPTERS.get(name);
        if (jmsPropertyExpression == null || !jmsPropertyExpression.isAlwaysWritable()) {
            message.checkReadOnlyProperties();
        }
        JmsMessagePropertySupport.checkPropertyNameIsValid(name, message.isValidatePropertyNames());
        JmsMessagePropertySupport.checkValidObject(value);
        if (jmsPropertyExpression != null) {
            jmsPropertyExpression.setProperty(message, value);
        } else {
            message.getFacade().setProperty(name, value);
        }
    }

    public static boolean propertyExists(JmsMessage message, String name) throws JMSException {
        try {
            JmsMessagePropertySupport.checkPropertyNameIsValid(name, message.isValidatePropertyNames());
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        PropertyIntercepter jmsPropertyExpression = PROPERTY_INTERCEPTERS.get(name);
        if (jmsPropertyExpression != null) {
            return jmsPropertyExpression.propertyExists(message);
        }
        return message.getFacade().propertyExists(name);
    }

    public static void clearProperties(JmsMessage message, boolean excludeStandardJMSHeaders) throws JMSException {
        for (Map.Entry<String, PropertyIntercepter> entry : PROPERTY_INTERCEPTERS.entrySet()) {
            if (excludeStandardJMSHeaders && STANDARD_HEADERS.contains(entry.getKey())) continue;
            entry.getValue().clearProperty(message);
        }
        message.getFacade().clearProperties();
        message.setReadOnlyProperties(false);
    }

    public static Set<String> getAllPropertyNames(JmsMessage message) throws JMSException {
        HashSet<String> names = new HashSet<String>(PROPERTY_INTERCEPTERS.keySet());
        names.addAll(message.getFacade().getPropertyNames());
        return names;
    }

    public static Set<String> getPropertyNames(JmsMessage message, boolean excludeStandardJMSHeaders) throws JMSException {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry<String, PropertyIntercepter> entry : PROPERTY_INTERCEPTERS.entrySet()) {
            if (excludeStandardJMSHeaders && STANDARD_HEADERS.contains(entry.getKey()) || !entry.getValue().propertyExists(message)) continue;
            names.add(entry.getKey());
        }
        for (String name : message.getFacade().getPropertyNames()) {
            try {
                JmsMessagePropertySupport.checkPropertyNameIsValid(name, message.isValidatePropertyNames());
            }
            catch (IllegalArgumentException iae) {
                continue;
            }
            names.add(name);
        }
        return names;
    }

    static {
        STANDARD_HEADERS.add("JMSMessageID");
        STANDARD_HEADERS.add("JMSTimestamp");
        STANDARD_HEADERS.add("JMSCorrelationID");
        STANDARD_HEADERS.add("JMSReplyTo");
        STANDARD_HEADERS.add("JMSDestination");
        STANDARD_HEADERS.add("JMSDeliveryMode");
        STANDARD_HEADERS.add("JMSRedelivered");
        STANDARD_HEADERS.add("JMSType");
        STANDARD_HEADERS.add("JMSExpiration");
        STANDARD_HEADERS.add("JMSPriority");
        STANDARD_HEADERS.add("JMSDeliveryTime");
        VENDOR_PROPERTIES.add("JMS_AMQP_ACK_TYPE");
        PROPERTY_INTERCEPTERS.put("JMSDestination", new PropertyIntercepter(){

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                throw new JMSException("Cannot set JMS Destination as a property, use setJMSDestination() instead");
            }

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                JmsDestination dest = message.getFacade().getDestination();
                if (dest == null) {
                    return null;
                }
                return ((Object)dest).toString();
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getDestination() != null;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setDestination(null);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSReplyTo", new PropertyIntercepter(){

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                throw new JMSException("Cannot set JMS ReplyTo as a property, use setJMSReplTo() instead");
            }

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                if (message.getFacade().getReplyTo() == null) {
                    return null;
                }
                return message.getFacade().getReplyTo().toString();
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getReplyTo() != null;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setReplyTo(null);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSType", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().getType();
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new JMSException("Property JMSType cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setType(rc);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getType() != null;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setType(null);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSDeliveryMode", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().isPersistent() ? "PERSISTENT" : "NON_PERSISTENT";
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                Integer rc;
                block9: {
                    rc = null;
                    try {
                        rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                    }
                    catch (NumberFormatException nfe) {
                        if (value instanceof String) {
                            if (((String)value).equalsIgnoreCase("PERSISTENT")) {
                                rc = 2;
                            } else if (((String)value).equalsIgnoreCase("NON_PERSISTENT")) {
                                rc = 1;
                            }
                        }
                        if (rc != null) break block9;
                        throw nfe;
                    }
                }
                if (rc == null) {
                    Boolean bool = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                    if (bool == null) {
                        throw new JMSException("Property JMSDeliveryMode cannot be set from a " + value.getClass().getName() + ".");
                    }
                    message.getFacade().setPersistent(bool);
                } else {
                    message.getFacade().setPersistent(rc == 2);
                }
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return true;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setPersistent(true);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSPriority", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().getPriority();
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new JMSException("Property JMSPriority cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setPriority(rc.byteValue());
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return true;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setPriority(4);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSMessageID", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                if (message.getFacade().getMessageId() == null) {
                    return null;
                }
                return message.getFacade().getMessageId();
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new JMSException("Property JMSMessageID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setMessageId(rc);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getMessageId() != null;
            }

            @Override
            public void clearProperty(JmsMessage message) throws JMSException {
                message.getFacade().setMessageId(null);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSTimestamp", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().getTimestamp();
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new JMSException("Property JMSTimestamp cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setTimestamp(rc);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getTimestamp() > 0L;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setTimestamp(0L);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSCorrelationID", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().getCorrelationId();
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new JMSException("Property JMSCorrelationID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setCorrelationId(rc);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getCorrelationId() != null;
            }

            @Override
            public void clearProperty(JmsMessage message) throws JMSException {
                message.getFacade().setCorrelationId(null);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSExpiration", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().getExpiration();
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new JMSException("Property JMSExpiration cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setExpiration(rc);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getExpiration() > 0L;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setExpiration(0L);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSRedelivered", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().isRedelivered();
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                Boolean rc = (Boolean)TypeConversionSupport.convert(value, Boolean.class);
                if (rc == null) {
                    throw new JMSException("Property JMSRedelivered cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setRedelivered(rc);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().isRedelivered();
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setRedelivered(false);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSXDeliveryCount", new PropertyIntercepter(){

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new JMSException("Property JMSXDeliveryCount cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setDeliveryCount(rc);
            }

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().getDeliveryCount();
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return true;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setDeliveryCount(1);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSXGroupID", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().getGroupId();
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                String rc = (String)TypeConversionSupport.convert(value, String.class);
                if (rc == null) {
                    throw new JMSException("Property JMSXGroupID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setGroupId(rc);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getGroupId() != null;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setGroupId(null);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSXGroupSeq", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().getGroupSequence();
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                Integer rc = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (rc == null) {
                    throw new JMSException("Property JMSXGroupSeq cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setGroupSequence(rc);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getGroupSequence() != 0;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setGroupSequence(0);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSXUserID", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                Object userId = message.getFacade().getUserId();
                if (userId == null) {
                    try {
                        userId = message.getFacade().getProperty("JMSXUserID");
                    }
                    catch (Exception e) {
                        throw JmsExceptionSupport.create(e);
                    }
                }
                return userId;
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                if (value != null && !(value instanceof String)) {
                    throw new JMSException("Property JMSXUserID cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setUserId((String)value);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getUserId() != null;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setUserId(null);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMS_AMQP_ACK_TYPE", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                Integer ackType = null;
                if (message.getAcknowledgeCallback() != null && message.getAcknowledgeCallback().isAckTypeSet()) {
                    ackType = message.getAcknowledgeCallback().getAckType();
                }
                return ackType;
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                if (message.getAcknowledgeCallback() == null) {
                    throw new JMSException("Session Acknowledgement Mode does not allow setting: JMS_AMQP_ACK_TYPE");
                }
                Integer ackType = (Integer)TypeConversionSupport.convert(value, Integer.class);
                if (ackType == null) {
                    throw new JMSException("Property JMS_AMQP_ACK_TYPE cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getAcknowledgeCallback().setAckType(ackType);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                if (message.getAcknowledgeCallback() != null) {
                    return message.getAcknowledgeCallback().isAckTypeSet();
                }
                return false;
            }

            @Override
            public void clearProperty(JmsMessage message) throws JMSException {
                if (message.getAcknowledgeCallback() != null) {
                    message.getAcknowledgeCallback().clearAckType();
                }
            }

            @Override
            public boolean isAlwaysWritable() {
                return true;
            }
        });
        PROPERTY_INTERCEPTERS.put("JMSDeliveryTime", new PropertyIntercepter(){

            @Override
            public Object getProperty(JmsMessage message) throws JMSException {
                return message.getFacade().getDeliveryTime();
            }

            @Override
            public void setProperty(JmsMessage message, Object value) throws JMSException {
                Long rc = (Long)TypeConversionSupport.convert(value, Long.class);
                if (rc == null) {
                    throw new JMSException("Property JMSDeliveryTime cannot be set from a " + value.getClass().getName() + ".");
                }
                message.getFacade().setDeliveryTime(rc, true);
            }

            @Override
            public boolean propertyExists(JmsMessage message) {
                return message.getFacade().getDeliveryTime() > 0L;
            }

            @Override
            public void clearProperty(JmsMessage message) {
                message.getFacade().setDeliveryTime(0L, true);
            }

            @Override
            public boolean isAlwaysWritable() {
                return false;
            }
        });
    }

    static interface PropertyIntercepter {
        public Object getProperty(JmsMessage var1) throws JMSException;

        public void setProperty(JmsMessage var1, Object var2) throws JMSException;

        public boolean propertyExists(JmsMessage var1);

        public void clearProperty(JmsMessage var1) throws JMSException;

        public boolean isAlwaysWritable();
    }
}

