/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.configuration.change.manager;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.kura.configuration.change.manager.ServiceTrackerListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ComponentsServiceTracker
extends ServiceTracker {
    private final Set<ServiceTrackerListener> listeners = new HashSet<ServiceTrackerListener>();
    private static final String FILTER_EXCLUDE_CONF_CHANGE_MANAGER_FACTORY = "(!(service.factoryPid=org.eclipse.kura.configuration.change.manager.ConfigurationChangeManager))";

    public ComponentsServiceTracker(BundleContext context) throws InvalidSyntaxException {
        super(context, context.createFilter(FILTER_EXCLUDE_CONF_CHANGE_MANAGER_FACTORY), null);
    }

    public Object addingService(ServiceReference ref) {
        Object service = super.addingService(ref);
        this.notifyListeners(ref);
        return service;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.notifyListeners(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        super.removedService(reference, service);
        this.notifyListeners(reference);
    }

    public void addServiceTrackerListener(ServiceTrackerListener listener) {
        this.listeners.add(listener);
    }

    public void removeServiceTrackerListener(ServiceTrackerListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(ServiceReference ref) {
        Optional<String> pid = this.getPidFromServiceReference(ref);
        if (pid.isPresent()) {
            for (ServiceTrackerListener listener : this.listeners) {
                listener.onConfigurationChanged(pid.get());
            }
        }
    }

    private Optional<String> getPidFromServiceReference(ServiceReference ref) {
        Optional<String> pid = Optional.empty();
        if (ref.getProperty("kura.service.pid") != null) {
            pid = Optional.of((String)ref.getProperty("kura.service.pid"));
        } else if (ref.getProperty("service.factoryPid") != null) {
            pid = Optional.of((String)ref.getProperty("service.factoryPid"));
        } else if (ref.getProperty("service.pid") != null) {
            pid = Optional.of((String)ref.getProperty("service.pid"));
        }
        return pid;
    }
}

