/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.configuration.metatype.AD;
import org.eclipse.kura.configuration.metatype.OCD;
import org.eclipse.kura.configuration.metatype.Scalar;

public class CollectionsUtil {
    public static Map<String, Object> dictionaryToMap(Dictionary<String, Object> dictionary, OCD ocd) {
        if (dictionary == null) {
            return null;
        }
        HashMap<String, AD> ads = new HashMap<String, AD>();
        if (ocd != null) {
            for (AD ad : ocd.getAD()) {
                ads.put(ad.getId(), ad);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Object value = dictionary.get(key);
            AD ad = (AD)ads.get(key);
            if (ad != null && ad.getType() != null && Scalar.PASSWORD.equals((Object)ad.getType())) {
                if (value instanceof char[]) {
                    map.put(key, new Password((char[])value));
                    continue;
                }
                if (value instanceof String[]) {
                    map.put(key, CollectionsUtil.convertStringsToPasswords((String[])value));
                    continue;
                }
                map.put(key, new Password(value.toString()));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    private static Password[] convertStringsToPasswords(String[] value) {
        Password[] result = new Password[value.length];
        int i = 0;
        while (i < value.length) {
            result[i] = new Password(value[i]);
            ++i;
        }
        return result;
    }

    public static Dictionary<String, Object> mapToDictionary(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value == null) continue;
            if (value instanceof Password) {
                ((Dictionary)dictionary).put(key, value.toString());
                continue;
            }
            if (value instanceof Password[]) {
                Password[] passwordArray = (Password[])value;
                String[] passwords = new String[passwordArray.length];
                int i = 0;
                while (i < passwordArray.length) {
                    passwords[i] = passwordArray[i].toString();
                    ++i;
                }
                ((Dictionary)dictionary).put(key, passwords);
                continue;
            }
            ((Dictionary)dictionary).put(key, value);
        }
        return dictionary;
    }
}

