/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateConfigurationsCallable
implements Callable<Void> {
    private static Logger logger = LoggerFactory.getLogger(UpdateConfigurationsCallable.class);
    private final String pid;
    private final XmlComponentConfigurations xmlConfigurations;
    private final ConfigurationService configurationService;
    private final AuditContext auditContext;

    public UpdateConfigurationsCallable(String pid, XmlComponentConfigurations xmlConfigurations, ConfigurationService configurationService) {
        this.pid = pid;
        this.xmlConfigurations = xmlConfigurations;
        this.configurationService = configurationService;
        this.auditContext = AuditContext.currentOrInternal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void call() throws Exception {
        logger.info("Updating configurations");
        Thread.currentThread().setName(this.getClass().getSimpleName());
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (AuditContext.Scope scope = AuditContext.openScope((AuditContext)this.auditContext);){
                List<ComponentConfiguration> configImpls;
                List<ComponentConfiguration> list = configImpls = this.xmlConfigurations != null ? this.xmlConfigurations.getConfigurations() : null;
                if (configImpls == null) {
                    return null;
                }
                ArrayList<ComponentConfiguration> configs = new ArrayList<ComponentConfiguration>();
                configs.addAll(configImpls);
                if (this.pid == null) {
                    this.configurationService.updateConfigurations(configs);
                    return null;
                }
                Iterator iterator = configs.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return null;
                    }
                    ComponentConfiguration config = (ComponentConfiguration)iterator.next();
                    if (!this.pid.equals(config.getPid())) continue;
                    this.configurationService.updateConfiguration(this.pid, config.getConfigurationProperties());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (KuraException e) {
            logger.error("Error updating configurations: {}", (Throwable)e);
            throw new KuraException(KuraErrorCode.CONFIGURATION_UPDATE, (Throwable)e, new Object[0]);
        }
    }
}

