/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloudconnecton.raw.mqtt.util;

import java.util.Map;
import java.util.Optional;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.CloudConnectionConstants;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackComponentOptions<T> {
    private static final Logger logger = LoggerFactory.getLogger(StackComponentOptions.class);
    private static final Property<String> CLOUD_ENDPOINT_SERVICE_PID = new Property<String>(CloudConnectionConstants.CLOUD_ENDPOINT_SERVICE_PID_PROP_NAME.value(), String.class);
    private final Optional<String> cloudEndpointPid;
    private final Optional<T> componentOptions;

    public StackComponentOptions(Map<String, Object> properties, OptionsFactory<T> factory) {
        this.cloudEndpointPid = StackComponentOptions.extractCloudEndpointPid(properties);
        this.componentOptions = factory.tryBuild(properties);
    }

    private static Optional<String> extractCloudEndpointPid(Map<String, Object> properties) {
        try {
            return Optional.of(CLOUD_ENDPOINT_SERVICE_PID.get(properties));
        }
        catch (Exception exception) {
            logger.warn("cloud endpoint pid not set");
            return Optional.empty();
        }
    }

    public Optional<String> getCloudEndpointPid() {
        return this.cloudEndpointPid;
    }

    public Optional<T> getComponentOptions() {
        return this.componentOptions;
    }

    public static interface OptionsFactory<T> {
        public T build(Map<String, Object> var1) throws KuraException;

        default public Optional<T> tryBuild(Map<String, Object> properties) {
            try {
                return Optional.of(this.build(properties));
            }
            catch (Exception e) {
                logger.warn("invalid publishing properties", (Throwable)e);
                return Optional.empty();
            }
        }
    }
}

