/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloudconnecton.raw.mqtt.util;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.kura.cloudconnection.CloudEndpoint;
import org.eclipse.kura.cloudconnection.listener.CloudConnectionListener;
import org.eclipse.kura.cloudconnection.raw.mqtt.cloud.RawMqttCloudEndpoint;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.StackComponentOptions;
import org.eclipse.kura.cloudconnecton.raw.mqtt.util.Utils;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;

public abstract class AbstractStackComponent<T>
implements ConfigurableComponent,
CloudConnectionListener {
    private final Set<CloudConnectionListener> cloudConnectionListeners = new CopyOnWriteArraySet<CloudConnectionListener>();
    private final AtomicReference<StackComponentOptions<T>> options = new AtomicReference();
    private final AtomicReference<Optional<RawMqttCloudEndpoint>> endpoint = new AtomicReference(Optional.empty());
    private ServiceTracker<CloudEndpoint, RawMqttCloudEndpoint> tracker;
    private final BundleContext context = FrameworkUtil.getBundle(AbstractStackComponent.class).getBundleContext();

    protected abstract Logger getLogger();

    protected abstract StackComponentOptions.OptionsFactory<T> getOptionsFactory();

    protected void setCloudEndpoint(RawMqttCloudEndpoint endpoint) {
        this.endpoint.set(Optional.of(endpoint));
        endpoint.registerCloudConnectionListener(this);
    }

    protected void unsetCloudEndpoint(RawMqttCloudEndpoint endpoint) {
        endpoint.unregisterCloudConnectionListener(this);
        this.endpoint.set(Optional.empty());
    }

    public void activated(Map<String, Object> properties) {
        this.getLogger().info("activating...");
        this.updated(properties);
        this.getLogger().info("activating...done");
    }

    public void updated(Map<String, Object> properties) {
        this.getLogger().info("updating...");
        this.options.set(new StackComponentOptions<T>(properties, this.getOptionsFactory()));
        this.reopenTracker();
        this.getLogger().info("updating...done");
    }

    public void deactivated() {
        this.getLogger().info("deactivating...");
        this.shutdownTracker();
        this.getLogger().info("deactivating...done");
    }

    protected StackComponentOptions<T> getOptions() {
        return this.options.get();
    }

    protected Optional<RawMqttCloudEndpoint> getEndpoint() {
        return this.endpoint.get();
    }

    private void shutdownTracker() {
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    private void reopenTracker() {
        Filter filter;
        this.shutdownTracker();
        StackComponentOptions<T> currentOptions = this.options.get();
        Optional<String> endpointPid = currentOptions.getCloudEndpointPid();
        if (!endpointPid.isPresent()) {
            return;
        }
        try {
            filter = Utils.createFilter(CloudEndpoint.class, endpointPid.get());
        }
        catch (Exception e) {
            this.getLogger().warn("invalid cloud endpoint pid", (Throwable)e);
            return;
        }
        this.tracker = new ServiceTracker(this.context, filter, (ServiceTrackerCustomizer)new Customizer());
        this.tracker.open();
    }

    public void registerCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.cloudConnectionListeners.add(cloudConnectionListener);
    }

    public void unregisterCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.cloudConnectionListeners.remove(cloudConnectionListener);
    }

    public void onDisconnected() {
        this.cloudConnectionListeners.forEach(Utils.catchAll(CloudConnectionListener::onDisconnected));
    }

    public void onConnectionLost() {
        this.cloudConnectionListeners.forEach(Utils.catchAll(CloudConnectionListener::onConnectionLost));
    }

    public void onConnectionEstablished() {
        this.cloudConnectionListeners.forEach(Utils.catchAll(CloudConnectionListener::onConnectionEstablished));
    }

    private class Customizer
    implements ServiceTrackerCustomizer<CloudEndpoint, RawMqttCloudEndpoint> {
        private Customizer() {
        }

        public RawMqttCloudEndpoint addingService(ServiceReference<CloudEndpoint> reference) {
            CloudEndpoint service = (CloudEndpoint)AbstractStackComponent.this.context.getService(reference);
            if (service == null) {
                return null;
            }
            if (!(service instanceof RawMqttCloudEndpoint)) {
                AbstractStackComponent.this.context.ungetService(reference);
                return null;
            }
            RawMqttCloudEndpoint trackedService = (RawMqttCloudEndpoint)service;
            AbstractStackComponent.this.setCloudEndpoint(trackedService);
            return trackedService;
        }

        public void modifiedService(ServiceReference<CloudEndpoint> reference, RawMqttCloudEndpoint service) {
        }

        public void removedService(ServiceReference<CloudEndpoint> reference, RawMqttCloudEndpoint service) {
            AbstractStackComponent.this.unsetCloudEndpoint(service);
            AbstractStackComponent.this.context.ungetService(reference);
        }
    }
}

