/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.system.dto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;

public class KuraPropertiesDTO {
    private Map<String, String> kuraProperties = new HashMap<String, String>();

    public KuraPropertiesDTO(Properties kuraProperties) {
        this.populateKuraProperties(kuraProperties, s -> true);
    }

    public KuraPropertiesDTO(Properties kuraProperties, List<String> names) {
        this.populateKuraProperties(kuraProperties, names::contains);
    }

    private void populateKuraProperties(Properties properties, Predicate<String> condition) {
        for (String key : properties.stringPropertyNames()) {
            this.putIf(key, properties.getProperty(key), condition.test(key));
        }
    }

    private void putIf(String key, String value, boolean condition) {
        if (condition) {
            this.kuraProperties.put(key, value);
        }
    }
}

