/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.asset.provider;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAssetExecutor {
    private static final Logger logger = LoggerFactory.getLogger(BaseAssetExecutor.class);
    private final ExecutorService ioExecutor;
    private final boolean isIoExecutorShared;
    private final ExecutorService configExecutor;
    private final boolean isConfigExecutorShared;
    private final AtomicReference<CompletableFuture<Void>> queue = new AtomicReference<CompletableFuture<Object>>(CompletableFuture.completedFuture(null));

    public BaseAssetExecutor(ExecutorService ioExecutor, ExecutorService configExecutor) {
        this(ioExecutor, false, configExecutor, false);
    }

    public BaseAssetExecutor(ExecutorService ioExecutor, boolean isIoExecutorShared, ExecutorService configExecutor, boolean isConfigExecutorShared) {
        this.ioExecutor = ioExecutor;
        this.isIoExecutorShared = isIoExecutorShared;
        this.configExecutor = configExecutor;
        this.isConfigExecutorShared = isConfigExecutorShared;
    }

    public <T> CompletableFuture<T> runIO(Callable<T> task) {
        CompletableFuture result = new CompletableFuture();
        this.ioExecutor.execute(() -> {
            try {
                result.complete(task.call());
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public CompletableFuture<Void> runConfig(Runnable task) {
        CompletableFuture<Void> next = new CompletableFuture<Void>();
        CompletableFuture previous = this.queue.getAndSet(next);
        previous.whenComplete((ok, err) -> this.configExecutor.execute(() -> {
            try {
                task.run();
                next.complete(null);
            }
            catch (Exception e) {
                logger.warn("Asset task failed", (Throwable)e);
                next.completeExceptionally(e);
            }
        }));
        return next;
    }

    public void shutdown() {
        if (!this.isIoExecutorShared) {
            this.ioExecutor.shutdown();
        }
        if (!this.isConfigExecutorShared) {
            this.configExecutor.shutdown();
        }
    }
}

