/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.status;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.IP6Address;
import org.eclipse.kura.net.status.NetworkInterfaceIpAddressStatus;
import org.eclipse.kura.net.status.NetworkInterfaceState;
import org.eclipse.kura.net.status.NetworkInterfaceType;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class NetworkInterfaceStatus {
    private final String interfaceId;
    private final String interfaceName;
    private final byte[] hardwareAddress;
    private final NetworkInterfaceType type;
    private final String driver;
    private final String driverVersion;
    private final String firmwareVersion;
    private final boolean virtual;
    private final NetworkInterfaceState state;
    private final boolean autoConnect;
    private final int mtu;
    private final Optional<NetworkInterfaceIpAddressStatus<IP4Address>> interfaceIp4Addresses;
    private final Optional<NetworkInterfaceIpAddressStatus<IP6Address>> interfaceIp6Addresses;

    protected NetworkInterfaceStatus(NetworkInterfaceStatusBuilder<?> builder) {
        this.interfaceId = ((NetworkInterfaceStatusBuilder)builder).interfaceId;
        this.interfaceName = ((NetworkInterfaceStatusBuilder)builder).interfaceName;
        this.hardwareAddress = ((NetworkInterfaceStatusBuilder)builder).hardwareAddress;
        this.type = ((NetworkInterfaceStatusBuilder)builder).type;
        this.driver = ((NetworkInterfaceStatusBuilder)builder).driver;
        this.driverVersion = ((NetworkInterfaceStatusBuilder)builder).driverVersion;
        this.firmwareVersion = ((NetworkInterfaceStatusBuilder)builder).firmwareVersion;
        this.virtual = ((NetworkInterfaceStatusBuilder)builder).virtual;
        this.state = ((NetworkInterfaceStatusBuilder)builder).state;
        this.autoConnect = ((NetworkInterfaceStatusBuilder)builder).autoConnect;
        this.mtu = ((NetworkInterfaceStatusBuilder)builder).mtu;
        this.interfaceIp4Addresses = ((NetworkInterfaceStatusBuilder)builder).interfaceIp4Addresses;
        this.interfaceIp6Addresses = ((NetworkInterfaceStatusBuilder)builder).interfaceIp6Addresses;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public byte[] getHardwareAddress() {
        return this.hardwareAddress;
    }

    public NetworkInterfaceType getType() {
        return this.type;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public NetworkInterfaceState getState() {
        return this.state;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public int getMtu() {
        return this.mtu;
    }

    public Optional<NetworkInterfaceIpAddressStatus<IP4Address>> getInterfaceIp4Addresses() {
        return this.interfaceIp4Addresses;
    }

    public Optional<NetworkInterfaceIpAddressStatus<IP6Address>> getInterfaceIp6Addresses() {
        return this.interfaceIp6Addresses;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.hardwareAddress);
        result = 31 * result + Objects.hash(new Object[]{this.autoConnect, this.driver, this.driverVersion, this.firmwareVersion, this.interfaceName, this.interfaceIp4Addresses, this.interfaceIp6Addresses, this.mtu, this.interfaceId, this.state, this.type, this.virtual});
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkInterfaceStatus other = (NetworkInterfaceStatus)obj;
        return this.autoConnect == other.autoConnect && Objects.equals(this.driver, other.driver) && Objects.equals(this.driverVersion, other.driverVersion) && Objects.equals(this.firmwareVersion, other.firmwareVersion) && Arrays.equals(this.hardwareAddress, other.hardwareAddress) && Objects.equals(this.interfaceName, other.interfaceName) && Objects.equals(this.interfaceIp4Addresses, other.interfaceIp4Addresses) && Objects.equals(this.interfaceIp6Addresses, other.interfaceIp6Addresses) && this.mtu == other.mtu && Objects.equals(this.interfaceId, other.interfaceId) && this.state == other.state && this.type == other.type && this.virtual == other.virtual;
    }

    public static abstract class NetworkInterfaceStatusBuilder<T extends NetworkInterfaceStatusBuilder<T>> {
        private static final String NA = "N/A";
        private String interfaceId = "N/A";
        private String interfaceName = "N/A";
        private byte[] hardwareAddress = new byte[6];
        private NetworkInterfaceType type = NetworkInterfaceType.UNKNOWN;
        private String driver = "N/A";
        private String driverVersion = "N/A";
        private String firmwareVersion = "N/A";
        private boolean virtual = false;
        private NetworkInterfaceState state = NetworkInterfaceState.UNKNOWN;
        private boolean autoConnect = false;
        private int mtu = 0;
        private Optional<NetworkInterfaceIpAddressStatus<IP4Address>> interfaceIp4Addresses = Optional.empty();
        private Optional<NetworkInterfaceIpAddressStatus<IP6Address>> interfaceIp6Addresses = Optional.empty();

        public T withInterfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
            return this.getThis();
        }

        public T withInterfaceName(String interfacenName) {
            this.interfaceName = interfacenName;
            return this.getThis();
        }

        public T withHardwareAddress(byte[] hardwareAddress) {
            this.hardwareAddress = hardwareAddress;
            return this.getThis();
        }

        protected T withType(NetworkInterfaceType type) {
            this.type = type;
            return this.getThis();
        }

        public T withDriver(String driver) {
            this.driver = driver;
            return this.getThis();
        }

        public T withDriverVersion(String driverVersion) {
            this.driverVersion = driverVersion;
            return this.getThis();
        }

        public T withFirmwareVersion(String firmwareVersion) {
            this.firmwareVersion = firmwareVersion;
            return this.getThis();
        }

        public T withVirtual(boolean virtual) {
            this.virtual = virtual;
            return this.getThis();
        }

        public T withState(NetworkInterfaceState state) {
            this.state = state;
            return this.getThis();
        }

        public T withAutoConnect(boolean autoConnect) {
            this.autoConnect = autoConnect;
            return this.getThis();
        }

        public T withMtu(int mtu) {
            this.mtu = mtu;
            return this.getThis();
        }

        public T withInterfaceIp4Addresses(Optional<NetworkInterfaceIpAddressStatus<IP4Address>> interfaceIp4Addresses) {
            this.interfaceIp4Addresses = interfaceIp4Addresses;
            return this.getThis();
        }

        public T withInterfaceIp6Addresses(Optional<NetworkInterfaceIpAddressStatus<IP6Address>> interfaceIp6Addresses) {
            this.interfaceIp6Addresses = interfaceIp6Addresses;
            return this.getThis();
        }

        public abstract T getThis();

        public abstract NetworkInterfaceStatus build();
    }
}

