/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.dhcp;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.net.IP4Address;
import org.eclipse.kura.net.dhcp.DhcpServerCfgIP;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DhcpServerCfgIP4
extends DhcpServerCfgIP<IP4Address> {
    public DhcpServerCfgIP4(IP4Address subnet, IP4Address subnetMask, short prefix, IP4Address routerAddress, IP4Address rangeStart, IP4Address rangeEnd, List<IP4Address> dnsServers) {
        super(subnet, subnetMask, prefix, routerAddress, rangeStart, rangeEnd, dnsServers);
    }

    public boolean isValid() throws KuraException {
        boolean ret = false;
        if (this.isIpAddressInSubnet(((IP4Address)this.getRangeStart()).getHostAddress(), ((IP4Address)this.getSubnet()).getHostAddress(), ((IP4Address)this.getSubnetMask()).getHostAddress()) && this.isIpAddressInSubnet(((IP4Address)this.getRangeEnd()).getHostAddress(), ((IP4Address)this.getSubnet()).getHostAddress(), ((IP4Address)this.getSubnetMask()).getHostAddress())) {
            ret = true;
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(": [subnet=").append(((IP4Address)this.getSubnet()).getHostAddress()).append(", subnetMask=").append(((IP4Address)this.getSubnetMask()).getHostAddress()).append(", prefix=").append(this.getPrefix()).append(", routerAddress=").append(this.getRouterAddress()).append(", rangeStart=").append(this.getRangeStart()).append(", rangeEnd=").append(this.getRangeEnd());
        for (IP4Address dnsServer : this.getDnsServers()) {
            sb.append(", dnsServer=").append(dnsServer);
        }
        sb.append(']');
        return sb.toString();
    }

    private static int inet4address2int(Inet4Address inet4addr) {
        byte[] baInet4addr = inet4addr.getAddress();
        return (baInet4addr[0] & 0xFF) << 24 | (baInet4addr[1] & 0xFF) << 16 | (baInet4addr[2] & 0xFF) << 8 | baInet4addr[3] & 0xFF;
    }

    private boolean isIpAddressInSubnet(String ip, String subnet, String netmask) throws KuraException {
        boolean retVal = false;
        try {
            int iIp = DhcpServerCfgIP4.inet4address2int((Inet4Address)InetAddress.getByName(ip));
            int iSubnet = DhcpServerCfgIP4.inet4address2int((Inet4Address)InetAddress.getByName(subnet));
            int iNetmask = DhcpServerCfgIP4.inet4address2int((Inet4Address)InetAddress.getByName(netmask));
            if ((iSubnet & iNetmask) == (iIp & iNetmask)) {
                retVal = true;
            }
        }
        catch (UnknownHostException e) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
        return retVal;
    }
}

