/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.audit;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.audit.AuditConstants;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AuditContext {
    private static ThreadLocal<AuditContext> localContext = new ThreadLocal();
    private final Map<String, String> properties;

    public AuditContext(Map<String, String> properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.properties.toString().replaceAll("[\n\r\t]", "_");
    }

    public AuditContext copy() {
        return new AuditContext(new HashMap<String, String>(this.properties));
    }

    public static AuditContext currentOrInternal() {
        AuditContext current = localContext.get();
        if (current != null) {
            return current;
        }
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put(AuditConstants.KEY_ENTRY_POINT.getValue(), "Internal");
        return new AuditContext(properties);
    }

    public static Optional<AuditContext> current() {
        return Optional.ofNullable(localContext.get());
    }

    public static Scope openScope(AuditContext context) {
        return new Scope(context);
    }

    @ProviderType
    public static class Scope
    implements AutoCloseable {
        private final AuditContext context;

        private Scope(AuditContext context) {
            this.context = context;
            localContext.set(context);
        }

        @Override
        public void close() {
            if (localContext.get() == this.context) {
                localContext.remove();
            }
        }
    }
}

