/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.ai.inference;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.kura.ai.inference.ModelInfoBuilder;
import org.eclipse.kura.ai.inference.TensorDescriptor;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ModelInfo {
    private final String name;
    private final Optional<String> platform;
    private final Optional<String> version;
    private final Map<String, Object> parameters;
    private final List<TensorDescriptor> inputDescriptors;
    private final List<TensorDescriptor> outputDescriptors;

    protected ModelInfo(String modelName, Optional<String> platform, Optional<String> version, Map<String, Object> parameters, List<TensorDescriptor> inputDescriptors, List<TensorDescriptor> outputDescriptors) {
        this.name = modelName;
        this.platform = platform;
        this.version = version;
        this.parameters = Collections.unmodifiableMap(parameters);
        this.inputDescriptors = Collections.unmodifiableList(inputDescriptors);
        this.outputDescriptors = Collections.unmodifiableList(outputDescriptors);
    }

    public static ModelInfoBuilder builder(String name) {
        return new ModelInfoBuilder(name);
    }

    public ModelInfoBuilder toBuilder() {
        return ModelInfoBuilder.fromModelInfo(this);
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getPlatform() {
        return this.platform;
    }

    public Optional<String> getVersion() {
        return this.version;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public List<TensorDescriptor> getInputs() {
        return this.inputDescriptors;
    }

    public List<TensorDescriptor> getOutputs() {
        return this.outputDescriptors;
    }
}

