/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.session;

import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.web.session.SecurityHandler;
import org.osgi.service.http.HttpContext;

public class HttpContextImpl
implements HttpContext {
    private final SecurityHandler securityHandler;
    private final HttpContext delegate;

    public HttpContextImpl(SecurityHandler securityHandler, HttpContext delegate) {
        this.securityHandler = securityHandler;
        this.delegate = delegate;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.handleSecurityInternal(request, response)) {
            return true;
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return false;
    }

    private boolean handleSecurityInternal(HttpServletRequest request, HttpServletResponse response) {
        try {
            return this.securityHandler.handleSecurity(request, response);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    public String getMimeType(String name) {
        return this.delegate.getMimeType(name);
    }
}

