/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.UserManager;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.session.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslAuthenticationServlet
extends HttpServlet {
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");
    private static final Logger logger = LoggerFactory.getLogger(SslAuthenticationServlet.class);
    private static final long serialVersionUID = -2371828320004624864L;
    private final String redirectPath;
    private final UserManager userManager;

    public SslAuthenticationServlet(String redirectPath, UserManager userManager) {
        this.redirectPath = redirectPath;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Console console = Console.instance();
        AuditContext auditContext = Console.instance().initAuditContext(req);
        try {
            if (!Console.getConsoleOptions().isAuthenticationMethodEnabled("Certificate")) {
                throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
            }
            X509Certificate[] clientCertificates = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
            if (clientCertificates == null || clientCertificates.length == 0) {
                throw new IllegalArgumentException("Certificate chain is empty");
            }
            LdapName ldapName = new LdapName(clientCertificates[0].getSubjectX500Principal().getName());
            Optional<Rdn> commonNameRdn = ldapName.getRdns().stream().filter(r -> "cn".equalsIgnoreCase(r.getType())).findAny();
            if (!commonNameRdn.isPresent()) {
                throw new IllegalArgumentException("Certificate common name is not present");
            }
            String commonName = (String)commonNameRdn.get().getValue();
            if (!this.userManager.getUserConfig(commonName).isPresent()) {
                throw new IllegalArgumentException("Common Name " + commonName + " is not associated with an user");
            }
            auditContext.getProperties().put(AuditConstants.KEY_IDENTITY.getValue(), commonName);
            HttpSession session = console.createNewSession(req);
            console.setAuthenticated(session, commonName, auditContext);
            auditContext.getProperties().put("session.id", GwtServerUtil.getSessionIdHash(session));
            session.removeAttribute(Attributes.LOCKED.getValue());
            auditLogger.info("{} UI Login - Success - Certificate login", (Object)auditContext);
            this.sendRedirect(resp, this.redirectPath);
        }
        catch (Exception e) {
            HttpSession existingSession = req.getSession(false);
            if (existingSession != null) {
                existingSession.invalidate();
            }
            auditLogger.info("{} UI Login - Failure - Certificate login", (Object)auditContext);
            logger.warn("certificate authentication failed", (Throwable)e);
            this.sendUnauthorized(resp);
        }
    }

    private void sendUnauthorized(HttpServletResponse resp) {
        try {
            resp.sendError(401);
        }
        catch (IOException e) {
            logger.warn("failed to send error", (Throwable)e);
        }
    }

    private void sendRedirect(HttpServletResponse resp, String path) {
        try {
            resp.sendRedirect(path);
        }
        catch (IOException e) {
            logger.warn("failed to send redirect", (Throwable)e);
        }
    }
}

