/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_fo extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean t\u00ed\u00f0",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia vanlig t\u00ed\u00f0",
               "",
               "Apia summart\u00ed\u00f0",
               "",
               "Apia t\u00ed\u00f0",
               "",
            };
        final String[] Cook = new String[] {
               "Cooksoyggjar vanlig t\u00ed\u00f0",
               "",
               "Cooksoyggjar summart\u00ed\u00f0",
               "",
               "Cooksoyggjar t\u00ed\u00f0",
               "",
            };
        final String[] Cuba = new String[] {
               "Cuba vanlig t\u00ed\u00f0",
               "CST",
               "Cuba summart\u00ed\u00f0",
               "CDT",
               "Cuba t\u00ed\u00f0",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiji vanlig t\u00ed\u00f0",
               "",
               "Fiji summart\u00ed\u00f0",
               "",
               "Fiji t\u00ed\u00f0",
               "",
            };
        final String[] Gulf = new String[] {
               "Gulf vanlig t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd vanlig t\u00ed\u00f0",
               "",
               "Hovd summart\u00ed\u00f0",
               "",
               "Hovd t\u00ed\u00f0",
               "",
            };
        final String[] Iran = new String[] {
               "Iran vanlig t\u00ed\u00f0",
               "",
               "Iran summart\u00ed\u00f0",
               "",
               "Iran t\u00ed\u00f0",
               "",
            };
        final String[] Niue = new String[] {
               "Niue t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk vanlig t\u00ed\u00f0",
               "",
               "Omsk summart\u00ed\u00f0",
               "",
               "Omsk t\u00ed\u00f0",
               "",
            };
        final String[] Peru = new String[] {
               "Peru vanlig t\u00ed\u00f0",
               "",
               "Peru summart\u00ed\u00f0",
               "",
               "Peru t\u00ed\u00f0",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wakeoyggj t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Kili vanlig t\u00ed\u00f0",
               "",
               "Kili summart\u00ed\u00f0",
               "",
               "Kili t\u00ed\u00f0",
               "",
            };
        final String[] China = new String[] {
               "Kina vanlig t\u00ed\u00f0",
               "CST",
               "Kina summart\u00ed\u00f0",
               "CDT",
               "Kina t\u00ed\u00f0",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokosoyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India t\u00ed\u00f0",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japan vanlig t\u00ed\u00f0",
               "JST",
               "Japan summart\u00ed\u00f0",
               "JDT",
               "Japan t\u00ed\u00f0",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korea vanlig t\u00ed\u00f0",
               "KST",
               "Korea summart\u00ed\u00f0",
               "KST",
               "Korea t\u00ed\u00f0",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa vanlig t\u00ed\u00f0",
               "SST",
               "Samoa summart\u00ed\u00f0",
               "SST",
               "Samoa t\u00ed\u00f0",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga vanlig t\u00ed\u00f0",
               "",
               "Tonga summart\u00ed\u00f0",
               "",
               "Tonga t\u00ed\u00f0",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukon t\u00ed\u00f0",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaska vanlig t\u00ed\u00f0",
               "AKST",
               "Alaska summart\u00ed\u00f0",
               "AKDT",
               "Alaska t\u00ed\u00f0",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amasona vanlig t\u00ed\u00f0",
               "",
               "Amasona summart\u00ed\u00f0",
               "",
               "Amasona t\u00ed\u00f0",
               "",
            };
        final String[] Azores = new String[] {
               "Azorurnar vanlig t\u00ed\u00f0",
               "",
               "Azorurnar summart\u00ed\u00f0",
               "",
               "Azorurnar t\u00ed\u00f0",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "P\u00e1skaoyggin vanlig t\u00ed\u00f0",
               "",
               "P\u00e1skaoyggin summart\u00ed\u00f0",
               "",
               "P\u00e1skaoyggin t\u00ed\u00f0",
               "",
            };
        final String[] Guyana = new String[] {
               "Gujana t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "\u00cdsrael vanlig t\u00ed\u00f0",
               "IST",
               "\u00cdsrael summart\u00ed\u00f0",
               "IDT",
               "\u00cdsrael t\u00ed\u00f0",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskva vanlig t\u00ed\u00f0",
               "MSK",
               "Moskva summart\u00ed\u00f0",
               "MSK",
               "Moskva t\u00ed\u00f0",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei vanlig t\u00ed\u00f0",
               "CST",
               "Taipei summart\u00ed\u00f0",
               "CDT",
               "Taipei t\u00ed\u00f0",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis- og Futunaoyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabisk vanlig t\u00ed\u00f0",
               "",
               "Arabisk summart\u00ed\u00f0",
               "",
               "Arabisk t\u00ed\u00f0",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenia vanlig t\u00ed\u00f0",
               "",
               "Armenia summart\u00ed\u00f0",
               "",
               "Armenia t\u00ed\u00f0",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivia t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham vanlig t\u00ed\u00f0",
               "",
               "Chatham summart\u00ed\u00f0",
               "",
               "Chatham t\u00ed\u00f0",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Samskipa\u00f0 heimst\u00ed\u00f0",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvador t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgia vanlig t\u00ed\u00f0",
               "",
               "Georgia summart\u00ed\u00f0",
               "",
               "Georgia t\u00ed\u00f0",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk vanlig t\u00ed\u00f0",
               "",
               "Irkutsk summart\u00ed\u00f0",
               "",
               "Irkutsk t\u00ed\u00f0",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan vanlig t\u00ed\u00f0",
               "",
               "Magadan summart\u00ed\u00f0",
               "",
               "Magadan t\u00ed\u00f0",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar (Burma) t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkoyggj vanlig t\u00ed\u00f0",
               "",
               "Norfolkoyggj summart\u00ed\u00f0",
               "",
               "Norfolkoyggj t\u00ed\u00f0",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha vanlig t\u00ed\u00f0",
               "",
               "Fernando de Noronha summart\u00ed\u00f0",
               "",
               "Fernando de Noronha t\u00ed\u00f0",
               "",
            };
        final String[] Reunion = new String[] {
               "R\u00e9union t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonoyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguai vanlig t\u00ed\u00f0",
               "",
               "Uruguai summart\u00ed\u00f0",
               "",
               "Uruguai t\u00ed\u00f0",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu vanlig t\u00ed\u00f0",
               "",
               "Vanuatu summart\u00ed\u00f0",
               "",
               "Vanuatu t\u00ed\u00f0",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk vanlig t\u00ed\u00f0",
               "",
               "Yakutsk summart\u00ed\u00f0",
               "",
               "Yakutsk t\u00ed\u00f0",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic vanlig t\u00ed\u00f0",
               "AST",
               "Atlantic summart\u00ed\u00f0",
               "AST",
               "Atlantic t\u00ed\u00f0",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia vanlig t\u00ed\u00f0",
               "",
               "Brasilia summart\u00ed\u00f0",
               "",
               "Brasilia t\u00ed\u00f0",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro vanlig t\u00ed\u00f0",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolombia vanlig t\u00ed\u00f0",
               "",
               "Kolombia summart\u00ed\u00f0",
               "",
               "Kolombia t\u00ed\u00f0",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandsoyggjar vanlig t\u00ed\u00f0",
               "",
               "Falklandsoyggjar summart\u00ed\u00f0",
               "",
               "Falklandsoyggjar t\u00ed\u00f0",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaisia t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldivoyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan Bator vanlig t\u00ed\u00f0",
               "",
               "Ulan Bator summart\u00ed\u00f0",
               "",
               "Ulan Bator t\u00ed\u00f0",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan vanlig t\u00ed\u00f0",
               "PKT",
               "Pakistan summart\u00ed\u00f0",
               "PKST",
               "Pakistan t\u00ed\u00f0",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguai vanlig t\u00ed\u00f0",
               "",
               "Paraguai summart\u00ed\u00f0",
               "",
               "Paraguai t\u00ed\u00f0",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairnoyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalin vanlig t\u00ed\u00f0",
               "",
               "Sakhalin summart\u00ed\u00f0",
               "",
               "Sakhalin t\u00ed\u00f0",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinam t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina vanlig t\u00ed\u00f0",
               "",
               "Argentina summart\u00ed\u00f0",
               "",
               "Argentina t\u00ed\u00f0",
               "",
            };
        final String[] Christmas = new String[] {
               "J\u00f3laoyggj t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Kong vanlig t\u00ed\u00f0",
               "HKT",
               "Hong Kong summart\u00ed\u00f0",
               "HKST",
               "Hong Kong t\u00ed\u00f0",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indokina t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisia t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe vanlig t\u00ed\u00f0",
               "",
               "Lord Howe summart\u00ed\u00f0",
               "",
               "Lord Howe t\u00ed\u00f0",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesas t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "M\u00f3ritius vanlig t\u00ed\u00f0",
               "",
               "M\u00f3ritius summart\u00ed\u00f0",
               "",
               "M\u00f3ritius t\u00ed\u00f0",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapor t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venesuela t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograd vanlig t\u00ed\u00f0",
               "MSK",
               "Volgograd summart\u00ed\u00f0",
               "MSK",
               "Volgograd t\u00ed\u00f0",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbadjan vanlig t\u00ed\u00f0",
               "",
               "Aserbadjan summart\u00ed\u00f0",
               "",
               "Aserbadjan t\u00ed\u00f0",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesj vanlig t\u00ed\u00f0",
               "",
               "Bangladesj summart\u00ed\u00f0",
               "",
               "Bangladesj t\u00ed\u00f0",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Gr\u00f8nh\u00f8vdaoyggjar vanlig t\u00ed\u00f0",
               "",
               "Gr\u00f8nh\u00f8vdaoyggjar summart\u00ed\u00f0",
               "",
               "Gr\u00f8nh\u00f8vdaoyggjar t\u00ed\u00f0",
               "",
            };
        final String[] East_Timor = new String[] {
               "Eysturtimor t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kasakstan t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seyskelloyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadsjikistan t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistan vanlig t\u00ed\u00f0",
               "",
               "Usbekistan summart\u00ed\u00f0",
               "",
               "Usbekistan t\u00ed\u00f0",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistan t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk vanlig t\u00ed\u00f0",
               "",
               "Krasnoyarsk summart\u00ed\u00f0",
               "",
               "Krasnoyarsk t\u00ed\u00f0",
               "",
            };
        final String[] New_Zealand = new String[] {
               "N\u00fds\u00e6land vanlig t\u00ed\u00f0",
               "NZST",
               "N\u00fds\u00e6land summart\u00ed\u00f0",
               "NZDT",
               "N\u00fds\u00e6land t\u00ed\u00f0",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk vanlig t\u00ed\u00f0",
               "",
               "Novosibirsk summart\u00ed\u00f0",
               "",
               "Novosibirsk t\u00ed\u00f0",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipsoyggjar vanlig t\u00ed\u00f0",
               "PST",
               "Filipsoyggjar summart\u00ed\u00f0",
               "PDT",
               "Filipsoyggjar t\u00ed\u00f0",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok vanlig t\u00ed\u00f0",
               "",
               "Vladivostok summart\u00ed\u00f0",
               "",
               "Vladivostok t\u00ed\u00f0",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiahav t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Lineoyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland vanlig t\u00ed\u00f0",
               "NST",
               "Newfoundland summart\u00ed\u00f0",
               "NDT",
               "Newfoundland t\u00ed\u00f0",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan vanlig t\u00ed\u00f0",
               "",
               "Turkmenistan summart\u00ed\u00f0",
               "",
               "Turkmenistan t\u00ed\u00f0",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Franska Gujana t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "N\u00fdkaled\u00f3nia vanlig t\u00ed\u00f0",
               "",
               "N\u00fdkaled\u00f3nia summart\u00ed\u00f0",
               "",
               "N\u00fdkaled\u00f3nia t\u00ed\u00f0",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Su\u00f0urgeorgiaoyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg vanlig t\u00ed\u00f0",
               "",
               "Yekaterinburg summart\u00ed\u00f0",
               "",
               "Yekaterinburg t\u00ed\u00f0",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Mi\u00f0afrika t\u00ed\u00f0",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Eysturafrika t\u00ed\u00f0",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Vesturafrika vanlig t\u00ed\u00f0",
               "WAT",
               "Vesturafrika summart\u00ed\u00f0",
               "WAT",
               "Vesturafrika t\u00ed\u00f0",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Mi\u00f0evropa vanlig t\u00ed\u00f0",
               "CET",
               "Mi\u00f0evropa summart\u00ed\u00f0",
               "CEST",
               "Mi\u00f0evropa t\u00ed\u00f0",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Eysturevropa vanlig t\u00ed\u00f0",
               "EET",
               "Eysturevropa summart\u00ed\u00f0",
               "EEST",
               "Eysturevropa t\u00ed\u00f0",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Vesturevropa vanlig t\u00ed\u00f0",
               "WET",
               "Vesturevropa summart\u00ed\u00f0",
               "WEST",
               "Vesturevropa t\u00ed\u00f0",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexican Pacific vanlig t\u00ed\u00f0",
               "MST",
               "Mexican Pacific summart\u00ed\u00f0",
               "MDT",
               "Mexican Pacific t\u00ed\u00f0",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Su\u00f0urafrika vanlig t\u00ed\u00f0",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Central vanlig t\u00ed\u00f0",
               "CST",
               "Central summart\u00ed\u00f0",
               "CDT",
               "Central t\u00ed\u00f0",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern vanlig t\u00ed\u00f0",
               "EST",
               "Eastern summart\u00ed\u00f0",
               "EST",
               "Eastern t\u00ed\u00f0",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Pacific vanlig t\u00ed\u00f0",
               "PST",
               "Pacific summart\u00ed\u00f0",
               "PDT",
               "Pacific t\u00ed\u00f0",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Fronsku sunnaru landa\u00f8ki og Antarktis t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbertoyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutian vanlig t\u00ed\u00f0",
               "HST",
               "Hawaii-Aleutian summart\u00ed\u00f0",
               "HST",
               "Hawaii-Aleutian t\u00ed\u00f0",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixoyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelon vanlig t\u00ed\u00f0",
               "",
               "St. Pierre & Miquelon summart\u00ed\u00f0",
               "",
               "St. Pierre & Miquelon t\u00ed\u00f0",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Mountain vanlig t\u00ed\u00f0",
               "MST",
               "Mountain summart\u00ed\u00f0",
               "MST",
               "Mountain t\u00ed\u00f0",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshalloyggjar t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua N\u00fdguinea t\u00ed\u00f0",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "mi\u00f0 Avstralia vanlig t\u00ed\u00f0",
               "ACST",
               "mi\u00f0 Avstralia summart\u00ed\u00f0",
               "ACDT",
               "mi\u00f0 Avstralia t\u00ed\u00f0",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "eystur Avstralia vanlig t\u00ed\u00f0",
               "AEST",
               "eystur Avstralia summart\u00ed\u00f0",
               "AEDT",
               "eystur Avstralia t\u00ed\u00f0",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "vestur Avstralia vanlig t\u00ed\u00f0",
               "AWST",
               "vestur Avstralia summart\u00ed\u00f0",
               "AWDT",
               "vestur Avstralia t\u00ed\u00f0",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Mi\u00f0 Indonesia t\u00ed\u00f0",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eystur Indonesia t\u00ed\u00f0",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Vestur Indonesia t\u00ed\u00f0",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "mi\u00f0vestur Avstralia vanlig t\u00ed\u00f0",
               "",
               "mi\u00f0vestur Avstralia summart\u00ed\u00f0",
               "",
               "mi\u00f0vestur Avstralia t\u00ed\u00f0",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "Bretsk summart\u00ed\u00f0",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Samskipa\u00f0 heimst\u00ed\u00f0",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "\u00cdrsk vanlig t\u00ed\u00f0",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Samskipa\u00f0 heimst\u00ed\u00f0",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Samskipa\u00f0 heimst\u00ed\u00f0",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "Bretsk summart\u00ed\u00f0",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Samskipa\u00f0 heimst\u00ed\u00f0",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Samskipa\u00f0 heimst\u00ed\u00f0",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Samskipa\u00f0 heimst\u00ed\u00f0",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "\u00cdrsk vanlig t\u00ed\u00f0",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "Bretsk summart\u00ed\u00f0",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "Bretsk summart\u00ed\u00f0",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "Bretsk summart\u00ed\u00f0",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "Bretsk summart\u00ed\u00f0",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Mean t\u00ed\u00f0",
                    "GMT",
                    "Bretsk summart\u00ed\u00f0",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Gaza", "Gasa" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Kuwait", "Kuvait" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "\u00d3kendur b\u00fdur" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Rom" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Bahrain", "Barein" },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Europe/Athens", "Aten" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "Varsjava" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Belize", "Belis" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Singapore", "Singapor" },
            { "timezone.excity.Europe/Vatican", "Vatikani\u00f0" },
            { "timezone.excity.Africa/Djibouti", "Djibuti" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Atlantic/Azores", "Azorurnar" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00f8royar" },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "timezone.excity.Indian/Maldives", "Maldivoyggjar" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Stockholm", "Stokkh\u00f3lm" },
            { "timezone.excity.Indian/Mauritius", "M\u00f3ritius" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Europe/Copenhagen", "Keypmannahavn" },
            { "timezone.excity.Europe/Luxembourg", "Luksemborg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.America/Costa_Rica", "Kosta Rika" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Riko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Gr\u00f8nh\u00f8vdaoyggjar" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Su\u00f0urgeorgiaoyggjar" },
        };
        return data;
    }
}
