/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "Svijet" },
            { "002", "Afrika" },
            { "003", "Sjevernoameri\u010dki kontinent" },
            { "005", "Ju\u017ena Amerika" },
            { "009", "Oceanija" },
            { "011", "Zapadna Afrika" },
            { "013", "Centralna Amerika" },
            { "014", "Isto\u010dna Afrika" },
            { "015", "Sjeverna Afrika" },
            { "017", "Sredi\u0161nja Afrika" },
            { "018", "Ju\u017ena Afrika" },
            { "019", "Amerike" },
            { "021", "Sjeverna Amerika" },
            { "029", "Karibi" },
            { "030", "Isto\u010dna Azija" },
            { "034", "Ju\u017ena Azija" },
            { "035", "Jugoisto\u010dna Azija" },
            { "039", "Ju\u017ena Europa" },
            { "053", "Australazija" },
            { "054", "Melanezija" },
            { "057", "Mikronezijsko podru\u010dje" },
            { "061", "Polinezija" },
            { "142", "Azija" },
            { "143", "Srednja Azija" },
            { "145", "Zapadna Azija" },
            { "150", "Europa" },
            { "151", "Isto\u010dna Europa" },
            { "154", "Sjeverna Europa" },
            { "155", "Zapadna Europa" },
            { "202", "Subsaharska Afrika" },
            { "419", "Latinska Amerika" },
            { "AC", "Otok Uza\u0161a\u0161\u0107a" },
            { "AD", "Andora" },
            { "AE", "Ujedinjeni Arapski Emirati" },
            { "AF", "Afganistan" },
            { "AG", "Antigva i Barbuda" },
            { "AI", "Angvila" },
            { "AL", "Albanija" },
            { "AM", "Armenija" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "AS", "Ameri\u010dka Samoa" },
            { "AT", "Austrija" },
            { "AU", "Australija" },
            { "AW", "Aruba" },
            { "AX", "\u00c5landski otoci" },
            { "AZ", "Azerbajd\u017ean" },
            { "BA", "Bosna i Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Banglade\u0161" },
            { "BE", "Belgija" },
            { "BF", "Burkina Faso" },
            { "BG", "Bugarska" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermudi" },
            { "BN", "Brunej" },
            { "BO", "Bolivija" },
            { "BQ", "Karipski otoci Nizozemske" },
            { "BR", "Brazil" },
            { "BS", "Bahami" },
            { "BT", "Butan" },
            { "BV", "Otok Bouvet" },
            { "BW", "Bocvana" },
            { "BY", "Bjelorusija" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosovi (Keelingovi) Otoci" },
            { "CD", "Kongo - Kinshasa" },
            { "CF", "Srednjoafri\u010dka Republika" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "\u0160vicarska" },
            { "CI", "Obala Bjelokosti" },
            { "CK", "Cookovi Otoci" },
            { "CL", "\u010cile" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Kolumbija" },
            { "CP", "Otok Clipperton" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Zelenortska Republika" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Bo\u017ei\u0107ni Otok" },
            { "CY", "Cipar" },
            { "CZ", "\u010ce\u0161ka" },
            { "DE", "Njema\u010dka" },
            { "DG", "Diego Garcia" },
            { "DJ", "D\u017eibuti" },
            { "DK", "Danska" },
            { "DM", "Dominika" },
            { "DO", "Dominikanska Republika" },
            { "DZ", "Al\u017eir" },
            { "EA", "Ceuta i Melilla" },
            { "EC", "Ekvador" },
            { "EE", "Estonija" },
            { "EG", "Egipat" },
            { "EH", "Zapadna Sahara" },
            { "ER", "Eritreja" },
            { "ES", "\u0160panjolska" },
            { "ET", "Etiopija" },
            { "EU", "Europska unija" },
            { "EZ", "eurozona" },
            { "FI", "Finska" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Falklandski Otoci" },
            { "FM", "Mikronezija" },
            { "FO", "Ov\u010dji Otoci" },
            { "FR", "Francuska" },
            { "GA", "Gabon" },
            { "GB", "Ujedinjeno Kraljevstvo" },
            { "GD", "Grenada" },
            { "GE", "Gruzija" },
            { "GF", "Francuska Gijana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Grenland" },
            { "GM", "Gambija" },
            { "GN", "Gvineja" },
            { "GP", "Guadalupe" },
            { "GQ", "Ekvatorska Gvineja" },
            { "GR", "Gr\u010dka" },
            { "GS", "Ju\u017ena Georgia i Otoci Ju\u017eni Sandwich" },
            { "GT", "Gvatemala" },
            { "GU", "Guam" },
            { "GW", "Gvineja Bisau" },
            { "GY", "Gvajana" },
            { "HK", "PUP Hong Kong Kina" },
            { "HM", "Otoci Heard i McDonald" },
            { "HN", "Honduras" },
            { "HR", "Hrvatska" },
            { "HT", "Haiti" },
            { "HU", "Ma\u0111arska" },
            { "IC", "Kanari" },
            { "ID", "Indonezija" },
            { "IE", "Irska" },
            { "IL", "Izrael" },
            { "IM", "Otok Man" },
            { "IN", "Indija" },
            { "IO", "Britanski Indijskooceanski Teritorij" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italija" },
            { "JE", "Jersey" },
            { "JM", "Jamajka" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenija" },
            { "KG", "Kirgistan" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komori" },
            { "KN", "Sveti Kristofor i Nevis" },
            { "KP", "Sjeverna Koreja" },
            { "KR", "Ju\u017ena Koreja" },
            { "KW", "Kuvajt" },
            { "KY", "Kajmanski Otoci" },
            { "KZ", "Kazahstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Sveta Lucija" },
            { "LI", "Lihten\u0161tajn" },
            { "LK", "\u0160ri Lanka" },
            { "LR", "Liberija" },
            { "LS", "Lesoto" },
            { "LT", "Litva" },
            { "LU", "Luksemburg" },
            { "LV", "Latvija" },
            { "LY", "Libija" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavija" },
            { "ME", "Crna Gora" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Mar\u0161alovi Otoci" },
            { "MK", "Sjeverna Makedonija" },
            { "ML", "Mali" },
            { "MM", "Mjanmar (Burma)" },
            { "MN", "Mongolija" },
            { "MO", "PUP Makao Kina" },
            { "MP", "Sjevernomarijanski Otoci" },
            { "MQ", "Martinik" },
            { "MR", "Mauretanija" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauricijus" },
            { "MV", "Maldivi" },
            { "MW", "Malavi" },
            { "MX", "Meksiko" },
            { "MY", "Malezija" },
            { "MZ", "Mozambik" },
            { "NA", "Namibija" },
            { "NC", "Nova Kaledonija" },
            { "NE", "Niger" },
            { "NF", "Otok Norfolk" },
            { "NG", "Nigerija" },
            { "NI", "Nikaragva" },
            { "NL", "Nizozemska" },
            { "NO", "Norve\u0161ka" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Novi Zeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francuska Polinezija" },
            { "PG", "Papua Nova Gvineja" },
            { "PH", "Filipini" },
            { "PK", "Pakistan" },
            { "PL", "Poljska" },
            { "PM", "Sveti Petar i Mikelon" },
            { "PN", "Pitcairnovi Otoci" },
            { "PR", "Portoriko" },
            { "PS", "Palestinsko podru\u010dje" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paragvaj" },
            { "QA", "Katar" },
            { "QO", "Vanjska podru\u010dja Oceanije" },
            { "RE", "R\u00e9union" },
            { "RO", "Rumunjska" },
            { "RS", "Srbija" },
            { "RU", "Rusija" },
            { "RW", "Ruanda" },
            { "SA", "Saudijska Arabija" },
            { "SB", "Salomonovi Otoci" },
            { "SC", "Sej\u0161eli" },
            { "SD", "Sudan" },
            { "SE", "\u0160vedska" },
            { "SG", "Singapur" },
            { "SH", "Sveta Helena" },
            { "SI", "Slovenija" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "SK", "Slova\u010dka" },
            { "SL", "Sijera Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalija" },
            { "SR", "Surinam" },
            { "SS", "Ju\u017eni Sudan" },
            { "ST", "Sveti Toma i Princip" },
            { "SV", "Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Sirija" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Otoci Turks i Caicos" },
            { "TD", "\u010cad" },
            { "TF", "Francuski Ju\u017eni Teritoriji" },
            { "TG", "Togo" },
            { "TH", "Tajland" },
            { "TJ", "Tad\u017eikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunis" },
            { "TO", "Tonga" },
            { "TR", "Turska" },
            { "TT", "Trinidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "TZ", "Tanzanija" },
            { "UA", "Ukrajina" },
            { "UG", "Uganda" },
            { "UM", "Mali udaljeni otoci SAD-a" },
            { "UN", "Ujedinjeni narodi" },
            { "US", "Sjedinjene Ameri\u010dke Dr\u017eave" },
            { "UY", "Urugvaj" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Sveti Vincent i Grenadini" },
            { "VE", "Venezuela" },
            { "VG", "Britanski Djevi\u010danski Otoci" },
            { "VI", "Ameri\u010dki Djevi\u010danski Otoci" },
            { "VN", "Vijetnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis i Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo naglasci" },
            { "XB", "pseudo bidi" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Ju\u017enoafri\u010dka Republika" },
            { "ZM", "Zambija" },
            { "ZW", "Zimbabve" },
            { "ZZ", "nepoznato podru\u010dje" },
            { "aa", "afarski" },
            { "ab", "abhaski" },
            { "ae", "avesti\u010dki" },
            { "af", "afrikaans" },
            { "ak", "akanski" },
            { "am", "amharski" },
            { "an", "aragonski" },
            { "ar", "arapski" },
            { "as", "asamski" },
            { "av", "avarski" },
            { "ay", "ajmarski" },
            { "az", "azerbajd\u017eanski" },
            { "ba", "ba\u0161kirski" },
            { "be", "bjeloruski" },
            { "bg", "bugarski" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bangla" },
            { "bo", "tibetski" },
            { "br", "bretonski" },
            { "bs", "bosanski" },
            { "ca", "katalonski" },
            { "ce", "\u010de\u010denski" },
            { "ch", "chamorro" },
            { "co", "korzi\u010dki" },
            { "cr", "cree" },
            { "cs", "\u010de\u0161ki" },
            { "cu", "crkvenoslavenski" },
            { "cv", "\u010duva\u0161ki" },
            { "cy", "vel\u0161ki" },
            { "da", "danski" },
            { "de", "njema\u010dki" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "gr\u010dki" },
            { "en", "engleski" },
            { "eo", "esperanto" },
            { "es", "\u0161panjolski" },
            { "et", "estonski" },
            { "eu", "baskijski" },
            { "fa", "perzijski" },
            { "ff", "fula" },
            { "fi", "finski" },
            { "fj", "fid\u017eijski" },
            { "fo", "ferojski" },
            { "fr", "francuski" },
            { "fy", "zapadnofrizijski" },
            { "ga", "irski" },
            { "gd", "\u0161kotski gaelski" },
            { "gl", "galicijski" },
            { "gn", "gvaranski" },
            { "gu", "gud\u017earatski" },
            { "gv", "manski" },
            { "ha", "hausa" },
            { "he", "hebrejski" },
            { "hi", "hindski" },
            { "ho", "hiri motu" },
            { "hr", "hrvatski" },
            { "ht", "hai\u0107anski kreolski" },
            { "hu", "ma\u0111arski" },
            { "hy", "armenski" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonezijski" },
            { "ie", "interligua" },
            { "ig", "igbo" },
            { "ii", "sichuan ji" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "islandski" },
            { "it", "talijanski" },
            { "iu", "inuktitut" },
            { "ja", "japanski" },
            { "jv", "javanski" },
            { "ka", "gruzijski" },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kaza\u0161ki" },
            { "kl", "kalaallisut" },
            { "km", "kmerski" },
            { "kn", "karnata\u010dki" },
            { "ko", "korejski" },
            { "kr", "kanuri" },
            { "ks", "ka\u0161mirski" },
            { "ku", "kurdski" },
            { "kv", "komi" },
            { "kw", "kornski" },
            { "ky", "kirgiski" },
            { "la", "latinski" },
            { "lb", "luksembur\u0161ki" },
            { "lg", "ganda" },
            { "li", "limbur\u0161ki" },
            { "ln", "lingala" },
            { "lo", "laoski" },
            { "lt", "litavski" },
            { "lu", "luba-katanga" },
            { "lv", "latvijski" },
            { "mg", "malga\u0161ki" },
            { "mh", "mar\u0161alski" },
            { "mi", "maorski" },
            { "mk", "makedonski" },
            { "ml", "malajalamski" },
            { "mn", "mongolski" },
            { "mr", "marathski" },
            { "ms", "malajski" },
            { "mt", "malte\u0161ki" },
            { "my", "burmanski" },
            { "na", "nauru" },
            { "nb", "norve\u0161ki bokm\u00e5l" },
            { "nd", "sjeverni ndebele" },
            { "ne", "nepalski" },
            { "ng", "ndonga" },
            { "nl", "nizozemski" },
            { "nn", "norve\u0161ki nynorsk" },
            { "no", "norve\u0161ki" },
            { "nr", "ju\u017eni ndebele" },
            { "nv", "navajo" },
            { "ny", "njand\u017ea" },
            { "oc", "okcitanski" },
            { "oj", "ojibwa" },
            { "om", "oromski" },
            { "or", "orijski" },
            { "os", "osetski" },
            { "pa", "pand\u017eapski" },
            { "pi", "pali" },
            { "pl", "poljski" },
            { "ps", "pa\u0161tunski" },
            { "pt", "portugalski" },
            { "qu", "ke\u010duanski" },
            { "rm", "retoromanski" },
            { "rn", "rundi" },
            { "ro", "rumunjski" },
            { "ru", "ruski" },
            { "rw", "kinyarwanda" },
            { "sa", "sanskrtski" },
            { "sc", "sardski" },
            { "sd", "sindski" },
            { "se", "sjeverni sami" },
            { "sg", "sango" },
            { "sh", "srpsko-hrvatski" },
            { "si", "sinhale\u0161ki" },
            { "sk", "slova\u010dki" },
            { "sl", "slovenski" },
            { "sm", "samoanski" },
            { "sn", "shona" },
            { "so", "somalski" },
            { "sq", "albanski" },
            { "sr", "srpski" },
            { "ss", "svati" },
            { "st", "sesotski" },
            { "su", "sundanski" },
            { "sv", "\u0161vedski" },
            { "sw", "svahili" },
            { "ta", "tamilski" },
            { "te", "telu\u0161ki" },
            { "tg", "tad\u017ei\u010dki" },
            { "th", "tajlandski" },
            { "ti", "tigrinja" },
            { "tk", "turkmenski" },
            { "tl", "tagalog" },
            { "tn", "cvana" },
            { "to", "tonganski" },
            { "tr", "turski" },
            { "ts", "tsonga" },
            { "tt", "tatarski" },
            { "tw", "twi" },
            { "ty", "tahi\u0107anski" },
            { "ug", "ujgurski" },
            { "uk", "ukrajinski" },
            { "ur", "urdski" },
            { "uz", "uzbe\u010dki" },
            { "ve", "venda" },
            { "vi", "vijetnamski" },
            { "vo", "volap\u00fck" },
            { "wa", "valonski" },
            { "wo", "volof" },
            { "xh", "xhosa" },
            { "yi", "jidi\u0161" },
            { "yo", "jorupski" },
            { "za", "zhuang" },
            { "zh", "kineski" },
            { "zu", "zulu" },
            { "ace", "a\u010dinski" },
            { "ach", "a\u010doli" },
            { "ada", "adangme" },
            { "ady", "adigejski" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainuski" },
            { "akk", "akadski" },
            { "ale", "aleutski" },
            { "alt", "ju\u017eni altai" },
            { "ang", "staroengleski" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramejski" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "ars", "najdi arapski" },
            { "arw", "arava\u010dki" },
            { "asa", "asu" },
            { "ast", "asturijski" },
            { "atj", "atikamekw" },
            { "awa", "awadhi" },
            { "bal", "belu\u010dki" },
            { "ban", "balijski" },
            { "bas", "basa" },
            { "bax", "bamunski" },
            { "bbj", "ghomala" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgc", "haryanvi" },
            { "bgn", "zapadnobalud\u017eijski" },
            { "bho", "bhojpuri" },
            { "bik", "bikolski" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "burjatski" },
            { "bug", "buginski" },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "caddo" },
            { "car", "karipski" },
            { "cay", "cayuga" },
            { "cch", "atsam" },
            { "ccp", "chakma" },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chb", "\u010dib\u010da" },
            { "chg", "\u010dagatajski" },
            { "chk", "chuukese" },
            { "chm", "marijski" },
            { "chn", "chinook \u017eargon" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "\u010derokijski" },
            { "chy", "\u010dejenski" },
            { "ckb", "soranski kurdski" },
            { "clc", "chilcotin" },
            { "cop", "koptski" },
            { "crg", "michif" },
            { "crh", "krimski turski" },
            { "crj", "jugoisti\u010dni cree" },
            { "crk", "plains cree" },
            { "crl", "sjevernoisto\u010dni cree" },
            { "crm", "moose cree" },
            { "crr", "karolinski algonkijski" },
            { "crs", "sej\u0161elski kreolski" },
            { "csb", "ka\u0161upski" },
            { "csw", "mo\u010dvarni cree" },
            { "dak", "dakota jezik" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "del", "delavarski" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "donjolu\u017ei\u010dki" },
            { "dua", "duala" },
            { "dum", "srednjonizozemski" },
            { "dyo", "jola-fonyi" },
            { "dyu", "dyula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "staroegipatski" },
            { "eka", "ekajuk" },
            { "elx", "elamitski" },
            { "enm", "srednjoengleski" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filipinski" },
            { "fon", "fon" },
            { "frc", "kajunski francuski" },
            { "frm", "srednjofrancuski" },
            { "fro", "starofrancuski" },
            { "frr", "sjevernofrizijski" },
            { "frs", "isto\u010dnofrizijski" },
            { "fur", "furlanski" },
            { "gaa", "ga" },
            { "gag", "gagauski" },
            { "gan", "gan kineski" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gez", "geez" },
            { "gil", "gilbertski" },
            { "gmh", "srednjogornjonjema\u010dki" },
            { "goh", "starovisokonjema\u010dki" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gotski" },
            { "grb", "grebo" },
            { "grc", "starogr\u010dki" },
            { "gsw", "\u0161vicarski njema\u010dki" },
            { "guz", "gusii" },
            { "gwi", "gwich\u2019in" },
            { "hai", "haidi" },
            { "hak", "hakka kineski" },
            { "haw", "havajski" },
            { "hax", "ju\u017eni haida" },
            { "hil", "hiligaynonski" },
            { "hit", "hetitski" },
            { "hmn", "hmong" },
            { "hsb", "gornjolu\u017ei\u010dki" },
            { "hsn", "xiang kineski" },
            { "hup", "hupa" },
            { "hur", "halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "zapadnokanadski inuktitut" },
            { "ilo", "iloko" },
            { "inh", "ingu\u0161etski" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "jpr", "judejsko-perzijski" },
            { "jrb", "judejsko-arapski" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabilski" },
            { "kac", "ka\u010dinski" },
            { "kaj", "kaje" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardinski" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "zelenortski" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasi" },
            { "kho", "khotanese" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permski" },
            { "kok", "konkani" },
            { "kos", "naurski" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "karelijski" },
            { "kru", "kuru\u0161ki" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "kelnski" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "kwk", "kwak\u02bcwala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezgi\u0161ki" },
            { "lij", "ligurski" },
            { "lil", "lillooet" },
            { "lkt", "lakota" },
            { "lmo", "lombardski" },
            { "lol", "mongo" },
            { "lou", "lujzijanski kreolski" },
            { "loz", "lozi" },
            { "lrc", "sjevernolurski" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "lus", "lushai" },
            { "luy", "luyia" },
            { "mad", "madurski" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "mas", "masajski" },
            { "mde", "maba" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "mauricijski kreolski" },
            { "mga", "srednjoirski" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mnc", "mand\u017eurski" },
            { "mni", "manipurski" },
            { "moe", "innu-aimun" },
            { "moh", "mohok" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "vi\u0161e jezika" },
            { "mus", "creek" },
            { "mwl", "mirandski" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "mordvinski" },
            { "mzn", "mazanderanski" },
            { "nan", "min nan kineski" },
            { "nap", "napolitanski" },
            { "naq", "nama" },
            { "nds", "donjonjema\u010dki" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niujski" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogajski" },
            { "non", "staronorve\u0161ki" },
            { "nqo", "n\u2019ko" },
            { "nso", "sjeverni sotski" },
            { "nus", "nuerski" },
            { "nwc", "klasi\u010dni newari" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "sjeverozapadni ojibwa" },
            { "ojc", "centralni ojibwa" },
            { "ojs", "oji-cree" },
            { "ojw", "zapadni ojibwa" },
            { "oka", "okanagan" },
            { "osa", "osage" },
            { "ota", "turski - otomanski" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauanski" },
            { "pcm", "nigerijski pid\u017ein" },
            { "peo", "staroperzijski" },
            { "phn", "feni\u010dki" },
            { "pis", "pijin" },
            { "pon", "pohnpeian" },
            { "pqm", "maliseet-Passamaquoddy" },
            { "prg", "pruski" },
            { "pro", "staroprovansalski" },
            { "quc", "ki\u010de" },
            { "raj", "rajasthani" },
            { "rap", "rapa nui" },
            { "rar", "raroton\u0161ki" },
            { "rhg", "rohind\u017ea" },
            { "rof", "rombo" },
            { "rom", "romski" },
            { "rup", "aromunski" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "jakutski" },
            { "sam", "samarijanski aramejski" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santalski" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sicilijski" },
            { "sco", "\u0161kotski" },
            { "sdh", "ju\u017enokurdski" },
            { "see", "seneca" },
            { "seh", "sena" },
            { "sel", "selkupski" },
            { "ses", "koyraboro senni" },
            { "sga", "staroirski" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "shu", "\u010dadski arapski" },
            { "sid", "sidamo" },
            { "slh", "ju\u017eni lushootseed" },
            { "sma", "ju\u017eni sami" },
            { "smj", "lule sami" },
            { "smn", "inari sami" },
            { "sms", "skolt sami" },
            { "snk", "soninke" },
            { "sog", "sogdien" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssy", metaValue_ssy },
            { "str", "sjeverni sali\u0161ki" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerski" },
            { "swb", "komorski" },
            { "syc", "klasi\u010dni sirski" },
            { "syr", "sirijski" },
            { "szl", "\u0161leski" },
            { "tce", "ju\u017eni tutchone" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "tagish" },
            { "tht", "tahltan" },
            { "tig", "tigri\u0161ki" },
            { "tiv", "tiv" },
            { "tkl", "tokelaunski" },
            { "tlh", "klingonski" },
            { "tli", "tlingit" },
            { "tmh", "tama\u0161e\u010dki" },
            { "tog", "nyasa tonga" },
            { "tok", "toki pona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "tsimshian" },
            { "ttm", "sjeverni tutchone" },
            { "tum", "tumbuka" },
            { "tvl", "tuvaluanski" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinski" },
            { "tzm", "tama\u0161ek (Srednji Atlas)" },
            { "udm", "udmurtski" },
            { "uga", "ugaritski" },
            { "umb", "umbundu" },
            { "und", "nepoznati jezik" },
            { "vec", "venecijanski" },
            { "vmw", "makhuwa" },
            { "vot", "votski" },
            { "vun", "vunjo" },
            { "wae", "walserski" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "wu kineski" },
            { "xal", "kalmyk" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "yao" },
            { "yap", "japski" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantonski" },
            { "zap", "zapote\u010dki" },
            { "zbl", "Blissovi simboli" },
            { "zen", "zenaga" },
            { "zgh", "standardni marokanski tama\u0161ek" },
            { "zun", "zuni" },
            { "zxx", "bez jezi\u010dnog sadr\u017eaja" },
            { "zza", "zazaki" },
            { "Adlm", "adlam pismo" },
            { "Afak", "afaka pismo" },
            { "Arab", "arapsko pismo" },
            { "Aran", "nastaliq pismo" },
            { "Armi", "aramejsko pismo" },
            { "Armn", "armensko pismo" },
            { "Avst", "avestansko pismo" },
            { "Bali", "balijsko pismo" },
            { "Bamu", "bamum pismo" },
            { "Bass", "bassa vah pismo" },
            { "Batk", "batak pismo" },
            { "Beng", "bengalsko pismo" },
            { "Blis", "blissymbols" },
            { "Bopo", "bopomofo pismo" },
            { "Brah", "brahmi pismo" },
            { "Brai", "brajica" },
            { "Bugi", "buginsko pismo" },
            { "Buhd", "buhid pismo" },
            { "Cakm", "\u010dakmansko pismo" },
            { "Cans", "unificirani kanadski abori\u0111inski slogovi" },
            { "Cari", "karijsko pismo" },
            { "Cham", "\u010damsko pismo" },
            { "Cher", "\u010deroki pismo" },
            { "Cirt", "cirth pismo" },
            { "Copt", "koptsko pismo" },
            { "Cprt", "cypriot pismo" },
            { "Cyrl", "\u0107irilica" },
            { "Cyrs", "staroslavenska crkvena \u010dirilica" },
            { "Deva", "devangari pismo" },
            { "Dsrt", "deseret pismo" },
            { "Egyd", "egipatsko narodno pismo" },
            { "Egyh", "egipatsko hijeratsko pismo" },
            { "Egyp", "egipatski hijeroglifi" },
            { "Ethi", "etiopsko pismo" },
            { "Geok", "gruzijsko khutsuri pismo" },
            { "Geor", "gruzijsko pismo" },
            { "Glag", "glagoljica" },
            { "Goth", "goti\u010dko pismo" },
            { "Gran", "grantha pismo" },
            { "Grek", "gr\u010dko pismo" },
            { "Gujr", "gud\u017earatsko pismo" },
            { "Guru", "gurmukhi pismo" },
            { "Hanb", "hanb pismo" },
            { "Hang", "hangul pismo" },
            { "Hani", "hansko pismo" },
            { "Hano", "hanunoo pismo" },
            { "Hans", "pojednostavljeno pismo" },
            { "Hant", "tradicionalno pismo" },
            { "Hebr", "hebrejsko pismo" },
            { "Hira", "hiragana pismo" },
            { "Hluw", "anatolijski hijeroglifi" },
            { "Hmng", "pahawh hmong pismo" },
            { "Hrkt", "japansko slogovno pismo" },
            { "Hung", "staro ma\u0111arsko pismo" },
            { "Inds", "indijsko pismo" },
            { "Ital", "staro talijansko pismo" },
            { "Jamo", "jamo pismo" },
            { "Java", "javansko pismo" },
            { "Jpan", "japansko pismo" },
            { "Jurc", "jurchen pismo" },
            { "Kali", "kayah li pismo" },
            { "Kana", "katakana pismo" },
            { "Khar", "kharoshthi pismo" },
            { "Khmr", "kmersko pismo" },
            { "Khoj", "khojki pismo" },
            { "Knda", "kannada pismo" },
            { "Kore", "korejsko pismo" },
            { "Kpel", "kpelle pismo" },
            { "Kthi", "kaithi pismo" },
            { "Lana", "lanna pismo" },
            { "Laoo", "laosko pismo" },
            { "Latf", "fraktur latinica" },
            { "Latg", "keltska latinica" },
            { "Latn", "latinica" },
            { "Lepc", "lepcha pismo" },
            { "Limb", "limbu pismo" },
            { "Lina", "linear A pismo" },
            { "Linb", "linear B pismo" },
            { "Lisu", "fraser pismo" },
            { "Loma", "loma pismo" },
            { "Lyci", "likijsko pismo" },
            { "Lydi", "lidijsko pismo" },
            { "Mand", "mandai pismo" },
            { "Mani", "manihejsko pismo" },
            { "Maya", "majanski hijeroglifi" },
            { "Mend", "mende pismo" },
            { "Merc", "meroitski kurziv" },
            { "Mero", "meroitic pismo" },
            { "Mlym", "malajalamsko pismo" },
            { "Mong", "mongolsko pismo" },
            { "Moon", "moon pismo" },
            { "Mroo", "mro pismo" },
            { "Mtei", "meitei mayek pismo" },
            { "Mymr", "mjanmarsko pismo" },
            { "Narb", "staro sjevernoarapsko pismo" },
            { "Nbat", "nabatejsko pismo" },
            { "Nkgb", "naxi geba pismo" },
            { "Nkoo", "n\u2019ko pismo" },
            { "Nshu", "nushu pismo" },
            { "Ogam", "ogham pismo" },
            { "Olck", "ol chiki pismo" },
            { "Orkh", "orkhon pismo" },
            { "Orya", "orijsko pismo" },
            { "Osma", "osmanya pismo" },
            { "Palm", "palmyrene pismo" },
            { "Perm", "staro permic pismo" },
            { "Phag", "phags-pa pismo" },
            { "Phli", "pisani pahlavi" },
            { "Phlp", "psalter pahlavi" },
            { "Phlv", "pahlavi pismo" },
            { "Phnx", "feni\u010dko pismo" },
            { "Plrd", "pollard fonetsko pismo" },
            { "Prti", "pisani parthian" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang pismo" },
            { "Rohg", "hanifi pismo" },
            { "Roro", "rongorongo pismo" },
            { "Runr", "runsko pismo" },
            { "Samr", "samaritansko pismo" },
            { "Sara", "sarati pismo" },
            { "Sarb", "staro ju\u017enoarapsko pismo" },
            { "Saur", "saurashtra pismo" },
            { "Sgnw", "znakovno pismo" },
            { "Shaw", "shavian pismo" },
            { "Shrd", "sharada pismo" },
            { "Sind", "khudawadi pismo" },
            { "Sinh", "sinhale\u0161ko pismo" },
            { "Sora", "sora sompeng pismo" },
            { "Sund", "sundansko pismo" },
            { "Sylo", "syloti nagri pismo" },
            { "Syrc", "sirijsko pismo" },
            { "Syre", "sirijsko estrangelo pismo" },
            { "Syrj", "pismo zapadne Sirije" },
            { "Syrn", "pismo isto\u010dne Sirije" },
            { "Tagb", "tagbanwa pismo" },
            { "Takr", "takri pismo" },
            { "Tale", "tai le pismo" },
            { "Talu", "novo tai lue pismo" },
            { "Taml", "tamilsko pismo" },
            { "Tang", "tangut pismo" },
            { "Tavt", "tai viet pismo" },
            { "Telu", "telu\u0161ko pismo" },
            { "Teng", "tengwar pismo" },
            { "Tfng", "tifinagh pismo" },
            { "Tglg", "tagalog pismo" },
            { "Thaa", "thaana pismo" },
            { "Thai", "tajsko pismo" },
            { "Tibt", "tibetansko pismo" },
            { "Tirh", "tirhuta pismo" },
            { "Ugar", "ugaritsko pismo" },
            { "Vaii", "vai pismo" },
            { "Visp", "Visible Speech" },
            { "Wara", "varang kshiti pismo" },
            { "Wole", "woleai pismo" },
            { "Xpeo", "staro perzijsko pismo" },
            { "Xsux", "sumersko-akadsko cuneiform pismo" },
            { "Yiii", "yi pismo" },
            { "Zinh", "nasljedno pismo" },
            { "Zmth", "matemati\u010dko znakovlje" },
            { "Zsye", "emotikoni" },
            { "Zsym", "simboli" },
            { "Zxxx", "jezik bez pismenosti" },
            { "Zyyy", "zajedni\u010dko pismo" },
            { "Zzzz", "nepoznato pismo" },
            { "de_AT", "austrijski njema\u010dki" },
            { "de_CH", "gornjonjema\u010dki (\u0161vicarski)" },
            { "en_AU", "australski engleski" },
            { "en_CA", "kanadski engleski" },
            { "en_GB", "britanski engleski" },
            { "en_US", "ameri\u010dki engleski" },
            { "es_ES", "europski \u0161panjolski" },
            { "es_MX", "meksi\u010dki \u0161panjolski" },
            { "fa_AF", "dari" },
            { "fr_CA", "kanadski francuski" },
            { "fr_CH", "\u0161vicarski francuski" },
            { "nl_BE", "flamanski" },
            { "pt_BR", "brazilski portugalski" },
            { "pt_PT", "europski portugalski" },
            { "ro_MD", "moldavski" },
            { "sw_CD", "kongoanski svahili" },
            { "%%1901", "tradicionalan njema\u010dki pravopis" },
            { "%%1994", "standardizirani resian pravopis" },
            { "%%1996", "njema\u010dka ortografija iz 1996." },
            { "ar_001", "moderni standardni arapski" },
            { "es_419", "latinoameri\u010dki \u0161panjolski" },
            { "key.ca", "kalendar" },
            { "key.cf", "format valute" },
            { "key.co", "redoslijed razvrstavanja" },
            { "key.cu", "valuta" },
            { "key.hc", "format vremena (12 ili 24)" },
            { "key.lb", "stil prijeloma retka" },
            { "key.ms", "sustav mjernih jedinica" },
            { "key.nu", "brojevi" },
            { "key.tz", "Vremenska zona" },
            { "key.va", "Varijanta zemlje/jezika" },
            { "nds_NL", "donjosaksonski" },
            { "%%ALUKU", "aluku dijalekt" },
            { "%%BISKE", "san giorgio/bila dijalekt" },
            { "%%BOONT", "boontling" },
            { "%%KKCOR", "Uobi\u010dajeni pravopis" },
            { "%%KSCOR", "standardna ortografija" },
            { "%%LIPAW", "lipova\u010dki dijalekt resian jezika" },
            { "%%NEDIS", "natisone dijalekt" },
            { "%%NJIVA", "Gniva/Njiva dijalekt" },
            { "%%NULIK", "moderni volapuk" },
            { "%%OSOJS", "oseacco/osojane dijalekt" },
            { "%%POSIX", "Ra\u010dunalo" },
            { "%%ROZAJ", "resian" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "stolvizza/solbica dijalekt" },
            { "%%UCCOR", "ujedna\u010dena ortografija" },
            { "az_Arab", "ju\u017enoazerbajd\u017eanski" },
            { "zh_Hans", "kineski (pojednostavljeni)" },
            { "zh_Hant", "kineski (tradicionalni)" },
            { "%%FONIPA", "IPA fonetika" },
            { "%%FONUPA", "UPA fonetika" },
            { "%%PAMAKA", "pamaka dijalekt" },
            { "%%PINYIN", "Pinyin romanizacija" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "taraskievica pravopis" },
            { "%%UCRCOR", "ujedna\u010dena revidirana ortografija" },
            { "%%AREVELA", "isto\u010dno-armenijski" },
            { "%%AREVMDA", "zapadno-armenijski" },
            { "%%EMODENG", "rani moderni engleski" },
            { "%%METELKO", "metel\u010dica" },
            { "%%MONOTON", "monotono" },
            { "%%POLYTON", "politono" },
            { "%%REVISED", "izmijenjen pravopis" },
            { "%%1606NICT", "kasni srednjofrancuski do 1606." },
            { "%%1694ACAD", "rani moderni francuski" },
            { "%%1959ACAD", "akademski" },
            { "%%BAKU1926", "unificirana turska abeceda" },
            { "%%SCOTLAND", "\u0161kotski standardni engleski" },
            { "%%VALENCIA", "valencijski" },
            { "%%WADEGILE", "Wade-Giles romanizacija" },
            { "type.ca.roc", "kalendar Republike Kine" },
            { "type.co.eor", "Europska pravila razvrstavanja" },
            { "type.hc.h11", "12-satni format (0 \u2013 11)" },
            { "type.hc.h12", "12-satni format (0 \u2013 12)" },
            { "type.hc.h23", "24-satni format (0 \u2013 23)" },
            { "type.hc.h24", "24-satni format (1 \u2013 24)" },
            { "type.m0.bgn", "transliteracija prema BGN-u" },
            { "type.nu.arab", "arapsko-indijske znamenke" },
            { "type.nu.armn", "armenski brojevi" },
            { "type.nu.beng", "znamenke bengalskog pisma" },
            { "type.nu.cakm", "znamenke \u010dakmanskog pisma" },
            { "type.nu.deva", "znamenke pisma devanagari" },
            { "type.nu.ethi", "etiopski brojevi" },
            { "type.nu.geor", "gruzijski brojevi" },
            { "type.nu.grek", "gr\u010dki brojevi" },
            { "type.nu.gujr", "gud\u017earatske znamenke" },
            { "type.nu.guru", "znamenke pisma gurmukhi" },
            { "type.nu.hans", "pojednostavljeni kineski brojevi" },
            { "type.nu.hant", "tradicionalni kineski brojevi" },
            { "type.nu.hebr", "hebrejski brojevi" },
            { "type.nu.java", "javanske znamenke" },
            { "type.nu.jpan", "japanski brojevi" },
            { "type.nu.khmr", "khmerske znamenke" },
            { "type.nu.knda", "znamenke pisma kannada" },
            { "type.nu.laoo", "laoske znamenke" },
            { "type.nu.latn", "arapski brojevi" },
            { "type.nu.mlym", "malajalamske znamenke" },
            { "type.nu.mong", "Mongolske znamenke" },
            { "type.nu.mtei", "meetei mayek znamenke" },
            { "type.nu.mymr", "mijanmarske znamenke" },
            { "type.nu.olck", "oi chiki znamenke" },
            { "type.nu.orya", "orijske znamenke" },
            { "type.nu.taml", "tamilski brojevi" },
            { "type.nu.telu", "znamenke telu\u0161kog pisma" },
            { "type.nu.thai", "tajske znamenke" },
            { "type.nu.tibt", "tibetske znamenke" },
            { "type.nu.vaii", "vai znamenke" },
            { "type.ca.dangi", "dangi kalendar" },
            { "type.co.ducet", "standardno unicode razvrstavanje" },
            { "type.lb.loose", "slobodni stil prijeloma retka" },
            { "type.nu.roman", "rimski brojevi" },
            { "type.ca.coptic", "koptski kalendar" },
            { "type.ca.hebrew", "hebrejski kalendar" },
            { "type.ca.indian", "indijski nacionalni kalendar" },
            { "type.co.compat", "prethodni redoslijed razvrstavanja, radi kompatibilnosti" },
            { "type.co.pinyin", "pinyin razvrstavanje" },
            { "type.co.search", "op\u0107enito pretra\u017eivanje" },
            { "type.co.stroke", "razvrstavanje po redoslijedu poteza za kineski" },
            { "type.co.unihan", "razvrstavanje prema korijenu i potezu" },
            { "type.co.zhuyin", "zhuyin razvrstavanje" },
            { "type.d0.fwidth", "\u0161iroki" },
            { "type.d0.hwidth", "uski" },
            { "type.lb.normal", "normalni stil prijeloma retka" },
            { "type.lb.strict", "strogi stil prijeloma retka" },
            { "type.m0.ungegn", "transliteracija prema UNGEGN-u" },
            { "type.ms.metric", "metri\u010dki sustav" },
            { "type.nu.native", "izvorne znamenke" },
            { "type.ca.chinese", "kineski kalendar" },
            { "type.ca.islamic", "hijri kalendar" },
            { "type.ca.iso8601", "ISO-8601 kalendar" },
            { "type.ca.persian", "perzijski kalendar" },
            { "type.cf.account", "ra\u010dunovodstveni format valute" },
            { "type.co.big5han", "razvrstavanje prema tradicionalnom kineskom - Big5" },
            { "type.d0.npinyin", "Numeri\u010dki" },
            { "type.nu.arabext", "pro\u0161irene arapsko-indijske znamenke" },
            { "type.nu.armnlow", "mali armenski brojevi" },
            { "type.nu.finance", "Financijski brojevi" },
            { "type.nu.greklow", "mali gr\u010dki brojevi" },
            { "type.nu.hanidec", "kineski decimalni brojevi" },
            { "type.nu.hansfin", "pojednostavljeni kineski financijski brojevi" },
            { "type.nu.hantfin", "tradicionalni kineski financijski brojevi" },
            { "type.nu.jpanfin", "japanski financijski brojevi" },
            { "type.nu.tamldec", "tamilske znamenke" },
            { "type.ca.buddhist", "budisti\u010dki kalendar" },
            { "type.ca.ethiopic", "etiopski kalendar" },
            { "type.ca.japanese", "japanski kalendar" },
            { "type.cf.standard", "standardni format valute" },
            { "type.co.phonetic", "fonetsko razvrstavanje" },
            { "type.co.searchjl", "Pretra\u017eivanje po po\u010detnom suglasniku hangula" },
            { "type.co.standard", "standardno razvrstavanje" },
            { "type.ms.uksystem", "imperijalni sustav mjera" },
            { "type.ms.ussystem", "ameri\u010dki sustav mjera" },
            { "type.nu.fullwide", "\u0161iroke znamenke" },
            { "type.nu.romanlow", "mali rimski brojevi" },
            { "type.ca.gregorian", "gregorijanski kalendar" },
            { "type.co.gb2312han", "razvrstavanje prema pojednostavljenom kineskom - GB2312" },
            { "type.co.phonebook", "razvrstavanje po abecedi" },
            { "type.co.dictionary", "rje\u010dni\u010dko razvrstavanje" },
            { "type.co.traditional", "tradicionalno razvrstavanje" },
            { "type.nu.traditional", "Tradicionalni brojevi" },
            { "type.ca.islamic-civil", "hijri kalendar (tabularni, civilna epoha)" },
            { "type.ca.islamic-umalqura", "hijri kalendar (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "etiopski kalendar \"Amete Alem\"" },
        };
        return data;
    }
}
