/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_en_CA extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Apia = new String[] {
               "Apia Standard Time",
               "",
               "Apia Daylight Saving Time",
               "",
               "Apia Time",
               "",
            };
        final String[] Cuba = new String[] {
               "Cuba Standard Time",
               "CST",
               "Cuba Daylight Saving Time",
               "CDT",
               "Cuba Time",
               "CT",
            };
        final String[] Iran = new String[] {
               "Iran Standard Time",
               "IRST",
               "Iran Daylight Saving Time",
               "IRDT",
               "Iran Time",
               "",
            };
        final String[] Peru = new String[] {
               "Peru Standard Time",
               "",
               "Peru Summer Time",
               "",
               "Peru Time",
               "PET",
            };
        final String[] China = new String[] {
               "China Standard Time",
               "CST",
               "China Daylight Saving Time",
               "CDT",
               "China Time",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Cocos Islands Time",
               "CCT",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India Standard Time",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japan Standard Time",
               "JST",
               "Japan Daylight Saving Time",
               "JDT",
               "Japan Time",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korean Standard Time",
               "KST",
               "Korean Daylight Saving Time",
               "KST",
               "Korean Time",
               "KST",
            };
        final String[] Nepal = new String[] {
               "Nepal Time",
               "NPT",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa Standard Time",
               "SST",
               "Samoa Daylight Saving Time",
               "SST",
               "Samoa Time",
               "SST",
            };
        final String[] Alaska = new String[] {
               "Alaska Standard Time",
               "AKST",
               "Alaska Daylight Saving Time",
               "AKDT",
               "Alaska Time",
               "AKT",
            };
        final String[] Bhutan = new String[] {
               "Bhutan Time",
               "BTT",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalam Time",
               "BNT",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Easter Island Standard Time",
               "EAST",
               "Easter Island Summer Time",
               "EASST",
               "Easter Island Time",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana Time",
               "GYT",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israel Standard Time",
               "IST",
               "Israel Daylight Saving Time",
               "IDT",
               "Israel Time",
               "IT",
            };
        final String[] Taipei = new String[] {
               "Taipei Standard Time",
               "CST",
               "Taipei Daylight Saving Time",
               "CDT",
               "Taipei Time",
               "CT",
            };
        final String[] Wallis = new String[] {
               "Wallis and Futuna Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabian Standard Time",
               "",
               "Arabian Daylight Saving Time",
               "",
               "Arabian Time",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham Standard Time",
               "CHAST",
               "Chatham Daylight Saving Time",
               "CHADT",
               "Chatham Time",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuador Time",
               "ECT",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk Island Standard Time",
               "",
               "Norfolk Island Daylight Saving Time",
               "",
               "Norfolk Island Time",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha Standard Time",
               "",
               "Fernando de Noronha Summer Time",
               "",
               "Fernando de Noronha Time",
               "FNT",
            };
        final String[] Uruguay = new String[] {
               "Uruguay Standard Time",
               "UYT",
               "Uruguay Summer Time",
               "UYST",
               "Uruguay Time",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantic Standard Time",
               "AST",
               "Atlantic Daylight Saving Time",
               "ADT",
               "Atlantic Time",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Brasilia Standard Time",
               "",
               "Brasilia Summer Time",
               "BRST",
               "Brasilia Time",
               "BRT",
            };
        final String[] Colombia = new String[] {
               "Colombia Standard Time",
               "",
               "Colombia Summer Time",
               "COST",
               "Colombia Time",
               "",
            };
        final String[] Falkland = new String[] {
               "Falkland Islands Standard Time",
               "",
               "Falkland Islands Summer Time",
               "FKST",
               "Falkland Islands Time",
               "FKT",
            };
        final String[] Malaysia = new String[] {
               "Malaysia Time",
               "MYT",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldives Time",
               "MVT",
               "",
               "",
               "",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistan Standard Time",
               "PKT",
               "Pakistan Summer Time",
               "PKST",
               "Pakistan Time",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguay Standard Time",
               "",
               "Paraguay Summer Time",
               "PYST",
               "Paraguay Time",
               "PYT",
            };
        final String[] Argentina = new String[] {
               "Argentina Standard Time",
               "",
               "Argentina Summer Time",
               "",
               "Argentina Time",
               "ART",
            };
        final String[] Christmas = new String[] {
               "Christmas Island Time",
               "CXT",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos Time",
               "GALT",
               "",
               "",
               "",
               "",
            };
        final String[] Indochina = new String[] {
               "Indochina Time",
               "ICT",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe Standard Time",
               "",
               "Lord Howe Daylight Saving Time",
               "",
               "Lord Howe Time",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela Time",
               "VET",
               "",
               "",
               "",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesh Standard Time",
               "BST",
               "Bangladesh Summer Time",
               "",
               "Bangladesh Time",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "East Timor Time",
               "TLT",
               "",
               "",
               "",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan Time",
               "AFT",
               "",
               "",
               "",
               "",
            };
        final String[] New_Zealand = new String[] {
               "New Zealand Standard Time",
               "NZST",
               "New Zealand Daylight Saving Time",
               "NZDT",
               "New Zealand Time",
               "NZT",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundland Standard Time",
               "NST",
               "Newfoundland Daylight Saving Time",
               "NDT",
               "Newfoundland Time",
               "NT",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexican Pacific Standard Time",
               "MST",
               "Mexican Pacific Daylight Saving Time",
               "MDT",
               "Mexican Pacific Time",
               "MT",
            };
        final String[] America_Central = new String[] {
               "Central Standard Time",
               "CST",
               "Central Daylight Saving Time",
               "CDT",
               "Central Time",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Eastern Standard Time",
               "EST",
               "Eastern Daylight Saving Time",
               "EDT",
               "Eastern Time",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Pacific Standard Time",
               "PST",
               "Pacific Daylight Saving Time",
               "PDT",
               "Pacific Time",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "French Southern and Antarctic Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleutian Standard Time",
               "HAST",
               "Hawaii-Aleutian Daylight Saving Time",
               "HADT",
               "Hawaii-Aleutian Time",
               "HAT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre-et-Miquelon Standard Time",
               "PMST",
               "Saint-Pierre-et-Miquelon Daylight Saving Time",
               "PMDT",
               "Saint-Pierre-et-Miquelon Time",
               "PMT",
            };
        final String[] America_Mountain = new String[] {
               "Mountain Standard Time",
               "MST",
               "Mountain Daylight Saving Time",
               "MDT",
               "Mountain Time",
               "MT",
            };
        final String[] Australia_Central = new String[] {
               "Australian Central Standard Time",
               "ACST",
               "Australian Central Daylight Saving Time",
               "ACDT",
               "Central Australia Time",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Australian Eastern Standard Time",
               "AEST",
               "Australian Eastern Daylight Saving Time",
               "AEDT",
               "Eastern Australia Time",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Australian Western Standard Time",
               "AWST",
               "Australian Western Daylight Saving Time",
               "AWDT",
               "Western Australia Time",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia Time",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia Time",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia Time",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australian Central Western Standard Time",
               "ACWST",
               "Australian Central Western Daylight Saving Time",
               "ACWDT",
               "Australian Central Western Time",
               "ACWT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MIT", Apia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "VST", Indochina },
            { "Cuba", Cuba },
            { "Iran", Iran },
            { "Japan", Japan },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Dili", East_Timor },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Kuwait", Arabian },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Colombo", India },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Thimphu", Bhutan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Calcutta", India },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Tel_Aviv", Israel },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Maceio", Brasilia },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Singapore", Malaysia },
            { "Asia/Vientiane", Indochina },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Midway", Samoa },
            { "Pacific/Tarawa", Wallis },
            { "Pacific/Wallis", Wallis },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Phnom_Penh", Indochina },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Araguaina", Brasilia },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Pago_Pago", Samoa },
            { "US/Indiana-Starke", America_Central },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Atlantic/St_Helena", "Saint Helena" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
        };
        return data;
    }
}
