/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_zu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "isi-Arabic";
        final String metaValue_ban = "isi-Balinese";
        final String metaValue_bug = "isi-Buginese";
        final String metaValue_chr = "isi-Cherokee";
        final String metaValue_ka = "isi-Georgian";
        final String metaValue_el = "isi-Greek";
        final String metaValue_gu = "isi-Gujarati";
        final String metaValue_he = "isi-Hebrew";
        final String metaValue_jv = "isi-Javanese";
        final String metaValue_ja = "isi-Japanese";
        final String metaValue_km = "isi-Khmer";
        final String metaValue_kn = "isi-Kannada";
        final String metaValue_ko = "isi-Korean";
        final String metaValue_lo = "isi-Lao";
        final String metaValue_la = "isi-Latin";
        final String metaValue_ml = "isi-Malayalam";
        final String metaValue_mn = "isi-Mongolian";
        final String metaValue_nqo = "isi-N\u2019Ko";
        final String metaValue_or = "isi-Odia";
        final String metaValue_si = "isi-Sinhala";
        final String metaValue_su = "isi-Sundanese";
        final String metaValue_syr = "isi-Syriac";
        final String metaValue_ta = "isi-Tamil";
        final String metaValue_te = "isi-Telugu";
        final String metaValue_th = "isi-Thai";
        final String metaValue_vai = "isi-Vai";
        final String metaValue_type_nu_taml = "izinombolo zesi-Tamil";
        final Object[][] data = new Object[][] {
            { "001", "umhlaba" },
            { "002", "i-Africa" },
            { "003", "i-North America" },
            { "005", "i-South America" },
            { "009", "i-Oceania" },
            { "011", "i-Western Africa" },
            { "013", "i-Central America" },
            { "014", "i-Eastern Africa" },
            { "015", "i-Northern Africa" },
            { "017", "i-Middle Africa" },
            { "018", "i-Southern Africa" },
            { "019", "i-Americas" },
            { "021", "i-Northern America" },
            { "029", "i-Caribbean" },
            { "030", "i-Eastern Asia" },
            { "034", "i-Southern Asia" },
            { "035", "i-South-Eastern Asia" },
            { "039", "i-Southern Europe" },
            { "053", "i-Australasia" },
            { "054", "i-Melanesia" },
            { "057", "i-Micronesian Region" },
            { "061", "i-Polynesia" },
            { "142", "i-Asia" },
            { "143", "i-Central Asia" },
            { "145", "i-Western Asia" },
            { "150", "i-Europe" },
            { "151", "i-Eastern Europe" },
            { "154", "i-Northern Europe" },
            { "155", "i-Western Europe" },
            { "202", "Sub-Saharan Africa" },
            { "419", "i-Latin America" },
            { "AC", "i-Ascension Island" },
            { "AD", "i-Andorra" },
            { "AE", "i-United Arab Emirates" },
            { "AF", "i-Afghanistan" },
            { "AG", "i-Antigua ne-Barbuda" },
            { "AI", "i-Anguilla" },
            { "AL", "i-Albania" },
            { "AM", "i-Armenia" },
            { "AO", "i-Angola" },
            { "AQ", "i-Antarctica" },
            { "AR", "i-Argentina" },
            { "AS", "i-American Samoa" },
            { "AT", "i-Austria" },
            { "AU", "i-Australia" },
            { "AW", "i-Aruba" },
            { "AX", "i-\u00c5land Islands" },
            { "AZ", "i-Azerbaijan" },
            { "BA", "i-Bosnia ne-Herzegovina" },
            { "BB", "i-Barbados" },
            { "BD", "i-Bangladesh" },
            { "BE", "i-Belgium" },
            { "BF", "i-Burkina Faso" },
            { "BG", "i-Bulgaria" },
            { "BH", "i-Bahrain" },
            { "BI", "i-Burundi" },
            { "BJ", "i-Benin" },
            { "BL", "i-Saint Barth\u00e9lemy" },
            { "BM", "i-Bermuda" },
            { "BN", "i-Brunei" },
            { "BO", "i-Bolivia" },
            { "BQ", "i-Caribbean Netherlands" },
            { "BR", "i-Brazil" },
            { "BS", "i-Bahamas" },
            { "BT", "i-Bhutan" },
            { "BV", "i-Bouvet Island" },
            { "BW", "iBotswana" },
            { "BY", "i-Belarus" },
            { "BZ", "i-Belize" },
            { "CA", "i-Canada" },
            { "CC", "i-Cocos (Keeling) Islands" },
            { "CD", "i-Congo - Kinshasa" },
            { "CF", "i-Central African Republic" },
            { "CG", "i-Congo - Brazzaville" },
            { "CH", "i-Switzerland" },
            { "CI", "i-C\u00f4te d\u2019Ivoire" },
            { "CK", "i-Cook Islands" },
            { "CL", "i-Chile" },
            { "CM", "i-Cameroon" },
            { "CN", "i-China" },
            { "CO", "i-Colombia" },
            { "CP", "i-Clipperton Island" },
            { "CR", "i-Costa Rica" },
            { "CU", "i-Cuba" },
            { "CV", "i-Cape Verde" },
            { "CW", "i-Cura\u00e7ao" },
            { "CX", "i-Christmas Island" },
            { "CY", "i-Cyprus" },
            { "CZ", "i-Czechia" },
            { "DE", "i-Germany" },
            { "DG", "i-Diego Garcia" },
            { "DJ", "i-Djibouti" },
            { "DK", "i-Denmark" },
            { "DM", "i-Dominica" },
            { "DO", "i-Dominican Republic" },
            { "DZ", "i-Algeria" },
            { "EA", "i-Cueta ne-Melilla" },
            { "EC", "i-Ecuador" },
            { "EE", "i-Estonia" },
            { "EG", "i-Egypt" },
            { "EH", "i-Western Sahara" },
            { "ER", "i-Eritrea" },
            { "ES", "i-Spain" },
            { "ET", "i-Ethiopia" },
            { "EU", "i-European Union" },
            { "EZ", "I-Eurozone" },
            { "FI", "i-Finland" },
            { "FJ", "i-Fiji" },
            { "FK", "i-Falkland Islands" },
            { "FM", "i-Micronesia" },
            { "FO", "i-Faroe Islands" },
            { "FR", "i-France" },
            { "GA", "i-Gabon" },
            { "GB", "i-United Kingdom" },
            { "GD", "i-Grenada" },
            { "GE", "i-Georgia" },
            { "GF", "i-French Guiana" },
            { "GG", "i-Guernsey" },
            { "GH", "i-Ghana" },
            { "GI", "i-Gibraltar" },
            { "GL", "i-Greenland" },
            { "GM", "i-Gambia" },
            { "GN", "i-Guinea" },
            { "GP", "i-Guadeloupe" },
            { "GQ", "i-Equatorial Guinea" },
            { "GR", "i-Greece" },
            { "GS", "i-South Georgia ne-South Sandwich Islands" },
            { "GT", "i-Guatemala" },
            { "GU", "i-Guam" },
            { "GW", "i-Guinea-Bissau" },
            { "GY", "i-Guyana" },
            { "HK", "i-Hong Kong SAR China" },
            { "HM", "I-Heard & McDonald Island" },
            { "HN", "i-Honduras" },
            { "HR", "i-Croatia" },
            { "HT", "i-Haiti" },
            { "HU", "i-Hungary" },
            { "IC", "i-Canary Islands" },
            { "ID", "i-Indonesia" },
            { "IE", "i-Ireland" },
            { "IL", "kwa-Israel" },
            { "IM", "i-Isle of Man" },
            { "IN", "i-India" },
            { "IO", "i-British Indian Ocean Territory" },
            { "IQ", "i-Iraq" },
            { "IR", "i-Iran" },
            { "IS", "i-Iceland" },
            { "IT", "i-Italy" },
            { "JE", "i-Jersey" },
            { "JM", "i-Jamaica" },
            { "JO", "i-Jordan" },
            { "JP", "i-Japan" },
            { "KE", "i-Kenya" },
            { "KG", "i-Kyrgyzstan" },
            { "KH", "i-Cambodia" },
            { "KI", "i-Kiribati" },
            { "KM", "i-Comoros" },
            { "KN", "i-Saint Kitts ne-Nevis" },
            { "KP", "i-North Korea" },
            { "KR", "i-South Korea" },
            { "KW", "i-Kuwait" },
            { "KY", "i-Cayman Islands" },
            { "KZ", "i-Kazakhstan" },
            { "LA", "i-Laos" },
            { "LB", "i-Lebanon" },
            { "LC", "i-Saint Lucia" },
            { "LI", "i-Liechtenstein" },
            { "LK", "i-Sri Lanka" },
            { "LR", "i-Liberia" },
            { "LS", "iLesotho" },
            { "LT", "i-Lithuania" },
            { "LU", "i-Luxembourg" },
            { "LV", "i-Latvia" },
            { "LY", "i-Libya" },
            { "MA", "i-Morocco" },
            { "MC", "i-Monaco" },
            { "MD", "i-Moldova" },
            { "ME", "i-Montenegro" },
            { "MF", "i-Saint Martin" },
            { "MG", "i-Madagascar" },
            { "MH", "i-Marshall Islands" },
            { "MK", "i-North Macedonia" },
            { "ML", "iMali" },
            { "MM", "i-Myanmar (Burma)" },
            { "MN", "i-Mongolia" },
            { "MO", "i-Macau SAR China" },
            { "MP", "i-Northern Mariana Islands" },
            { "MQ", "i-Martinique" },
            { "MR", "i-Mauritania" },
            { "MS", "i-Montserrat" },
            { "MT", "i-Malta" },
            { "MU", "i-Mauritius" },
            { "MV", "i-Maldives" },
            { "MW", "iMalawi" },
            { "MX", "i-Mexico" },
            { "MY", "i-Malaysia" },
            { "MZ", "i-Mozambique" },
            { "NA", "i-Namibia" },
            { "NC", "i-New Caledonia" },
            { "NE", "i-Niger" },
            { "NF", "i-Norfolk Island" },
            { "NG", "i-Nigeria" },
            { "NI", "i-Nicaragua" },
            { "NL", "i-Netherlands" },
            { "NO", "i-Norway" },
            { "NP", "i-Nepal" },
            { "NR", "i-Nauru" },
            { "NU", "i-Niue" },
            { "NZ", "i-New Zealand" },
            { "OM", "i-Oman" },
            { "PA", "i-Panama" },
            { "PE", "i-Peru" },
            { "PF", "i-French Polynesia" },
            { "PG", "i-Papua New Guinea" },
            { "PH", "i-Philippines" },
            { "PK", "i-Pakistan" },
            { "PL", "i-Poland" },
            { "PM", "i-Saint Pierre kanye ne-Miquelon" },
            { "PN", "i-Pitcairn Islands" },
            { "PR", "i-Puerto Rico" },
            { "PS", "i-Palestinian Territories" },
            { "PT", "i-Portugal" },
            { "PW", "i-Palau" },
            { "PY", "i-Paraguay" },
            { "QA", "i-Qatar" },
            { "QO", "i-Outlying Oceania" },
            { "RE", "i-R\u00e9union" },
            { "RO", "i-Romania" },
            { "RS", "i-Serbia" },
            { "RU", "i-Russia" },
            { "RW", "i-Rwanda" },
            { "SA", "i-Saudi Arabia" },
            { "SB", "i-Solomon Islands" },
            { "SC", "i-Seychelles" },
            { "SD", "i-Sudan" },
            { "SE", "i-Sweden" },
            { "SG", "i-Singapore" },
            { "SH", "i-St. Helena" },
            { "SI", "i-Slovenia" },
            { "SJ", "i-Svalbard ne-Jan Mayen" },
            { "SK", "i-Slovakia" },
            { "SL", "i-Sierra Leone" },
            { "SM", "i-San Marino" },
            { "SN", "i-Senegal" },
            { "SO", "i-Somalia" },
            { "SR", "i-Suriname" },
            { "SS", "i-South Sudan" },
            { "ST", "i-S\u00e3o Tom\u00e9 kanye ne-Pr\u00edncipe" },
            { "SV", "i-El Salvador" },
            { "SX", "i-Sint Maarten" },
            { "SY", "i-Syria" },
            { "SZ", "i-Swaziland" },
            { "TA", "i-Tristan da Cunha" },
            { "TC", "i-Turks ne-Caicos Islands" },
            { "TD", "i-Chad" },
            { "TF", "i-French Southern Territories" },
            { "TG", "i-Togo" },
            { "TH", "i-Thailand" },
            { "TJ", "i-Tajikistan" },
            { "TK", "i-Tokelau" },
            { "TL", "i-Timor-Leste" },
            { "TM", "i-Turkmenistan" },
            { "TN", "i-Tunisia" },
            { "TO", "i-Tonga" },
            { "TR", "i-Turkey" },
            { "TT", "i-Trinidad ne-Tobago" },
            { "TV", "i-Tuvalu" },
            { "TW", "i-Taiwan" },
            { "TZ", "i-Tanzania" },
            { "UA", "i-Ukraine" },
            { "UG", "i-Uganda" },
            { "UM", "I-U.S. Outlying Islands" },
            { "UN", "I-United Nations" },
            { "US", "i-United States" },
            { "UY", "i-Uruguay" },
            { "UZ", "i-Uzbekistan" },
            { "VA", "i-Vatican City" },
            { "VC", "i-Saint Vincent ne-Grenadines" },
            { "VE", "i-Venezuela" },
            { "VG", "i-British Virgin Islands" },
            { "VI", "i-U.S. Virgin Islands" },
            { "VN", "i-Vietnam" },
            { "VU", "i-Vanuatu" },
            { "WF", "i-Wallis ne-Futuna" },
            { "WS", "i-Samoa" },
            { "XA", "Pseudo-Accents" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "i-Kosovo" },
            { "YE", "i-Yemen" },
            { "YT", "i-Mayotte" },
            { "ZA", "iNingizimu Afrika" },
            { "ZM", "i-Zambia" },
            { "ZW", "iZimbabwe" },
            { "ZZ", "iSifunda esingaziwa" },
            { "aa", "isi-Afar" },
            { "ab", "isi-Abkhazian" },
            { "af", "i-Afrikaans" },
            { "ak", "isi-Akan" },
            { "am", "isi-Amharic" },
            { "an", "isi-Aragonese" },
            { "ar", metaValue_ar },
            { "as", "isi-Assamese" },
            { "av", "isi-Avaric" },
            { "ay", "isi-Aymara" },
            { "az", "isi-Azerbaijani" },
            { "ba", "isi-Bashkir" },
            { "be", "isi-Belarusian" },
            { "bg", "isi-Bulgari" },
            { "bi", "isi-Bislama" },
            { "bm", "isi-Bambara" },
            { "bn", "isi-Bengali" },
            { "bo", "isi-Tibetan" },
            { "br", "isi-Breton" },
            { "bs", "isi-Bosnian" },
            { "ca", "isi-Catalan" },
            { "ce", "isi-Chechen" },
            { "ch", "isi-Chamorro" },
            { "co", "isi-Corsican" },
            { "cs", "isi-Czech" },
            { "cu", "isi-Church Slavic" },
            { "cv", "isi-Chuvash" },
            { "cy", "isi-Welsh" },
            { "da", "isi-Danish" },
            { "de", "isi-German" },
            { "dv", "isi-Divehi" },
            { "dz", "isi-Dzongkha" },
            { "ee", "isi-Ewe" },
            { "el", metaValue_el },
            { "en", "i-English" },
            { "eo", "isi-Esperanto" },
            { "es", "isi-Spanish" },
            { "et", "isi-Estonia" },
            { "eu", "isi-Basque" },
            { "fa", "isi-Persian" },
            { "ff", "isi-Fulah" },
            { "fi", "isi-Finnish" },
            { "fj", "isi-Fijian" },
            { "fo", "isi-Faroese" },
            { "fr", "isi-French" },
            { "fy", "isi-Western Frisian" },
            { "ga", "isi-Irish" },
            { "gd", "isi-Scottish Gaelic" },
            { "gl", "isi-Galicia" },
            { "gn", "isi-Guarani" },
            { "gu", metaValue_gu },
            { "gv", "isi-Manx" },
            { "ha", "isi-Hausa" },
            { "he", metaValue_he },
            { "hi", "isi-Hindi" },
            { "hr", "isi-Croatian" },
            { "ht", "isi-Haitian" },
            { "hu", "isi-Hungarian" },
            { "hy", "isi-Armenia" },
            { "hz", "isi-Herero" },
            { "ia", "izilimi ezihlangene" },
            { "id", "isi-Indonesian" },
            { "ie", "izimili" },
            { "ig", "isi-Igbo" },
            { "ii", "isi-Sichuan Yi" },
            { "io", "isi-Ido" },
            { "is", "isi-Icelandic" },
            { "it", "isi-Italian" },
            { "iu", "isi-Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "isi-Kongo" },
            { "ki", "isi-Kikuyu" },
            { "kj", "isi-Kuanyama" },
            { "kk", "isi-Kazakh" },
            { "kl", "isi-Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "isi-Kanuri" },
            { "ks", "isi-Kashmiri" },
            { "ku", "isi-Kurdish" },
            { "kv", "isi-Komi" },
            { "kw", "isi-Cornish" },
            { "ky", "isi-Kyrgyz" },
            { "la", metaValue_la },
            { "lb", "isi-Luxembourgish" },
            { "lg", "isi-Ganda" },
            { "li", "isi-Limburgish" },
            { "ln", "isi-Lingala" },
            { "lo", metaValue_lo },
            { "lt", "isi-Lithuanian" },
            { "lu", "isi-Luba-Katanga" },
            { "lv", "isi-Latvian" },
            { "mg", "isi-Malagasy" },
            { "mh", "isi-Marshallese" },
            { "mi", "isi-Maori" },
            { "mk", "isi-Macedonian" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "isi-Marathi" },
            { "ms", "isi-Malay" },
            { "mt", "isi-Maltese" },
            { "my", "isi-Burmese" },
            { "na", "isi-Nauru" },
            { "nb", "isi-Norwegian Bokm\u00e5l" },
            { "nd", "isi-North Ndebele" },
            { "ne", "isi-Nepali" },
            { "ng", "isi-Ndonga" },
            { "nl", "isi-Dutch" },
            { "nn", "isi-Norwegian Nynorsk" },
            { "no", "isi-Norwegian" },
            { "nr", "isi-South Ndebele" },
            { "nv", "isi-Navajo" },
            { "ny", "isi-Nyanja" },
            { "oc", "isi-Occitan" },
            { "om", "isi-Oromo" },
            { "or", metaValue_or },
            { "os", "isi-Ossetic" },
            { "pa", "isi-Punjabi" },
            { "pl", "isi-Polish" },
            { "ps", "isi-Pashto" },
            { "pt", "isi-Portuguese" },
            { "qu", "isi-Quechua" },
            { "rm", "isi-Romansh" },
            { "rn", "isi-Rundi" },
            { "ro", "isi-Romanian" },
            { "ru", "isi-Russian" },
            { "rw", "isi-Kinyarwanda" },
            { "sa", "isi-Sanskrit" },
            { "sc", "isi-Sardinian" },
            { "sd", "isi-Sindhi" },
            { "se", "isi-Northern Sami" },
            { "sg", "isi-Sango" },
            { "sh", "isi-Serbo-Croatian" },
            { "si", metaValue_si },
            { "sk", "isi-Slovak" },
            { "sl", "isi-Slovenian" },
            { "sm", "isi-Samoan" },
            { "sn", "isiShona" },
            { "so", "isi-Somali" },
            { "sq", "isi-Albania" },
            { "sr", "isi-Serbian" },
            { "ss", "isiSwati" },
            { "st", "isi-Southern Sotho" },
            { "su", metaValue_su },
            { "sv", "isi-Swedish" },
            { "sw", "isiSwahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "isi-Tajik" },
            { "th", metaValue_th },
            { "ti", "isi-Tigrinya" },
            { "tk", "isi-Turkmen" },
            { "tn", "isi-Tswana" },
            { "to", "isi-Tongan" },
            { "tr", "isi-Turkish" },
            { "ts", "isi-Tsonga" },
            { "tt", "isi-Tatar" },
            { "tw", "isi-Twi" },
            { "ty", "isi-Tahitian" },
            { "ug", "isi-Uighur" },
            { "uk", "isi-Ukrainian" },
            { "ur", "isi-Urdu" },
            { "uz", "isi-Uzbek" },
            { "ve", "isi-Venda" },
            { "vi", "isi-Vietnamese" },
            { "vo", "isi-Volap\u00fck" },
            { "wa", "isi-Walloon" },
            { "wo", "isi-Wolof" },
            { "xh", "isiXhosa" },
            { "yi", "isi-Yiddish" },
            { "yo", "isi-Yoruba" },
            { "zh", "isi-Chinese" },
            { "zu", "isiZulu" },
            { "ace", "isi-Achinese" },
            { "ach", "isi-Acoli" },
            { "ada", "isi-Adangme" },
            { "ady", "isi-Adyghe" },
            { "agq", "isi-Aghem" },
            { "ain", "isi-Ainu" },
            { "ale", "isi-Aleut" },
            { "alt", "isi-Southern Altai" },
            { "ann", "isi-Obolo" },
            { "anp", "isi-Angika" },
            { "arn", "isi-Mapuche" },
            { "arp", "isi-Arapaho" },
            { "ars", "isi-Najdi Arabic" },
            { "asa", "isi-Asu" },
            { "ast", "isi-Asturian" },
            { "atj", "isi-Atikamekw" },
            { "awa", "isi-Awadhi" },
            { "ban", metaValue_ban },
            { "bas", "isi-Basaa" },
            { "bem", "isi-Bemba" },
            { "bez", "isi-Bena" },
            { "bgn", "isi-Western Balochi" },
            { "bho", "isi-Bhojpuri" },
            { "bin", "isi-Bini" },
            { "bla", "isi-Siksika" },
            { "brx", "isi-Bodo" },
            { "bug", metaValue_bug },
            { "byn", "isi-Blin" },
            { "cay", "isi-Cayuga" },
            { "ccp", "i-Chakma" },
            { "ceb", "isi-Cebuano" },
            { "cgg", "isi-Chiga" },
            { "chk", "isi-Chuukese" },
            { "chm", "isi-Mari" },
            { "cho", "isi-Choctaw" },
            { "chp", "isi-Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "isi-Cheyenne" },
            { "ckb", "isi-Central Kurdish" },
            { "clc", "isi-Chilcotin" },
            { "crg", "isi-Michif" },
            { "crj", "Southern East Cree" },
            { "crk", "Plains Cree" },
            { "crl", "isi-Northern East Cree" },
            { "crm", "isi-Moose Cree" },
            { "crr", "isi-Carolina Algonquian" },
            { "crs", "i-Seselwa Creole French" },
            { "csw", "Swampy Cree" },
            { "dak", "isi-Dakota" },
            { "dar", "isi-Dargwa" },
            { "dav", "isi-Taita" },
            { "dgr", "isi-Dogrib" },
            { "dje", "isi-Zarma" },
            { "doi", "isi-Dogri" },
            { "dsb", "isi-Lower Sorbian" },
            { "dua", "isi-Duala" },
            { "dyo", "isi-Jola-Fonyi" },
            { "dzg", "isi-Dazaga" },
            { "ebu", "isi-Embu" },
            { "efi", "isi-Efik" },
            { "eka", "isi-Ekajuk" },
            { "ewo", "isi-Ewondo" },
            { "fil", "isi-Filipino" },
            { "fon", "isi-Fon" },
            { "frc", "isi-Cajun French" },
            { "frr", "isi-Northern Frisian" },
            { "fur", "isi-Friulian" },
            { "gaa", "isi-Ga" },
            { "gag", "isi-Gagauz" },
            { "gan", "isi-Gan Chinese" },
            { "gez", "isi-Geez" },
            { "gil", "isi-Gilbertese" },
            { "gor", "isi-Gorontalo" },
            { "gsw", "isi-Swiss German" },
            { "guz", "isi-Gusli" },
            { "gwi", "isi-Gwich\u02bcin" },
            { "hai", "isi-Haida" },
            { "hak", "isi-Hakka Chinese" },
            { "haw", "isi-Hawaiian" },
            { "hax", "Southern Haida" },
            { "hil", "isi-Hiligaynon" },
            { "hmn", "isi-Hmong" },
            { "hsb", "isi-Upper Sorbian" },
            { "hsn", "isi-Xiang Chinese" },
            { "hup", "isi-Hupa" },
            { "hur", "isi-Halkomelem" },
            { "iba", "isi-Iban" },
            { "ibb", "isi-Ibibio" },
            { "ikt", "Western Canadian Inuktitut" },
            { "ilo", "isi-Iloko" },
            { "inh", "isi-Ingush" },
            { "jbo", "isi-Lojban" },
            { "jgo", "isi-Ngomba" },
            { "jmc", "isi-Machame" },
            { "kab", "isi-Kabyle" },
            { "kac", "isi-Kachin" },
            { "kaj", "isi-Jju" },
            { "kam", "isi-Kamba" },
            { "kbd", "isi-Kabardian" },
            { "kcg", "isi-Tyap" },
            { "kde", "isi-Makonde" },
            { "kea", "isi-Kabuverdianu" },
            { "kfo", "isi-Koro" },
            { "kgp", "isi-Kaingang" },
            { "kha", "isi-Khasi" },
            { "khq", "isi-Koyra Chiini" },
            { "kkj", "isi-Kako" },
            { "kln", "isi-Kalenjin" },
            { "kmb", "isi-Kimbundu" },
            { "koi", "isi-Komi-Permyak" },
            { "kok", "isi-Konkani" },
            { "kpe", "isi-Kpelle" },
            { "krc", "isi-Karachay-Balkar" },
            { "krl", "isi-Karelian" },
            { "kru", "isi-Kurukh" },
            { "ksb", "isiShambala" },
            { "ksf", "isi-Bafia" },
            { "ksh", "isi-Colognian" },
            { "kum", "isi-Kumyk" },
            { "kwk", "Kwak\u02bcwala" },
            { "lad", "isi-Ladino" },
            { "lag", "isi-Langi" },
            { "lez", "isi-Lezghian" },
            { "lil", "isi-Lillooet" },
            { "lkt", "isi-Lakota" },
            { "lou", "isi-Louisiana Creole" },
            { "loz", "isi-Lozi" },
            { "lrc", "isi-Northern Luri" },
            { "lsm", "isi-Saamia" },
            { "lua", "isi-Luba-Lulua" },
            { "lun", "isi-Lunda" },
            { "luo", "isi-Luo" },
            { "lus", "isi-Mizo" },
            { "luy", "isi-Luyia" },
            { "mad", "isi-Madurese" },
            { "mag", "isi-Magahi" },
            { "mai", "isi-Maithili" },
            { "mak", "isi-Makasar" },
            { "mas", "isi-Masai" },
            { "mdf", "isi-Moksha" },
            { "men", "isi-Mende" },
            { "mer", "isi-Meru" },
            { "mfe", "isi-Morisyen" },
            { "mgh", "isi-Makhuwa-Meetto" },
            { "mgo", "isi-Meta\u2019" },
            { "mic", "isi-Micmac" },
            { "min", "isi-Minangkabau" },
            { "mni", "isi-Manipuri" },
            { "moe", "isi-Innu-aimun" },
            { "moh", "isi-Mohawk" },
            { "mos", "isi-Mossi" },
            { "mua", "isi-Mundang" },
            { "mul", "izilimi ezehlukene" },
            { "mus", "isi-Creek" },
            { "mwl", "isi-Mirandese" },
            { "myv", "isi-Erzya" },
            { "mzn", "isi-Mazanderani" },
            { "nan", "isi-Min Nan Chinese" },
            { "nap", "isi-Neapolitan" },
            { "naq", "isi-Nama" },
            { "nds", "isi-Low German" },
            { "new", "isi-Newari" },
            { "nia", "isi-Nias" },
            { "niu", "isi-Niuean" },
            { "nmg", "isi-Kwasio" },
            { "nnh", "isi-Ngiemboon" },
            { "nog", "isi-Nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "isi-Northern Sotho" },
            { "nus", "isi-Nuer" },
            { "nyn", "isi-Nyankole" },
            { "ojb", "Northwestern Ojibwa" },
            { "ojc", "isi-Central Ojibwa" },
            { "ojs", "isi-Oji-Cree" },
            { "ojw", "Western Ojibwa" },
            { "oka", "isi-Okanagan" },
            { "pag", "isi-Pangasinan" },
            { "pam", "isi-Pampanga" },
            { "pap", "isi-Papiamento" },
            { "pau", "isi-Palauan" },
            { "pcm", "isi-Nigerian Pidgin" },
            { "pis", "Pijin" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "isi-Prussian" },
            { "quc", "isi-K\u02bciche\u02bc" },
            { "rap", "isi-Rapanui" },
            { "rar", "isi-Rarotongan" },
            { "rhg", "Rohingya" },
            { "rof", "isi-Rombo" },
            { "rup", "isi-Aromanian" },
            { "rwk", "isi-Rwa" },
            { "sad", "isi-Sandawe" },
            { "sah", "i-Sakha" },
            { "saq", "isi-Samburu" },
            { "sat", "isi-Santali" },
            { "sba", "isi-Ngambay" },
            { "sbp", "isi-Sangu" },
            { "scn", "isi-Sicilian" },
            { "sco", "isi-Scots" },
            { "sdh", "i-Southern Kurdish" },
            { "seh", "isi-Sena" },
            { "ses", "isi-Koyraboro Senni" },
            { "shi", "isi-Tachelhit" },
            { "shn", "isi-Shan" },
            { "slh", "Southern Lushootseed" },
            { "sma", "isi-Southern Sami" },
            { "smj", "isi-Lule Sami" },
            { "smn", "isi-Inari Sami" },
            { "sms", "isi-Skolt Sami" },
            { "snk", "isi-Soninke" },
            { "srn", "isi-Sranan Tongo" },
            { "ssy", "isi-Saho" },
            { "str", "Straits Salish" },
            { "suk", "isi-Sukuma" },
            { "swb", "isi-Comorian" },
            { "syr", metaValue_syr },
            { "tce", "Southern Tutchone" },
            { "tem", "isi-Timne" },
            { "teo", "isi-Teso" },
            { "tet", "isi-Tetum" },
            { "tgx", "isi-Tagish" },
            { "tht", "Tahltan" },
            { "tig", "isi-Tigre" },
            { "tlh", "isi-Klingon" },
            { "tli", "Tlingit" },
            { "tok", "Toki Pona" },
            { "tpi", "isi-Tok Pisin" },
            { "trv", "isi-Taroko" },
            { "ttm", "Northern Tutchone" },
            { "tum", "isi-Tumbuka" },
            { "tvl", "isi-Tuvalu" },
            { "twq", "isi-Tasawaq" },
            { "tyv", "isi-Tuvinian" },
            { "tzm", "isi-Central Atlas Tamazight" },
            { "udm", "isi-Udmurt" },
            { "umb", "isi-Umbundu" },
            { "und", "ulimi olungaziwa" },
            { "vai", metaValue_vai },
            { "vun", "isiVunjo" },
            { "wae", "isi-Walser" },
            { "wal", "isi-Wolaytta" },
            { "war", "isi-Waray" },
            { "wbp", "isi-Warlpiri" },
            { "wuu", "isi-Wu Chinese" },
            { "xal", "isi-Kalmyk" },
            { "xog", "isi-Soga" },
            { "yav", "isi-Yangben" },
            { "ybb", "isi-Yemba" },
            { "yrl", "isi-Nheengatu" },
            { "yue", "isi-Cantonese" },
            { "zgh", "isi-Moroccan Tamazight esivamile" },
            { "zun", "isi-Zuni" },
            { "zxx", "akukho okuqukethwe kolimi" },
            { "zza", "isi-Zaza" },
            { "Adlm", "isi-Adlam" },
            { "Aghb", "isi-Caucasian Albanian" },
            { "Ahom", "isi-Ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "i-Nastaliq" },
            { "Armi", "isi-Imperial Aramaic" },
            { "Armn", "isi-Armenian" },
            { "Avst", "isi-Avestan" },
            { "Bali", metaValue_ban },
            { "Bamu", "isi-Bamum" },
            { "Bass", "isi-Bassa Vah" },
            { "Batk", "isi-Batak" },
            { "Beng", "isi-Bangla" },
            { "Bhks", "isi-Bhaiksuki" },
            { "Bopo", "isi-Bopomofo" },
            { "Brah", "isi-Brahmi" },
            { "Brai", "i-Braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "isi-Buhid" },
            { "Cakm", "isi-Chakma" },
            { "Cans", "i-Unified Canadian Aboriginal Syllabics" },
            { "Cari", "isi-Carian" },
            { "Cham", "isi-Cham" },
            { "Cher", metaValue_chr },
            { "Chrs", "isi-Chorasmian" },
            { "Copt", "isi-Coptic" },
            { "Cprt", "isi-Cypriot" },
            { "Cyrl", "isi-Cyrillic" },
            { "Deva", "isi-Devanagari" },
            { "Diak", "isi-Dives Akuru" },
            { "Dogr", "isi-Dogra" },
            { "Dsrt", "isi-Deseret" },
            { "Dupl", "isi-Duployan shorthand" },
            { "Egyp", "i-Egyptian hieroglyphs" },
            { "Elba", "isi-Elbasan" },
            { "Elym", "isi-Elymaic" },
            { "Ethi", "isi-Ethiopic" },
            { "Geor", metaValue_ka },
            { "Glag", "isi-Glagolitic" },
            { "Gong", "isi-Gunjala Gondi" },
            { "Gonm", "isi-Masaram Gondi" },
            { "Goth", "isi-Gothic" },
            { "Gran", "isi-Grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "isi-Gurmukhi" },
            { "Hanb", "isi-Hanb" },
            { "Hang", "isi-Hangul" },
            { "Hani", "isi-Han" },
            { "Hano", "isi-Hanunoo" },
            { "Hans", "enziwe lula" },
            { "Hant", "okosiko" },
            { "Hatr", "isi-Hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "isi-Hiragana" },
            { "Hluw", "isi-Anatolian Hieroglyphs" },
            { "Hmng", "isi-Pahawh Hmong" },
            { "Hmnp", "i-Nyiakeng Puachue Hmong" },
            { "Hrkt", "i-Japanese syllabaries" },
            { "Hung", "isi-Old Hungarian" },
            { "Ital", "i-Old Italic" },
            { "Jamo", "isi-Jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "isi-Kayah Li" },
            { "Kana", "isi-Katakana" },
            { "Khar", "isi-Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "isi-Khojki" },
            { "Kits", "i-Khitan small script" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "isi-Kaithi" },
            { "Lana", "isi-Lanna" },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Lepc", "isi-Lepcha" },
            { "Limb", "isi-Limbu" },
            { "Lina", "i-Linear A" },
            { "Linb", "i-Linear B" },
            { "Lisu", "isi-Fraser" },
            { "Lyci", "i-Lycian" },
            { "Lydi", "i-Lydian" },
            { "Mahj", "i-Mahajani" },
            { "Maka", "i-Makasar" },
            { "Mand", "isi-Mandaean" },
            { "Mani", "i-Manichaean" },
            { "Marc", "i-Marchen" },
            { "Medf", "i-Medefaidrin" },
            { "Mend", "i-Mende" },
            { "Merc", "i-Meroitic Cursive" },
            { "Mero", "i-Meroitic" },
            { "Mlym", metaValue_ml },
            { "Modi", "i-Modi" },
            { "Mong", metaValue_mn },
            { "Mroo", "i-Mro" },
            { "Mtei", "isi-Meitei Mayek" },
            { "Mult", "i-Multani" },
            { "Mymr", "isi-Myanmar" },
            { "Nand", "i-Nandinagari" },
            { "Narb", "i-Old North Arabian" },
            { "Nbat", "i-Nabataean" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "i-N\u00fcshu" },
            { "Ogam", "i-Ogham" },
            { "Olck", "isi-Ol Chiki" },
            { "Orkh", "i-Orkhon" },
            { "Orya", metaValue_or },
            { "Osge", "isi-Osage" },
            { "Osma", "i-Osmanya" },
            { "Palm", "i-Palmyrene" },
            { "Pauc", "i-Pau Cin Hau" },
            { "Perm", "i-Old Permic" },
            { "Phag", "i-Phags-pa" },
            { "Phli", "i-Inscriptional Pahlavi" },
            { "Phlp", "i-Psalter Pahlavi" },
            { "Phnx", "i-Phoenician" },
            { "Plrd", "isi-Pollard Phonetic" },
            { "Prti", "i-Inscriptional Parthian" },
            { "Qaag", "i-Zawgyi" },
            { "Rjng", "i-Rejang" },
            { "Rohg", "isi-Hanifi Rohingya" },
            { "Runr", "i-Runic" },
            { "Samr", "i-Samaritan" },
            { "Sarb", "i-Old South Arabian" },
            { "Saur", "isi-Saurashtra" },
            { "Sgnw", "i-SignWriting" },
            { "Shaw", "i-Shavian" },
            { "Shrd", "i-Sharada" },
            { "Sidd", "i-Siddham" },
            { "Sind", "i-Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "i-Sogdian" },
            { "Sogo", "i-Old Sogdian" },
            { "Sora", "i-Sora Sompeng" },
            { "Soyo", "i-Soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "isi-Syloti Nagri" },
            { "Syrc", metaValue_syr },
            { "Tagb", "i-Tagbanwa" },
            { "Takr", "i-Takri" },
            { "Tale", "isi-Tai Le" },
            { "Talu", "isi-New Tai Lue" },
            { "Taml", metaValue_ta },
            { "Tang", "i-Tangut" },
            { "Tavt", "isi-Tai Viet" },
            { "Telu", metaValue_te },
            { "Tfng", "isi-Tifinagh" },
            { "Tglg", "i-Tagalog" },
            { "Thaa", "isi-Thaana" },
            { "Thai", metaValue_th },
            { "Tibt", "i-Tibetan" },
            { "Tirh", "i-Tirhuta" },
            { "Ugar", "i-Ugaritic" },
            { "Vaii", metaValue_vai },
            { "Wara", "i-Varang Kshiti" },
            { "Wcho", "isi-Wancho" },
            { "Xpeo", "i-Old Persian" },
            { "Xsux", "i-Sumero-Akkadian Cuneiform" },
            { "Yezi", "i-Yezidi" },
            { "Yiii", "isi-Yi" },
            { "Zanb", "i-Zanabazar Square" },
            { "Zinh", "Okuthethwe" },
            { "Zmth", "i-Mathematical Notation" },
            { "Zsye", "i-Emoji" },
            { "Zsym", "amasimbuli" },
            { "Zxxx", "okungabhaliwe" },
            { "Zyyy", "jwayelekile" },
            { "Zzzz", "iskripthi esingaziwa" },
            { "de_AT", "isi-Austrian German" },
            { "de_CH", "Isi-Swiss High German" },
            { "en_AU", "i-Australian English" },
            { "en_CA", "i-Canadian English" },
            { "en_GB", "i-British English" },
            { "en_US", "i-American English" },
            { "es_ES", "isi-European Spanish" },
            { "es_MX", "isi-Mexican Spanish" },
            { "fa_AF", "isi-Dari" },
            { "fr_CA", "isi-Canadian French" },
            { "fr_CH", "isi-Swiss French" },
            { "nl_BE", "isi-Flemish" },
            { "pt_BR", "isi-Brazillian Portuguese" },
            { "pt_PT", "isi-European Portuguese" },
            { "ro_MD", "isi-Moldavian" },
            { "sw_CD", "isi-Congo Swahili" },
            { "%%1901", "Ubhalomagama lwase-German losiko" },
            { "%%1994", "Ubhalomagama lwase-Russia olusezingeni" },
            { "%%1996", "Ubhalomagama lwase-German lwango-1996" },
            { "ar_001", "isi-Arabic esivamile sesimanje" },
            { "es_419", "isi-Latin American Spanish" },
            { "key.ca", "Ikhalenda" },
            { "key.cf", "Ifomethi yemali" },
            { "key.co", "Uhlelo lokuhlunga" },
            { "key.cu", "Imali" },
            { "key.hc", "Umjikelezo wehora (12 vs 24" },
            { "key.lb", "I-Line Break Style" },
            { "key.ms", "Isistimu yokulinganisa" },
            { "key.nu", "Izinombolo" },
            { "key.tz", "Isikhathi Sendawo" },
            { "key.va", "Okokwehlukanisa Kwasendaweni" },
            { "nds_NL", "isi-Low Saxon" },
            { "%%ALUKU", "Ulwimi lwesi-Aluku" },
            { "%%BARLA", "Iqembu lolwomi lwesi-Barlavento lwe-Kabuverdianu" },
            { "%%BISKE", "Ulwimi lwe-San Giorgio/Bila" },
            { "%%BOONT", "i-Boontling" },
            { "%%CORNU", "i-CORNU" },
            { "%%JAUER", "i-JAUER" },
            { "%%KKCOR", "Ubhalomagama oluvamile" },
            { "%%KSCOR", "Ubhalomagama olusezingeni" },
            { "%%LIPAW", "Ulwimi lwesi-Lipovaz lase-Resian" },
            { "%%NEDIS", "Ulwimi lwesi-Natisone" },
            { "%%NJIVA", "Ulwimi lwesi-Gniva/Njiva" },
            { "%%NULIK", "i-Volap\u00fck yesimanje" },
            { "%%OSOJS", "Ulwimi lwesi-Oseacco/Osojane" },
            { "%%POSIX", "Ikhompyutha" },
            { "%%PUTER", "i-PUTER" },
            { "%%RIGIK", "I-Volap\u00fck Yakudala" },
            { "%%ROZAJ", "i-Resian" },
            { "%%RUMGR", "i-RUMGR" },
            { "%%SAAHO", "i-Saho" },
            { "%%SOLBA", "Ulwimi lwesi-Stolvizza/Solbica" },
            { "%%SOTAV", "Iqembu lolwimi lwesi-Sotavento lwe-Kabuverdianu" },
            { "%%UCCOR", "Ubhalomagama Oluhlanganisiwe" },
            { "zh_Hans", "isi-Chinese (esenziwe-lula)" },
            { "zh_Hant", "isi-Chinese (Sasendulo)" },
            { "%%AO1990", "Isivumelwano Sobhalomagama Lolwimi lesi-Portuguese sango-1990" },
            { "%%ARANES", "i-ARANES" },
            { "%%ASANTE", "i-ASANTE" },
            { "%%AUVERN", "i-AUVERN" },
            { "%%CISAUP", "i-CISAUP" },
            { "%%CREISS", "i-CREISS" },
            { "%%DAJNKO", "Uhlamvu lwe-Dajnko" },
            { "%%EKAVSK", "isi-Serbian esinokuphimisa kwe-Ekavian" },
            { "%%FONIPA", "Ifonotiki ye-IPA" },
            { "%%FONUPA", "Ifonotiki ye-UPA" },
            { "%%GASCON", "i-GASCON" },
            { "%%GRITAL", "i-GRITAL" },
            { "%%NDYUKA", "Ulwimi lwesi-Ndyuka" },
            { "%%NICARD", "i-NICARD" },
            { "%%PAMAKA", "ulwimi lwesi-Pamaka" },
            { "%%PINYIN", "i-Pinyin Romanization" },
            { "%%SCOUSE", "i-Scouse" },
            { "%%SIMPLE", "OKULULA" },
            { "%%TARASK", "Ubhalomagama lwesi-Taraskievica" },
            { "%%UCRCOR", "Ubhalomagama Olubuyekeziwe Oluhlanganisiwe" },
            { "%%ULSTER", "i-ULSTER" },
            { "%%UNIFON", "Uhlamvu lwefonotiki lwe-Unifon" },
            { "%%ABL1943", "Ukwakhiwa kobhalomagama kwango-1943" },
            { "%%AKUAPEM", "i-AKUAPEM" },
            { "%%ALALC97", "i-ALA-LC Romanization, i-edishini yango-1997" },
            { "%%BALANKA", "Ulwimi lwe-Balank lwe-Anii" },
            { "%%BAUDDHA", "i-BAUDDHA" },
            { "%%BOHORIC", "Uhlambu lwe-Bohori\u010d" },
            { "%%EMODENG", "i-English Yesimanje" },
            { "%%FONNAPA", "i-FONNAPA" },
            { "%%GRCLASS", "i-GRCLASS" },
            { "%%GRMISTR", "i-GRMISTR" },
            { "%%HEPBURN", "i-Hepburn romanization" },
            { "%%ITIHASA", "i-ITIHASA" },
            { "%%LAUKIKA", "i-LAUKIKA" },
            { "%%LEMOSIN", "i-LEMOSIN" },
            { "%%METELKO", "Uhlambu lwe-Metelko" },
            { "%%MONOTON", "i-Monotonic" },
            { "%%PAHAWH2", "i-PAHAWH2" },
            { "%%PAHAWH3", "i-PAHAWH3" },
            { "%%PAHAWH4", "i-PAHAWH4" },
            { "%%POLYTON", "i-Polytonic" },
            { "%%PROVENC", "i-PROVENC" },
            { "%%REVISED", "Ubhalomagama Olubuyekeziwe" },
            { "%%SURSILV", "i-SURSILV" },
            { "%%SUTSILV", "i-SUTSILV" },
            { "%%VAIDIKA", "i-VAIDIKA" },
            { "%%1606NICT", "Isi-French esimaphakathi kuya ku-1606" },
            { "%%1694ACAD", "isi-French Samanje" },
            { "%%1959ACAD", "Okwemfundo" },
            { "%%BAKU1926", "Uhlamvu lwesi-Turkic Latin oluhlanganisiwe" },
            { "%%BASICENG", "i-BASICENG" },
            { "%%BISCAYAN", "i-BISCAYAN" },
            { "%%BORNHOLM", "i-BORNHOLM" },
            { "%%COLB1945", "Ubhalomagama lwe-Portuguese-Brazilian lwango-1945" },
            { "%%FONKIRSH", "i-FONKIRSH" },
            { "%%FONXSAMP", "i-FONXSAMP" },
            { "%%HOGNORSK", "i-HOGNORSK" },
            { "%%HSISTEMO", "i-HSISTEMO" },
            { "%%IJEKAVSK", "Isi-Serbian esinokuphimisa kwe-Ijekavian" },
            { "%%IVANCHOV", "i-IVANCHOV" },
            { "%%JYUTPING", "i-JYUTPING" },
            { "%%KOCIEWIE", "i-KOCIEWIE" },
            { "%%LENGADOC", "i-LENGADOC" },
            { "%%LUNA1918", "i-LUNA1918" },
            { "%%NEWFOUND", "i-NEWFOUND" },
            { "%%OXENDICT", "Ukupela Kwesichazamazwi se-Oxford EnglishOxford English Dictionary spelling" },
            { "%%PETR1708", "i-PETR1708" },
            { "%%SCOTLAND", "i-English Esezingeni ye-Scotish" },
            { "%%SPANGLIS", "i-SPANGLIS" },
            { "%%SURMIRAN", "i-SURMIRAN" },
            { "%%VALENCIA", "i-Valencian" },
            { "%%VALLADER", "i-VALLADER" },
            { "%%VIVARAUP", "i-VIVARAUP" },
            { "%%WADEGILE", "i-Wade-Giles Romanization" },
            { "%%XSISTEMO", "i-XSISTEMO" },
            { "type.ca.roc", "Ikhalenda lesi-Minguo" },
            { "type.co.eor", "Imithetho Yokuhlunga ye-European" },
            { "type.hc.h11", "isistimu yamahora angu-12 (0-11)" },
            { "type.hc.h12", "isistimu yamahora angu-12 (1-12)" },
            { "type.hc.h23", "isistimu yamahora angu-24 (0-23)" },
            { "type.hc.h24", "isistimu yamahora angu-24 (1-24)" },
            { "type.m0.bgn", "I-BGN" },
            { "type.nu.ahom", "Izinombolo ze-Ahom" },
            { "type.nu.arab", "amadijithi esi-Arabic-Indic" },
            { "type.nu.armn", "izinombolo zesi-Armenian" },
            { "type.nu.bali", "Izinombolo ze-Balinese" },
            { "type.nu.beng", "izinombolo zesi-Bengali" },
            { "type.nu.brah", "Izinombolo ze-Brahmi" },
            { "type.nu.cakm", "Izinombolo ze-Chakma" },
            { "type.nu.cham", "Izinombolo ze-Cham" },
            { "type.nu.cyrl", "Izinombolo ze-Cyrillic" },
            { "type.nu.deva", "izinombolo zesi-Devanagari" },
            { "type.nu.diak", "Izinombolo ze-Dives Akuru" },
            { "type.nu.ethi", "izinombolo zesi-Ethiopic" },
            { "type.nu.geor", "izinombolo zesi-Georgian" },
            { "type.nu.gong", "Izinombolo ze-Gunjala Gondi" },
            { "type.nu.gonm", "Izinombolo ze-Masaram Gondi" },
            { "type.nu.grek", "izinombolo zesi-Greek" },
            { "type.nu.gujr", "amadijithi esi-Gujarati" },
            { "type.nu.guru", "amadijithi esi-Gurmukhi" },
            { "type.nu.hans", "izinombolo ezicacile zesi-Chinese" },
            { "type.nu.hant", "izinombolo zosiko zesi-Chinese" },
            { "type.nu.hebr", "izinombolo zesi-Hebrew" },
            { "type.nu.hmng", "Izinombolo ze-Pahawh Hmong" },
            { "type.nu.hmnp", "Izinombolo ze-Nyiakeng Puachue Hmong" },
            { "type.nu.java", "Izinombolo ze-Javanese" },
            { "type.nu.jpan", "izinombolo zesi-Japanese" },
            { "type.nu.kali", "Izinombolo ze-Kayah Li" },
            { "type.nu.khmr", "amadijithi esi-Khmer" },
            { "type.nu.knda", "amadijithi esi-Kannada" },
            { "type.nu.lana", "Izinombolo ze-Tai Tham Hora" },
            { "type.nu.laoo", "amadijithi esi-Lao" },
            { "type.nu.latn", "amadijithi ase-Western" },
            { "type.nu.lepc", "Izinombolo ze-Lepcha" },
            { "type.nu.limb", "Izinombolo ze-Limbu" },
            { "type.nu.mlym", "amadijithi esi-Malayalam" },
            { "type.nu.modi", "Izinombolo ze-Modi" },
            { "type.nu.mong", "i-Mongolian Digits" },
            { "type.nu.mroo", "Izinombolo ze-Mro" },
            { "type.nu.mtei", "Izinombolo ze-Meetei Mayek" },
            { "type.nu.mymr", "amadijithi esi-Maynmar" },
            { "type.nu.nkoo", "Izinombolo ze-N\u2019Ko" },
            { "type.nu.olck", "Izinombolo ze-Ol Chiki" },
            { "type.nu.orya", "Amadijithi ase-Odia" },
            { "type.nu.osma", "Izinombolo ze-Osmanya" },
            { "type.nu.rohg", "Izinombolo ze-Hanifi Rohingya" },
            { "type.nu.saur", "Izinombolo ze-Saurashtra" },
            { "type.nu.shrd", "Izinombolo ze-Sharada" },
            { "type.nu.sind", "Izinombolo ze-Khudawadi" },
            { "type.nu.sinh", "Izinombolo ze-Sinhala Lith" },
            { "type.nu.sora", "Izinombolo ze-Sora Sompeng" },
            { "type.nu.sund", "Izinombolo ze-Sundanese" },
            { "type.nu.takr", "Izinombolo ze-Takri" },
            { "type.nu.talu", "Izinombolo ze-New Tai Lue" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "type.nu.telu", "amadijithi esi-Telegu" },
            { "type.nu.thai", "amadijithi esi-Thai" },
            { "type.nu.tibt", "amadijithi esi-Tibetan" },
            { "type.nu.tirh", "Izinombolo ze-Tirhuta" },
            { "type.nu.vaii", "Izinhlazu Zezinombolo ze-Vai" },
            { "type.nu.wara", "Izinombolo ze-Warang Citi" },
            { "type.nu.wcho", "Izinombolo ze-Wancho" },
            { "type.ca.dangi", "Ikhalenda lesi-Dangi" },
            { "type.co.ducet", "Ukuhlunga okuzenzakalelayo kwe-Unicode" },
            { "type.co.emoji", "Uhlelo Lokuhlunga le-Emoji" },
            { "type.lb.loose", "i-Line Break Style exegayo" },
            { "type.nu.roman", "izinombolo zesi-Roman" },
            { "type.ca.coptic", "i-Coptic Calender" },
            { "type.ca.hebrew", "Ikhalenda lesi-Hebrew" },
            { "type.ca.indian", "i-Indian National Calender" },
            { "type.co.compat", "Ukuhlunga Kwangaphambilini, ngokusebenzisana" },
            { "type.co.pinyin", "Ukuhlunga nge-Pinyin" },
            { "type.co.search", "Usesho olujwayelekile" },
            { "type.co.stroke", "Ukuhlunga kwe-Stroke" },
            { "type.co.unihan", "Ukuhlunga kwe-Radical-Stroke" },
            { "type.co.zhuyin", "Ukuhlunga kwe-Zhuyin" },
            { "type.d0.fwidth", "i-Fullwidth" },
            { "type.d0.hwidth", "Ubude obuhhafu" },
            { "type.lb.normal", "i-Line Break Style ekahle" },
            { "type.lb.strict", "i-Line Break Style enomthetho oqinile" },
            { "type.m0.ungegn", "I-UNGEGN" },
            { "type.ms.metric", "isistimu ye-Metric" },
            { "type.nu.native", "Izinkinobho Zasendaweni" },
            { "type.ca.chinese", "Ikhalenda lesi-Chinese" },
            { "type.ca.islamic", "Ikhalenda lesi-Islamic" },
            { "type.ca.iso8601", "Ikhalenda le-ISO-8601" },
            { "type.ca.persian", "Ikhalenda lesi-Persian" },
            { "type.cf.account", "Ifomethi yemali ye-Accounting" },
            { "type.co.big5han", "Ukuhlunga kwe-Traditional Chinese - Big5" },
            { "type.d0.npinyin", "Okwezinombolo" },
            { "type.nu.arabext", "amadijithi esi-Arabic-Indic eluliwe" },
            { "type.nu.armnlow", "izinombolo ezincane zesi-Armenian" },
            { "type.nu.finance", "Izinombolo Zezomnotho" },
            { "type.nu.greklow", "izinombolo ezincane zesi-Greek" },
            { "type.nu.hanidec", "izinombolo zezinombolo zesi-Chinese" },
            { "type.nu.hansfin", "izinombolo ezicacile zezezimali zesi-Chinese" },
            { "type.nu.hantfin", "izinombolo zosiko zezezimali zesi-Chinese" },
            { "type.nu.jpanfin", "izinombolo zezezimali zesi-Japanese" },
            { "type.nu.mathdbl", "Izinombolo ze-Mathematical Double-Struck" },
            { "type.nu.tamldec", "amadijithi esi-Tamil" },
            { "type.ca.buddhist", "ikhalenda lesi-Buddhist" },
            { "type.ca.ethiopic", "Ikhalenda lesi-Ethiopic" },
            { "type.ca.japanese", "Ikhalenda lesi-Japanese" },
            { "type.cf.standard", "Ifomethi yemali ejwayelekile" },
            { "type.co.phonetic", "Hlela Ngokwefonetiki" },
            { "type.co.reformed", "Ukuhlunga okwenziwe kabusha" },
            { "type.co.searchjl", "Sesha nge-Hangul Ongwaqa Basekuqaleni" },
            { "type.co.standard", "I-oda yokuhlunga ejwayelekile" },
            { "type.ms.uksystem", "isistimu yokulinganisa ebusayo" },
            { "type.ms.ussystem", "isistimu yokulinganisa yase-US" },
            { "type.nu.fullwide", "ububanzi obugcwele bamadijithi" },
            { "type.nu.lanatham", "Izinombolo ze-Tai Tham Tham" },
            { "type.nu.mathbold", "Izinombolo ze-Mathematical Bold" },
            { "type.nu.mathmono", "Izinombolo ze-Mathematical Monospace" },
            { "type.nu.mathsanb", "Izinombolo ze-Mathematical Sans-Serif Bold" },
            { "type.nu.mathsans", "Izinombolo ze-Mathematical Sans-Serif" },
            { "type.nu.mymrshan", "Izinombolo ze-Myanmar Shan" },
            { "type.nu.mymrtlng", "Izinombolo ze-Myanmar Tai Laing" },
            { "type.nu.romanlow", metaValue_type_nu_taml },
            { "type.ca.gregorian", "ikhalenda lesi-Gregorian" },
            { "type.co.gb2312han", "Ukuhlunga kwe-Simplified Chinese - GB2312" },
            { "type.co.phonebook", "Ukuhlunga kwebhuku lefoni" },
            { "type.co.dictionary", "Uhlelo Lokuhlunga Lesichazamazwi" },
            { "type.co.traditional", "Ukuhlunga ngokisiko" },
            { "type.nu.traditional", "Izinombolo Ezijwayelekile" },
            { "type.ca.islamic-rgsa", "Ikhalenda yesi-Islamic (Saudi Arabia, sighting)" },
            { "type.ca.islamic-tbla", "Ikhalenda yesi-Islamic (tabular, astronomical epoch)" },
            { "type.ca.islamic-civil", "i-Islamic-Civil Calendar" },
            { "type.ca.islamic-umalqura", "Ikhalenda yesi-Islamic (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "i-Ethiopic Amete Alem Calender" },
        };
        return data;
    }
}
