/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ti extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "GMT",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Acre = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u12a3\u12ad\u122a",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u12a3\u12ad\u122a",
               "",
               "\u130d\u12dc \u12a3\u12ad\u122a",
               "",
            };
        final String[] Peru = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u1354\u1229",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u1354\u1229",
               "",
               "\u130d\u12dc \u1354\u1229",
               "",
            };
        final String[] Chile = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u127a\u120c",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u127a\u120c",
               "",
               "\u130d\u12dc \u127a\u120c",
               "",
            };
        final String[] Alaska = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u12a3\u120b\u1235\u12ab",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u12a3\u120b\u1235\u12ab",
               "",
               "\u130d\u12dc \u12a3\u120b\u1235\u12ab",
               "",
            };
        final String[] Amazon = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u12a3\u121b\u12de\u1295",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u12a3\u121b\u12de\u1295",
               "",
               "\u130d\u12dc \u12a3\u121b\u12de\u1295",
               "",
            };
        final String[] Azores = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u12a3\u12de\u1228\u1235",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u12a3\u12de\u1228\u1235",
               "",
               "\u130d\u12dc \u12a3\u12de\u1228\u1235",
               "",
            };
        final String[] Easter = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u12f0\u1234\u1275 \u134b\u1232\u12ab",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u12f0\u1234\u1275 \u134b\u1232\u12ab",
               "",
               "\u130d\u12dc \u12f0\u1234\u1275 \u134b\u1232\u12ab",
               "",
            };
        final String[] Guyana = new String[] {
               "\u130d\u12dc \u1309\u12eb\u1293",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "\u130d\u12dc \u1266\u120a\u126d\u12eb",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "\u12dd\u1270\u1233\u1290\u12e8 \u12a3\u12f5\u121b\u1233\u12ca \u130d\u12dc",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "\u130d\u12dc \u12a4\u12b3\u12f6\u122d",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u1348\u122d\u1293\u1295\u12f6 \u12f0 \u1296\u122e\u1295\u12eb",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u1348\u122d\u1293\u1295\u12f6 \u12f0 \u1296\u122e\u1295\u12eb",
               "",
               "\u130d\u12dc \u1348\u122d\u1293\u1295\u12f6 \u12f0 \u1296\u122e\u1295\u12eb",
               "",
            };
        final String[] Reunion = new String[] {
               "\u130d\u12dc \u122d\u12e9\u1295\u12e8\u1295",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u12a1\u122b\u1313\u12ed",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u12a1\u122b\u1313\u12ed",
               "",
               "\u130d\u12dc \u12a1\u122b\u1313\u12ed",
               "",
            };
        final String[] Brasilia = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u1265\u122b\u12da\u120d\u12eb",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u1265\u122b\u12da\u120d\u12eb",
               "",
               "\u130d\u12dc \u1265\u122b\u12da\u120d\u12eb",
               "",
            };
        final String[] Colombia = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u12ae\u120e\u121d\u1265\u12eb",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u12ae\u120e\u121d\u1265\u12eb",
               "",
               "\u130d\u12dc \u12ae\u120e\u121d\u1265\u12eb",
               "",
            };
        final String[] Falkland = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u12f0\u1234\u1273\u1275 \u134e\u12ad\u120b\u1295\u12f5",
               "",
               "\u130d\u12dc \u12a8\u1228\u121d\u1272 \u12f0\u1234\u1273\u1275 \u134e\u12ad\u120b\u1295\u12f5",
               "",
               "\u130d\u12dc \u12f0\u1234\u1273\u1275 \u134e\u12ad\u120b\u1295\u12f5",
               "",
            };
        final String[] Malaysia = new String[] {
               "\u130d\u12dc \u121b\u1208\u12e5\u12eb",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Paraguay = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u1353\u122b\u1313\u12ed",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u1353\u122b\u1313\u12ed",
               "",
               "\u130d\u12dc \u1353\u122b\u1313\u12ed",
               "",
            };
        final String[] Suriname = new String[] {
               "\u130d\u12dc \u1231\u122a\u1293\u121d",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u12a3\u122d\u1300\u1295\u1272\u1293",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u12a3\u122d\u1300\u1295\u1272\u1293",
               "",
               "\u130d\u12dc \u12a3\u122d\u1300\u1295\u1272\u1293",
               "",
            };
        final String[] Galapagos = new String[] {
               "\u130d\u12dc \u130b\u120b\u1353\u130e\u1235",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u121b\u12cd\u122a\u1238\u1235",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u121b\u12cd\u122a\u1238\u1235",
               "",
               "\u130d\u12dc \u121b\u12cd\u122a\u1238\u1235",
               "",
            };
        final String[] Singapore = new String[] {
               "\u130d\u12dc \u1232\u1295\u130b\u1356\u122d",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "\u130d\u12dc \u126c\u1294\u12dd\u12cc\u120b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u12ac\u1355 \u1268\u122d\u12f0",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u12ac\u1355 \u1268\u122d\u12f0",
               "",
               "\u130d\u12dc \u12ac\u1355 \u1268\u122d\u12f0",
               "",
            };
        final String[] Seychelles = new String[] {
               "\u130d\u12dc \u1232\u1238\u120d\u1235",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "\u130d\u12dc \u1205\u1295\u12f3\u12ca \u12cd\u1245\u12eb\u1296\u1235",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] French_Guiana = new String[] {
               "\u130d\u12dc \u1348\u1228\u1295\u1233\u12ca\u1275 \u130a\u12eb\u1293",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] South_Georgia = new String[] {
               "\u130d\u12dc \u12f0\u1261\u1265 \u1306\u122d\u1305\u12eb",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Central = new String[] {
               "\u130d\u12dc \u121b\u12a5\u12a8\u120b\u12ed \u12a3\u134d\u122a\u1243",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "\u130d\u12dc \u121d\u1265\u122b\u1255 \u12a3\u134d\u122a\u1243",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Western = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u121d\u12d5\u122b\u1265 \u12a3\u134d\u122a\u1243",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u121d\u12d5\u122b\u1265 \u12a3\u134d\u122a\u1243",
               "",
               "\u130d\u12dc \u121d\u12d5\u122b\u1265 \u12a3\u134d\u122a\u1243",
               "",
            };
        final String[] Europe_Central = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u121b\u12a5\u12a8\u120b\u12ed \u12a4\u12cd\u122e\u1333",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u12a4\u12cd\u122e\u1333",
               "",
               "\u130d\u12dc \u121b\u12a5\u12a8\u120b\u12ed \u12a4\u12cd\u122e\u1333",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "\u121d\u12f1\u1265 \u130d\u12dc \u121d\u1265\u122b\u1255 \u12a4\u12cd\u122e\u1333",
               "",
               "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u121d\u1265\u122b\u1255 \u12a4\u12cd\u122e\u1333",
               "",
               "\u130d\u12dc \u121d\u1265\u122b\u1255 \u12a4\u12cd\u122e\u1333",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "\u130d\u12dc \u12f0\u1261\u1265 \u12a3\u134d\u122a\u1243",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] French_Southern = new String[] {
               "\u130d\u12dc \u1348\u1228\u1295\u1233\u12ca \u12f0\u1261\u1263\u12ca \u130d\u12dd\u12a3\u1273\u1275\u1295 \u12a3\u1295\u1273\u122d\u1272\u12ad\u1295",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "\u130d\u12dc \u121b\u12a5\u12a8\u120b\u12ed \u12a2\u1295\u12f6\u1290\u12e5\u12eb",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u130d\u12dc \u121d\u1265\u122b\u1253\u12ca \u12a2\u1295\u12f6\u1290\u12e5\u12eb",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "\u130d\u12dc \u121d\u12d5\u122b\u1263\u12ca \u12a2\u1295\u12f6\u1290\u12e5\u12eb",
               "",
               "",
               "",
               "",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Anchorage", Alaska },
            { "America/Sitka", Alaska },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Europe/Bucharest", Europe_Eastern },
            { "UTC", ETC_UTC },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "CAT", Africa_Central },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "Asia/Gaza", Europe_Eastern },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Hebron", Europe_Eastern },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Kuching", Malaysia },
            { "Asia/Nicosia", Europe_Eastern },
            { "Europe/Malta", Europe_Central },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Jujuy", Argentina },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "GMT",
                    "",
                    "Irish Standard Time",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/London",
                new String[] {
                    "GMT",
                    "",
                    "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u1265\u122a\u1323\u1295\u12eb",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Bogota", Colombia },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Recife", Brasilia },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Singapore", Singapore },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "GMT",
                    "",
                    "\u130d\u12dc \u12ad\u1228\u121d\u1272 \u1265\u122a\u1323\u1295\u12eb",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Mendoza", Argentina },
            { "America/Noronha", Noronha },
            { "America/Yakutat", Alaska },
            { "Atlantic/Azores", Azores },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Asuncion", Paraguay },
            { "America/Eirunepe", Acre },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "Antarctica/Troll", GMT },
            { "Atlantic/Stanley", Falkland },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Fortaleza", Brasilia },
            { "America/Guayaquil", Ecuador },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/Porto_Velho", Amazon },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "timezone.excity.Asia/Aden", "\u12d3\u12f0\u1295" },
            { "timezone.excity.Asia/Baku", "\u1263\u12a9" },
            { "timezone.excity.Asia/Dili", "\u12f2\u120a" },
            { "timezone.excity.Asia/Gaza", "\u1253\u12db" },
            { "timezone.excity.Asia/Hovd", "\u1206\u126d\u12f5" },
            { "timezone.excity.Asia/Omsk", "\u12a6\u121d\u1235\u12ad" },
            { "timezone.excity.Asia/Oral", "\u12a6\u122b\u120d" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "timezone.excity.Asia/Amman", "\u12d3\u121b\u1295" },
            { "timezone.excity.Asia/Aqtau", "\u12a3\u12ad\u1273\u12cd" },
            { "timezone.excity.Asia/Chita", "\u127a\u1273" },
            { "timezone.excity.Asia/Dhaka", "\u12f3\u12ab" },
            { "timezone.excity.Asia/Dubai", "\u12f1\u1263\u12ed" },
            { "timezone.excity.Asia/Kabul", "\u12ab\u1261\u120d" },
            { "timezone.excity.Asia/Macau", "\u121b\u12ab\u12cd" },
            { "timezone.excity.Asia/Qatar", "\u1250\u1320\u122d" },
            { "timezone.excity.Asia/Seoul", "\u1236\u12cd\u120d" },
            { "timezone.excity.Asia/Tokyo", "\u1276\u12ad\u12ee" },
            { "timezone.excity.Asia/Tomsk", "\u1276\u121d\u1235\u12ad" },
            { "timezone.excity.Africa/Juba", "\u1301\u1263" },
            { "timezone.excity.Africa/Lome", "\u120e\u1218" },
            { "timezone.excity.Asia/Almaty", "\u12a3\u120d\u121b\u1272" },
            { "timezone.excity.Asia/Anadyr", "\u12a3\u1293\u12f2\u122d" },
            { "timezone.excity.Asia/Aqtobe", "\u12a3\u12ad\u1276\u1260" },
            { "timezone.excity.Asia/Atyrau", "\u12a3\u1272\u122b\u12cd" },
            { "timezone.excity.Asia/Beirut", "\u1260\u12ed\u1229\u1275" },
            { "timezone.excity.Asia/Brunei", "\u1265\u1229\u1290\u12ed" },
            { "timezone.excity.Asia/Hebron", "\u12ac\u1265\u122e\u1295" },
            { "timezone.excity.Asia/Kuwait", "\u12a9\u12cc\u1275" },
            { "timezone.excity.Asia/Manila", "\u121b\u1292\u120b" },
            { "timezone.excity.Asia/Muscat", "\u1219\u1235\u12ab\u1275" },
            { "timezone.excity.Asia/Riyadh", "\u122d\u12eb\u12f5" },
            { "timezone.excity.Asia/Saigon", "\u12a8\u1270\u121b \u1206 \u127a \u121a\u1295" },
            { "timezone.excity.Asia/Taipei", "\u1273\u12ed\u1350\u12ed" },
            { "timezone.excity.Asia/Tehran", "\u1270\u1205\u122b\u1295" },
            { "timezone.excity.Asia/Urumqi", "\u12a1\u1229\u121d\u12aa" },
            { "timezone.excity.Etc/Unknown", "\u12d8\u12ed\u1270\u1348\u120d\u1320 \u12a8\u1270\u121b" },
            { "timezone.excity.Europe/Kiev", "\u12ad\u12e8\u126d" },
            { "timezone.excity.Europe/Oslo", "\u12a6\u1235\u120e" },
            { "timezone.excity.Europe/Riga", "\u122a\u130b" },
            { "timezone.excity.Europe/Rome", "\u122e\u121b" },
            { "timezone.excity.Indian/Mahe", "\u121b\u1204" },
            { "timezone.excity.Africa/Accra", "\u12a3\u12ad\u122b" },
            { "timezone.excity.Africa/Cairo", "\u12ab\u12ed\u122e" },
            { "timezone.excity.Africa/Ceuta", "\u1234\u12cd\u1273" },
            { "timezone.excity.Africa/Dakar", "\u12f3\u12ab\u122d" },
            { "timezone.excity.Africa/Lagos", "\u120c\u130e\u1235" },
            { "timezone.excity.Africa/Tunis", "\u1271\u1292\u1235" },
            { "timezone.excity.America/Adak", "\u12a3\u12f3\u12ad" },
            { "timezone.excity.America/Lima", "\u120a\u121b" },
            { "timezone.excity.America/Nome", "\u1290\u12cd\u121d" },
            { "timezone.excity.Asia/Baghdad", "\u1263\u1255\u12f3\u12f5" },
            { "timezone.excity.Asia/Bahrain", "\u1263\u1215\u122c\u1295" },
            { "timezone.excity.Asia/Bangkok", "\u1263\u1295\u130d\u12ae\u12ad" },
            { "timezone.excity.Asia/Barnaul", "\u1263\u122d\u1293\u12cd\u120d" },
            { "timezone.excity.Asia/Bishkek", "\u1262\u123d\u12ac\u12ad" },
            { "timezone.excity.Asia/Colombo", "\u12ae\u120e\u121d\u1266" },
            { "timezone.excity.Asia/Irkutsk", "\u12a2\u122d\u12a9\u1275\u1235\u12ad" },
            { "timezone.excity.Asia/Jakarta", "\u1303\u12ab\u122d\u1273" },
            { "timezone.excity.Asia/Karachi", "\u12ab\u122b\u127a" },
            { "timezone.excity.Asia/Kuching", "\u12a9\u127a\u1295\u130d" },
            { "timezone.excity.Asia/Magadan", "\u121b\u130b\u12f3\u1295" },
            { "timezone.excity.Asia/Nicosia", "\u1292\u12ae\u1235\u12eb" },
            { "timezone.excity.Asia/Rangoon", "\u12eb\u1295\u130e\u1295" },
            { "timezone.excity.Asia/Tbilisi", "\u1275\u1262\u120a\u1232" },
            { "timezone.excity.Asia/Thimphu", "\u1272\u121d\u1349" },
            { "timezone.excity.Asia/Yakutsk", "\u12eb\u12a9\u1275\u1235\u12ad" },
            { "timezone.excity.Asia/Yerevan", "\u12e8\u1228\u126b\u1295" },
            { "timezone.excity.Europe/Kirov", "\u12aa\u122e\u126d" },
            { "timezone.excity.Europe/Malta", "\u121b\u120d\u1273" },
            { "timezone.excity.Europe/Minsk", "\u121a\u1295\u1235\u12ad" },
            { "timezone.excity.Europe/Paris", "\u1353\u122a\u1235" },
            { "timezone.excity.Europe/Sofia", "\u1236\u134d\u12eb" },
            { "timezone.excity.Europe/Vaduz", "\u126b\u12f1\u12dd" },
            { "timezone.excity.Indian/Cocos", "\u12ae\u12ae\u1235" },
            { "timezone.excity.Pacific/Apia", "\u12a3\u1355\u12eb" },
            { "timezone.excity.Pacific/Fiji", "\u134a\u1302" },
            { "timezone.excity.Pacific/Guam", "\u1313\u121d" },
            { "timezone.excity.Pacific/Niue", "\u1292\u12e9" },
            { "timezone.excity.Pacific/Truk", "\u1279\u12ad" },
            { "timezone.excity.Pacific/Wake", "\u12cc\u12ad" },
            { "timezone.excity.Africa/Asmera", "\u12a3\u1235\u1218\u122b" },
            { "timezone.excity.Africa/Bamako", "\u1263\u121b\u12ae" },
            { "timezone.excity.Africa/Bangui", "\u1263\u1295\u130a" },
            { "timezone.excity.Africa/Banjul", "\u1263\u1295\u1301\u120d" },
            { "timezone.excity.Africa/Bissau", "\u1262\u1233\u12cd" },
            { "timezone.excity.Africa/Douala", "\u12f1\u12cb\u120b" },
            { "timezone.excity.Africa/Harare", "\u1203\u122b\u1228" },
            { "timezone.excity.Africa/Kigali", "\u12aa\u130b\u120a" },
            { "timezone.excity.Africa/Luanda", "\u1209\u12cb\u1295\u12f3" },
            { "timezone.excity.Africa/Lusaka", "\u1209\u1233\u12ab" },
            { "timezone.excity.Africa/Malabo", "\u121b\u120b\u1266" },
            { "timezone.excity.Africa/Maputo", "\u121b\u1351\u1276" },
            { "timezone.excity.Africa/Maseru", "\u121b\u1230\u1229" },
            { "timezone.excity.Africa/Niamey", "\u1295\u12eb\u1218\u12ed" },
            { "timezone.excity.America/Aruba", "\u12a3\u1229\u1263" },
            { "timezone.excity.America/Bahia", "\u1263\u1205\u12eb" },
            { "timezone.excity.America/Belem", "\u1260\u1208\u121d" },
            { "timezone.excity.America/Boise", "\u1266\u12ed\u12da" },
            { "timezone.excity.America/Jujuy", "\u1201\u1201\u12ed" },
            { "timezone.excity.America/Sitka", "\u1232\u1275\u12ab" },
            { "timezone.excity.America/Thule", "\u12d9\u120d" },
            { "timezone.excity.Asia/Ashgabat", "\u12a3\u123d\u130b\u1263\u1275" },
            { "timezone.excity.Asia/Calcutta", "\u12ae\u120d\u12ab\u1273" },
            { "timezone.excity.Asia/Damascus", "\u12f0\u121b\u1235\u1246" },
            { "timezone.excity.Asia/Dushanbe", "\u12f1\u123b\u1295\u1260" },
            { "timezone.excity.Asia/Jayapura", "\u1303\u12eb\u1351\u122b" },
            { "timezone.excity.Asia/Katmandu", "\u12ab\u1275\u121b\u1295\u12f1" },
            { "timezone.excity.Asia/Khandyga", "\u12ab\u1295\u12f2\u130b" },
            { "timezone.excity.Asia/Makassar", "\u121b\u12ab\u1233\u122d" },
            { "timezone.excity.Asia/Qostanay", "\u12ae\u1235\u1273\u1293\u12ed" },
            { "timezone.excity.Asia/Sakhalin", "\u1233\u12ab\u120a\u1295" },
            { "timezone.excity.Asia/Shanghai", "\u123b\u1295\u130d\u1203\u12ed" },
            { "timezone.excity.Asia/Tashkent", "\u1273\u123d\u12a8\u1295\u1275" },
            { "timezone.excity.Asia/Ust-Nera", "\u12a1\u1235\u1275-\u1294\u122b" },
            { "timezone.excity.Europe/Athens", "\u12a3\u1274\u1295\u1235" },
            { "timezone.excity.Europe/Berlin", "\u1260\u122d\u120a\u1295" },
            { "timezone.excity.Europe/Dublin", "\u12f0\u1265\u120a\u1295" },
            { "timezone.excity.Europe/Jersey", "\u1300\u122d\u12da" },
            { "timezone.excity.Europe/Lisbon", "\u120a\u12dd\u1260\u1295" },
            { "timezone.excity.Europe/London", "\u120e\u1295\u12f0\u1295" },
            { "timezone.excity.Europe/Madrid", "\u121b\u12f5\u122a\u12f5" },
            { "timezone.excity.Europe/Monaco", "\u121e\u1293\u12ae" },
            { "timezone.excity.Europe/Moscow", "\u121e\u1235\u12ae" },
            { "timezone.excity.Europe/Prague", "\u1355\u122b\u130d" },
            { "timezone.excity.Europe/Samara", "\u1233\u121b\u122b" },
            { "timezone.excity.Europe/Skopje", "\u1235\u12ae\u1355\u12e8" },
            { "timezone.excity.Europe/Tirane", "\u1272\u122b\u1293" },
            { "timezone.excity.Europe/Vienna", "\u126d\u12e8\u1293" },
            { "timezone.excity.Europe/Warsaw", "\u12cb\u122d\u1233\u12cd" },
            { "timezone.excity.Europe/Zagreb", "\u12db\u130d\u1228\u1265" },
            { "timezone.excity.Europe/Zurich", "\u12d9\u122a\u12ad" },
            { "timezone.excity.Indian/Chagos", "\u127b\u130e\u1235" },
            { "timezone.excity.Indian/Comoro", "\u12ae\u121e\u122e" },
            { "timezone.excity.Pacific/Efate", "\u12a4\u134b\u1274" },
            { "timezone.excity.Pacific/Nauru", "\u1293\u12cd\u1229" },
            { "timezone.excity.Pacific/Palau", "\u1353\u120b\u12cd" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Africa/Abidjan", "\u12a3\u1262\u1303\u1295" },
            { "timezone.excity.Africa/Algiers", "\u12a3\u120d\u1300\u122d\u1235" },
            { "timezone.excity.Africa/Conakry", "\u12ae\u1293\u12ad\u122a" },
            { "timezone.excity.Africa/Kampala", "\u12ab\u121d\u1353\u120b" },
            { "timezone.excity.Africa/Mbabane", "\u121d\u1263\u1263\u1290" },
            { "timezone.excity.Africa/Nairobi", "\u1293\u12ed\u122e\u1262" },
            { "timezone.excity.Africa/Tripoli", "\u1275\u122a\u1356\u120a" },
            { "timezone.excity.America/Belize", "\u1260\u120a\u12dd" },
            { "timezone.excity.America/Bogota", "\u1266\u130e\u1273" },
            { "timezone.excity.America/Cancun", "\u12ab\u1295\u12a9\u1295" },
            { "timezone.excity.America/Cayman", "\u12ab\u12ed\u121b\u1295" },
            { "timezone.excity.America/Cuiaba", "\u12a9\u12eb\u1263" },
            { "timezone.excity.America/Dawson", "\u12f3\u12cd\u1230\u1295" },
            { "timezone.excity.America/Denver", "\u12f0\u1295\u1268\u122d" },
            { "timezone.excity.America/Guyana", "\u1309\u12eb\u1293" },
            { "timezone.excity.America/Havana", "\u1203\u126b\u1293" },
            { "timezone.excity.America/Inuvik", "\u12a2\u1291\u126a\u12ad" },
            { "timezone.excity.America/Juneau", "\u1301\u1290\u12cd" },
            { "timezone.excity.America/La_Paz", "\u120b \u1353\u12dd" },
            { "timezone.excity.America/Maceio", "\u121b\u1230\u12ee" },
            { "timezone.excity.America/Manaus", "\u121b\u1293\u12cd\u1235" },
            { "timezone.excity.America/Merida", "\u1218\u122a\u12f3" },
            { "timezone.excity.America/Nassau", "\u1293\u1233\u12cd" },
            { "timezone.excity.America/Panama", "\u1353\u1293\u121b" },
            { "timezone.excity.America/Recife", "\u1228\u1232\u1348" },
            { "timezone.excity.America/Regina", "\u1228\u1302\u1293" },
            { "timezone.excity.Asia/Famagusta", "\u134b\u121b\u1309\u1235\u1273" },
            { "timezone.excity.Asia/Hong_Kong", "\u1206\u1295\u130d \u12ae\u1295\u130d" },
            { "timezone.excity.Asia/Jerusalem", "\u12e8\u1229\u1233\u120c\u121d" },
            { "timezone.excity.Asia/Kamchatka", "\u12ab\u121d\u127b\u1275\u12ab" },
            { "timezone.excity.Asia/Pontianak", "\u1356\u1295\u1275\u12eb\u1293\u12ad" },
            { "timezone.excity.Asia/Pyongyang", "\u1355\u12ee\u1295\u130d\u12eb\u1295\u130d" },
            { "timezone.excity.Asia/Qyzylorda", "\u12aa\u12da\u120e\u122d\u12f3" },
            { "timezone.excity.Asia/Samarkand", "\u1233\u121b\u122d\u12ab\u1295\u12f5" },
            { "timezone.excity.Asia/Singapore", "\u1232\u1295\u130b\u1356\u122d" },
            { "timezone.excity.Asia/Vientiane", "\u126d\u12e8\u1295\u1275\u12eb\u1295" },
            { "timezone.excity.Europe/Andorra", "\u12a3\u1295\u12f6\u122b" },
            { "timezone.excity.Europe/Saratov", "\u1233\u122b\u1276\u126d" },
            { "timezone.excity.Europe/Tallinn", "\u1273\u120a\u1295" },
            { "timezone.excity.Europe/Vatican", "\u126b\u1272\u12ab\u1295" },
            { "timezone.excity.Europe/Vilnius", "\u126a\u120d\u1295\u12e8\u1235" },
            { "timezone.excity.Indian/Mayotte", "\u121b\u12ee\u1275" },
            { "timezone.excity.Indian/Reunion", "\u122d\u12e9\u1295\u12e8\u1295" },
            { "timezone.excity.Pacific/Easter", "\u12f0\u1234\u1275 \u134b\u1232\u12ab" },
            { "timezone.excity.Pacific/Kanton", "\u12ab\u1295\u1276\u1295" },
            { "timezone.excity.Pacific/Kosrae", "\u12ae\u1235\u122c" },
            { "timezone.excity.Pacific/Majuro", "\u121b\u1301\u122e" },
            { "timezone.excity.Pacific/Midway", "\u121a\u12f5\u12c8\u12ed" },
            { "timezone.excity.Pacific/Noumea", "\u1291\u1218\u12eb" },
            { "timezone.excity.Pacific/Ponape", "\u1356\u1295\u1350\u12ed" },
            { "timezone.excity.Pacific/Saipan", "\u1233\u12ed\u1353\u1295" },
            { "timezone.excity.Pacific/Tahiti", "\u1273\u1202\u1272" },
            { "timezone.excity.Pacific/Tarawa", "\u1273\u122b\u12cb" },
            { "timezone.excity.Pacific/Wallis", "\u12cb\u120a\u1235" },
            { "timezone.excity.Africa/Blantyre", "\u1265\u120b\u1295\u1273\u12e8\u122d" },
            { "timezone.excity.Africa/Djibouti", "\u1305\u1261\u1272" },
            { "timezone.excity.Africa/El_Aaiun", "\u12a4\u120d \u12a3\u12e9\u1295" },
            { "timezone.excity.Africa/Freetown", "\u134d\u122a\u1273\u12cd\u1295" },
            { "timezone.excity.Africa/Gaborone", "\u130b\u1266\u122e\u1295" },
            { "timezone.excity.Africa/Khartoum", "\u12ab\u122d\u1271\u121d" },
            { "timezone.excity.Africa/Kinshasa", "\u12aa\u1295\u123b\u1233" },
            { "timezone.excity.Africa/Monrovia", "\u121e\u1295\u122e\u126d\u12eb" },
            { "timezone.excity.Africa/Ndjamena", "\u1295\u1303\u1218\u1293" },
            { "timezone.excity.Africa/Sao_Tome", "\u1233\u12a6 \u1276\u1218" },
            { "timezone.excity.Africa/Windhoek", "\u12ca\u1295\u12f5\u1206\u12ad" },
            { "timezone.excity.America/Antigua", "\u12a3\u1295\u1272\u1313" },
            { "timezone.excity.America/Caracas", "\u12ab\u122b\u12ab\u1235" },
            { "timezone.excity.America/Cayenne", "\u12ab\u12e8\u1295" },
            { "timezone.excity.America/Chicago", "\u127a\u12ab\u130e" },
            { "timezone.excity.America/Cordoba", "\u12ae\u122d\u12f6\u1263" },
            { "timezone.excity.America/Creston", "\u12ad\u1228\u1235\u1270\u1295" },
            { "timezone.excity.America/Curacao", "\u12a9\u122b\u1233\u12cd" },
            { "timezone.excity.America/Detroit", "\u12f2\u1275\u122e\u12ed\u1275" },
            { "timezone.excity.America/Godthab", "\u1291\u12ad" },
            { "timezone.excity.America/Grenada", "\u130d\u1228\u1293\u12f3" },
            { "timezone.excity.America/Halifax", "\u1203\u120a\u134b\u12ad\u1235" },
            { "timezone.excity.America/Iqaluit", "\u12a2\u1243\u120d\u12ca\u1275" },
            { "timezone.excity.America/Jamaica", "\u1303\u121b\u12ed\u12ab" },
            { "timezone.excity.America/Managua", "\u121b\u1293\u1313" },
            { "timezone.excity.America/Marigot", "\u121b\u122a\u130e\u1275" },
            { "timezone.excity.America/Mendoza", "\u1218\u1295\u12f6\u12db" },
            { "timezone.excity.America/Moncton", "\u121e\u1295\u12ad\u1270\u1295" },
            { "timezone.excity.America/Nipigon", "\u1292\u1352\u130e\u1295" },
            { "timezone.excity.America/Noronha", "\u1296\u122e\u1295\u12eb" },
            { "timezone.excity.America/Ojinaga", "\u12a6\u1302\u1293\u130b" },
            { "timezone.excity.America/Phoenix", "\u134a\u1292\u12ad\u1235" },
            { "timezone.excity.America/Tijuana", "\u1272\u1305\u12cb\u1293" },
            { "timezone.excity.America/Toronto", "\u1276\u122e\u1295\u1276" },
            { "timezone.excity.America/Tortola", "\u1276\u122d\u1276\u120b" },
            { "timezone.excity.America/Yakutat", "\u12eb\u12a9\u1273\u1275" },
            { "timezone.excity.Asia/Choibalsan", "\u127e\u12ed\u1263\u120d\u1233\u1295" },
            { "timezone.excity.Asia/Phnom_Penh", "\u1355\u1296\u121d \u1350\u1295" },
            { "timezone.excity.Atlantic/Azores", "\u12a3\u12de\u1228\u1235" },
            { "timezone.excity.Atlantic/Canary", "\u12ab\u1293\u122a" },
            { "timezone.excity.Atlantic/Faeroe", "\u12f0\u1234\u1273\u1275 \u134b\u122e" },
            { "timezone.excity.Australia/Eucla", "\u12e9\u12ad\u120b" },
            { "timezone.excity.Australia/Perth", "\u1350\u122d\u12dd" },
            { "timezone.excity.Europe/Belgrade", "\u1260\u120d\u130d\u122c\u12f5" },
            { "timezone.excity.Europe/Brussels", "\u1265\u122b\u1235\u120d\u1235" },
            { "timezone.excity.Europe/Budapest", "\u1261\u12f3\u1350\u1235\u1275" },
            { "timezone.excity.Europe/Busingen", "\u1261\u1232\u1295\u1308\u1295" },
            { "timezone.excity.Europe/Chisinau", "\u12aa\u123a\u1293\u12cd" },
            { "timezone.excity.Europe/Guernsey", "\u1308\u122d\u1295\u12da" },
            { "timezone.excity.Europe/Helsinki", "\u1204\u120d\u1232\u1295\u12aa" },
            { "timezone.excity.Europe/Istanbul", "\u12a2\u1235\u1273\u1295\u1261\u120d" },
            { "timezone.excity.Europe/Sarajevo", "\u1233\u122b\u12e8\u126e" },
            { "timezone.excity.Europe/Uzhgorod", "\u12a1\u12dd\u130e\u122e\u12f5" },
            { "timezone.excity.Indian/Maldives", "\u121b\u120d\u12f2\u126d\u1235" },
            { "timezone.excity.Pacific/Chatham", "\u127b\u1273\u121d" },
            { "timezone.excity.Pacific/Fakaofo", "\u134b\u12ab\u12a6\u134e" },
            { "timezone.excity.Pacific/Gambier", "\u130b\u121d\u1265\u12e8\u122d" },
            { "timezone.excity.Pacific/Norfolk", "\u1296\u122d\u134e\u120d\u12ad" },
            { "timezone.excity.Africa/Bujumbura", "\u1261\u1301\u121d\u1261\u122b" },
            { "timezone.excity.Africa/Mogadishu", "\u121e\u1253\u12f5\u123e" },
            { "timezone.excity.America/Anguilla", "\u12a3\u1295\u1312\u120b" },
            { "timezone.excity.America/Asuncion", "\u12a3\u1231\u1295\u1235\u12ee\u1295" },
            { "timezone.excity.America/Barbados", "\u1263\u122d\u1263\u12f6\u1235" },
            { "timezone.excity.America/Dominica", "\u12f6\u121a\u1292\u12ab" },
            { "timezone.excity.America/Edmonton", "\u12a4\u12f5\u1218\u1295\u1270\u1295" },
            { "timezone.excity.America/Eirunepe", "\u12a4\u12ed\u1229\u1294\u1352" },
            { "timezone.excity.America/Mazatlan", "\u121b\u12db\u1275\u120b\u1295" },
            { "timezone.excity.America/Miquelon", "\u121a\u12a8\u120e\u1295" },
            { "timezone.excity.America/New_York", "\u1292\u12cd \u12ee\u122d\u12ad" },
            { "timezone.excity.America/Resolute", "\u1228\u12de\u1209\u1275" },
            { "timezone.excity.America/Santarem", "\u1233\u1295\u1273\u1228\u121d" },
            { "timezone.excity.America/Santiago", "\u1233\u1295\u1275\u12eb\u130e" },
            { "timezone.excity.America/St_Johns", "\u1245\u12f1\u1235 \u12ee\u1203\u1295\u1235" },
            { "timezone.excity.America/St_Kitts", "\u1245\u12f1\u1235 \u12aa\u1275\u1235" },
            { "timezone.excity.America/St_Lucia", "\u1245\u12f5\u1235\u1272 \u1209\u1235\u12eb" },
            { "timezone.excity.America/Winnipeg", "\u12ca\u1292\u1350\u130d" },
            { "timezone.excity.Antarctica/Casey", "\u12a8\u12ed\u12da" },
            { "timezone.excity.Antarctica/Davis", "\u12f0\u126a\u1235" },
            { "timezone.excity.Antarctica/Syowa", "\u1235\u12ee\u12cb" },
            { "timezone.excity.Antarctica/Troll", "\u1275\u122e\u120d" },
            { "timezone.excity.Asia/Krasnoyarsk", "\u12ad\u122b\u1235\u1296\u12eb\u122d\u1235\u12ad" },
            { "timezone.excity.Asia/Novosibirsk", "\u1296\u126e\u1232\u1262\u122d\u1235\u12ad" },
            { "timezone.excity.Asia/Ulaanbaatar", "\u12a1\u120b\u1295 \u1263\u1276\u122d" },
            { "timezone.excity.Asia/Vladivostok", "\u126d\u120b\u12f2\u126e\u1235\u1276\u12ad" },
            { "timezone.excity.Atlantic/Bermuda", "\u1260\u122d\u1219\u12f3" },
            { "timezone.excity.Atlantic/Madeira", "\u121b\u12f0\u12ed\u122b" },
            { "timezone.excity.Atlantic/Stanley", "\u1235\u1273\u1295\u120a" },
            { "timezone.excity.Australia/Currie", "\u12a9\u122a" },
            { "timezone.excity.Australia/Darwin", "\u12f3\u122d\u12ca\u1295" },
            { "timezone.excity.Australia/Hobart", "\u1206\u1263\u122d\u1275" },
            { "timezone.excity.Australia/Sydney", "\u1232\u12f5\u1292" },
            { "timezone.excity.Europe/Amsterdam", "\u12a3\u121d\u1235\u1270\u122d\u12f3\u121d" },
            { "timezone.excity.Europe/Astrakhan", "\u12a3\u1235\u1275\u122b\u12ab\u1295" },
            { "timezone.excity.Europe/Bucharest", "\u1261\u12ab\u1228\u1235\u1275" },
            { "timezone.excity.Europe/Gibraltar", "\u1302\u1265\u122b\u120d\u1273\u122d" },
            { "timezone.excity.Europe/Ljubljana", "\u120d\u12e9\u1265\u120d\u12eb\u1293" },
            { "timezone.excity.Europe/Mariehamn", "\u121b\u122a\u1203\u121d\u1295" },
            { "timezone.excity.Europe/Podgorica", "\u1356\u12f5\u130e\u122a\u133b" },
            { "timezone.excity.Europe/Stockholm", "\u1235\u1276\u12ad\u1206\u120d\u121d" },
            { "timezone.excity.Europe/Ulyanovsk", "\u12a1\u120d\u12eb\u1296\u126d\u1235\u12ad" },
            { "timezone.excity.Europe/Volgograd", "\u126e\u120d\u130e\u130d\u122b\u12f5" },
            { "timezone.excity.Indian/Christmas", "\u12ad\u122a\u1235\u121b\u1235" },
            { "timezone.excity.Indian/Kerguelen", "\u12a8\u122d\u1309\u1208\u1295" },
            { "timezone.excity.Indian/Mauritius", "\u121b\u12cd\u122a\u1238\u1235" },
            { "timezone.excity.Pacific/Auckland", "\u12a6\u12ad\u120b\u1295\u12f5" },
            { "timezone.excity.Pacific/Funafuti", "\u1349\u1293\u1349\u1272" },
            { "timezone.excity.Pacific/Honolulu", "\u1206\u1296\u1209\u1209" },
            { "timezone.excity.Pacific/Johnston", "\u1306\u1295\u1235\u1270\u1295" },
            { "timezone.excity.Pacific/Pitcairn", "\u1352\u1275\u12a8\u122d\u1295" },
            { "timezone.excity.Africa/Casablanca", "\u12ab\u12db\u1265\u120b\u1295\u12ab" },
            { "timezone.excity.Africa/Libreville", "\u120a\u1265\u1228\u126a\u120d" },
            { "timezone.excity.Africa/Lubumbashi", "\u1209\u1261\u121d\u1263\u123a" },
            { "timezone.excity.Africa/Nouakchott", "\u1295\u12cb\u12ad\u123e\u1275" },
            { "timezone.excity.Africa/Porto-Novo", "\u1356\u122d\u1276 \u1296\u126e" },
            { "timezone.excity.America/Anchorage", "\u12a3\u1295\u12ae\u1228\u1305" },
            { "timezone.excity.America/Araguaina", "\u12a3\u122b\u1313\u12ed\u1293" },
            { "timezone.excity.America/Boa_Vista", "\u1266\u12cb \u126a\u1235\u1273" },
            { "timezone.excity.America/Catamarca", "\u12ab\u1273\u121b\u122d\u12ab" },
            { "timezone.excity.America/Chihuahua", "\u127a\u12cb\u12cb" },
            { "timezone.excity.America/Fortaleza", "\u134e\u122d\u1273\u1208\u12db" },
            { "timezone.excity.America/Glace_Bay", "\u130d\u120c\u1235 \u1260\u12ed" },
            { "timezone.excity.America/Goose_Bay", "\u1309\u12dd \u1260\u12ed" },
            { "timezone.excity.America/Guatemala", "\u1313\u1272\u121b\u120b" },
            { "timezone.excity.America/Guayaquil", "\u1313\u12eb\u12aa\u120d" },
            { "timezone.excity.America/Matamoros", "\u121b\u1273\u121e\u122e\u1235" },
            { "timezone.excity.America/Menominee", "\u121c\u1296\u121a\u1292" },
            { "timezone.excity.America/Monterrey", "\u121e\u1295\u1270\u1228\u12ed" },
            { "timezone.excity.America/Sao_Paulo", "\u1233\u12a6 \u1353\u12cd\u120e" },
            { "timezone.excity.America/St_Thomas", "\u1230\u12ed\u1295\u1275 \u1276\u121b\u1235" },
            { "timezone.excity.America/Vancouver", "\u126b\u1295\u12a9\u1268\u122d" },
            { "timezone.excity.Antarctica/Mawson", "\u121b\u12cd\u1230\u1295" },
            { "timezone.excity.Antarctica/Palmer", "\u1353\u120d\u1218\u122d" },
            { "timezone.excity.Antarctica/Vostok", "\u126e\u1235\u1276\u12ad" },
            { "timezone.excity.Asia/Kuala_Lumpur", "\u12b3\u120b \u1209\u121d\u1351\u122d" },
            { "timezone.excity.Asia/Novokuznetsk", "\u1296\u126e\u12a9\u12dd\u1290\u1275\u1235\u12ad" },
            { "timezone.excity.Europe/Bratislava", "\u1265\u122b\u1272\u1235\u120b\u126b" },
            { "timezone.excity.Europe/Copenhagen", "\u12ae\u1350\u1295\u1203\u1308\u1295" },
            { "timezone.excity.Europe/Luxembourg", "\u1209\u12ad\u1230\u121d\u1260\u122d\u130d" },
            { "timezone.excity.Europe/San_Marino", "\u1233\u1295 \u121b\u122a\u1296" },
            { "timezone.excity.Europe/Simferopol", "\u1232\u121d\u1348\u122e\u1356\u120d" },
            { "timezone.excity.Europe/Zaporozhye", "\u12db\u1356\u122a\u12e5\u12eb" },
            { "timezone.excity.Pacific/Enderbury", "\u12a4\u1295\u12f0\u122d\u1260\u122a" },
            { "timezone.excity.Pacific/Galapagos", "\u130b\u120b\u1353\u130e\u1235" },
            { "timezone.excity.Pacific/Kwajalein", "\u12ad\u12cb\u1303\u120a\u1295" },
            { "timezone.excity.Pacific/Marquesas", "\u121b\u122d\u12ac\u1233\u1235" },
            { "timezone.excity.Pacific/Pago_Pago", "\u1353\u130e \u1353\u130e" },
            { "timezone.excity.Pacific/Rarotonga", "\u122b\u122e\u1276\u1295\u130b" },
            { "timezone.excity.Pacific/Tongatapu", "\u1276\u1295\u130b\u1273\u1351" },
            { "timezone.excity.Africa/Addis_Ababa", "\u12a3\u12f2\u1235 \u12a3\u1260\u1263" },
            { "timezone.excity.Africa/Brazzaville", "\u1265\u122b\u12db\u126a\u120d" },
            { "timezone.excity.Africa/Ouagadougou", "\u12cb\u130b\u12f1\u1309" },
            { "timezone.excity.America/Costa_Rica", "\u12ae\u1235\u1273 \u122a\u12ab" },
            { "timezone.excity.America/Grand_Turk", "\u130d\u122b\u1295\u12f5 \u1271\u122d\u12ad" },
            { "timezone.excity.America/Guadeloupe", "\u1313\u12f0\u1209\u1355" },
            { "timezone.excity.America/Hermosillo", "\u12a4\u122d\u121e\u1235\u12ee" },
            { "timezone.excity.America/Kralendijk", "\u12ad\u122b\u1208\u1295\u12f3\u12ed\u12ad" },
            { "timezone.excity.America/Louisville", "\u120d\u12ca\u126a\u120d" },
            { "timezone.excity.America/Martinique", "\u121b\u122d\u1272\u1292\u12ad" },
            { "timezone.excity.America/Metlakatla", "\u1218\u1275\u120b\u12ab\u1275\u120b" },
            { "timezone.excity.America/Montevideo", "\u121e\u1295\u1270\u126a\u12f0\u12ee" },
            { "timezone.excity.America/Montserrat", "\u121e\u1295\u1275\u1230\u122b\u1275" },
            { "timezone.excity.America/Paramaribo", "\u1353\u122b\u121b\u122a\u1266" },
            { "timezone.excity.America/Rio_Branco", "\u122d\u12ee \u1265\u122b\u1295\u12ae" },
            { "timezone.excity.America/St_Vincent", "\u1245\u12f1\u1235 \u126a\u1295\u1230\u1295\u1275" },
            { "timezone.excity.America/Whitehorse", "\u12cb\u12ed\u1275\u1206\u12dd" },
            { "timezone.excity.Antarctica/McMurdo", "\u121b\u12ad\u1219\u122d\u12f6" },
            { "timezone.excity.Antarctica/Rothera", "\u122e\u12d8\u122b" },
            { "timezone.excity.Asia/Srednekolymsk", "\u1235\u122c\u12f5\u1290\u12ae\u120a\u121d\u1235\u12ad" },
            { "timezone.excity.Asia/Yekaterinburg", "\u12e8\u12ab\u1270\u122a\u1295\u1260\u122d\u130d" },
            { "timezone.excity.Atlantic/Reykjavik", "\u1228\u12ed\u12ad\u12eb\u126a\u12ad" },
            { "timezone.excity.Atlantic/St_Helena", "\u1245\u12f5\u1235\u1272 \u1204\u1208\u1293" },
            { "timezone.excity.Australia/Adelaide", "\u12a3\u12f0\u1208\u12ed\u12f5" },
            { "timezone.excity.Australia/Brisbane", "\u1265\u122a\u12dd\u1264\u1295" },
            { "timezone.excity.Australia/Lindeman", "\u120a\u1295\u12f5\u121b\u1295" },
            { "timezone.excity.Europe/Isle_of_Man", "\u12a3\u12ed\u120d \u12a6\u134d \u121b\u1295" },
            { "timezone.excity.Europe/Kaliningrad", "\u12ab\u120a\u1292\u1295\u130d\u122b\u12f5" },
            { "timezone.excity.Pacific/Kiritimati", "\u12aa\u122a\u1272\u121b\u1272" },
            { "timezone.excity.Africa/Johannesburg", "\u1306\u1203\u1295\u1235\u1260\u122d\u130d" },
            { "timezone.excity.America/El_Salvador", "\u12a4\u120d \u1233\u120d\u126b\u12f6\u122d" },
            { "timezone.excity.America/Fort_Nelson", "\u134e\u122d\u1275 \u1290\u120d\u1230\u1295" },
            { "timezone.excity.America/Los_Angeles", "\u120e\u1235 \u12a3\u1295\u1300\u1208\u1235" },
            { "timezone.excity.America/Mexico_City", "\u12a8\u1270\u121b \u121c\u12ad\u1232\u12ae" },
            { "timezone.excity.America/Pangnirtung", "\u1353\u1295\u130d\u1292\u122d\u1270\u1295\u130d" },
            { "timezone.excity.America/Porto_Velho", "\u1356\u122d\u1276 \u1268\u120d\u12ee" },
            { "timezone.excity.America/Puerto_Rico", "\u1356\u122d\u1276 \u122a\u12ae" },
            { "timezone.excity.America/Rainy_River", "\u1228\u12ed\u1292 \u122a\u1268\u122d" },
            { "timezone.excity.America/Tegucigalpa", "\u1270\u1309\u1232\u130b\u120d\u1353" },
            { "timezone.excity.America/Thunder_Bay", "\u12db\u1295\u12f0\u122d \u1260\u12ed" },
            { "timezone.excity.America/Yellowknife", "\u12e8\u1208\u12cd\u1293\u12ed\u134d" },
            { "timezone.excity.Arctic/Longyearbyen", "\u120e\u1295\u130d\u12e8\u122d\u1263\u12e8\u1295" },
            { "timezone.excity.Atlantic/Cape_Verde", "\u12ac\u1355 \u1268\u122d\u12f0" },
            { "timezone.excity.Australia/Lord_Howe", "\u120e\u122d\u12f5 \u1203\u12cd" },
            { "timezone.excity.Australia/Melbourne", "\u1218\u120d\u1260\u122d\u1295" },
            { "timezone.excity.Indian/Antananarivo", "\u12a3\u1295\u1273\u1293\u1293\u122a\u126e" },
            { "timezone.excity.Pacific/Guadalcanal", "\u1313\u12f3\u120d\u12ab\u1293\u120d" },
            { "timezone.excity.Africa/Dar_es_Salaam", "\u12f3\u122d \u12a4\u1235 \u1233\u120b\u121d" },
            { "timezone.excity.America/Blanc-Sablon", "\u1265\u120b\u1295\u12ad-\u1233\u1265\u120e\u1295" },
            { "timezone.excity.America/Buenos_Aires", "\u1265\u12c8\u1296\u1235 \u12a3\u12ed\u1228\u1235" },
            { "timezone.excity.America/Campo_Grande", "\u12ab\u121d\u1356 \u130d\u122b\u1295\u12f0" },
            { "timezone.excity.America/Danmarkshavn", "\u12f3\u1295\u121b\u122d\u12ad\u123b\u126d\u1295" },
            { "timezone.excity.America/Dawson_Creek", "\u12f3\u12cd\u1230\u1295 \u12ad\u122a\u12ad" },
            { "timezone.excity.America/Indiana/Knox", "\u1296\u12ad\u1235\u1363 \u12a2\u1295\u12f5\u12eb\u1293" },
            { "timezone.excity.America/Indianapolis", "\u12a2\u1295\u12f5\u12eb\u1293\u1356\u120a\u1235" },
            { "timezone.excity.America/Punta_Arenas", "\u1351\u1295\u1273 \u12a3\u1228\u1293\u1235" },
            { "timezone.excity.America/Rankin_Inlet", "\u122b\u1295\u12aa\u1295 \u12a2\u1295\u1208\u1275" },
            { "timezone.excity.America/Scoresbysund", "\u12a2\u1276\u1246\u122d\u1276\u121a\u1275" },
            { "timezone.excity.Antarctica/Macquarie", "\u121b\u12b3\u122a" },
            { "timezone.excity.Pacific/Bougainville", "\u1261\u1308\u1295\u126a\u120d" },
            { "timezone.excity.Pacific/Port_Moresby", "\u1356\u122d\u1275 \u121e\u122d\u1235\u1262" },
            { "timezone.excity.America/Cambridge_Bay", "\u12ab\u121d\u1265\u122a\u1305 \u1260\u12ed" },
            { "timezone.excity.America/Coral_Harbour", "\u12a3\u1272\u12ae\u12ab\u1295" },
            { "timezone.excity.America/Indiana/Vevay", "\u126a\u126a\u1363 \u12a2\u1295\u12f5\u12eb\u1293" },
            { "timezone.excity.America/Lower_Princes", "\u1208\u12c8\u122d \u1355\u122a\u1295\u1230\u1235 \u12b3\u122d\u1270\u122d" },
            { "timezone.excity.America/Port_of_Spain", "\u1356\u122d\u1275 \u12a6\u134d \u1235\u1354\u1295" },
            { "timezone.excity.America/Santo_Domingo", "\u1233\u1295\u1276 \u12f6\u121a\u1295\u130e" },
            { "timezone.excity.America/St_Barthelemy", "\u1245\u12f1\u1235 \u1263\u122d\u1270\u1208\u121a" },
            { "timezone.excity.America/Swift_Current", "\u1235\u12ca\u134d\u1275 \u12ab\u1228\u1295\u1275" },
            { "timezone.excity.Australia/Broken_Hill", "\u1265\u122e\u12ad\u1295 \u1202\u120d" },
            { "timezone.excity.America/Bahia_Banderas", "\u1263\u12a5\u12eb \u12f0 \u1263\u1295\u12f0\u122b\u1235" },
            { "timezone.excity.America/Port-au-Prince", "\u1356\u122d\u1275-\u12a6-\u1355\u122a\u1295\u1235" },
            { "timezone.excity.Atlantic/South_Georgia", "\u12f0\u1261\u1265 \u1306\u122d\u1305\u12eb" },
            { "timezone.excity.America/Argentina/Salta", "\u1233\u120d\u1273" },
            { "timezone.excity.America/Indiana/Marengo", "\u121b\u1228\u1295\u130e\u1363 \u12a2\u1295\u12f5\u12eb\u1293" },
            { "timezone.excity.America/Indiana/Winamac", "\u12ca\u1293\u121b\u12ad\u1363 \u12a2\u1295\u12f5\u12eb\u1293" },
            { "timezone.excity.America/Argentina/Tucuman", "\u1271\u12a9\u121b\u1295" },
            { "timezone.excity.America/Argentina/Ushuaia", "\u12a1\u123d\u12cb\u12eb" },
            { "timezone.excity.America/Indiana/Tell_City", "\u1270\u120d \u1232\u1272\u1363 \u12a2\u1295\u12f5\u12eb\u1293" },
            { "timezone.excity.America/Indiana/Vincennes", "\u126a\u1295\u1230\u1295\u1235\u1363 \u12a2\u1295\u12f5\u12eb\u1293" },
            { "timezone.excity.Antarctica/DumontDUrville", "\u12f1\u121e\u1295\u1275 \u12f2\u12a1\u122d\u126a\u120d" },
            { "timezone.excity.America/Argentina/La_Rioja", "\u120b \u122d\u12ee\u1203" },
            { "timezone.excity.America/Argentina/San_Juan", "\u1233\u1295 \u1205\u12cb\u1295" },
            { "timezone.excity.America/Argentina/San_Luis", "\u1233\u1295 \u120d\u12ca\u1235" },
            { "timezone.excity.America/Indiana/Petersburg", "\u1352\u1270\u122d\u1235\u1260\u122d\u130d\u1363 \u12a2\u1295\u12f5\u12eb\u1293" },
            { "timezone.excity.America/Kentucky/Monticello", "\u121e\u1295\u1272\u1278\u120e\u1363 \u12a8\u1295\u1273\u12aa" },
            { "timezone.excity.America/North_Dakota/Beulah", "\u1265\u12e9\u120b\u1363 \u1230\u121c\u1295 \u12f3\u12ae\u1273" },
            { "timezone.excity.America/North_Dakota/Center", "\u1230\u1295\u1270\u122d\u1363 \u1230\u121c\u1295 \u12f3\u12ae\u1273" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "\u122d\u12ee \u130b\u12e8\u130e\u1235" },
            { "timezone.excity.America/North_Dakota/New_Salem", "\u1292\u12cd \u1233\u1208\u121d\u1363 \u1230\u121c\u1295 \u12f3\u12ae\u1273" },
        };
        return data;
    }
}
