/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sw_KE extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "Kibangla";
        final String metaValue_km = "Kikhema";
        final String metaValue_nqo = "Kiin\u2019ko";
        final String metaValue_or = "Kiodia";
        final String metaValue_su = "Kisundani";
        final String metaValue_syr = "Kisiria";
        final Object[][] data = new Object[][] {
            { "001", "dunia" },
            { "011", "Afrika Magharibi" },
            { "014", "Afrika Mashariki" },
            { "015", "Afrika Kaskazini" },
            { "030", "Asia Mashariki" },
            { "034", "Asia Kusini" },
            { "035", "Kusini Mashariki mwa Asia" },
            { "039", "Ulaya Kusini" },
            { "057", "Maikronesia" },
            { "061", "Polinesia" },
            { "145", "Asia Magharibi" },
            { "151", "Ulaya Mashariki" },
            { "154", "Ulaya Kaskazini" },
            { "155", "Ulaya Magharibi" },
            { "202", "Kusini mwa Jangwa la Sahara" },
            { "AF", "Afghanistani" },
            { "AG", "Antigua na Babuda" },
            { "AI", "Anguila" },
            { "AQ", "Antaktika" },
            { "AZ", "Azabajani" },
            { "BB", "Babados" },
            { "BJ", "Benini" },
            { "BS", "Bahamas" },
            { "BT", "Bhutani" },
            { "BY", "Belarusi" },
            { "CC", "Visiwa vya Kokos (Keeling)" },
            { "CD", "Kongo - Kinshasa" },
            { "CV", "Kepuvede" },
            { "CW", "Kurakao" },
            { "EA", "Keuta na Melilla" },
            { "EC", "Ekwado" },
            { "GA", "Gaboni" },
            { "GP", "Gwadelupe" },
            { "GS", "Visiwa vya Jojia Kusini na Sandwich Kusini" },
            { "GT", "Gwatemala" },
            { "GU", "Guami" },
            { "HR", "Kroashia" },
            { "IO", "Himaya ya Uingereza katika Bahari Hindi" },
            { "JO", "Yordani" },
            { "LA", "Laosi" },
            { "LB", "Lebanoni" },
            { "LI", "Lishenteni" },
            { "LS", "Lesotho" },
            { "LU", "Lasembagi" },
            { "LV", "Lativia" },
            { "MA", "Moroko" },
            { "MC", "Monako" },
            { "MK", "Masedonia" },
            { "MM", "Myama (Burma)" },
            { "MS", "Montserati" },
            { "NC", "Nyukaledonia" },
            { "NE", "Nijeri" },
            { "NO", "Norwe" },
            { "NP", "Nepali" },
            { "OM", "Omani" },
            { "PF", "Polinesia ya Ufaransa" },
            { "PG", "Papua Guinea Mpya" },
            { "PL", "Polandi" },
            { "PM", "St. Pierre na Miquelon" },
            { "PR", "Pwetoriko" },
            { "PS", "Himaya za Palestina" },
            { "PY", "Paragwai" },
            { "QA", "Katari" },
            { "QO", "Eneo la Oceania" },
            { "SG", "Singapuri" },
            { "ST", "Sao Tome na Prinsipe" },
            { "SV", "Elsalvado" },
            { "SY", "Shamu" },
            { "TD", "Chadi" },
            { "TH", "Thailandi" },
            { "TM", "Turukimenstani" },
            { "TW", "Taiwani" },
            { "UA", "Ukreni" },
            { "UY", "Urugwai" },
            { "VA", "Mji wa Vatikani" },
            { "VG", "Visiwa vya Virgin vya Uingereza" },
            { "VI", "Visiwa vya Virgin vya Marekani" },
            { "XA", "Lafudhi za Kigeni" },
            { "XB", "Lugha Bandia" },
            { "YT", "Mayote" },
            { "ZZ", "Eneo Lisilojulikana" },
            { "az", "Kiazabaijani" },
            { "bn", metaValue_bn },
            { "ce", "Kichechen" },
            { "ch", "Kichamoro" },
            { "cu", "Kislovakia cha Kanisa la Jadi" },
            { "cy", "Kiwels" },
            { "ff", "Kifula" },
            { "fo", "Kifaro" },
            { "fy", "Kifrisi cha Magharibi" },
            { "gv", "Kimaniksi" },
            { "hr", "Kikroeshia" },
            { "ht", "Kikrioli cha Haiti" },
            { "ia", "Lugha ya kimataifa" },
            { "ig", "Kiibo" },
            { "ii", "Kiiyi cha Sichuan" },
            { "is", "Kiaisilandi" },
            { "kj", "Kikuanyama" },
            { "kk", "Kikazaki" },
            { "km", metaValue_km },
            { "kw", "Kikoni" },
            { "ky", "Kikirigizi" },
            { "li", "Kilimbugi" },
            { "mh", "Kimashali" },
            { "mk", "Kimasedonia" },
            { "ml", "Kimalayalam" },
            { "my", "Kibama" },
            { "nr", "Kindebele cha Kusini" },
            { "oc", "Kiositia" },
            { "or", metaValue_or },
            { "rm", "Kirumi" },
            { "sc", "Kisadini" },
            { "st", "Kisotho cha Kusini" },
            { "su", metaValue_su },
            { "tn", "Kiswana" },
            { "ts", "Kisonga" },
            { "tw", "Kitwi" },
            { "ug", "Kiuiguri" },
            { "uk", "Kiukreni" },
            { "wa", "Kiwaluni" },
            { "wo", "Kiwolof" },
            { "xh", "Kikhosa" },
            { "yi", "Kiyidi" },
            { "alt", "Kialtai cha Kusini" },
            { "arq", "Kiarabu cha Aljeria" },
            { "atj", "Kiatikameku" },
            { "ban", "Kibalini" },
            { "bho", "Kibojpuri" },
            { "ceb", "Kisebuano" },
            { "chk", "Kichuuki" },
            { "chr", "Kicheroki" },
            { "ckb", "Kikurdi cha Kati" },
            { "clc", "Kichilkotini" },
            { "crg", "Kimichif" },
            { "crk", "Kikrii cha Chini" },
            { "crm", "Kimoosekrii" },
            { "crr", "Kialgiki cha Carolina" },
            { "csw", "Kikrii cha Kinamasi" },
            { "dje", "Kizama" },
            { "frr", "Kifrisi cha Kaskazini" },
            { "fur", "Kifriuli" },
            { "gaa", "Kiga" },
            { "gez", "Kigiiz" },
            { "gil", "Kigilbert" },
            { "grc", "Kigiriki cha Kale" },
            { "gwi", "Kigwich\u02bcin" },
            { "haw", "Kihawaii" },
            { "hsb", "Kisorbia cha Juu" },
            { "hup", "Kihupa" },
            { "hur", "Kihalkomelem" },
            { "ikt", "Kiinuktitut cha Kanada Magharibi" },
            { "ilo", "Kiiloko" },
            { "inh", "Kiingushi" },
            { "jbo", "Kilojbani" },
            { "kac", "Kikachini" },
            { "kbd", "Kikabadi" },
            { "kea", "Kikabuvedi" },
            { "khq", "Kikoyrachiini" },
            { "kkj", "Kikako" },
            { "koi", "Kikomipermyak" },
            { "kpe", "Kikpele" },
            { "krc", "Kikarachaybalka" },
            { "krl", "Kakareli" },
            { "kru", "Kikuruki" },
            { "ksb", "Kisambala" },
            { "ksh", "Kikolon" },
            { "kum", "Kikumyk" },
            { "lag", "Kilangi" },
            { "lam", "Kilamba" },
            { "lez", "Kilezighi" },
            { "luy", "Kiluyia" },
            { "mak", "Kimakasaa" },
            { "mas", "Kimasai" },
            { "mdf", "Kimoksha" },
            { "mfe", "Kimorisi" },
            { "mic", "Kimi'kmak" },
            { "moh", "Kimohok" },
            { "mos", "Kimosi" },
            { "mus", "Kimuskogii" },
            { "mwl", "Kimiranda" },
            { "nds", "Kijerumani cha Chini" },
            { "nnh", "Kiingiemboon" },
            { "nqo", metaValue_nqo },
            { "ojc", "Kiojibwa cha Kati" },
            { "pag", "Kipangasini" },
            { "pcm", "Kipijini cha Naijeria" },
            { "rwk", "Kirwa" },
            { "sba", "Kingambei" },
            { "scn", "Kisisilia" },
            { "ses", "Kikoyraborosenni" },
            { "shn", "Kishani" },
            { "shu", "Kiarabu cha Chadi" },
            { "slh", "Kilushootseed cha Kusini" },
            { "srn", "Kisranantongo" },
            { "str", "Kisali cha Straits" },
            { "swb", "Kikomoro" },
            { "syr", metaValue_syr },
            { "tce", "Kituchone cha Kusini" },
            { "tem", "Kitimne" },
            { "tgx", "Kitagi" },
            { "tht", "Kitahlti" },
            { "tok", "Kitokipona" },
            { "ttm", "Kituchone cha Kaskazini" },
            { "tzm", "Kitamazight cha Atlas ya Kati" },
            { "udm", "Kiudumurti" },
            { "umb", "Kiumbundu" },
            { "wae", "Kiwalsa" },
            { "wal", "Kiwolaitta" },
            { "war", "Kiwarai" },
            { "yav", "Kiyangbeni" },
            { "zgh", "Kitamazight cha Kawaida cha Moroko" },
            { "Beng", metaValue_bn },
            { "Brai", "Breli" },
            { "Cans", "Silabi za Asili Zilizounganishwa za Kanada" },
            { "Cher", "Kicherokii" },
            { "Cyrl", "Kikrili" },
            { "Ethi", "Kihabeshi" },
            { "Hanb", "Kihan chenye Kibopomofo" },
            { "Hans", "Kilichorahisishwa" },
            { "Hira", "Kihiragana" },
            { "Hrkt", "Silabi za Kijapani" },
            { "Jamo", "Kijamo" },
            { "Khmr", metaValue_km },
            { "Mtei", "Kimeiteimayek" },
            { "Mymr", "Kimyanma" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "Kiolchiki" },
            { "Orya", metaValue_or },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", "Kitamili" },
            { "Yiii", "Kiiyi" },
            { "Zmth", "Mwandiko wa kihisabati" },
            { "de_AT", "Kijerumani cha Austria" },
            { "de_CH", "Kijerumani cha Kawaida cha Uswisi" },
            { "en_AU", "Kiingereza cha Australia" },
            { "en_CA", "Kiingereza cha Kanada" },
            { "en_GB", "Kiingereza cha Uingereza" },
            { "en_US", "Kiingereza cha Marekani" },
            { "es_ES", "Kihispania cha Ulaya" },
            { "es_MX", "Kihispania cha Meksiko" },
            { "fa_AF", "Kidari" },
            { "fr_CA", "Kifaransa cha Kanada" },
            { "fr_CH", "Kifaransa cha Uswisi" },
            { "pt_BR", "Kireno cha Brazili" },
            { "pt_PT", "Kireno cha Ulaya" },
            { "sw_CD", "Kiswahili cha Kongo" },
            { "es_419", "Kihispania cha Amerika Kusini" },
            { "key.hc", "Kipindi cha saa (12 dhidi ya 24)" },
            { "key.va", "Tofauti ya Lugha" },
            { "zh_Hans", "Kichina Kilichorahisishwa" },
            { "zh_Hant", "Kichina cha Kawaida" },
            { "type.nu.ethi", "Nambari za Kihabeshi" },
            { "type.nu.geor", "Nambari za Kijiojia" },
            { "type.nu.hebr", "Nambari za Kihibrania" },
            { "type.nu.mlym", "Nambari za Kimalayalam" },
            { "type.nu.mymr", "Nambari za Kimyama" },
            { "type.ca.dangi", "Kalenda ya Kidangi" },
            { "type.ca.hebrew", "Kalenda ya kihibrania" },
            { "type.nu.tamldec", "Nambari za Kitamili" },
            { "type.ca.ethiopic", "Kalenda ya Kihabeshi" },
        };
        return data;
    }
}
