/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_uz extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arab";
        final String metaValue_bn = "bengal";
        final String metaValue_bo = "tibet";
        final String metaValue_el = "grek";
        final String metaValue_gu = "gujarot";
        final String metaValue_he = "ivrit";
        final String metaValue_hy = "arman";
        final String metaValue_ja = "yapon";
        final String metaValue_kn = "kannada";
        final String metaValue_lo = "laos";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongol";
        final String metaValue_or = "oriya";
        final String metaValue_si = "singal";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tay";
        final String metaValue_zh = "xitoy";
        final Object[][] data = new Object[][] {
            { "ksh", "kyoln" },
            { "mwl", "miranda" },
            { "Zsym", "belgilar" },
            { "Zsye", "emoji" },
            { "ccp", "chakma" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "AC", "Me\u2019roj oroli" },
            { "rar", "rarotongan" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Birlashgan Arab Amirliklari" },
            { "nl_BE", "flamand" },
            { "AF", "Afg\u02bboniston" },
            { "AG", "Antigua va Barbuda" },
            { "type.ca.ethiopic", "habash taqvimi" },
            { "AI", "Angilya" },
            { "AL", "Albaniya" },
            { "AM", "Armaniston" },
            { "AO", "Angola" },
            { "AQ", "Antarktida" },
            { "AR", "Argentina" },
            { "AS", "Amerika Samoasi" },
            { "AT", "Avstriya" },
            { "AU", "Avstraliya" },
            { "AW", "Aruba" },
            { "en_US", "ingliz (Amerika)" },
            { "AX", "Aland orollari" },
            { "AZ", "Ozarbayjon" },
            { "BA", "Bosniya va Gertsegovina" },
            { "BB", "Barbados" },
            { "ceb", "sebuan" },
            { "BD", "Bangladesh" },
            { "kum", "qo\u2018miq" },
            { "BE", "Belgiya" },
            { "BF", "Burkina-Faso" },
            { "BG", "Bolgariya" },
            { "BH", "Bahrayn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sen-Bartelemi" },
            { "BM", "Bermuda orollari" },
            { "myv", "erzya" },
            { "BN", "Bruney" },
            { "BO", "Boliviya" },
            { "BQ", "Boneyr, Sint-Estatius va Saba" },
            { "BR", "Braziliya" },
            { "BS", "Bagama orollari" },
            { "xog", "soga" },
            { "BT", "Butan" },
            { "BV", "Buve oroli" },
            { "BW", "Botsvana" },
            { "BY", "Belarus" },
            { "BZ", "Beliz" },
            { "type.ca.persian", "fors taqvimi" },
            { "type.nu.hebr", "ivrit raqamlari" },
            { "CA", "Kanada" },
            { "CC", "Kokos (Kiling) orollari" },
            { "mzn", "mozandaron" },
            { "CD", "Kongo \u2013 Kinshasa" },
            { "CF", "Markaziy Afrika Respublikasi" },
            { "CG", "Kongo \u2013 Brazzavil" },
            { "CH", "Shveytsariya" },
            { "CI", "Kot-d\u2019Ivuar" },
            { "CK", "Kuk orollari" },
            { "CL", "Chili" },
            { "CM", "Kamerun" },
            { "CN", "Xitoy" },
            { "CO", "Kolumbiya" },
            { "CP", "Klipperton oroli" },
            { "CR", "Kosta-Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabo-Verde" },
            { "CW", "Kyurasao" },
            { "CX", "Rojdestvo oroli" },
            { "CY", "Kipr" },
            { "CZ", "Chexiya" },
            { "eka", "ekajuk" },
            { "DE", "Germaniya" },
            { "ace", "achin" },
            { "cgg", "chiga" },
            { "DG", "Diyego-Garsiya" },
            { "type.nu.deva", "devanagari raqamlari" },
            { "DJ", "Jibuti" },
            { "DK", "Daniya" },
            { "Brai", "brayl" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "arman kichik raqamlari" },
            { "DO", "Dominikan Respublikasi" },
            { "gor", "gorontalo" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "DZ", "Jazoir" },
            { "pag", "pangasinan" },
            { "EA", "Seuta va Melilya" },
            { "pam", "pampanga" },
            { "EC", "Ekvador" },
            { "pap", "papiyamento" },
            { "ada", "adangme" },
            { "EE", "Estoniya" },
            { "EG", "Misr" },
            { "EH", "G\u2018arbiy Sahroi Kabir" },
            { "pau", "palau" },
            { "chk", "chukot" },
            { "chm", "mari" },
            { "cho", "choktav" },
            { "chr", "cheroki" },
            { "ER", "Eritreya" },
            { "ES", "Ispaniya" },
            { "ET", "Efiopiya" },
            { "EU", "Yevropa Ittifoqi" },
            { "type.ca.gregorian", "grigorian taqvimi" },
            { "EZ", "Yevrozona" },
            { "chy", "cheyenn" },
            { "type.nu.gujr", "gujarot raqamlari" },
            { "ady", "adigey" },
            { "FI", "Finlandiya" },
            { "FJ", "Fiji" },
            { "FK", "Folklend orollari" },
            { "FM", "Mikroneziya" },
            { "FO", "Farer orollari" },
            { "Taml", metaValue_ta },
            { "FR", "Fransiya" },
            { "GA", "Gabon" },
            { "GB", "Buyuk Britaniya" },
            { "pcm", "kreol (Nigeriya)" },
            { "GD", "Grenada" },
            { "GE", "Gruziya" },
            { "GF", "Fransuz Gvianasi" },
            { "GG", "Gernsi" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Grenlandiya" },
            { "GM", "Gambiya" },
            { "GN", "Gvineya" },
            { "GP", "Gvadelupe" },
            { "GQ", "Ekvatorial Gvineya" },
            { "GR", "Gretsiya" },
            { "GS", "Janubiy Georgiya va Janubiy Sendvich orollari" },
            { "GT", "Gvatemala" },
            { "GU", "Guam" },
            { "GW", "Gvineya-Bisau" },
            { "rhg", "rohinja" },
            { "tlh", "klingon" },
            { "GY", "Gayana" },
            { "ckb", "sorani-kurd" },
            { "zxx", "til tarkibi yo\u2018q" },
            { "de_AT", "nemis (Avstriya)" },
            { "HK", "Gonkong (Xitoy MMH)" },
            { "HM", "Xerd va Makdonald orollari" },
            { "HN", "Gonduras" },
            { "HR", "Xorvatiya" },
            { "agq", "agem" },
            { "gsw", "nemis (Shveytsariya)" },
            { "HT", "Gaiti" },
            { "HU", "Vengriya" },
            { "IC", "Kanar orollari" },
            { "ID", "Indoneziya" },
            { "IE", "Irlandiya" },
            { "nap", "neapolitan" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "IL", "Isroil" },
            { "IM", "Men oroli" },
            { "IN", "Hindiston" },
            { "IO", "Britaniyaning Hind okeanidagi hududi" },
            { "IQ", "Iroq" },
            { "IR", "Eron" },
            { "IS", "Islandiya" },
            { "IT", "Italiya" },
            { "Zmth", "matematik ifodalar" },
            { "type.nu.thai", "tay raqamlari" },
            { "type.nu.beng", "bengal raqamlari" },
            { "JE", "Jersi" },
            { "type.ca.islamic", "islomiy taqvim" },
            { "Beng", metaValue_bn },
            { "JM", "Yamayka" },
            { "JO", "Iordaniya" },
            { "JP", "Yaponiya" },
            { "ain", "aynu" },
            { "guz", "gusii" },
            { "type.nu.knda", "kannada raqamlari" },
            { "de_CH", "yuqori nemis (Shveytsariya)" },
            { "type.ca.buddhist", "buddizm taqvimi" },
            { "KE", "Keniya" },
            { "419", "Lotin Amerikasi" },
            { "KG", "Qirg\u02bbiziston" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komor orollari" },
            { "Knda", metaValue_kn },
            { "KN", "Sent-Kits va Nevis" },
            { "fr_CA", "fransuz (Kanada)" },
            { "KP", "Shimoliy Koreya" },
            { "KR", "Janubiy Koreya" },
            { "fr_CH", "fransuz (Shveytsariya)" },
            { "KW", "Quvayt" },
            { "tpi", "tok-piksin" },
            { "KY", "Kayman orollari" },
            { "KZ", "Qozog\u02bbiston" },
            { "Cyrl", "kirill" },
            { "LA", "Laos" },
            { "LB", "Livan" },
            { "LC", "Sent-Lyusiya" },
            { "gwi", "gvichin" },
            { "nds", "quyi nemis" },
            { "LI", "Lixtenshteyn" },
            { "LK", "Shri-Lanka" },
            { "LR", "Liberiya" },
            { "LS", "Lesoto" },
            { "LT", "Litva" },
            { "LU", "Lyuksemburg" },
            { "LV", "Latviya" },
            { "Kana", "katakana" },
            { "LY", "Liviya" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lag", "langi" },
            { "Thaa", "taana" },
            { "MA", "Marokash" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Chernogoriya" },
            { "MF", "Sent-Martin" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshall orollari" },
            { "ale", "aleut" },
            { "MK", "Shimoliy Makedoniya" },
            { "ML", "Mali" },
            { "MM", "Myanma (Birma)" },
            { "MN", "Mongoliya" },
            { "new", "nevar" },
            { "MO", "Makao (Xitoy MMH)" },
            { "MP", "Shimoliy Mariana orollari" },
            { "MQ", "Martinika" },
            { "MR", "Mavritaniya" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mavrikiy" },
            { "alt", "janubiy oltoy" },
            { "MV", "Maldiv orollari" },
            { "MW", "Malavi" },
            { "MX", "Meksika" },
            { "type.ca.japanese", "yapon taqvimi" },
            { "MY", "Malayziya" },
            { "MZ", "Mozambik" },
            { "NA", "Namibiya" },
            { "202", "Sahro janubidagi Afrika" },
            { "type.ca.hebrew", "yahudiy taqvimi" },
            { "NC", "Yangi Kaledoniya" },
            { "NE", "Niger" },
            { "NF", "Norfolk oroli" },
            { "NG", "Nigeriya" },
            { "trv", "taroko" },
            { "NI", "Nikaragua" },
            { "NL", "Niderlandiya" },
            { "NO", "Norvegiya" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "NZ", "Yangi Zelandiya" },
            { "OM", "Ummon" },
            { "anp", "angika" },
            { "crs", "kreol (Seyshel)" },
            { "PA", "Panama" },
            { "en_GB", "ingliz (Britaniya)" },
            { "PE", "Peru" },
            { "PF", "Fransuz Polineziyasi" },
            { "PG", "Papua \u2013 Yangi Gvineya" },
            { "PH", "Filippin" },
            { "PK", "Pokiston" },
            { "PL", "Polsha" },
            { "ewo", "evondo" },
            { "PM", "Sen-Pyer va Mikelon" },
            { "PN", "Pitkern orollari" },
            { "PR", "Puerto-Riko" },
            { "PS", "Falastin hududlari" },
            { "PT", "Portugaliya" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "kichik grek raqamlari" },
            { "PY", "Paragvay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "niu", "niue" },
            { "QO", "Tashqi Okeaniya" },
            { "lez", "lezgin" },
            { "tvl", "tuvalu" },
            { "001", "Dunyo" },
            { "002", "Afrika" },
            { "003", "Shimoliy Amerika" },
            { "RE", "Reyunion" },
            { "005", "Janubiy Amerika" },
            { "jbo", "lojban" },
            { "009", "Okeaniya" },
            { "RO", "Ruminiya" },
            { "RS", "Serbiya" },
            { "RU", "Rossiya" },
            { "RW", "Ruanda" },
            { "SA", "Saudiya Arabistoni" },
            { "SB", "Solomon orollari" },
            { "twq", "tasavak" },
            { "011", "G\u2018arbiy Afrika" },
            { "SC", "Seyshel orollari" },
            { "SD", "Sudan" },
            { "013", "Markaziy Amerika" },
            { "SE", "Shvetsiya" },
            { "014", "Sharqiy Afrika" },
            { "015", "Shimoliy Afrika" },
            { "SG", "Singapur" },
            { "SH", "Muqaddas Yelena oroli" },
            { "type.lb.strict", "qatorni qat\u2019iy uzish" },
            { "017", "Markaziy Afrika" },
            { "SI", "Sloveniya" },
            { "018", "Janubiy Afrika" },
            { "SJ", "Shpitsbergen va Yan-Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakiya" },
            { "SL", "Syerra-Leone" },
            { "SM", "San-Marino" },
            { "SN", "Senegal" },
            { "SO", "Somali" },
            { "arn", "mapuche" },
            { "arp", "arapaxo" },
            { "type.nu.taml", "an\u2019anaviy tamil raqamlari" },
            { "SR", "Surinam" },
            { "SS", "Janubiy Sudan" },
            { "ST", "San-Tome va Prinsipi" },
            { "SV", "Salvador" },
            { "SX", "Sint-Marten" },
            { "SY", "Suriya" },
            { "SZ", "Svazilend" },
            { "TA", "Tristan-da-Kunya" },
            { "asa", "asu" },
            { "type.ms.ussystem", "AQSH o\u2018lchov tizimi" },
            { "021", "Shimoliy Amerika \u2013 AQSH va Kanada" },
            { "TC", "Turks va Kaykos orollari" },
            { "yav", "yangben" },
            { "TD", "Chad" },
            { "TF", "Fransuz Janubiy hududlari" },
            { "TG", "Togo" },
            { "TH", "Tailand" },
            { "TJ", "Tojikiston" },
            { "029", "Karib havzasi" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "yemba" },
            { "TM", "Turkmaniston" },
            { "TN", "Tunis" },
            { "TO", "Tonga" },
            { "TR", "Turkiya" },
            { "TT", "Trinidad va Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tayvan" },
            { "ast", "asturiy" },
            { "TZ", "Tanzaniya" },
            { "nmg", "kvasio" },
            { "Zzzz", "noma\u2019lum yozuv" },
            { "UA", "Ukraina" },
            { "rup", "arumin" },
            { "030", "Sharqiy Osiyo" },
            { "tyv", "tuva" },
            { "sw_CD", "suaxili (Kongo)" },
            { "034", "Janubiy Osiyo" },
            { "035", "Janubi-sharqiy Osiyo" },
            { "UG", "Uganda" },
            { "039", "Janubiy Yevropa" },
            { "Sinh", metaValue_si },
            { "UM", "AQSH yondosh orollari" },
            { "UN", "Birlashgan Millatlar Tashkiloti" },
            { "US", "Amerika Qo\u2018shma Shtatlari" },
            { "haw", "gavaycha" },
            { "UY", "Urugvay" },
            { "prg", "pruss" },
            { "UZ", "O\u02bbzbekiston" },
            { "tzm", "markaziy atlas tamazigxt" },
            { "nnh", "ngiyembun" },
            { "VA", "Vatikan" },
            { "VC", "Sent-Vinsent va Grenadin" },
            { "VE", "Venesuela" },
            { "VG", "Britaniya Virgin orollari" },
            { "VI", "AQSH Virgin orollari" },
            { "VN", "Vyetnam" },
            { "VU", "Vanuatu" },
            { "nog", "no\u2018g\u2018ay" },
            { "rwk", "ruanda" },
            { "053", "Avstralaziya" },
            { "054", "Melaneziya" },
            { "WF", "Uollis va Futuna" },
            { "057", "Mikroneziya mintaqasi" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "wae", "valis" },
            { "WS", "Samoa" },
            { "wal", "volamo" },
            { "XA", "Qalbaki urg\u2018u" },
            { "war", "varay" },
            { "XB", "Qalbaki Bidi" },
            { "awa", "avadxi" },
            { "061", "Polineziya" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "yozuvsiz" },
            { "wbp", "valbiri" },
            { "YE", "Yaman" },
            { "nqo", "nko" },
            { "type.co.standard", "standart saralash tartibi" },
            { "YT", "Mayotta" },
            { "ZA", "Janubiy Afrika Respublikasi" },
            { "type.lb.loose", "qatorni yumshoq uzish" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "gruzin raqamlari" },
            { "Hira", "hiragana" },
            { "ZM", "Zambiya" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Noma\u2019lum mintaqa" },
            { "type.ms.metric", "metrik tizim" },
            { "type.ca.iso8601", "ISO-8601 taqvimi" },
            { "nso", "shimoliy soto" },
            { "type.nu.telu", "telugu raqamlari" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "type.nu.hansfin", "soddalashgan xitoy raqamlari (moliyaviy)" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "kengaytirilgan arab-hind raqamlari" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "to\u2018liq enli raqamlar" },
            { "dar", "dargva" },
            { "dav", "taita" },
            { "lrc", "shimoliy luri" },
            { "udm", "udmurt" },
            { "Khmr", "kxmer" },
            { "sad", "sandave" },
            { "type.nu.roman", "rim raqamlari" },
            { "sah", "saxa" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "Guru", "gurmukxi" },
            { "lua", "luba-lulua" },
            { "sbp", "sangu" },
            { "nyn", "nyankole" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "fil", "filipincha" },
            { "hmn", "xmong" },
            { "lus", "lushay" },
            { "ban", "bali" },
            { "luy", "luhya" },
            { "bas", "basa" },
            { "es_ES", "ispan (Yevropa)" },
            { "sco", "shotland" },
            { "scn", "sitsiliya" },
            { "aa", "afar" },
            { "ab", "abxaz" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amxar" },
            { "Arab", metaValue_ar },
            { "an", "aragon" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana yoki hiragana" },
            { "as", "assam" },
            { "av", "avar" },
            { "sdh", "janubiy kurd" },
            { "ay", "aymara" },
            { "az", "ozarbayjon" },
            { "ba", "boshqird" },
            { "be", "belarus" },
            { "bg", "bolgar" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "breton" },
            { "bs", "bosniy" },
            { "Mymr", "myanma" },
            { "type.nu.laoo", "laos raqamlari" },
            { "seh", "sena" },
            { "ca", "katalan" },
            { "ses", "koyraboro-senni" },
            { "ce", "chechen" },
            { "ch", "chamorro" },
            { "co", "korsikan" },
            { "Orya", metaValue_or },
            { "cs", "chex" },
            { "cu", "slavyan (cherkov)" },
            { "cv", "chuvash" },
            { "cy", "valliy" },
            { "type.nu.ethi", "habash raqamlari" },
            { "da", "dan" },
            { "pt_PT", "portugal (Yevropa)" },
            { "de", "nemischa" },
            { "type.cf.standard", "standart valyuta formati" },
            { "bem", "bemba" },
            { "dv", "divexi" },
            { "es_419", "ispan (Lotin Amerikasi)" },
            { "dz", "dzongka" },
            { "bez", "bena" },
            { "type.ca.chinese", "xitoy taqvimi" },
            { "dje", "zarma" },
            { "type.nu.grek", "grek raqamlari" },
            { "ee", "eve" },
            { "type.lb.normal", "qatorni odatiy uzish" },
            { "ro_MD", "moldovan" },
            { "el", metaValue_el },
            { "en", "inglizcha" },
            { "eo", "esperanto" },
            { "es", "ispancha" },
            { "et", "estoncha" },
            { "Hanb", "hanb" },
            { "eu", "bask" },
            { "Hang", "hangul" },
            { "shi", "tashelxit" },
            { "Hani", metaValue_zh },
            { "hsb", "yuqori sorb" },
            { "shn", "shan" },
            { "fa", "fors" },
            { "Hans", "soddalashgan xitoy" },
            { "type.nu.latn", "zamonaviy arab raqamlari" },
            { "Hant", "an\u2019anaviy xitoy" },
            { "ff", "fula" },
            { "fi", "fincha" },
            { "fj", "fiji" },
            { "fon", "fon" },
            { "bgn", "g\u2018arbiy baluj" },
            { "yue", "kanton" },
            { "fo", "farercha" },
            { "umb", "umbundu" },
            { "fr", "fransuzcha" },
            { "fy", "g\u2018arbiy friz" },
            { "ga", "irland" },
            { "gd", "shotland-gel" },
            { "gl", "galisiy" },
            { "gn", "guarani" },
            { "bho", "bxojpuri" },
            { "und", "noma\u2019lum til" },
            { "gu", metaValue_gu },
            { "gv", "men" },
            { "ha", "xausa" },
            { "he", metaValue_he },
            { "hi", "hind" },
            { "hup", "xupa" },
            { "bin", "bini" },
            { "hr", "xorvat" },
            { "ht", "gaityan" },
            { "hu", "venger" },
            { "hy", metaValue_hy },
            { "hz", "gerero" },
            { "ia", "interlingva" },
            { "Jamo", "jamo" },
            { "id", "indonez" },
            { "type.nu.tibt", "tibet raqamlari" },
            { "ig", "igbo" },
            { "ii", "sichuan" },
            { "io", "ido" },
            { "is", "island" },
            { "it", "italyan" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "doi", "dogri" },
            { "sma", "janubiy saam" },
            { "jv", "yavan" },
            { "mad", "madur" },
            { "smj", "lule-saam" },
            { "mag", "magahi" },
            { "mai", "maythili" },
            { "smn", "inari-saam" },
            { "ka", "gruzincha" },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "sms", "skolt-saam" },
            { "ki", "kikuyu" },
            { "mas", "masay" },
            { "kj", "kvanyama" },
            { "kk", "qozoqcha" },
            { "kl", "grenland" },
            { "km", "xmer" },
            { "kn", metaValue_kn },
            { "ko", "koreyscha" },
            { "kr", "kanuri" },
            { "ks", "kashmircha" },
            { "ku", "kurdcha" },
            { "kv", "komi" },
            { "kw", "korn" },
            { "ky", "qirg\u02bbizcha" },
            { "snk", "soninke" },
            { "la", "lotincha" },
            { "lb", "lyuksemburgcha" },
            { "type.nu.mlym", "malayalam raqamlari" },
            { "lg", "ganda" },
            { "li", "limburg" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friul" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Britaniya o\u2018lchov tizimi" },
            { "lt", "litva" },
            { "lu", "luba-katanga" },
            { "lv", "latishcha" },
            { "mg", "malagasiy" },
            { "mh", "marshall" },
            { "type.co.ducet", "standart Unicode saralash tartibi" },
            { "mi", "maori" },
            { "mk", "makedon" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "maratxi" },
            { "ms", "malay" },
            { "mt", "maltiy" },
            { "my", "birman" },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "dsb", "quyi sorb" },
            { "na", "nauru" },
            { "type.co.search", "qidiruv" },
            { "nb", "norveg-bokmal" },
            { "nd", "shimoliy ndebele" },
            { "ne", "nepal" },
            { "ng", "ndonga" },
            { "nl", "niderland" },
            { "nn", "norveg-nyunorsk" },
            { "no", "norveg" },
            { "nr", "janubiy ndebel" },
            { "nv", "navaxo" },
            { "ny", "cheva" },
            { "kac", "kachin" },
            { "kab", "kabil" },
            { "oc", "oksitan" },
            { "kaj", "kaji" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "mer", "meru" },
            { "type.nu.armn", "arman raqamlari" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osetin" },
            { "kbd", "kabardin" },
            { "mfe", "morisyen" },
            { "srn", "sranan-tongo" },
            { "pa", "panjobcha" },
            { "dua", "duala" },
            { "pl", "polyakcha" },
            { "type.ca.dangi", "dangi taqvimi" },
            { "ps", "pushtu" },
            { "pt", "portugalcha" },
            { "key.co", "saralash tartibi" },
            { "pt_BR", "portugal (Braziliya)" },
            { "kcg", "tyap" },
            { "mgh", "maxuva-mitto" },
            { "key.cf", "valyuta formati" },
            { "key.ca", "taqvim" },
            { "Laoo", metaValue_lo },
            { "mgo", "meta" },
            { "type.hc.h23", "24 soatlik tizim (0\u201323)" },
            { "type.hc.h24", "24 soatlik tizim (1\u201324)" },
            { "ssy", "saho" },
            { "type.nu.mymr", "birma raqamlari" },
            { "qu", "kechua" },
            { "brx", "bodo" },
            { "kde", "makonde" },
            { "Ethi", "habash" },
            { "type.hc.h12", "12 soatlik tizim (1\u201312)" },
            { "type.hc.h11", "12 soatlik tizim (0\u201311)" },
            { "rm", "romansh" },
            { "rn", "rundi" },
            { "key.cu", "valyuta" },
            { "ro", "rumincha" },
            { "type.nu.orya", "oriya raqamlari" },
            { "type.nu.hanidec", "xitoy o\u2018nli raqamlari" },
            { "ru", "ruscha" },
            { "rw", "kinyaruanda" },
            { "kea", "kabuverdianu" },
            { "mic", "mikmak" },
            { "suk", "sukuma" },
            { "en_AU", "ingliz (Avstraliya)" },
            { "sa", "sanskrit" },
            { "sc", "sardin" },
            { "sd", "sindhi" },
            { "se", "shimoliy saam" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "si", metaValue_si },
            { "sk", "slovakcha" },
            { "sl", "slovencha" },
            { "sm", "samoa" },
            { "sn", "shona" },
            { "so", "somalicha" },
            { "type.nu.arab", "arab-hind raqamlari" },
            { "sq", "alban" },
            { "sr", "serbcha" },
            { "ss", "svati" },
            { "type.cf.account", "moliyaviy valyuta formati" },
            { "st", "janubiy soto" },
            { "su", "sundan" },
            { "sv", "shved" },
            { "sw", "suaxili" },
            { "type.nu.hantfin", "an\u2019anaviy xitoy raqamlari (moliyaviy)" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Osiyo" },
            { "143", "Markaziy Osiyo" },
            { "te", metaValue_te },
            { "145", "G\u2018arbiy Osiyo" },
            { "tg", "tojik" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "bug", "bugi" },
            { "kfo", "koro" },
            { "en_CA", "ingliz (Kanada)" },
            { "tk", "turkman" },
            { "tn", "tsvana" },
            { "to", "tongan" },
            { "dyo", "diola-fogni" },
            { "type.nu.jpan", "yapon raqamlari" },
            { "tr", "turk" },
            { "ts", "tsonga" },
            { "swb", "qamar" },
            { "tt", "tatar" },
            { "ty", "taiti" },
            { "150", "Yevropa" },
            { "151", "Sharqiy Yevropa" },
            { "154", "Shimoliy Yevropa" },
            { "dzg", "dazag" },
            { "155", "G\u2018arbiy Yevropa" },
            { "ug", "uyg\u2018ur" },
            { "Kore", "koreys" },
            { "Zyyy", "umumiy" },
            { "uk", "ukrain" },
            { "ur", "urdu" },
            { "xal", "qalmoq" },
            { "uz", "o\u2018zbek" },
            { "kha", "kxasi" },
            { "nds_NL", "quyi sakson" },
            { "ve", "venda" },
            { "type.ca.roc", "Mingo taqvimi" },
            { "vi", "vyetnam" },
            { "khq", "koyra-chiini" },
            { "key.hc", "soat tizimi (12 yoki 24)" },
            { "vo", "volapyuk" },
            { "quc", "kiche" },
            { "gaa", "ga" },
            { "wa", "vallon" },
            { "gag", "gagauz" },
            { "syr", "suriyacha" },
            { "Grek", metaValue_el },
            { "gan", "gan" },
            { "wo", "volof" },
            { "zgh", "tamazigxt" },
            { "ar_001", "standart arab" },
            { "Mong", metaValue_mn },
            { "mni", "manipur" },
            { "Latn", "lotin" },
            { "type.nu.hans", "soddalashgan xitoy raqamlari" },
            { "type.nu.hant", "an\u2019anaviy xitoy raqamlari" },
            { "xh", "kxosa" },
            { "type.nu.romanlow", "kichik rim raqamlari" },
            { "byn", "blin" },
            { "moh", "mohauk" },
            { "kkj", "kako" },
            { "yi", "idish" },
            { "mos", "mossi" },
            { "yo", "yoruba" },
            { "es_MX", "ispan (Meksika)" },
            { "vai", "vai" },
            { "kln", "kalenjin" },
            { "zh", metaValue_zh },
            { "Bopo", "bopomofo" },
            { "key.lb", "qatorni uzish uslubi" },
            { "zu", "zulu" },
            { "Geor", "gruzin" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "yapon raqamlari (moliyaviy)" },
            { "gez", "geez" },
            { "ebu", "embu" },
            { "zh_Hans", "xitoy (soddalashgan)" },
            { "koi", "komi-permyak" },
            { "kok", "konkan" },
            { "zh_Hant", "xitoy (an\u2019anaviy)" },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "kxmer raqamlari" },
            { "ilo", "iloko" },
            { "mua", "mundang" },
            { "type.nu.guru", "gurmukxi raqamlari" },
            { "mul", "bir nechta til" },
            { "key.ms", "o\u2018lchov tizimi" },
            { "mus", "krik" },
            { "gil", "gilbert" },
            { "type.nu.tamldec", "tamil raqamlari" },
            { "krc", "qorachoy-bolqor" },
            { "inh", "ingush" },
            { "fa_AF", "dari" },
            { "krl", "karel" },
            { "efi", "efik" },
            { "key.nu", "raqamlar" },
            { "kru", "kurux" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafiya" },
        };
        return data;
    }
}
