/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ka extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AUD", "AUD" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "CNY", "CNY" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "\u20be" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HKD", "HKD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "ILS", "ILS" },
            { "INR", "INR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "JPY", "JPY" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KRW", "KRW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MRU", "MRU" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "NZD", "NZD" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "STN", "STN" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "THB" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VES", "VES" },
            { "VND", "VND" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMK", "ZMK" },
            { "ZMW", "ZMW" },
            { "adp", "\u10d0\u10dc\u10d3\u10dd\u10e0\u10e3\u10da\u10d8 \u10de\u10d4\u10e1\u10d4\u10e2\u10d0" },
            { "aed", "\u10d0\u10e0\u10d0\u10d1\u10d7\u10d0 \u10d2\u10d0\u10d4\u10e0\u10d7\u10d8\u10d0\u10dc\u10d4\u10d1\u10e3\u10da\u10d8 \u10e1\u10d0\u10d0\u10db\u10d8\u10e0\u10dd\u10d4\u10d1\u10d8\u10e1 \u10d3\u10d8\u10e0\u10f0\u10d0\u10db\u10d8" },
            { "afa", "\u10d0\u10d5\u10e6\u10d0\u10dc\u10d8 (1927\u20132002)" },
            { "afn", "\u10d0\u10d5\u10e6\u10d0\u10dc\u10e3\u10e0\u10d8 \u10d0\u10d5\u10e6\u10d0\u10dc\u10d8" },
            { "all", "\u10d0\u10da\u10d1\u10d0\u10dc\u10e3\u10e0\u10d8 \u10da\u10d4\u10d9\u10d8" },
            { "amd", "\u10e1\u10dd\u10db\u10ee\u10e3\u10e0\u10d8 \u10d3\u10e0\u10d0\u10db\u10d8" },
            { "ang", "\u10dc\u10d8\u10d3\u10d4\u10e0\u10da\u10d0\u10dc\u10d3\u10d4\u10d1\u10d8\u10e1 \u10d0\u10dc\u10e2\u10d8\u10da\u10d4\u10d1\u10d8\u10e1 \u10d2\u10e3\u10da\u10d3\u10d4\u10dc\u10d8" },
            { "aoa", "\u10d0\u10dc\u10d2\u10dd\u10da\u10e3\u10e0\u10d8 \u10d9\u10d5\u10d0\u10dc\u10d6\u10d0" },
            { "aok", "\u10d0\u10dc\u10d2\u10dd\u10da\u10e3\u10e0\u10d8 \u10d9\u10d5\u10d0\u10dc\u10d6\u10d0 (1977\u20131990)" },
            { "aon", "\u10d0\u10dc\u10d2\u10dd\u10da\u10e3\u10e0\u10d8 \u10d0\u10ee\u10d0\u10da\u10d8 \u10d9\u10d5\u10d0\u10dc\u10d6\u10d0 (1990\u20132000)" },
            { "aor", "\u10d0\u10dc\u10d2\u10dd\u10da\u10e3\u10e0\u10d8 \u10db\u10d8\u10e2\u10dd\u10da\u10d4\u10d1\u10e3\u10da\u10d8 \u10d9\u10d5\u10d0\u10dc\u10d6\u10d0 (1995\u20131999)" },
            { "ara", "\u10d0\u10e0\u10d2\u10d4\u10dc\u10e2\u10d8\u10dc\u10e3\u10da\u10d8 \u10d0\u10e3\u10e1\u10e2\u10e0\u10d0\u10da\u10d8" },
            { "arp", "\u10d0\u10e0\u10d2\u10d4\u10dc\u10e2\u10d8\u10dc\u10e3\u10da\u10d8 \u10de\u10d4\u10e1\u10dd (1983\u20131985)" },
            { "ars", "\u10d0\u10e0\u10d2\u10d4\u10dc\u10e2\u10d8\u10dc\u10e3\u10da\u10d8 \u10de\u10d4\u10e1\u10dd" },
            { "ats", "\u10d0\u10d5\u10e1\u10e2\u10e0\u10d8\u10e3\u10da\u10d8 \u10e8\u10d8\u10da\u10d8\u10dc\u10d2\u10d8" },
            { "aud", "\u10d0\u10d5\u10e1\u10e2\u10e0\u10d0\u10da\u10d8\u10e3\u10e0\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "awg", "\u10d0\u10e0\u10e3\u10d1\u10d0\u10dc\u10e3\u10da\u10d8 \u10d2\u10e3\u10da\u10d3\u10d4\u10dc\u10d8" },
            { "azm", "\u10d0\u10d6\u10d4\u10e0\u10d1\u10d0\u10d8\u10ef\u10d0\u10dc\u10e3\u10da\u10d8 \u10db\u10d0\u10dc\u10d0\u10d7\u10d8 (1993\u20132006)" },
            { "azn", "\u10d0\u10d6\u10d4\u10e0\u10d1\u10d0\u10d8\u10ef\u10d0\u10dc\u10e3\u10da\u10d8 \u10db\u10d0\u10dc\u10d0\u10d7\u10d8" },
            { "bad", "\u10d1\u10dd\u10e1\u10dc\u10d8\u10d0-\u10f0\u10d4\u10e0\u10ea\u10dd\u10d2\u10dd\u10d5\u10d8\u10dc\u10d0\u10e1 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "bam", "\u10d1\u10dd\u10e1\u10dc\u10d8\u10d0 \u10d3\u10d0 \u10f0\u10d4\u10e0\u10ea\u10dd\u10d2\u10dd\u10d5\u10d8\u10dc\u10d0\u10e1 \u10d9\u10dd\u10dc\u10d5\u10d4\u10e0\u10e2\u10d8\u10e0\u10d4\u10d1\u10d0\u10d3\u10d8 \u10db\u10d0\u10e0\u10d9\u10d0" },
            { "bbd", "\u10d1\u10d0\u10e0\u10d1\u10d0\u10d3\u10dd\u10e1\u10e3\u10da\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "bdt", "\u10d1\u10d0\u10dc\u10d2\u10da\u10d0\u10d3\u10d4\u10e8\u10e3\u10e0\u10d8 \u10e2\u10d0\u10d9\u10d0" },
            { "bec", "\u10d1\u10d4\u10da\u10d2\u10d8\u10e3\u10e0\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8 (\u10d9\u10dd\u10d5\u10d4\u10e0\u10e2\u10d8\u10e0\u10d4\u10d1\u10d0\u10d3\u10d8)" },
            { "bef", "\u10d1\u10d4\u10da\u10d2\u10d8\u10e3\u10e0\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "bel", "\u10d1\u10d4\u10da\u10d2\u10d8\u10e3\u10e0\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8 (\u10e4\u10d8\u10dc\u10d0\u10dc\u10e1\u10e3\u10e0\u10d8)" },
            { "bgl", "\u10d1\u10e3\u10da\u10d2\u10d0\u10e0\u10e3\u10da\u10d8 \u10db\u10e7\u10d0\u10e0\u10d8 \u10da\u10d4\u10d5\u10d8" },
            { "bgn", "\u10d1\u10e3\u10da\u10d2\u10d0\u10e0\u10e3\u10da\u10d8 \u10da\u10d4\u10d5\u10d8" },
            { "bhd", "\u10d1\u10d0\u10f0\u10e0\u10d4\u10d8\u10dc\u10e3\u10da\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "bif", "\u10d1\u10e3\u10e0\u10e3\u10dc\u10d3\u10d8\u10e3\u10da\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "bmd", "\u10d1\u10d4\u10e0\u10db\u10e3\u10d3\u10e3\u10da\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "bnd", "\u10d1\u10e0\u10e3\u10dc\u10d4\u10e3\u10da\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "bob", "\u10d1\u10dd\u10da\u10d8\u10d5\u10d8\u10e3\u10e0\u10d8 \u10d1\u10dd\u10da\u10d8\u10d5\u10d8\u10d0\u10dc\u10dd" },
            { "bop", "\u10d1\u10dd\u10da\u10d8\u10d5\u10d8\u10e3\u10e0\u10d8 \u10de\u10d4\u10e1\u10dd" },
            { "brb", "\u10d1\u10e0\u10d0\u10d6\u10d8\u10da\u10d8\u10e3\u10e0\u10d8 \u10d9\u10e0\u10e3\u10d6\u10d4\u10d8\u10e0\u10dd \u10dc\u10dd\u10d5\u10dd (1967\u20131986)" },
            { "brc", "\u10d1\u10e0\u10d0\u10d6\u10d8\u10da\u10d8\u10e3\u10e0\u10d8 \u10d9\u10e0\u10e3\u10d6\u10d0\u10d3\u10dd" },
            { "bre", "\u10d1\u10e0\u10d0\u10d6\u10d8\u10da\u10d8\u10e3\u10e0\u10d8 \u10d9\u10e0\u10e3\u10d6\u10d4\u10d8\u10e0\u10dd (1990\u20131993)" },
            { "brl", "\u10d1\u10e0\u10d0\u10d6\u10d8\u10da\u10d8\u10e3\u10e0\u10d8 \u10e0\u10d4\u10d0\u10da\u10d8" },
            { "brn", "\u10d1\u10e0\u10d0\u10d6\u10d8\u10da\u10d8\u10e3\u10e0\u10d8 \u10d9\u10e0\u10e3\u10d6\u10d0\u10d3\u10dd \u10dc\u10dd\u10d5\u10dd" },
            { "brr", "\u10d1\u10e0\u10d0\u10d6\u10d8\u10da\u10d8\u10e3\u10e0\u10d8 \u10d9\u10e0\u10e3\u10d6\u10d4\u10d8\u10e0\u10dd" },
            { "bsd", "\u10d1\u10d0\u10f0\u10d0\u10db\u10e3\u10e0\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "btn", "\u10d1\u10e3\u10e2\u10d0\u10dc\u10e3\u10e0\u10d8 \u10dc\u10d2\u10e3\u10da\u10e2\u10e0\u10e3\u10db\u10d8" },
            { "bwp", "\u10d1\u10dd\u10ea\u10d5\u10d0\u10dc\u10e3\u10e0\u10d8 \u10de\u10e3\u10da\u10d0" },
            { "byb", "\u10d0\u10ee\u10d0\u10da\u10d8 \u10d1\u10d4\u10da\u10d0\u10e0\u10e3\u10e1\u10d8\u10e3\u10da\u10d8 \u10e0\u10e3\u10d1\u10da\u10d8 (1994\u20131999)" },
            { "byn", "\u10d1\u10d4\u10da\u10dd\u10e0\u10e3\u10e1\u10e3\u10da\u10d8 \u10e0\u10e3\u10d1\u10da\u10d8" },
            { "byr", "\u10d1\u10d4\u10da\u10dd\u10e0\u10e3\u10e1\u10e3\u10da\u10d8 \u10e0\u10e3\u10d1\u10da\u10d8 (2000\u20132016)" },
            { "bzd", "\u10d1\u10d4\u10da\u10d8\u10d6\u10d8\u10e1 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "cad", "\u10d9\u10d0\u10dc\u10d0\u10d3\u10e3\u10e0\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "cdf", "\u10d9\u10dd\u10dc\u10d2\u10dd\u10e1 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "chf", "\u10e8\u10d5\u10d4\u10d8\u10ea\u10d0\u10e0\u10d8\u10e3\u10da\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "clp", "\u10e9\u10d8\u10da\u10d4\u10e1 \u10de\u10d4\u10e1\u10dd" },
            { "cnh", "\u10e9\u10d8\u10dc\u10e3\u10e0\u10d8 \u10d8\u10e3\u10d0\u10dc\u10d8 (\u10dd\u10e4\u10e8\u10dd\u10e0\u10d8)" },
            { "cny", "\u10e9\u10d8\u10dc\u10e3\u10e0\u10d8 \u10d8\u10e3\u10d0\u10dc\u10d8" },
            { "cop", "\u10d9\u10dd\u10da\u10e3\u10db\u10d1\u10d8\u10e3\u10e0\u10d8 \u10de\u10d4\u10e1\u10dd" },
            { "crc", "\u10d9\u10dd\u10e1\u10e2\u10d0-\u10e0\u10d8\u10d9\u10e3\u10da\u10d8 \u10d9\u10dd\u10da\u10dd\u10dc\u10d8" },
            { "csd", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10e1\u10d4\u10e0\u10d1\u10d8\u10e3\u10da\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "csk", "\u10e9\u10d4\u10ee\u10dd\u10e1\u10da\u10dd\u10d5\u10d0\u10d9\u10d8\u10d8\u10e1 \u10db\u10e7\u10d0\u10e0\u10d8 \u10d9\u10e0\u10dd\u10dc\u10d0" },
            { "cuc", "\u10d9\u10e3\u10d1\u10e3\u10e0\u10d8 \u10d9\u10dd\u10dc\u10d5\u10d4\u10e0\u10e2\u10d8\u10e0\u10d4\u10d1\u10d0\u10d3\u10d8 \u10de\u10d4\u10e1\u10dd" },
            { "cup", "\u10d9\u10e3\u10d1\u10e3\u10e0\u10d8 \u10de\u10d4\u10e1\u10dd" },
            { "cve", "\u10d9\u10d0\u10d1\u10dd-\u10d5\u10d4\u10e0\u10d3\u10d4\u10e1 \u10d4\u10e1\u10d9\u10e3\u10d3\u10dd" },
            { "cyp", "\u10d9\u10d5\u10d8\u10de\u10e0\u10dd\u10e1\u10d8\u10e1 \u10d2\u10d8\u10e0\u10d5\u10d0\u10dc\u10e5\u10d0" },
            { "czk", "\u10e9\u10d4\u10ee\u10e3\u10e0\u10d8 \u10d9\u10e0\u10dd\u10dc\u10d0" },
            { "ddm", "\u10d0\u10e6\u10db\u10dd\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10e3\u10da\u10d8 \u10db\u10d0\u10e0\u10d9\u10d0" },
            { "dem", "\u10d2\u10d4\u10e0\u10db\u10d0\u10dc\u10e3\u10da\u10d8 \u10db\u10d0\u10e0\u10d9\u10d0" },
            { "djf", "\u10ef\u10d8\u10d1\u10e3\u10e2\u10d8\u10e1 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "dkk", "\u10d3\u10d0\u10dc\u10d8\u10e3\u10e0\u10d8 \u10d9\u10e0\u10dd\u10dc\u10d0" },
            { "dop", "\u10d3\u10dd\u10db\u10d8\u10dc\u10d8\u10d9\u10e3\u10e0\u10d8 \u10de\u10d4\u10e1\u10dd" },
            { "dzd", "\u10d0\u10da\u10df\u10d8\u10e0\u10e3\u10da\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "eek", "\u10d4\u10e1\u10e2\u10dd\u10dc\u10e3\u10e0\u10d8 \u10d9\u10e0\u10e3\u10dc\u10d0" },
            { "egp", "\u10d4\u10d2\u10d5\u10d8\u10de\u10e2\u10e3\u10e0\u10d8 \u10d2\u10d8\u10e0\u10d5\u10d0\u10dc\u10e5\u10d0" },
            { "ern", "\u10d4\u10e0\u10d8\u10e2\u10e0\u10d4\u10d8\u10e1 \u10dc\u10d0\u10d9\u10e4\u10d0" },
            { "esp", "\u10d4\u10e1\u10de\u10d0\u10dc\u10e3\u10e0\u10d8 \u10de\u10d4\u10e1\u10d4\u10e2\u10d0" },
            { "etb", "\u10d4\u10d7\u10d8\u10dd\u10de\u10d8\u10e3\u10e0\u10d8 \u10d1\u10d8\u10e0\u10d8" },
            { "eur", "\u10d4\u10d5\u10e0\u10dd" },
            { "fim", "\u10e4\u10d8\u10dc\u10e3\u10e0\u10d8 \u10db\u10d0\u10e0\u10d9\u10d0" },
            { "fjd", "\u10e4\u10d8\u10ef\u10d8\u10e1 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "fkp", "\u10e4\u10dd\u10da\u10d9\u10da\u10d4\u10dc\u10d3\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8\u10e1 \u10e4\u10e3\u10dc\u10e2\u10d8" },
            { "frf", "\u10e4\u10e0\u10d0\u10dc\u10d2\u10e3\u10da\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "gbp", "\u10d1\u10e0\u10d8\u10e2\u10d0\u10dc\u10e3\u10da\u10d8 \u10d2\u10d8\u10e0\u10d5\u10d0\u10dc\u10e5\u10d0 \u10e1\u10e2\u10d4\u10e0\u10da\u10d8\u10dc\u10d2\u10d8" },
            { "gek", "\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8 \u10d9\u10e3\u10de\u10dd\u10dc\u10d8 \u10da\u10d0\u10e0\u10d8\u10d7" },
            { "gel", "\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8 \u10da\u10d0\u10e0\u10d8" },
            { "ghs", "\u10d2\u10d0\u10dc\u10e3\u10e0\u10d8 \u10e1\u10d4\u10d3\u10d8" },
            { "gip", "\u10d2\u10d8\u10d1\u10e0\u10d0\u10da\u10e2\u10d0\u10e0\u10e3\u10da\u10d8 \u10e4\u10e3\u10dc\u10e2\u10d8" },
            { "gmd", "\u10d2\u10d0\u10db\u10d1\u10d8\u10e3\u10e0\u10d8 \u10d3\u10d0\u10da\u10d0\u10e1\u10d8" },
            { "gnf", "\u10d2\u10d5\u10d8\u10dc\u10d4\u10e3\u10e0\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "grd", "\u10d1\u10d4\u10e0\u10eb\u10dc\u10e3\u10da\u10d8 \u10d3\u10e0\u10d0\u10f0\u10db\u10d0" },
            { "gtq", "\u10d2\u10d5\u10d0\u10e2\u10d4\u10db\u10d0\u10da\u10e3\u10e0\u10d8 \u10d9\u10d4\u10e2\u10e1\u10d0\u10da\u10d8" },
            { "gwe", "\u10de\u10dd\u10e0\u10e2\u10e3\u10d2\u10d0\u10da\u10d8\u10e3\u10e0\u10d8 \u10d2\u10d8\u10dc\u10d4\u10d0 \u10d4\u10e1\u10d9\u10e3\u10d3\u10dd" },
            { "gyd", "\u10d2\u10d0\u10d8\u10d0\u10dc\u10e3\u10e0\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "hkd", "\u10f0\u10dd\u10dc\u10d9\u10dd\u10dc\u10d2\u10d8\u10e1 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "hnl", "\u10f0\u10dd\u10dc\u10d3\u10e3\u10e0\u10d0\u10e1\u10e3\u10da\u10d8 \u10da\u10d4\u10db\u10de\u10d8\u10e0\u10d0" },
            { "hrd", "\u10ee\u10dd\u10e0\u10d5\u10d0\u10e2\u10d8\u10e3\u10da\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "hrk", "\u10ee\u10dd\u10e0\u10d5\u10d0\u10e2\u10e3\u10da\u10d8 \u10d9\u10e3\u10dc\u10d0" },
            { "htg", "\u10f0\u10d0\u10d8\u10e2\u10e3\u10e0\u10d8 \u10d2\u10e3\u10e0\u10d3\u10d8" },
            { "huf", "\u10e3\u10dc\u10d2\u10e0\u10e3\u10da\u10d8 \u10e4\u10dd\u10e0\u10d8\u10dc\u10e2\u10d8" },
            { "idr", "\u10d8\u10dc\u10d3\u10dd\u10dc\u10d4\u10d6\u10d8\u10e3\u10e0\u10d8 \u10e0\u10e3\u10de\u10d8\u10d0" },
            { "iep", "\u10d8\u10e0\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8 \u10d2\u10d8\u10e0\u10d5\u10d0\u10dc\u10e5\u10d0" },
            { "ils", "\u10d8\u10e1\u10e0\u10d0\u10d4\u10da\u10d8\u10e1 \u10d0\u10ee\u10d0\u10da\u10d8 \u10e8\u10d4\u10d9\u10d4\u10da\u10d8" },
            { "inr", "\u10d8\u10dc\u10d3\u10e3\u10e0\u10d8 \u10e0\u10e3\u10de\u10d8\u10d0" },
            { "iqd", "\u10d4\u10e0\u10d0\u10e7\u10e3\u10da\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "irr", "\u10d8\u10e0\u10d0\u10dc\u10e3\u10da\u10d8 \u10e0\u10d8\u10d0\u10da\u10d8" },
            { "isk", "\u10d8\u10e1\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8 \u10d9\u10e0\u10dd\u10dc\u10d0" },
            { "itl", "\u10d8\u10e2\u10d0\u10da\u10d8\u10e3\u10e0\u10d8 \u10da\u10d8\u10e0\u10d0" },
            { "jmd", "\u10d8\u10d0\u10db\u10d0\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "jod", "\u10d8\u10dd\u10e0\u10d3\u10d0\u10dc\u10d8\u10e3\u10da\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "jpy", "\u10d8\u10d0\u10de\u10dd\u10dc\u10e3\u10e0\u10d8 \u10d8\u10d4\u10dc\u10d8" },
            { "kes", "\u10d9\u10d4\u10dc\u10d8\u10e3\u10e0\u10d8 \u10e8\u10d8\u10da\u10d8\u10dc\u10d2\u10d8" },
            { "kgs", "\u10e7\u10d8\u10e0\u10d2\u10d8\u10d6\u10e3\u10da\u10d8 \u10e1\u10dd\u10db\u10d8" },
            { "khr", "\u10d9\u10d0\u10db\u10d1\u10dd\u10ef\u10e3\u10e0\u10d8 \u10e0\u10d8\u10d4\u10da\u10d8" },
            { "kmf", "\u10d9\u10dd\u10db\u10dd\u10e0\u10e3\u10da\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "kpw", "\u10e9\u10e0\u10d3\u10d8\u10da\u10dd\u10d4\u10d7 \u10d9\u10dd\u10e0\u10d4\u10e3\u10da\u10d8 \u10d5\u10dd\u10dc\u10d8" },
            { "krw", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10d9\u10dd\u10e0\u10d4\u10e3\u10da\u10d8 \u10d5\u10dd\u10dc\u10d8" },
            { "kwd", "\u10e5\u10e3\u10d5\u10d4\u10d8\u10d7\u10e3\u10e0\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "kyd", "\u10d9\u10d0\u10d8\u10db\u10d0\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8\u10e1 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "kzt", "\u10e7\u10d0\u10d6\u10d0\u10ee\u10e3\u10e0\u10d8 \u10e2\u10d4\u10dc\u10d2\u10d4" },
            { "lak", "\u10da\u10d0\u10dd\u10e1\u10e3\u10e0\u10d8 \u10d9\u10d8\u10de\u10d8" },
            { "lbp", "\u10da\u10d8\u10d1\u10d0\u10dc\u10e3\u10e0\u10d8 \u10e4\u10e3\u10dc\u10e2\u10d8" },
            { "lkr", "\u10e8\u10e0\u10d8-\u10da\u10d0\u10dc\u10d9\u10e3\u10e0\u10d8 \u10e0\u10e3\u10de\u10d8\u10d0" },
            { "lrd", "\u10da\u10d8\u10d1\u10d4\u10e0\u10d8\u10e3\u10da\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "ltl", "\u10da\u10d8\u10e2\u10d5\u10e3\u10e0\u10d8 \u10da\u10d8\u10e2\u10d0" },
            { "ltt", "\u10da\u10d8\u10e2\u10d5\u10e3\u10e0\u10d8 \u10e2\u10d0\u10da\u10dd\u10dc\u10d8" },
            { "luc", "\u10da\u10e3\u10e5\u10e1\u10d4\u10db\u10d1\u10e3\u10e0\u10d2\u10d8\u10e1 \u10d9\u10dd\u10dc\u10d5\u10d4\u10e0\u10e2\u10d8\u10e0\u10d4\u10d1\u10d0\u10d3\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "luf", "\u10da\u10e3\u10e5\u10e1\u10d4\u10db\u10d1\u10e3\u10e0\u10d2\u10d8\u10e1 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "lul", "\u10da\u10e3\u10e5\u10e1\u10d4\u10db\u10d1\u10e3\u10e0\u10d2\u10d8\u10e1 \u10e4\u10d8\u10dc\u10d0\u10dc\u10e1\u10e3\u10e0\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "lvl", "\u10da\u10d0\u10e2\u10d5\u10d8\u10e3\u10e0\u10d8 \u10da\u10d0\u10e2\u10d8" },
            { "lvr", "\u10da\u10d0\u10e2\u10d5\u10d8\u10e3\u10e0\u10d8 \u10e0\u10e3\u10d1\u10da\u10d8" },
            { "lyd", "\u10da\u10d8\u10d1\u10d8\u10e3\u10e0\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "mad", "\u10db\u10d0\u10e0\u10dd\u10d9\u10dd\u10e1 \u10d3\u10d8\u10e0\u10f0\u10d0\u10db\u10d8" },
            { "maf", "\u10db\u10d0\u10e0\u10dd\u10d9\u10dd\u10e1 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "mdl", "\u10db\u10dd\u10da\u10d3\u10dd\u10d5\u10e3\u10e0\u10d8 \u10da\u10d4\u10e3" },
            { "mga", "\u10db\u10d0\u10d3\u10d0\u10d2\u10d0\u10e1\u10d9\u10d0\u10e0\u10d8\u10e1 \u10d0\u10e0\u10d8\u10d0\u10e0\u10d8" },
            { "mgf", "\u10db\u10d0\u10d3\u10d0\u10d2\u10d0\u10e1\u10d9\u10d0\u10e0\u10d8\u10e1 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "mkd", "\u10db\u10d0\u10d9\u10d4\u10d3\u10dd\u10dc\u10d8\u10e3\u10e0\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "mlf", "\u10db\u10d0\u10da\u10d8\u10e1 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "mmk", "\u10db\u10d8\u10d0\u10dc\u10db\u10d0\u10e0\u10d8\u10e1 \u10d9\u10d8\u10d0\u10e2\u10d8" },
            { "mnt", "\u10db\u10dd\u10dc\u10e6\u10dd\u10da\u10e3\u10e0\u10d8 \u10e2\u10e3\u10d2\u10e0\u10d8\u10d9\u10d8" },
            { "mop", "\u10db\u10d0\u10d9\u10d0\u10e3\u10e1 \u10de\u10d0\u10e2\u10d0\u10d9\u10d0" },
            { "mro", "\u10db\u10d0\u10d5\u10e0\u10d8\u10e2\u10d0\u10dc\u10e3\u10da\u10d8 \u10e3\u10d2\u10d8\u10d0 (1973\u20132017)" },
            { "mru", "\u10db\u10d0\u10d5\u10e0\u10d8\u10e2\u10d0\u10dc\u10e3\u10da\u10d8 \u10e3\u10d2\u10d8\u10d0" },
            { "mtl", "\u10db\u10d0\u10da\u10e2\u10d8\u10e1 \u10da\u10d8\u10e0\u10d0" },
            { "mtp", "\u10db\u10d0\u10da\u10e2\u10d8\u10e1 \u10d2\u10d8\u10e0\u10d5\u10d0\u10dc\u10e5\u10d0" },
            { "mur", "\u10db\u10d0\u10d5\u10e0\u10d8\u10e2\u10d0\u10dc\u10e3\u10da\u10d8 \u10e0\u10e3\u10de\u10d8\u10d0" },
            { "mvr", "\u10db\u10d0\u10da\u10d3\u10d8\u10d5\u10e3\u10e0\u10d8 \u10e0\u10e3\u10e4\u10d8\u10d0" },
            { "mwk", "\u10db\u10d0\u10da\u10d0\u10d5\u10d8\u10e3\u10e0\u10d8 \u10d9\u10d5\u10d0\u10e9\u10d0" },
            { "mxn", "\u10db\u10d4\u10e5\u10e1\u10d8\u10d9\u10e3\u10e0\u10d8 \u10de\u10d4\u10e1\u10dd" },
            { "mxp", "\u10db\u10d4\u10e5\u10e1\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d5\u10d4\u10e0\u10ea\u10ee\u10da\u10d8\u10e1 \u10de\u10d4\u10e1\u10dd (1861\u20131992)" },
            { "myr", "\u10db\u10d0\u10da\u10d0\u10d8\u10d6\u10d8\u10e3\u10e0\u10d8 \u10e0\u10d8\u10dc\u10d2\u10d8\u10e2\u10d8" },
            { "mze", "\u10db\u10dd\u10d6\u10d0\u10db\u10d1\u10d8\u10d9\u10e3\u10e0\u10d8 \u10d4\u10e1\u10d9\u10e3\u10d3\u10dd" },
            { "mzm", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10db\u10dd\u10d6\u10d0\u10db\u10d1\u10d8\u10d9\u10e3\u10e0\u10d8 \u10db\u10d4\u10e2\u10d8\u10d9\u10d0\u10da\u10d8" },
            { "mzn", "\u10db\u10dd\u10d6\u10d0\u10db\u10d1\u10d8\u10d9\u10e3\u10e0\u10d8 \u10db\u10d4\u10e2\u10d8\u10d9\u10d0\u10da\u10d8" },
            { "nad", "\u10dc\u10d0\u10db\u10d8\u10d1\u10d8\u10e3\u10e0\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "ngn", "\u10dc\u10d8\u10d2\u10d4\u10e0\u10d8\u10e3\u10da\u10d8 \u10dc\u10d0\u10d8\u10e0\u10d0" },
            { "nic", "\u10dc\u10d8\u10d9\u10d0\u10e0\u10d0\u10d2\u10e3\u10d0\u10e1 \u10d9\u10dd\u10e0\u10d3\u10dd\u10d1\u10d0" },
            { "nio", "\u10dc\u10d8\u10d9\u10d0\u10e0\u10d0\u10d2\u10e3\u10d0\u10e1 \u10dd\u10e5\u10e0\u10dd\u10e1 \u10d9\u10dd\u10e0\u10d3\u10dd\u10d1\u10d0" },
            { "nlg", "\u10f0\u10dd\u10da\u10d0\u10dc\u10d3\u10d8\u10e3\u10e0\u10d8 \u10d2\u10e3\u10da\u10d3\u10d4\u10dc\u10d8" },
            { "nok", "\u10dc\u10dd\u10e0\u10d5\u10d4\u10d2\u10d8\u10e3\u10da\u10d8 \u10d9\u10e0\u10dd\u10dc\u10d0" },
            { "npr", "\u10dc\u10d4\u10de\u10d0\u10da\u10e3\u10e0\u10d8 \u10e0\u10e3\u10de\u10d8\u10d0" },
            { "nzd", "\u10d0\u10ee\u10d0\u10da\u10d8 \u10d6\u10d4\u10da\u10d0\u10dc\u10d3\u10d8\u10d8\u10e1 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "omr", "\u10dd\u10db\u10d0\u10dc\u10d8\u10e1 \u10e0\u10d8\u10d0\u10da\u10d8" },
            { "pab", "\u10de\u10d0\u10dc\u10d0\u10db\u10e3\u10e0\u10d8 \u10d1\u10d0\u10da\u10d1\u10dd\u10d0" },
            { "pei", "\u10de\u10d4\u10e0\u10e3\u10e1 \u10d8\u10dc\u10e2\u10d8" },
            { "pen", "\u10de\u10d4\u10e0\u10e3\u10e1 \u10e1\u10dd\u10da\u10d8" },
            { "pes", "\u10de\u10d4\u10e0\u10e3\u10e1 \u10e1\u10dd\u10da\u10d8 (1863\u20131965)" },
            { "pgk", "\u10de\u10d0\u10de\u10e3\u10d0-\u10d0\u10ee\u10d0\u10da\u10d8 \u10d2\u10d5\u10d8\u10dc\u10d4\u10d8\u10e1 \u10d9\u10d8\u10dc\u10d0" },
            { "php", "\u10e4\u10d8\u10da\u10d8\u10de\u10d8\u10dc\u10e3\u10e0\u10d8 \u10de\u10d4\u10e1\u10dd" },
            { "pkr", "\u10de\u10d0\u10d9\u10d8\u10e1\u10e2\u10d0\u10dc\u10e3\u10e0\u10d8 \u10e0\u10e3\u10de\u10d8\u10d0" },
            { "pln", "\u10de\u10dd\u10da\u10dd\u10dc\u10e3\u10e0\u10d8 \u10d6\u10da\u10dd\u10e2\u10d8" },
            { "plz", "\u10de\u10dd\u10da\u10dd\u10dc\u10e3\u10e0\u10d8 \u10d6\u10da\u10dd\u10e2\u10d8 (1950\u20131995)" },
            { "pte", "\u10de\u10dd\u10e0\u10e2\u10e3\u10d2\u10d0\u10da\u10d8\u10e3\u10e0\u10d8 \u10d4\u10e1\u10d9\u10e3\u10d3\u10dd" },
            { "pyg", "\u10de\u10d0\u10e0\u10d0\u10d2\u10d5\u10d0\u10e3\u10da\u10d8 \u10d2\u10e3\u10d0\u10e0\u10d0\u10dc\u10d8" },
            { "qar", "\u10d9\u10d0\u10e2\u10d0\u10e0\u10d8\u10e1 \u10e0\u10d8\u10d0\u10da\u10d8" },
            { "rhd", "\u10e0\u10dd\u10d3\u10d4\u10d6\u10d8\u10e3\u10da\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "rol", "\u10eb\u10d5\u10d4\u10da\u10d8 \u10e0\u10e3\u10db\u10d8\u10dc\u10e3\u10da\u10d8 \u10da\u10d4\u10e3" },
            { "ron", "\u10e0\u10e3\u10db\u10d8\u10dc\u10e3\u10da\u10d8 \u10da\u10d4\u10e3" },
            { "rsd", "\u10e1\u10d4\u10e0\u10d1\u10e3\u10da\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "rub", "\u10e0\u10e3\u10e1\u10e3\u10da\u10d8 \u10e0\u10e3\u10d1\u10da\u10d8" },
            { "rur", "\u10e0\u10e3\u10e1\u10e3\u10da\u10d8 \u10e0\u10e3\u10d1\u10da\u10d8 (1991\u20131998)" },
            { "rwf", "\u10e0\u10e3\u10d0\u10dc\u10d3\u10e3\u10da\u10d8 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "sar", "\u10e1\u10d0\u10e3\u10d3\u10d8\u10e1 \u10d0\u10e0\u10d0\u10d1\u10d4\u10d7\u10d8\u10e1 \u10e0\u10d8\u10d0\u10da\u10d8" },
            { "sbd", "\u10e1\u10dd\u10da\u10dd\u10db\u10dd\u10dc\u10d8\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d4\u10d1\u10d8\u10e1 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "scr", "\u10e1\u10d4\u10d8\u10e8\u10d4\u10da\u10e3\u10e0\u10d8 \u10e0\u10e3\u10de\u10d8\u10d0" },
            { "sdd", "\u10e1\u10e3\u10d3\u10d0\u10dc\u10d8\u10e1 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "sdg", "\u10e1\u10e3\u10d3\u10d0\u10dc\u10e3\u10e0\u10d8 \u10e4\u10e3\u10dc\u10e2\u10d8" },
            { "sdp", "\u10e1\u10e3\u10d3\u10d0\u10dc\u10d8\u10e1 \u10d2\u10d8\u10e0\u10d5\u10d0\u10dc\u10e5\u10d0" },
            { "sek", "\u10e8\u10d5\u10d4\u10d3\u10e3\u10e0\u10d8 \u10d9\u10e0\u10dd\u10dc\u10d0" },
            { "sgd", "\u10e1\u10d8\u10dc\u10d2\u10d0\u10de\u10e3\u10e0\u10d8\u10e1 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "shp", "\u10ec\u10db. \u10d4\u10da\u10d4\u10dc\u10d4\u10e1 \u10d9\u10e3\u10dc\u10eb\u10e3\u10da\u10d8\u10e1 \u10e4\u10e3\u10dc\u10e2\u10d8" },
            { "sll", "\u10e1\u10d8\u10d4\u10e0\u10d0-\u10da\u10d4\u10dd\u10dc\u10d4\u10e1 \u10da\u10d4\u10dd\u10dc\u10d4" },
            { "sos", "\u10e1\u10dd\u10db\u10d0\u10da\u10e3\u10e0\u10d8 \u10e8\u10d8\u10da\u10d8\u10dc\u10d2\u10d8" },
            { "srd", "\u10e1\u10e3\u10e0\u10d8\u10dc\u10d0\u10db\u10e3\u10da\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "srg", "\u10e1\u10e3\u10e0\u10d8\u10dc\u10d0\u10db\u10d8\u10e1 \u10d2\u10e3\u10da\u10d3\u10d4\u10dc\u10d8" },
            { "ssp", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10e1\u10e3\u10d3\u10d0\u10dc\u10e3\u10e0\u10d8 \u10e4\u10e3\u10dc\u10e2\u10d8" },
            { "std", "\u10e1\u10d0\u10dc-\u10e2\u10dd\u10db\u10d4 \u10d3\u10d0 \u10de\u10e0\u10d8\u10dc\u10e1\u10d8\u10de\u10d8\u10e1 \u10d3\u10dd\u10d1\u10e0\u10d0 (1977\u20132017)" },
            { "stn", "\u10e1\u10d0\u10dc-\u10e2\u10dd\u10db\u10d4 \u10d3\u10d0 \u10de\u10e0\u10d8\u10dc\u10e1\u10d8\u10de\u10d8\u10e1 \u10d3\u10dd\u10d1\u10e0\u10d0" },
            { "sur", "\u10e1\u10d0\u10d1\u10ed\u10dd\u10d7\u10d0 \u10e0\u10e3\u10d1\u10da\u10d8" },
            { "syp", "\u10e1\u10d8\u10e0\u10d8\u10e3\u10da\u10d8 \u10e4\u10e3\u10dc\u10e2\u10d8" },
            { "szl", "\u10e1\u10d5\u10d0\u10d6\u10d8\u10da\u10d4\u10dc\u10d3\u10d8\u10e1 \u10da\u10d8\u10da\u10d0\u10dc\u10d2\u10d4\u10dc\u10d8" },
            { "thb", "\u10e2\u10d0\u10d8\u10da\u10d0\u10dc\u10d3\u10e3\u10e0\u10d8 \u10d1\u10d0\u10e2\u10d8" },
            { "tjr", "\u10e2\u10d0\u10ef\u10d8\u10d9\u10e3\u10e0\u10d8 \u10e0\u10e3\u10d1\u10da\u10d8" },
            { "tjs", "\u10e2\u10d0\u10ef\u10d8\u10d9\u10e3\u10e0\u10d8 \u10e1\u10dd\u10db\u10dd\u10dc\u10d8" },
            { "tmm", "\u10d7\u10e3\u10e0\u10e5\u10db\u10d4\u10dc\u10e3\u10da\u10d8 \u10db\u10d0\u10dc\u10d0\u10d7\u10d8" },
            { "tmt", "\u10d7\u10e3\u10e0\u10e5\u10db\u10d4\u10dc\u10d4\u10d7\u10d8\u10e1 \u10db\u10d0\u10dc\u10d0\u10d7\u10d8" },
            { "tnd", "\u10e2\u10e3\u10dc\u10d8\u10e1\u10e3\u10e0\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "top", "\u10e2\u10dd\u10dc\u10d2\u10d0\u10dc\u10e3\u10e0\u10d8 \u10de\u10d0\u10d0\u10dc\u10d2\u10d0" },
            { "trl", "\u10d7\u10e3\u10e0\u10e5\u10e3\u10da\u10d8 \u10da\u10d8\u10e0\u10d0" },
            { "try", "\u10d0\u10ee\u10d0\u10da\u10d8 \u10d7\u10e3\u10e0\u10e5\u10e3\u10da\u10d8 \u10da\u10d8\u10e0\u10d0" },
            { "ttd", "\u10e2\u10e0\u10d8\u10dc\u10d8\u10d3\u10d0\u10d3 \u10d3\u10d0 \u10e2\u10dd\u10d1\u10d0\u10d2\u10dd\u10e1 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "twd", "\u10e2\u10d0\u10d8\u10d5\u10d0\u10dc\u10e3\u10e0\u10d8 \u10d0\u10ee\u10d0\u10da\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "tzs", "\u10e2\u10d0\u10dc\u10d6\u10d0\u10dc\u10d8\u10e3\u10e0\u10d8 \u10e8\u10d8\u10da\u10d8\u10dc\u10d2\u10d8" },
            { "uah", "\u10e3\u10d9\u10e0\u10d0\u10d8\u10dc\u10e3\u10da\u10d8 \u10d2\u10e0\u10d8\u10d5\u10dc\u10d0" },
            { "uak", "\u10e3\u10d9\u10e0\u10d0\u10d8\u10dc\u10e3\u10da\u10d8 \u10d9\u10d0\u10e0\u10d1\u10dd\u10d5\u10d0\u10dc\u10d4\u10ea\u10d8" },
            { "ugs", "\u10e3\u10d2\u10d0\u10dc\u10d3\u10e3\u10e0\u10d8 \u10e8\u10d8\u10da\u10d8\u10dc\u10d2\u10d8 (1966\u20131987)" },
            { "ugx", "\u10e3\u10d2\u10d0\u10dc\u10d3\u10e3\u10e0\u10d8 \u10e8\u10d8\u10da\u10d8\u10dc\u10d2\u10d8" },
            { "usd", "\u10d0\u10e8\u10e8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "usn", "\u10d0\u10e8\u10e8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8 (\u10e8\u10d4\u10db\u10d3\u10d4\u10d2\u10d8 \u10d3\u10e6\u10d4)" },
            { "uss", "\u10d0\u10e8\u10e8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8 (\u10d8\u10d2\u10d8\u10d5\u10d4 \u10d3\u10e6\u10d4)" },
            { "uyp", "\u10e3\u10e0\u10e3\u10d2\u10d5\u10d0\u10d8\u10e1 \u10de\u10d4\u10e1\u10dd (1975\u20131993)" },
            { "uyu", "\u10e3\u10e0\u10e3\u10d2\u10d5\u10d0\u10d8\u10e1 \u10de\u10d4\u10e1\u10dd" },
            { "uzs", "\u10e3\u10d6\u10d1\u10d4\u10d9\u10e3\u10e0\u10d8 \u10e1\u10e3\u10db\u10d8" },
            { "veb", "\u10d5\u10d4\u10dc\u10d4\u10e1\u10e3\u10d4\u10da\u10d8\u10e1 \u10d1\u10dd\u10da\u10d8\u10d5\u10d0\u10e0\u10d8 (1871\u20132008)" },
            { "vef", "\u10d5\u10d4\u10dc\u10d4\u10e1\u10e3\u10d4\u10da\u10d8\u10e1 \u10d1\u10dd\u10da\u10d8\u10d5\u10d0\u10e0\u10d8 (2008\u20132018)" },
            { "ves", "\u10d5\u10d4\u10dc\u10d4\u10e1\u10e3\u10d4\u10da\u10d8\u10e1 \u10d1\u10dd\u10da\u10d8\u10d5\u10d0\u10e0\u10d8" },
            { "vnd", "\u10d5\u10d8\u10d4\u10e2\u10dc\u10d0\u10db\u10e3\u10e0\u10d8 \u10d3\u10dd\u10dc\u10d2\u10d8" },
            { "vuv", "\u10d5\u10d0\u10dc\u10e3\u10d0\u10e2\u10e3\u10e1 \u10d5\u10d0\u10e2\u10e3" },
            { "wst", "\u10e1\u10d0\u10db\u10dd\u10e3\u10e0\u10d8 \u10e2\u10d0\u10da\u10d0" },
            { "xaf", "\u10ea\u10d4\u10dc\u10e2\u10e0\u10d0\u10da\u10e3\u10e0 \u10d0\u10e4\u10e0\u10d8\u10d9\u10e3\u10da\u10d8 CFA \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "xag", "\u10d5\u10d4\u10e0\u10ea\u10ee\u10da\u10d8" },
            { "xba", "\u10d4\u10d5\u10e0\u10dd\u10de\u10e3\u10da\u10d8 \u10d9\u10dd\u10db\u10de\u10de\u10dd\u10d6\u10d8\u10e2\u10e3\u10e0\u10d8 \u10d4\u10e0\u10d7\u10d4\u10e3\u10da\u10d8" },
            { "xbb", "\u10d4\u10d5\u10e0\u10dd\u10de\u10e3\u10da\u10d8 \u10e4\u10e3\u10da\u10d0\u10d3\u10d8 \u10d4\u10e0\u10d7\u10d4\u10e3\u10da\u10d8" },
            { "xcd", "\u10d0\u10e6\u10db\u10dd\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d9\u10d0\u10e0\u10d8\u10d1\u10d8\u10e3\u10da\u10d8 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
            { "xeu", "\u10d4\u10d5\u10e0\u10dd\u10de\u10e3\u10da\u10d8 \u10e1\u10d0\u10d5\u10d0\u10da\u10e3\u10e2\u10dd \u10d4\u10e0\u10d7\u10d4\u10e3\u10da\u10d8" },
            { "xfo", "\u10e4\u10e0\u10d0\u10dc\u10d2\u10e3\u10da\u10d8 \u10dd\u10e5\u10e0\u10dd\u10e1 \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "xof", "\u10d3\u10d0\u10e1\u10d0\u10d5\u10da\u10d4\u10d7 \u10d0\u10e4\u10e0\u10d8\u10d9\u10e3\u10da\u10d8 CFA \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "xpf", "CFP \u10e4\u10e0\u10d0\u10dc\u10d9\u10d8" },
            { "xxx", "\u10e3\u10ea\u10dc\u10dd\u10d1\u10d8 \u10d5\u10d0\u10da\u10e3\u10e2\u10d0" },
            { "ydd", "\u10d8\u10d4\u10db\u10d4\u10dc\u10d8\u10e1 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "yer", "\u10d8\u10d4\u10db\u10d4\u10dc\u10d8\u10e1 \u10e0\u10d4\u10d0\u10da\u10d8" },
            { "yud", "\u10d8\u10e3\u10d2\u10dd\u10e1\u10da\u10d0\u10d5\u10d8\u10e3\u10e0\u10d8 \u10db\u10e7\u10d0\u10e0\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "yum", "\u10d8\u10e3\u10d2\u10dd\u10e1\u10da\u10d0\u10d5\u10d8\u10e3\u10e0\u10d8 \u10d0\u10ee\u10d0\u10da\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "yun", "\u10d8\u10e3\u10d2\u10dd\u10e1\u10da\u10d0\u10d5\u10d8\u10e3\u10e0\u10d8 \u10d9\u10dd\u10dc\u10d5\u10d4\u10e0\u10e2\u10d8\u10e0\u10d4\u10d1\u10d0\u10d3\u10d8 \u10d3\u10d8\u10dc\u10d0\u10e0\u10d8" },
            { "zar", "\u10e1\u10d0\u10db\u10ee\u10e0\u10d4\u10d7 \u10d0\u10e4\u10e0\u10d8\u10d9\u10e3\u10da\u10d8 \u10e0\u10d0\u10dc\u10d3\u10d8" },
            { "zmk", "\u10d6\u10d0\u10db\u10d1\u10d8\u10e3\u10e0\u10d8 \u10d9\u10d5\u10d0\u10ed\u10d0 (1968\u20132012)" },
            { "zmw", "\u10d6\u10d0\u10db\u10d1\u10d8\u10e3\u10e0\u10d8 \u10d9\u10d5\u10d0\u10ed\u10d0" },
            { "zrn", "\u10d6\u10d0\u10d8\u10e0\u10d8\u10e1 \u10d0\u10ee\u10d0\u10da\u10d8 \u10d6\u10d0\u10d8\u10e0\u10d8" },
            { "zrz", "\u10d6\u10d0\u10d8\u10e0\u10d8\u10e1 \u10d6\u10d0\u10d8\u10e0\u10d8" },
            { "zwd", "\u10d6\u10d8\u10db\u10d1\u10d0\u10d1\u10d5\u10d4\u10e1 \u10d3\u10dd\u10da\u10d0\u10e0\u10d8" },
        };
        return data;
    }
}
